/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event;

import cn.gtmap.hlw.core.domain.fj.FjDownloadCheckEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjDownloadCheckEventParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FjDownloadCheckEventResultModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class FjDownloadCheckDomainService {
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, FjDownloadCheckEventService> eventServiceMap;

    public FjDownloadCheckEventResultModel event(FjDownloadCheckEventParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ErrorEnum.LYSJ_LYDZ_EMPTY_ERR.getCode(), ErrorEnum.LYSJ_LYDZ_EMPTY_ERR.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ErrorEnum.LYSJ_LYDZ_EMPTY_ERR.getCode(), ErrorEnum.LYSJ_LYDZ_EMPTY_ERR.getMsg());
        }
        FjDownloadCheckEventResultModel resultModel = new FjDownloadCheckEventResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            FjDownloadCheckEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }
}

