/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.export.event.dycx;

import cn.gtmap.hlw.core.domain.export.FjExportEventService;
import cn.gtmap.hlw.core.domain.export.model.FjExportModel;
import cn.gtmap.hlw.core.dto.query.DyxxQueryResultDTO;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.enums.status.Status2Enum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FjExportDycxWhEvent
implements FjExportEventService {
    @Autowired
    RedisRepository redisRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(FjExportModel fjExportModel, File file) {
        String json = (String)this.redisRepository.get("export:" + fjExportModel.getId());
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new BizException(ErrorEnum.PARAM_NULL.getCode(), "\u672a\u67e5\u8be2\u5230\u5bfc\u81f4\u53c2\u6570\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2");
        }
        List list = JSON.parseArray((String)json, DyxxQueryResultDTO.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BizException(ErrorEnum.PARAM_NULL.getCode(), "\u672a\u67e5\u8be2\u5230\u5bfc\u81f4\u53c2\u6570\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2");
        }
        ArrayList dataList = Lists.newArrayList();
        int index = 1;
        for (DyxxQueryResultDTO dyxx : list) {
            HashMap map = Maps.newHashMap();
            map.put("xh", index);
            map.put("bdczmh", dyxx.getBdcdjzmh());
            map.put("qlr", dyxx.getDyqr());
            map.put("ywr", dyxx.getDyr());
            map.put("zl", dyxx.getZl());
            map.put("jzmj", dyxx.getCqmj());
            map.put("fwytmc", dyxx.getFwytmc());
            map.put("dyje", dyxx.getDyje());
            map.put("sfyed", StringUtils.equals((CharSequence)dyxx.getSfyed(), (CharSequence)Status2Enum.YES.getCode()) ? "\u662f" : "\u5426");
            map.put("sfczjzq", StringUtils.equals((CharSequence)dyxx.getSfczjzq(), (CharSequence)Status2Enum.YES.getCode()) ? "\u662f" : "\u5426");
            map.put("djsj", dyxx.getDjsj());
            map.put("dylx", StringUtils.equals((CharSequence)dyxx.getSfydy(), (CharSequence)Status2Enum.YES.getCode()) ? "\u9884\u62b5\u62bc" : "\u62b5\u62bc");
            Object xzzt = "";
            if (StringUtils.equals((CharSequence)dyxx.getSfcf(), (CharSequence)Status2Enum.YES.getCode())) {
                xzzt = (String)xzzt + "\u67e5\u5c01";
            }
            if (StringUtils.equals((CharSequence)dyxx.getSfsd(), (CharSequence)Status2Enum.YES.getCode())) {
                xzzt = (String)xzzt + "\u9501\u5b9a";
            }
            if (StringUtils.equals((CharSequence)dyxx.getSfyy(), (CharSequence)Status2Enum.YES.getCode())) {
                xzzt = (String)xzzt + "\u5f02\u8bae";
            }
            map.put("xzzt", StringUtils.isNotBlank((CharSequence)xzzt) ? xzzt : "\u6b63\u5e38");
            map.put("qszt", dyxx.getQsztmc());
            ++index;
            dataList.add(map);
        }
        ExcelWriter writer = ExcelUtil.getWriter();
        writer.addHeaderAlias("xh", "\u5e8f\u53f7");
        writer.addHeaderAlias("bdczmh", "\u4e0d\u52a8\u4ea7\u8bc1\u660e\u53f7");
        writer.addHeaderAlias("qlr", "\u6743\u5229\u4eba");
        writer.addHeaderAlias("ywr", "\u62b5\u62bc\u4eba");
        writer.addHeaderAlias("zl", "\u623f\u5c4b\u5750\u843d");
        writer.addHeaderAlias("jzmj", "\u5efa\u7b51\u9762\u79ef");
        writer.addHeaderAlias("fwytmc", "\u623f\u5c4b\u7528\u9014");
        writer.addHeaderAlias("dyje", "\u62b5\u62bc\u91d1\u989d\uff08\u4e07\u5143\uff09");
        writer.addHeaderAlias("sfyed", "\u662f\u5426\u4e8c\u62b5");
        writer.addHeaderAlias("sfczjzq", "\u662f\u5426\u8bbe\u7acb\u5c45\u4f4f\u6743");
        writer.addHeaderAlias("djsj", "\u767b\u7c3f\u65f6\u95f4");
        writer.addHeaderAlias("dylx", "\u62b5\u62bc\u7c7b\u578b");
        writer.addHeaderAlias("xzzt", "\u9650\u5236\u72b6\u6001");
        writer.addHeaderAlias("qszt", "\u6743\u5229\u72b6\u6001");
        writer.write((Iterable)dataList, true);
        Map map = (Map)dataList.get(0);
        int idx = 0;
        for (String key : map.keySet()) {
            writer.setColumnWidth(idx, 30);
            ++idx;
        }
        int size = dataList.size() + 1;
        for (int i = 0; i < size; ++i) {
            writer.setRowHeight(i, 20);
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            writer.flush((OutputStream)outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            writer.close();
            file.delete();
        }
    }
}

