/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.export.event.dycx;

import cn.gtmap.hlw.core.domain.export.FjExportEventService;
import cn.gtmap.hlw.core.domain.export.model.FjExportModel;
import cn.gtmap.hlw.core.dto.query.DyxxQueryResultDTO;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FjExportDycxEvent
implements FjExportEventService {
    @Autowired
    RedisRepository redisRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(FjExportModel fjExportModel, File file) {
        String json = (String)this.redisRepository.get("export:" + fjExportModel.getId());
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new BizException(ErrorEnum.PARAM_NULL.getCode(), "\u672a\u67e5\u8be2\u5230\u5bfc\u81f4\u53c2\u6570\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2");
        }
        List list = JSON.parseArray((String)json, DyxxQueryResultDTO.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BizException(ErrorEnum.PARAM_NULL.getCode(), "\u672a\u67e5\u8be2\u5230\u5bfc\u81f4\u53c2\u6570\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2");
        }
        ArrayList dataList = Lists.newArrayList();
        int index = 1;
        for (DyxxQueryResultDTO dyxx : list) {
            HashMap map = Maps.newHashMap();
            map.put("xh", index);
            map.put("nwslbh", dyxx.getNwslbh());
            map.put("ywmc", dyxx.getYwmc());
            map.put("jbr", dyxx.getJbr());
            map.put("bdczmh", dyxx.getBdcdjzmh());
            map.put("qlr", dyxx.getDyqr());
            map.put("dlr", dyxx.getDlr());
            map.put("ywr", dyxx.getDyr());
            map.put("ywrzjh", dyxx.getDyrzjh());
            map.put("dyqx", dyxx.getDykssj() + "~" + dyxx.getDyjssj());
            map.put("dyje", dyxx.getDyje());
            map.put("zl", dyxx.getZl());
            map.put("dycs", dyxx.getDycs());
            map.put("dysw", dyxx.getDysw());
            ++index;
            dataList.add(map);
        }
        ExcelWriter writer = ExcelUtil.getWriter();
        writer.addHeaderAlias("xh", "\u5e8f\u53f7");
        writer.addHeaderAlias("nwslbh", "\u4e1a\u52a1\u53f7");
        writer.addHeaderAlias("ywmc", "\u4e1a\u52a1\u540d\u79f0");
        writer.addHeaderAlias("jbr", "\u7ecf\u529e\u4eba");
        writer.addHeaderAlias("bdczmh", "\u4e0d\u52a8\u4ea7\u8bc1\u660e\u53f7");
        writer.addHeaderAlias("qlr", "\u6743\u5229\u4eba");
        writer.addHeaderAlias("dlr", "\u4ee3\u7406\u4eba");
        writer.addHeaderAlias("ywr", "\u4e49\u52a1\u4eba");
        writer.addHeaderAlias("ywrzjh", "\u4e49\u52a1\u4eba\u8bc1\u4ef6\u53f7");
        writer.addHeaderAlias("dyqx", "\u62b5\u62bc\u671f\u9650");
        writer.addHeaderAlias("dyje", "\u62b5\u62bc\u91d1\u989d\uff08\u4e07\u5143\uff09");
        writer.addHeaderAlias("zl", "\u5750\u843d");
        writer.addHeaderAlias("dycs", "\u62b5\u62bc\u6b21\u6570");
        writer.addHeaderAlias("dysw", "\u62b5\u62bc\u987a\u4f4d");
        writer.write((Iterable)dataList, true);
        Map map = (Map)dataList.get(0);
        int idx = 0;
        for (String key : map.keySet()) {
            writer.setColumnWidth(idx, 30);
            ++idx;
        }
        int size = dataList.size() + 1;
        for (int i = 0; i < size; ++i) {
            writer.setRowHeight(i, 20);
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            writer.flush((OutputStream)outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            writer.close();
            file.delete();
        }
    }
}

