/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.esign.event.verify;

import cn.gtmap.hlw.core.domain.esign.ESignVerifyEventService;
import cn.gtmap.hlw.core.domain.esign.model.ESignVerifyParamsModel;
import cn.gtmap.hlw.core.domain.esign.model.ESignVerifyResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.login.enums.LoginStatusEnum;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ESignVerifyDomainService {
    private static final Logger log = LoggerFactory.getLogger(ESignVerifyDomainService.class);
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, ESignVerifyEventService> eventServiceMap;

    public ESignVerifyResultModel event(ESignVerifyParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(LoginStatusEnum.LOGIN_LYSJDM_NOTNULL.getCode(), LoginStatusEnum.LOGIN_LYSJDM_NOTNULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), null);
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getCode(), LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getMsg());
        }
        ESignVerifyResultModel resultModel = new ESignVerifyResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            ESignVerifyEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }
}

