/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.dyxx.event;

import cn.gtmap.hlw.core.domain.dyxx.BdczmSaveEventService;
import cn.gtmap.hlw.core.dto.third.cqzdyxx.dyzm.BdczmThirdSaveResultDTO;
import cn.gtmap.hlw.core.dto.third.cqzdyxx.dyzm.BdczmThridSaveParamsDTO;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class BdczmSaveOrUpdateDomainService {
    @Resource
    GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, BdczmSaveEventService> eventServiceMap;

    public BdczmThirdSaveResultDTO event(BdczmThridSaveParamsDTO paramsDTO) {
        if (StringUtils.isBlank((CharSequence)paramsDTO.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsDTO.getLysjdm(), paramsDTO.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        BdczmThirdSaveResultDTO resultDTO = new BdczmThirdSaveResultDTO();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            BdczmSaveEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsDTO, resultDTO);
        }
        return resultDTO;
    }
}

