/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.dyxx.event;

import cn.gtmap.hlw.core.domain.dyxx.BdczmThirdEventService;
import cn.gtmap.hlw.core.dto.third.cqzdyxx.dyzm.BdczmThridParamsDTO;
import cn.gtmap.hlw.core.dto.third.cqzdyxx.dyzm.BdczmThridResultDTO;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BdczmQueryDomainService {
    private static final Logger log = LoggerFactory.getLogger(BdczmQueryDomainService.class);
    @Resource
    GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, BdczmThirdEventService> eventServiceMap;

    public List<BdczmThridResultDTO> event(BdczmThridParamsDTO paramsDTO) {
        if (StringUtils.isBlank((CharSequence)paramsDTO.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsDTO.getLysjdm(), paramsDTO.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        ArrayList list = Lists.newArrayList();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            BdczmThirdEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsDTO, (List)list);
        }
        return list;
    }
}

