/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.djzx.event;

import cn.gtmap.hlw.core.domain.djzx.DjzxQueryEventService;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.model.query.DjzxQueryParamsModel;
import cn.gtmap.hlw.core.model.query.DjzxQueryResultModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DjzxQueryDomainService {
    @Autowired
    Map<String, DjzxQueryEventService> queryEventServiceMap;
    @Autowired
    GxYyLysjRepository lysjRepository;

    public List<DjzxQueryResultModel> list(DjzxQueryParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        ArrayList resultModelList = Lists.newArrayList();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            DjzxQueryEventService eventService = this.queryEventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, (List)resultModelList);
        }
        return resultModelList;
    }
}

