/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.server.core.send;

import cn.gtmap.server.core.dto.BaseLogMessage;
import cn.gtmap.server.core.dto.RunLogMessage;
import cn.gtmap.server.core.dto.TraceMessage;
import cn.gtmap.server.core.factory.MessageAppenderFactory;
import cn.gtmap.server.logback.utils.LogMessageUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.web.method.HandlerMethod;

public class SendRedisFactory {
    private static final Integer MAXLENGTH = 100000;

    public static void sendMsgToRedis(HttpServletRequest request, Object handler, String logLevel, String appName) {
        BaseLogMessage logMessage;
        RunLogMessage runLogMessage;
        HandlerMethod method = null;
        if (handler instanceof HandlerMethod) {
            method = (HandlerMethod)handler;
        }
        if (StringUtils.isNotBlank((CharSequence)(runLogMessage = (RunLogMessage)(logMessage = LogMessageUtil.getLogMessage(appName, request, method, logLevel))).getContent()) && !StringUtils.equals((CharSequence)runLogMessage.getContent(), (CharSequence)"{}")) {
            MessageAppenderFactory.pushRundataQueue(JSONObject.toJSONString(SendRedisFactory.getMDC(logMessage)));
        }
    }

    public static void sendMsgToRedis(String msg, String className, String method, String logLevel, String appName) {
        if (msg.length() > MAXLENGTH) {
            SendRedisFactory.asyncPush(msg, className, method, logLevel, appName);
        } else {
            BaseLogMessage logMessage = LogMessageUtil.getLogMessage(appName, msg, className, method, logLevel);
            MessageAppenderFactory.pushRundataQueue(JSONObject.toJSONString(SendRedisFactory.getMDC(logMessage)));
        }
    }

    public static void sendMsgToRedis(TraceMessage traceMessage, String appName) {
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage(appName, traceMessage);
        MessageAppenderFactory.pushTracedataQueue(JSONObject.toJSONString((Object)logMessage));
    }

    private static Map<String, String> getMDC(BaseLogMessage logMessage) {
        Map mdc = MDC.getCopyOfContextMap();
        Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)logMessage), Map.class);
        if (mdc != null) {
            mdc.putAll(map);
        }
        return mdc;
    }

    private static void asyncPush(final String msg, final String className, final String method, final String logLevel, final String appName) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int max = msg.length() / MAXLENGTH + 1;
                for (int i = 0; i < max; ++i) {
                    BaseLogMessage logMessage = null;
                    logMessage = max - i > 1 ? LogMessageUtil.getLogMessage(appName, msg.substring(i * MAXLENGTH, (i + 1) * MAXLENGTH), className, method, logLevel) : LogMessageUtil.getLogMessage(appName, msg.substring(i * MAXLENGTH), className, method, logLevel);
                    MessageAppenderFactory.pushRundataQueue(JSONObject.toJSONString((Object)SendRedisFactory.getMDC(logMessage)));
                }
            }
        }).start();
    }
}

