/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.server.core.redis;

import cn.gtmap.server.core.exception.LogQueueConnectException;
import cn.gtmap.server.core.redis.RedisAbstractClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class RedisClient
extends RedisAbstractClient {
    private static RedisClient instance;
    private int MAX_ACTIVE = 100;
    private int MAX_IDLE = 8;
    private int MAX_WAIT = 5000;
    private int TIMEOUT = 5000;
    private boolean TEST_ON_BORROW = true;
    private JedisPool jedisPool = null;
    private static final String script = "local rs=redis.call('setnx',KEYS[1],ARGV[1]);if(rs<1) then return 0;end;redis.call('expire',KEYS[1],tonumber(ARGV[2]));return 1;";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisClient getInstance(String host, int port, String pass) {
        if (instance != null) return instance;
        Class<RedisClient> clazz = RedisClient.class;
        synchronized (RedisClient.class) {
            if (instance != null) return instance;
            instance = new RedisClient(host, port, pass);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    public RedisClient(String host, int port, String pass) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(this.MAX_ACTIVE);
        config.setMaxIdle(this.MAX_IDLE);
        config.setMaxWaitMillis((long)this.MAX_WAIT);
        config.setTestOnBorrow(this.TEST_ON_BORROW);
        this.jedisPool = pass != null && !"".equals(pass) ? new JedisPool((GenericObjectPoolConfig)config, host, port, this.TIMEOUT, pass, 0) : new JedisPool((GenericObjectPoolConfig)config, host, port, this.TIMEOUT);
    }

    public RedisClient(String host, int port, String pass, int db) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(this.MAX_ACTIVE);
        config.setMaxIdle(this.MAX_IDLE);
        config.setMaxWaitMillis((long)this.MAX_WAIT);
        config.setTestOnBorrow(this.TEST_ON_BORROW);
        this.jedisPool = pass != null && !"".equals(pass) ? new JedisPool((GenericObjectPoolConfig)config, host, port, this.TIMEOUT, pass, db) : new JedisPool((GenericObjectPoolConfig)config, host, port, this.TIMEOUT);
    }

    @Override
    public void pushMessage(String key, String strings) throws LogQueueConnectException {
        try (Jedis sj = null;){
            sj = this.jedisPool.getResource();
            sj.rpush(key, new String[]{strings});
        }
    }

    @Override
    public boolean setNx(String key, Integer expire) {
        if (null == key) {
            return false;
        }
        try {
            Jedis jedis = this.jedisPool.getResource();
            Long result = (Long)jedis.evalsha(jedis.scriptLoad(script), Arrays.asList(key), Arrays.asList(key, String.valueOf(expire)));
            jedis.close();
            if (result == 1L) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsKey(String key) {
        try (Jedis sj = this.jedisPool.getResource();){
            boolean bl = sj.exists(key);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage(String key) {
        String obj;
        try (Jedis sj = this.jedisPool.getResource();){
            obj = sj.lpop(key);
        }
        return obj;
    }

    @Override
    public void putMessageList(String key, List<String> list) throws LogQueueConnectException {
        try (Jedis sj = null;){
            sj = this.jedisPool.getResource();
            Pipeline pl = sj.pipelined();
            for (String str : list) {
                pl.rpush(key, new String[]{str});
            }
            pl.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value) {
        try (Jedis sj = this.jedisPool.getResource();){
            sj.set(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value, int seconds) {
        try (Jedis sj = this.jedisPool.getResource();){
            Pipeline pl = sj.pipelined();
            pl.set(key, value);
            pl.expire(key, seconds);
            pl.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireAt(String key, Long time) {
        try (Jedis sj = this.jedisPool.getResource();){
            sj.expireAt(key, time.longValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expire(String key, int seconds) {
        try (Jedis sj = this.jedisPool.getResource();){
            sj.expire(key, seconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(String key) {
        Long re = 0L;
        try (Jedis sj = this.jedisPool.getResource();){
            re = sj.incr(key);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrBy(String key, int value) {
        Long re = 0L;
        try (Jedis sj = this.jedisPool.getResource();){
            re = sj.incrBy(key, (long)value);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hset(String key, Map<String, String> value) {
        try (Jedis sj = this.jedisPool.getResource();){
            sj.hset(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void del(String key) {
        try (Jedis sj = this.jedisPool.getResource();){
            sj.del(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hset(String key, String field, String value) {
        try (Jedis sj = this.jedisPool.getResource();){
            sj.hset(key, field, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hdel(String key, String ... field) {
        try (Jedis sj = this.jedisPool.getResource();){
            sj.hdel(key, field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hget(String key, String field) {
        String value = "";
        try (Jedis sj = this.jedisPool.getResource();){
            value = sj.hget(key, field);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> hgetAll(String key) {
        HashMap<String, String> value = new HashMap();
        try (Jedis sj = this.jedisPool.getResource();){
            value = sj.hgetAll(key);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> hmget(String key, String ... field) {
        ArrayList<String> value = new ArrayList();
        try (Jedis sj = this.jedisPool.getResource();){
            value = sj.hmget(key, field);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hincrby(String key, String field, int num) {
        Long re = 0L;
        try (Jedis sj = this.jedisPool.getResource();){
            re = sj.hincrBy(key, field, (long)num);
        }
        return re;
    }

    @Override
    public List<String> getMessage(String key, int size) throws LogQueueConnectException {
        ArrayList<String> list = new ArrayList<String>();
        try (Jedis sj = null;){
            Response res2;
            sj = this.jedisPool.getResource();
            Long count = sj.llen(key);
            if (count < (long)size) {
                size = count.intValue();
            }
            if (size == 0) {
                ArrayList<String> arrayList = list;
                return arrayList;
            }
            ArrayList<Response> listRes = new ArrayList<Response>();
            Pipeline pl = sj.pipelined();
            for (int i = 0; i < size && (res2 = pl.lpop(key)) != null; ++i) {
                listRes.add(res2);
            }
            pl.sync();
            for (Response res2 : listRes) {
                String log = (String)res2.get();
                if (log == null) continue;
                list.add(log);
            }
        }
        return list;
    }
}

