/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.server.core.aop;

import cn.gtmap.server.core.dto.TraceMessage;
import cn.gtmap.server.core.send.SendRedisFactory;
import cn.gtmap.server.utils.LogMessageThreadLocal;
import cn.gtmap.server.utils.LogSwitch;
import cn.gtmap.server.utils.TraceId;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogAspect.class);
    private String appName;

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Object aroundExecute(ProceedingJoinPoint joinPoint) throws Throwable {
        Object returnObj = null;
        TraceMessage traceMessage = null;
        try {
            if (LogSwitch.isAopSwitch()) {
                traceMessage = (TraceMessage)LogMessageThreadLocal.logMessageThreadLocal.get();
                String traceId = (String)TraceId.logTraceID.get();
                if (traceMessage == null || traceId == null) {
                    traceMessage = new TraceMessage();
                    traceMessage.getPositionNum().set(0);
                }
                traceMessage.setTraceId(traceId);
                traceMessage.setMessageType(joinPoint.getSignature().toString());
                traceMessage.setPosition("<");
                traceMessage.getPositionNum().incrementAndGet();
                LogMessageThreadLocal.logMessageThreadLocal.set((Object)traceMessage);
                SendRedisFactory.sendMsgToRedis(traceMessage, this.appName);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u94fe\u8def\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        try {
            if (LogSwitch.isAopAroundSwitch()) {
                SendRedisFactory.sendMsgToRedis(StringUtils.join((Object[])joinPoint.getArgs(), (String)"|"), joinPoint.getSignature().getDeclaringType().getName(), joinPoint.getSignature().getName(), "INTERCEPTOR", this.appName);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u670d\u52a1\u5165\u53c2\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        try {
            returnObj = joinPoint.proceed();
        }
        catch (Throwable e) {
            if (LogSwitch.isAopAroundSwitch()) {
                String message = e.getMessage();
                if (StringUtils.isBlank((CharSequence)message)) {
                    message = e.toString();
                    StackTraceElement[] stackTraceElement = e.getStackTrace();
                    if (stackTraceElement != null && stackTraceElement.length > 0) {
                        for (StackTraceElement s : stackTraceElement) {
                            message = message + "\n\tat " + s.toString();
                        }
                    }
                }
                SendRedisFactory.sendMsgToRedis(message, joinPoint.getSignature().getDeclaringType().getName(), joinPoint.getSignature().getName(), "INTERCEPTOR", this.appName);
            }
            throw e;
        }
        try {
            if (LogSwitch.isAopSwitch()) {
                traceMessage.setMessageType(joinPoint.getSignature().toString());
                traceMessage.setPosition(">");
                traceMessage.getPositionNum().incrementAndGet();
                SendRedisFactory.sendMsgToRedis(traceMessage, this.appName);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u94fe\u8def\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        try {
            if (LogSwitch.isAopAroundSwitch()) {
                String result = "";
                if (returnObj != null) {
                    result = returnObj.getClass().isPrimitive() ? String.valueOf(returnObj) : JSONObject.toJSONString((Object)returnObj);
                }
                SendRedisFactory.sendMsgToRedis(result, joinPoint.getSignature().getDeclaringType().getName(), joinPoint.getSignature().getName(), "INTERCEPTOR", this.appName);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u670d\u52a1\u51fa\u53c2\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return returnObj;
    }
}

