/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.server.core.Interceptor;

import cn.gtmap.server.core.send.SendRedisFactory;
import cn.gtmap.server.utils.LogSwitch;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class WebInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebInterceptor.class);
    private String appName;

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (LogSwitch.isSpringSwitch()) {
            try {
                SendRedisFactory.sendMsgToRedis(request, handler, "INTERCEPTOR", this.appName);
            }
            catch (Exception e) {
                LOGGER.error("spring\u62e6\u622a\u5668\u65e5\u5fd7\u5f02\u5e38:{}", (Throwable)e);
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

