/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.server.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import cn.gtmap.server.core.dto.BaseLogMessage;
import cn.gtmap.server.core.dto.RunLogMessage;
import cn.gtmap.server.core.factory.MessageAppenderFactory;
import cn.gtmap.server.core.redis.RedisAbstractClient;
import cn.gtmap.server.core.redis.RedisClient;
import cn.gtmap.server.core.redis.RedisClusterClient;
import cn.gtmap.server.core.redis.RedisSentinelClient;
import cn.gtmap.server.logback.utils.LogMessageUtil;
import cn.gtmap.server.utils.LogMessageConstant;
import cn.gtmap.server.utils.ThreadPoolUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;

public class RedisAppender
extends AppenderBase<ILoggingEvent> {
    private RedisAbstractClient redisClient;
    private String appName;
    private String redisHost;
    private String redisPort;
    private String redisAuth;
    private String runModel;
    private String expand;
    private String redisModel;
    private String masterName;
    private int redisDb = 0;
    private int maxCount = 1000;
    private static ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getPool();

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setRedisHost(String redisHost) {
        this.redisHost = redisHost;
    }

    public void setRedisPort(String redisPort) {
        this.redisPort = redisPort;
    }

    public void setRedisAuth(String redisAuth) {
        this.redisAuth = redisAuth;
    }

    public void setRunModel(String runModel) {
        this.runModel = runModel;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void setRedisModel(String redisModel) {
        this.redisModel = redisModel;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public void setRedisDb(int redisDb) {
        this.redisDb = redisDb;
    }

    protected void append(ILoggingEvent event) {
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage(this.appName, event);
        if (logMessage instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage(logMessage, event);
            MessageAppenderFactory.pushRundataQueue(message);
        } else {
            MessageAppenderFactory.pushTracedataQueue(JSONObject.toJSONString((Object)logMessage));
        }
    }

    public void start() {
        super.start();
        if (this.runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(this.runModel);
        }
        if (this.expand != null && LogMessageConstant.EXPANDS.contains(this.expand)) {
            LogMessageConstant.EXPAND = this.expand;
        }
        if (this.redisClient == null) {
            try {
                this.redisClient = StringUtils.equals((CharSequence)this.redisModel, (CharSequence)"cluster") ? RedisClusterClient.getInstance(this.redisHost, this.redisAuth) : (StringUtils.equals((CharSequence)this.redisModel, (CharSequence)"sentinel") ? RedisSentinelClient.getInstance(this.redisHost, this.masterName, this.redisAuth, this.redisDb) : RedisClient.getInstance(this.redisHost, Integer.parseInt(this.redisPort), this.redisAuth));
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        for (int a = 0; a < 5; ++a) {
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MessageAppenderFactory.startRunLog(RedisAppender.this.redisClient, RedisAppender.this.maxCount);
                }
            });
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MessageAppenderFactory.startTraceLog(RedisAppender.this.redisClient, RedisAppender.this.maxCount);
                }
            });
        }
    }
}

