/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.server.core.factory;

import cn.gtmap.server.core.exception.LogQueueConnectException;
import cn.gtmap.server.core.redis.RedisAbstractClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import sun.misc.Cache;

public class MessageAppenderFactory {
    private static Boolean logOutPut = true;
    private static BlockingQueue<String> rundataQueue = new LinkedBlockingQueue<String>(20000);
    private static BlockingQueue<String> tracedataQueue = new LinkedBlockingQueue<String>(20000);
    private static final Cache cache = new Cache();

    public static void pushRundataQueue(String message) {
        if (rundataQueue.size() < 20000) {
            rundataQueue.add(message);
        }
    }

    public static void pushTracedataQueue(String message) {
        if (tracedataQueue.size() < 20000) {
            tracedataQueue.add(message);
        }
    }

    public static void push(String redisKey, List<String> baseLogMessage, RedisAbstractClient client, String logOutPutKey) {
        logOutPut = (Boolean)cache.get((Object)logOutPutKey);
        if (logOutPut == null || logOutPut.booleanValue()) {
            try {
                client.putMessageList(redisKey, baseLogMessage);
                cache.put((Object)logOutPutKey, (Object)true);
            }
            catch (LogQueueConnectException e) {
                cache.put((Object)logOutPutKey, (Object)false);
                e.printStackTrace();
            }
        } else {
            if (redisKey.equals("plume_log_list")) {
                rundataQueue.addAll(baseLogMessage);
            }
            if (redisKey.equals("plume_trace_list")) {
                tracedataQueue.addAll(baseLogMessage);
            }
        }
    }

    public static void startRunLog(RedisAbstractClient client, int maxCount) {
        while (true) {
            try {
                while (true) {
                    ArrayList<String> logs;
                    int count;
                    if ((count = rundataQueue.drainTo(logs = new ArrayList<String>(), maxCount)) > 0) {
                        MessageAppenderFactory.push("plume_log_list", logs, client, "plume.log.ack");
                        continue;
                    }
                    String log = rundataQueue.take();
                    logs.add(log);
                    MessageAppenderFactory.push("plume_log_list", logs, client, "plume.log.ack");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public static void startTraceLog(RedisAbstractClient client, int maxCount) {
        while (true) {
            try {
                while (true) {
                    ArrayList<String> logs;
                    int count;
                    if ((count = tracedataQueue.drainTo(logs = new ArrayList<String>(), maxCount)) > 0) {
                        MessageAppenderFactory.push("plume_trace_list", logs, client, "plume.log.ack");
                        continue;
                    }
                    String log = tracedataQueue.take();
                    logs.add(log);
                    MessageAppenderFactory.push("plume_trace_list", logs, client, "plume.log.ack");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }
}

