/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.server.core.Interceptor;

import cn.gtmap.server.core.send.SendRedisFactory;
import cn.gtmap.server.utils.LogSwitch;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MybatisInterceptor
implements Interceptor {
    private String appName;
    private static final Logger LOGGER = LoggerFactory.getLogger(MybatisInterceptor.class);

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[1];
        }
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        Configuration configuration = mappedStatement.getConfiguration();
        String sql = this.getSql(configuration, boundSql);
        if (LogSwitch.isMybatisSwitch()) {
            try {
                SendRedisFactory.sendMsgToRedis(sql, this.getClass().getName(), "intercept", "MYBATIS", this.appName);
            }
            catch (Exception e) {
                LOGGER.error("mybatis\u62e6\u622a\u5668\u65e5\u5fd7\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
        try {
            return invocation.proceed();
        }
        catch (InvocationTargetException e) {
            LOGGER.error("mybatis\u62e6\u622a\u5668\u65e5\u5fd7\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("mybatis\u62e6\u622a\u5668\u65e5\u5fd7\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return null;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.appName = properties.getProperty("appName");
    }

    private String getSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterObject == null || parameterMappings.size() == 0) {
            return sql;
        }
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
            sql = sql.replaceFirst("\\?", this.getParameterValue(parameterObject));
        } else {
            MetaObject metaObject = configuration.newMetaObject(parameterObject);
            for (ParameterMapping parameterMapping : parameterMappings) {
                Object obj;
                String propertyName = parameterMapping.getProperty();
                if (metaObject.hasGetter(propertyName)) {
                    obj = metaObject.getValue(propertyName);
                    sql = sql.replaceFirst("\\?", this.getParameterValue(obj));
                    sql = sql.replaceAll("RDS_CHAR_DOLLAR", "\\$");
                    continue;
                }
                if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                obj = boundSql.getAdditionalParameter(propertyName);
                sql = sql.replaceFirst("\\?", this.getParameterValue(obj));
                sql = sql.replaceAll("RDS_CHAR_DOLLAR", "\\$");
            }
        }
        return sql;
    }

    private String getParameterValue(Object obj) {
        String value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(obj) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        value = value.replaceAll("\\$", "RDS_CHAR_DOLLAR");
        return value;
    }
}

