/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.server.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class DateUtil {
    public static final String DATE_FORMAT_YYYY = "yyyy";
    public static final String DATE_FORMAT_YYYYMM = "yyyyMM";
    public static final String DATE_FORMAT_YYYY_MM = "yyyy-MM";
    public static final String DATE_FORMAT_YYMMDD = "yyMMdd";
    public static final String DATE_FORMAT_YY_MM_DD = "yy-MM-dd";
    public static final String DATE_FORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String DATE_FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String DATE_FORMAT_POINTYYYYMMDD = "yyyy.MM.dd";
    public static final String DATE_TIME_FORMAT_YYYY\u5e74MM\u6708DD\u65e5 = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String DATE_FORMAT_YYYYMMDDHHmm = "yyyyMMddHHmm";
    public static final String DATE_TIME_FORMAT_YYYYMMDD_HH_MI = "yyyyMMdd HH:mm";
    public static final String DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI = "yyyy-MM-dd HH:mm";
    public static final String DATE_TIME_FORMAT_YYYYMMDDHHMISS = "yyyyMMddHHmmss";
    public static final String DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TIME_FORMAT_YYYYMMDDHHMISSSSS = "yyyyMMddHHmmssSSS";
    public static final String DATE_FORMAT_MMDDHHMI = "MM-dd HH:mm";

    public static Integer getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static Integer getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static Integer getDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int day = cal.get(5);
        return day;
    }

    public static String parseDateToStr(Date time, String timeFromat) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(timeFromat);
        return dateFormat.format(time);
    }

    public static String parseTimestampToStr(Timestamp timestamp, String timeFromat) {
        SimpleDateFormat df = new SimpleDateFormat(timeFromat);
        return df.format(timestamp);
    }

    public static String parseDateToStr(Date time, String timeFromat, Date defaultValue) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(timeFromat);
            return dateFormat.format(time);
        }
        catch (Exception e) {
            if (defaultValue != null) {
                return DateUtil.parseDateToStr(defaultValue, timeFromat);
            }
            return DateUtil.parseDateToStr(new Date(), timeFromat);
        }
    }

    public static String parseDateToStr(Date time, String timeFromat, String defaultValue) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(timeFromat);
            return dateFormat.format(time);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Date parseStrToDate(String time, String timeFromat) {
        if (time == null || time.equals("")) {
            return null;
        }
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(timeFromat);
            date = dateFormat.parse(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Date parseStrToDate(String strTime, String timeFromat, Date defaultValue) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(timeFromat);
            return dateFormat.parse(strTime);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Date strToDate(String strTime) {
        if (strTime == null || strTime.trim().length() <= 0) {
            return null;
        }
        Date date = null;
        ArrayList<String> list = new ArrayList<String>(0);
        list.add(DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI_SS);
        list.add(DATE_TIME_FORMAT_YYYYMMDDHHMISSSSS);
        list.add(DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI);
        list.add(DATE_TIME_FORMAT_YYYYMMDD_HH_MI);
        list.add(DATE_TIME_FORMAT_YYYYMMDDHHMISS);
        list.add(DATE_FORMAT_YYYY_MM_DD);
        list.add(DATE_FORMAT_YYYYMMDD);
        list.add(DATE_FORMAT_YYYY_MM);
        list.add(DATE_FORMAT_YYYYMM);
        list.add(DATE_FORMAT_YYYY);
        for (String format : list) {
            if (strTime.indexOf("-") > 0 && format.indexOf("-") < 0 || strTime.indexOf("-") < 0 && format.indexOf("-") > 0 || strTime.length() > format.length() || (date = DateUtil.parseStrToDate(strTime, format)) == null) continue;
            break;
        }
        return date;
    }

    public static List<String> getMonthListOfDate(String beginDateStr, String endDateStr) {
        SimpleDateFormat f = new SimpleDateFormat(DATE_FORMAT_YYYY_MM);
        String sRet = "";
        Date beginDate = null;
        Date endDate = null;
        GregorianCalendar beginGC = null;
        GregorianCalendar endGC = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            beginDate = f.parse(beginDateStr);
            endDate = f.parse(endDateStr);
            beginGC = new GregorianCalendar();
            beginGC.setTime(beginDate);
            endGC = new GregorianCalendar();
            endGC.setTime(endDate);
            while (beginGC.getTime().compareTo(endGC.getTime()) <= 0) {
                sRet = beginGC.get(1) + "-" + (beginGC.get(2) + 1);
                list.add(sRet);
                beginGC.add(2, 1);
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> getDayListOfDate(String beginDateStr, String endDateStr) {
        SimpleDateFormat f = new SimpleDateFormat(DATE_FORMAT_YYYY_MM_DD);
        Date beginDate = null;
        Date endDate = null;
        Calendar beginGC = null;
        Calendar endGC = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            beginDate = f.parse(beginDateStr);
            endDate = f.parse(endDateStr);
            beginGC = Calendar.getInstance();
            beginGC.setTime(beginDate);
            endGC = Calendar.getInstance();
            endGC.setTime(endDate);
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_YYYY_MM_DD);
            while (beginGC.getTime().compareTo(endGC.getTime()) <= 0) {
                list.add(sdf.format(beginGC.getTime()));
                beginGC.add(5, 1);
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Integer> getYearListOfYears(int before, int behind) {
        if (before < 0 || behind < 0) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        Calendar c = null;
        c = Calendar.getInstance();
        c.setTime(new Date());
        int currYear = Calendar.getInstance().get(1);
        int startYear = currYear - before;
        int endYear = currYear + behind;
        for (int i = startYear; i < endYear; ++i) {
            list.add(i);
        }
        return list;
    }

    public static Integer getWeekthOfYear(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setMinimalDaysInFirstWeek(7);
        c.setTime(date);
        return c.get(3);
    }

    public static HashMap<Integer, String> getWeekTimeOfYear(int year) {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        GregorianCalendar c = new GregorianCalendar();
        c.set(year, 11, 31, 23, 59, 59);
        int count = DateUtil.getWeekthOfYear(c.getTime());
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_YYYY_MM_DD);
        String dayOfWeekStart = "";
        String dayOfWeekEnd = "";
        for (int i = 1; i <= count; ++i) {
            dayOfWeekStart = sdf.format(DateUtil.getFirstDayOfWeek(year, i));
            dayOfWeekEnd = sdf.format(DateUtil.getLastDayOfWeek(year, i));
            map.put(i, "\u7b2c" + i + "\u5468(\u4ece" + dayOfWeekStart + "\u81f3" + dayOfWeekEnd + ")");
        }
        return map;
    }

    public static Integer getWeekCountOfYear(int year) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(year, 11, 31, 23, 59, 59);
        int count = DateUtil.getWeekthOfYear(c.getTime());
        return count;
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        return c.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek() + 6);
        return c.getTime();
    }

    public static Date getFirstDayOfWeek(int year, int week) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(1, year);
        c.set(2, 0);
        c.set(5, 1);
        GregorianCalendar cal = (GregorianCalendar)((Calendar)c).clone();
        ((Calendar)cal).add(5, week * 7);
        return DateUtil.getFirstDayOfWeek(cal.getTime());
    }

    public static Date getLastDayOfWeek(int year, int week) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(1, year);
        c.set(2, 0);
        c.set(5, 1);
        GregorianCalendar cal = (GregorianCalendar)((Calendar)c).clone();
        ((Calendar)cal).add(5, week * 7);
        return DateUtil.getLastDayOfWeek(cal.getTime());
    }

    public static Date getFirstDayOfMonth(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, --month);
        int day = c.getActualMinimum(5);
        c.set(5, day);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getLastDayOfMonth(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, --month);
        int day = c.getActualMaximum(5);
        c.set(5, day);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static String getDayWeekOfDate1(Date date) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static Integer getDayWeekOfDate2(Date date) {
        Calendar aCalendar = Calendar.getInstance();
        aCalendar.setTime(date);
        int weekDay = aCalendar.get(7);
        return weekDay;
    }

    public static boolean validateIsDate(String strTime) {
        if (strTime == null || strTime.trim().length() <= 0) {
            return false;
        }
        Date date = null;
        ArrayList<String> list = new ArrayList<String>(0);
        list.add(DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI_SS);
        list.add(DATE_TIME_FORMAT_YYYYMMDDHHMISSSSS);
        list.add(DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI);
        list.add(DATE_TIME_FORMAT_YYYYMMDD_HH_MI);
        list.add(DATE_TIME_FORMAT_YYYYMMDDHHMISS);
        list.add(DATE_FORMAT_YYYY_MM_DD);
        list.add(DATE_FORMAT_YYYYMMDD);
        for (String format : list) {
            if (strTime.indexOf("-") > 0 && format.indexOf("-") < 0 || strTime.indexOf("-") < 0 && format.indexOf("-") > 0 || strTime.length() > format.length() || (date = DateUtil.parseStrToDate(strTime.trim(), format)) == null) continue;
            break;
        }
        if (date != null) {
            System.out.println("\u751f\u6210\u7684\u65e5\u671f:" + DateUtil.parseDateToStr(date, DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI_SS, "--null--"));
            return true;
        }
        return false;
    }

    public static Date formatHhMmSsOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date addDate(Date date, int year, int month, int day, int hour, int minute, int second, int millisecond) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, year);
        c.add(2, month);
        c.add(5, day);
        c.add(10, hour);
        c.add(12, minute);
        c.add(13, second);
        c.add(14, millisecond);
        return c.getTime();
    }

    public static Long getDistanceTimestamp(Date startDate, Date endDate) {
        long daysBetween = (endDate.getTime() - startDate.getTime() + 1000000L) / 86400000L;
        return daysBetween;
    }

    public static Boolean compareIsSameMonth(Date date1, Date date2) {
        int month2;
        int month1;
        int year2;
        boolean flag = false;
        int year1 = DateUtil.getYear(date1);
        if (year1 == (year2 = DateUtil.getYear(date2).intValue()) && (month1 = DateUtil.getMonth(date1).intValue()) == (month2 = DateUtil.getMonth(date2).intValue())) {
            flag = true;
        }
        return flag;
    }

    public static long[] getDistanceTime(Date one, Date two) {
        long day = 0L;
        long hour = 0L;
        long min = 0L;
        long sec = 0L;
        try {
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 < time2 ? time2 - time1 : time1 - time2;
            day = diff / 86400000L;
            hour = diff / 3600000L - day * 24L;
            min = diff / 60000L - day * 24L * 60L - hour * 60L;
            sec = diff / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long[] times = new long[]{day, hour, min, sec};
        return times;
    }

    public static long[] getDistanceTime(String str1, String str2) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI_SS);
        long day = 0L;
        long hour = 0L;
        long min = 0L;
        long sec = 0L;
        try {
            Date one = df.parse(str1);
            Date two = df.parse(str2);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 < time2 ? time2 - time1 : time1 - time2;
            day = diff / 86400000L;
            hour = diff / 3600000L - day * 24L;
            min = diff / 60000L - day * 24L * 60L - hour * 60L;
            sec = diff / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        long[] times = new long[]{day, hour, min, sec};
        return times;
    }

    public static Long getDistanceDays(String str1, String str2) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat(DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI_SS);
        long days = 0L;
        try {
            Date one = df.parse(str1);
            Date two = df.parse(str2);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 < time2 ? time2 - time1 : time1 - time2;
            days = diff / 86400000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static Date getDayBeginTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getDayEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }
}

