/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.server.logback.utils;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import cn.gtmap.server.core.dto.BaseLogMessage;
import cn.gtmap.server.core.dto.RunLogMessage;
import cn.gtmap.server.core.dto.TraceMessage;
import cn.gtmap.server.core.factory.TraceLogMessageFactory;
import cn.gtmap.server.utils.DateUtil;
import cn.gtmap.server.utils.LogExceptionStackTrace;
import cn.gtmap.server.utils.LogMessageConstant;
import cn.gtmap.server.utils.LogMessageThreadLocal;
import cn.gtmap.server.utils.TraceId;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;

public class LogMessageUtil {
    private static String isExpandRunLog(ILoggingEvent logEvent) {
        String traceId = null;
        if (LogMessageConstant.EXPAND.equals("sleuth") && !logEvent.getMDCPropertyMap().isEmpty()) {
            traceId = (String)logEvent.getMDCPropertyMap().get("traceId");
            TraceId.logTraceID.set((Object)traceId);
        }
        return traceId;
    }

    public static String getLogMessage(BaseLogMessage baseLogMessage, ILoggingEvent iLoggingEvent) {
        Map mdc = iLoggingEvent.getMDCPropertyMap();
        Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)baseLogMessage), Map.class);
        if (mdc != null) {
            map.putAll(mdc);
        }
        return JSONObject.toJSONString((Object)map);
    }

    public static BaseLogMessage getLogMessage(String appName, ILoggingEvent iLoggingEvent) {
        String traceId = LogMessageUtil.isExpandRunLog(iLoggingEvent);
        TraceMessage traceMessage = (TraceMessage)LogMessageThreadLocal.logMessageThreadLocal.get();
        String formattedMessage = LogMessageUtil.getMessage(iLoggingEvent);
        if (formattedMessage.startsWith("TRACE:")) {
            if (!LogMessageConstant.EXPAND.equals("plumelog") && traceId != null) {
                traceMessage.setTraceId(traceId);
            }
            return TraceLogMessageFactory.getTraceLogMessage(traceMessage, appName, iLoggingEvent.getTimeStamp());
        }
        RunLogMessage logMessage = TraceLogMessageFactory.getLogMessage(appName, formattedMessage, iLoggingEvent.getTimeStamp());
        logMessage.setClassName(iLoggingEvent.getLoggerName());
        if (LogMessageConstant.RUN_MODEL == 1) {
            logMessage.setMethod(iLoggingEvent.getThreadName());
        } else {
            StackTraceElement atackTraceElement = iLoggingEvent.getCallerData()[0];
            String method = atackTraceElement.getMethodName();
            String line = String.valueOf(atackTraceElement.getLineNumber());
            logMessage.setMethod(method + "(" + atackTraceElement.getFileName() + ":" + line + ")");
            logMessage.setDateTime(DateUtil.parseDateToStr(new Date(iLoggingEvent.getTimeStamp()), "yyyy-MM-dd HH:mm:ss"));
        }
        logMessage.setLogLevel(iLoggingEvent.getLevel().toString());
        return logMessage;
    }

    private static String getMessage(ILoggingEvent logEvent) {
        if (logEvent.getLevel().equals(Level.ERROR)) {
            if (logEvent.getThrowableProxy() != null) {
                ThrowableProxy throwableProxy = (ThrowableProxy)logEvent.getThrowableProxy();
                Object[] args = new String[]{LogExceptionStackTrace.erroStackTrace(throwableProxy.getThrowable()).toString()};
                return LogMessageUtil.packageMessage(logEvent.getMessage(), args);
            }
            Object[] args = logEvent.getArgumentArray();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof Throwable)) continue;
                    args[i] = LogExceptionStackTrace.erroStackTrace(args[i]);
                }
                return LogMessageUtil.packageMessage(logEvent.getMessage(), args);
            }
        }
        return logEvent.getFormattedMessage();
    }

    private static String packageMessage(String message, Object[] args) {
        if (message != null && message.indexOf("{}") > -1) {
            return MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        }
        return TraceLogMessageFactory.packageMessage(message, args);
    }

    public static BaseLogMessage getLogMessage(String appName, TraceMessage traceMessage) {
        return TraceLogMessageFactory.getTraceLogMessage(traceMessage, appName, System.currentTimeMillis());
    }

    public static BaseLogMessage getLogMessage(String appName, HttpServletRequest request, HandlerMethod handlerMethod, String logLevel) {
        String formattedMessage = JSONObject.toJSONString((Object)request.getParameterMap());
        RunLogMessage logMessage = TraceLogMessageFactory.getLogMessage(appName, formattedMessage, new Date().getTime());
        if (handlerMethod != null) {
            logMessage.setClassName(handlerMethod.getBean().getClass().getName());
            logMessage.setMethod(handlerMethod.getMethod().getName());
        }
        if (request.getParameterMap() != null && request.getParameterMap().size() != 0) {
            logMessage.setContent(JSONObject.toJSONString((Object)request.getParameterMap()));
        }
        if (request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE) != null) {
            logMessage.setContent(JSONObject.toJSONString((Object)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE)));
        }
        logMessage.setDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        logMessage.setLogLevel(logLevel);
        return logMessage;
    }

    public static BaseLogMessage getLogMessage(String appName, String msg, String className, String method, String logLevel) {
        RunLogMessage logMessage = TraceLogMessageFactory.getLogMessage(appName, msg, new Date().getTime());
        if (className != null) {
            logMessage.setClassName(className);
        }
        if (method != null) {
            logMessage.setMethod(method);
        }
        logMessage.setContent(msg);
        logMessage.setDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        logMessage.setLogLevel(logLevel);
        return logMessage;
    }
}

