/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.log.web;

import cn.gtmap.gtcc.domain.log.ResponseMessage;
import cn.gtmap.log.domain.es.HttpMethod;
import cn.gtmap.log.domain.message.RequestMessage;
import cn.gtmap.log.domain.message.StatisticsRequestMessage;
import cn.gtmap.log.server.HistoryResourceLogService;
import cn.gtmap.log.server.HotResourceLogService;
import cn.gtmap.log.util.JSONUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/log/server"})
public class LogController {
    @Autowired
    HistoryResourceLogService historyQueryInfoMessage;
    @Autowired
    HotResourceLogService hotQueryInfoMessage;
    @Autowired
    RestClient restClient;

    @GetMapping(value={"/hot"})
    public ResponseMessage getHotResource(@RequestParam(name="servername") String serverName, @RequestParam(name="starttime") Long startTime, @RequestParam(name="endtime") Long endTime) throws IOException {
        Map params = Collections.emptyMap();
        String es_search = "{\n  \"size\": 0,\n  \"query\": {\n    \"bool\": {\n      \"must\": [\n        {\n          \"wildcard\": {\n            \"name\": \"${url}\"\n          }\n        },\n        {\n          \"range\": {\n            \"timestamp_millis\": {\n              \"gte\": \"${start}\",\n              \"lte\": \"${end}\"\n            }\n          }\n        }\n      ]\n    }\n  },\n  \"aggs\": {\n    \"xx\": {\n      \"nested\": {\n        \"path\": \"binaryAnnotations\"\n      },\n      \"aggs\": {\n        \"tsdd\": {\n          \"filter\": {\n            \"term\": {\n              \"binaryAnnotations.key\": \"custom\"\n            }\n          },\n          \"aggs\": {\n            \"terms\": {\n              \"terms\": {\n                \"field\": \"binaryAnnotations.value\",\n                \"size\": 10\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n}".replace("${start}", startTime + "").replace("${end}", endTime + "").replace("${url}", serverName);
        NStringEntity entity = new NStringEntity(es_search, ContentType.APPLICATION_JSON);
        Response response = this.restClient.performRequest(HttpMethod.POST.getName(), "/zipkin-*/_search?size=0", params, (HttpEntity)entity, new Header[0]);
        return JSONUtil.getResponseMessage((String)EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    @GetMapping(value={"/total"})
    public ResponseMessage getAllResource(@RequestParam(name="servername") String serverName, @RequestParam(name="starttime") Long startTime, @RequestParam(name="endtime") Long endTime) throws IOException {
        Map params = Collections.emptyMap();
        String es_search = "{\n  \"size\": 0,\n  \"query\": {\n    \"bool\": {\n      \"must\": [\n        {\n          \"wildcard\": {\n            \"name\": \"${url}\"\n          }\n        },\n        {\n          \"range\": {\n            \"timestamp_millis\": {\n              \"gte\": \"${begin}\",\n              \"lte\": \"${end}\"\n            }\n          }\n        }\n      ]\n    }\n  }\n}".replace("${begin}", startTime + "").replace("${end}", endTime + "").replace("${url}", serverName);
        System.out.println(es_search);
        NStringEntity entity = new NStringEntity(es_search, ContentType.APPLICATION_JSON);
        Response response = this.restClient.performRequest(HttpMethod.POST.getName(), "/zipkin-*/_search?size=0", params, (HttpEntity)entity, new Header[0]);
        return JSONUtil.getCountByResourceId((String)EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    @GetMapping(value={"/days"})
    public ResponseMessage getDaysInfoBySearchName(@RequestParam(name="servername") String serverName, @RequestParam(name="startTime") long startTime, @RequestParam(name="endTime") long endTime, @RequestParam(name="interval") String interval) throws IOException {
        StatisticsRequestMessage statisticsRequestMessage = new StatisticsRequestMessage();
        statisticsRequestMessage.setUrlName(serverName);
        statisticsRequestMessage.setBeginTime(startTime);
        statisticsRequestMessage.setEndTime(endTime);
        statisticsRequestMessage.setInterval(interval);
        return this.historyQueryInfoMessage.getRequestMessage((RequestMessage)statisticsRequestMessage);
    }
}

