/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.log.server;

import cn.gtmap.gtcc.domain.log.Data;
import cn.gtmap.gtcc.domain.log.ResponseMessage;
import cn.gtmap.log.domain.es.EsPredicate;
import cn.gtmap.log.domain.message.RequestMessage;
import cn.gtmap.log.domain.message.StatisticsRequestMessage;
import cn.gtmap.log.domain.query.QueryMetadata;
import cn.gtmap.log.service.AbstractQueryInfoMessage;
import cn.gtmap.log.service.ExplainQueryMetadata;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;

public class HotResourceLogService
extends AbstractQueryInfoMessage {
    @Autowired
    ExplainQueryMetadata explainQueryMetadata;

    public HotResourceLogService(ExplainQueryMetadata searchByQueryMetadata) {
        super(searchByQueryMetadata);
    }

    public QueryMetadata converRequestMessage(RequestMessage requestMessage) {
        StatisticsRequestMessage statisticsRequestMessage = (StatisticsRequestMessage)requestMessage;
        long startTime = statisticsRequestMessage.getBeginTime();
        long endTime = statisticsRequestMessage.getEndTime();
        String searchUrl = statisticsRequestMessage.getUrlName();
        QueryMetadata queryMetadata = new QueryMetadata();
        queryMetadata.setEndpoint("/zipkin-*/_search?size=0");
        ArrayList<QueryMetadata.MustQueryMetaData> queryMetaDataList = new ArrayList<QueryMetadata.MustQueryMetaData>();
        QueryMetadata.AggregationMetaData aggregationMetaData = new QueryMetadata.AggregationMetaData(queryMetadata);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("field", "name");
        aggregationMetaData.addType(EsPredicate.TERMS.getName()).addParams(params).addBlukName("count");
        if (searchUrl != null) {
            QueryMetadata.MustQueryMetaData queryMetaData = new QueryMetadata.MustQueryMetaData(queryMetadata);
            ArrayList<String> symbolValue = new ArrayList<String>();
            symbolValue.add(statisticsRequestMessage.getUrlName());
            ArrayList<String> symbols = new ArrayList<String>();
            symbols.add("equals");
            queryMetaDataList.add(queryMetaData);
            queryMetaData.addFilterDo("regexp").addSymbolAndValue(symbols, symbolValue).addFieldName("name");
        }
        if (startTime != 0L && endTime != 0L) {
            QueryMetadata.MustQueryMetaData queryMetaData1 = new QueryMetadata.MustQueryMetaData(queryMetadata);
            ArrayList<String> symbolValue1 = new ArrayList<String>();
            symbolValue1.add(statisticsRequestMessage.getBeginTime() + "");
            symbolValue1.add(statisticsRequestMessage.getEndTime() + "");
            ArrayList<String> symbols1 = new ArrayList<String>();
            symbols1.add("gte");
            symbols1.add("lte");
            queryMetaDataList.add(queryMetaData1);
            queryMetaData1.addFilterDo(EsPredicate.RANGE.getName()).addSymbolAndValue(symbols1, symbolValue1).addFieldName("timestamp_millis");
        }
        queryMetadata.setAggregationMetaData(aggregationMetaData);
        queryMetadata.setQueryMustMetaData(queryMetaDataList);
        return queryMetadata;
    }

    public ResponseMessage analysisSearchResponse(RequestMessage requestMessage, String data) {
        ResponseMessage responseMessage = new ResponseMessage();
        StatisticsRequestMessage statisticsRequestMessage = (StatisticsRequestMessage)requestMessage;
        ArrayList<Data> dataList = new ArrayList<Data>();
        String datas = data.replaceAll("/n", "");
        TreeMap<Long, String> statisticalData = new TreeMap<Long, String>();
        JSONObject jsonObject = JSON.parseObject((String)datas);
        JSONObject tt = null;
        JSONObject t = (JSONObject)jsonObject.get((Object)"aggregations");
        Iterator<Object> iterator = t.keySet().iterator();
        if (iterator.hasNext()) {
            String string = (String)iterator.next();
            tt = (JSONObject)t.get((Object)string);
        }
        if (tt != null) {
            JSONArray ttt = (JSONArray)tt.get((Object)"buckets");
            for (JSONObject json : ttt.toJavaList(JSONObject.class)) {
                Data data1 = new Data();
                data1.setKey(json.get((Object)"key").toString());
                data1.setValue(Long.valueOf(json.get((Object)"doc_count").toString()).longValue());
                statisticalData.put(Long.valueOf(json.get((Object)"doc_count").toString()), json.get((Object)"key").toString());
                dataList.add(data1);
            }
        }
        for (Map.Entry entry : statisticalData.entrySet()) {
            System.out.println(entry.getKey() + "::" + (String)entry.getValue());
        }
        responseMessage.setDatas(dataList);
        responseMessage.setResponseInfo(JSON.toJSONString(statisticalData));
        responseMessage.setRequestUrl(statisticsRequestMessage.getUrlName());
        return responseMessage;
    }
}

