/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.log.server;

import cn.gtmap.gtcc.domain.log.Data;
import cn.gtmap.gtcc.domain.log.ResponseMessage;
import cn.gtmap.log.domain.es.EsPredicate;
import cn.gtmap.log.domain.message.RequestMessage;
import cn.gtmap.log.domain.message.StatisticsRequestMessage;
import cn.gtmap.log.domain.query.QueryMetadata;
import cn.gtmap.log.service.AbstractQueryInfoMessage;
import cn.gtmap.log.service.ExplainQueryMetadata;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;

public class HistoryResourceLogService
extends AbstractQueryInfoMessage {
    @Autowired
    ExplainQueryMetadata explainQueryMetadata;

    public HistoryResourceLogService(ExplainQueryMetadata searchByQueryMetadata) {
        super(searchByQueryMetadata);
    }

    public QueryMetadata converRequestMessage(RequestMessage requestMessage) {
        StatisticsRequestMessage statisticsRequestMessage = (StatisticsRequestMessage)requestMessage;
        String url = statisticsRequestMessage.getUrlName();
        QueryMetadata queryMetadata = new QueryMetadata();
        queryMetadata.setEndpoint("/zipkin-*/_search?size=0");
        ArrayList<QueryMetadata.MustQueryMetaData> queryMetaDataList = new ArrayList<QueryMetadata.MustQueryMetaData>();
        QueryMetadata.MustQueryMetaData queryMetaData = new QueryMetadata.MustQueryMetaData(queryMetadata);
        ArrayList<String> symbolValue = new ArrayList<String>();
        symbolValue.add(url);
        ArrayList<String> symbols = new ArrayList<String>();
        symbols.add("equals");
        queryMetaDataList.add(queryMetaData);
        queryMetaData.addFilterDo(EsPredicate.WILDCARD.getName()).addSymbolAndValue(symbols, symbolValue).addFieldName("name");
        QueryMetadata.MustQueryMetaData queryMetaData1 = new QueryMetadata.MustQueryMetaData(queryMetadata);
        ArrayList<String> symbolValue1 = new ArrayList<String>();
        symbolValue1.add(statisticsRequestMessage.getBeginTime() + "");
        symbolValue1.add(statisticsRequestMessage.getEndTime() + "");
        ArrayList<String> symbols1 = new ArrayList<String>();
        symbols1.add("gte");
        symbols1.add("lte");
        queryMetaDataList.add(queryMetaData1);
        queryMetaData1.addFilterDo(EsPredicate.RANGE.getName()).addSymbolAndValue(symbols1, symbolValue1).addFieldName("timestamp_millis");
        QueryMetadata.AggregationMetaData aggregationMetaData = new QueryMetadata.AggregationMetaData(queryMetadata);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("field", "timestamp_millis");
        params.put("min_doc_count", 0);
        params.put("interval", statisticsRequestMessage.getInterval());
        aggregationMetaData.addType(EsPredicate.HISTOGRAM.getName()).addParams(params).addBlukName("days");
        queryMetadata.setAggregationMetaData(aggregationMetaData);
        queryMetadata.setQueryMustMetaData(queryMetaDataList);
        return queryMetadata;
    }

    public ResponseMessage analysisSearchResponse(RequestMessage requestMessage, String data) {
        StatisticsRequestMessage statisticsRequestMessage = (StatisticsRequestMessage)requestMessage;
        ResponseMessage responseMessage = new ResponseMessage();
        String datas = data.replaceAll("/n", "");
        JSONObject jsonObject = JSON.parseObject((String)datas);
        JSONObject tt = null;
        JSONObject t = (JSONObject)jsonObject.get((Object)"aggregations");
        Iterator iterator = t.keySet().iterator();
        if (iterator.hasNext()) {
            String key = (String)iterator.next();
            tt = (JSONObject)t.get((Object)key);
        }
        TreeMap<Long, String> statisticalData = new TreeMap<Long, String>();
        ArrayList<Data> dataList = new ArrayList<Data>();
        if (tt != null) {
            JSONArray ttt = (JSONArray)tt.get((Object)"buckets");
            for (JSONObject json : ttt.toJavaList(JSONObject.class)) {
                Data value = new Data();
                statisticalData.put(Long.valueOf(json.get((Object)"key").toString()), json.get((Object)"doc_count").toString());
                value.setValue(Long.valueOf(json.get((Object)"key").toString()).longValue());
                value.setKey(json.get((Object)"doc_count").toString());
                dataList.add(value);
            }
        }
        responseMessage.setDatas(dataList);
        responseMessage.setRequestUrl(statisticsRequestMessage.getUrlName());
        return responseMessage;
    }
}

