/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.log.config;

import cn.gtmap.log.server.HistoryResourceLogService;
import cn.gtmap.log.server.HotResourceLogService;
import cn.gtmap.log.service.ExplainQueryMetadata;
import cn.gtmap.log.service.impl.ExplainQueryMetadataImpl;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ElasticsearchConfig {
    @Value(value="${spring.elasticsearch.host}")
    private String host;
    @Value(value="${spring.elasticsearch.port}")
    private int port;

    @Bean
    public RestClient elasticsearchClient() {
        RestClient restClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.host, this.port, "http")}).build();
        return restClient;
    }

    @Bean(value={"history"})
    public HistoryResourceLogService getHistoryResource() {
        ExplainQueryMetadataImpl defaultSearchByQueryMetadata = new ExplainQueryMetadataImpl(this.elasticsearchClient());
        return new HistoryResourceLogService((ExplainQueryMetadata)defaultSearchByQueryMetadata);
    }

    @Bean(value={"hot"})
    public HotResourceLogService getHotResource() {
        ExplainQueryMetadataImpl defaultSearchByQueryMetadata = new ExplainQueryMetadataImpl(this.elasticsearchClient());
        return new HotResourceLogService((ExplainQueryMetadata)defaultSearchByQueryMetadata);
    }
}

