/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gateway.service.impl;

import cn.gtmap.gtcc.gateway.dao.RouteRepo;
import cn.gtmap.gtcc.gateway.domain.Route;
import cn.gtmap.gtcc.gateway.service.RouteService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.cloud.netflix.zuul.filters.CompositeRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class RouteServiceImpl
implements RouteService {
    ZuulProperties zuulProperties;
    RouteRepo routeRepo;
    CompositeRouteLocator routeLocator;

    public RouteServiceImpl(ZuulProperties zuulProperties, RouteRepo routeRepo, CompositeRouteLocator routeLocator) {
        this.zuulProperties = zuulProperties;
        this.routeRepo = routeRepo;
        this.routeLocator = routeLocator;
        this.setRoutes();
    }

    public void addRoute(Route route) {
        Assert.notNull((Object)route.getPath(), (String)"route path can't be null");
        Assert.notNull((Object)route.getUrl(), (String)"route url can't be null");
        this.routeRepo.save((Object)route);
        this.zuulProperties.getRoutes().put(route.getId(), this.buildZuulRoute(route));
        this.refresh();
    }

    public List<Route> getRoutes() {
        ArrayList<Route> routes = new ArrayList<Route>();
        for (Map.Entry item : this.zuulProperties.getRoutes().entrySet()) {
            routes.add(this.buildRoute((ZuulProperties.ZuulRoute)item.getValue()));
        }
        return routes;
    }

    public void deleteRoute(String path) {
        Optional route = this.routeRepo.findByPath(path);
        if (route.isPresent()) {
            this.zuulProperties.getRoutes().remove(((Route)route.get()).getId());
            this.routeRepo.delete(route.get());
            this.refresh();
        }
    }

    public Set<String> getIgnoreServices() {
        return this.zuulProperties.getIgnoredServices();
    }

    public void ignoreService(String serviceId) {
        Assert.notNull((Object)serviceId, (String)"serviceId can't be null");
        this.routeRepo.save((Object)new Route(serviceId, true));
        this.zuulProperties.getIgnoredServices().add(serviceId);
        this.refresh();
    }

    public void resumeService(String serviceId) {
        Optional route = this.routeRepo.findByServiceId(serviceId);
        if (route.isPresent()) {
            this.zuulProperties.getIgnoredServices().remove(serviceId);
            this.routeRepo.delete(route.get());
            this.refresh();
        }
    }

    private void setRoutes() {
        List routes = this.routeRepo.findAll();
        for (Route route : routes) {
            if (route.isIgnore()) {
                this.zuulProperties.getIgnoredServices().add(route.getServiceId());
                continue;
            }
            this.zuulProperties.getRoutes().put(route.getId(), this.buildZuulRoute(route));
        }
        this.refresh();
    }

    private void refresh() {
        this.routeLocator.refresh();
    }

    private ZuulProperties.ZuulRoute buildZuulRoute(Route route) {
        return new ZuulProperties.ZuulRoute(route.getPath(), route.getUrl());
    }

    private Route buildRoute(ZuulProperties.ZuulRoute route) {
        return new Route(route.getId(), route.getPath(), route.getUrl());
    }
}

