/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dev.web;

import cn.gtmap.dev.service.ArticleBaseService;
import cn.gtmap.dev.service.CommentService;
import cn.gtmap.dev.service.IndexService;
import cn.gtmap.gtcc.domain.dev.Article;
import cn.gtmap.gtcc.domain.dev.Comment;
import cn.gtmap.gtcc.domain.dev.Index;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dev/data/"})
public class EsDataController {
    @Autowired
    ArticleBaseService articleBaseService;
    @Autowired
    IndexService indexService;
    @Autowired
    CommentService commentService;

    @PostMapping(value={"add/article"})
    public String addArticle(@RequestBody Article article) throws IOException, InterruptedException {
        article.setCreatetime(new Date());
        article.setUpdatetime(article.getCreatetime());
        return this.articleBaseService.addArticle(article);
    }

    @PostMapping(value={"search/article"})
    public Article searchArticle(@RequestParam(value="id") String id) throws IOException, InterruptedException {
        return this.articleBaseService.getArticleById(id);
    }

    @PostMapping(value={"search/category"})
    public Page<Article> searchArticleByCategoryId(@RequestParam(value="id") String id, Pageable pageable) throws IOException, InterruptedException {
        return this.articleBaseService.getArticleBydCategoryid(id, pageable);
    }

    @PostMapping(value={"add/comment"})
    public String addComment(@RequestBody Comment comment) throws IOException, InterruptedException {
        comment.setCreatetime(new Date());
        comment.setUpdatetime(comment.getCreatetime());
        comment.setChildren(null);
        return this.commentService.addComment(comment);
    }

    @PostMapping(value={"search/comment/id"})
    public Comment searchComment(@RequestParam(value="id") String id) throws IOException, InterruptedException {
        return this.commentService.getCommentById(id);
    }

    @PostMapping(value={"search/comment/articleid"})
    public Page<Comment> searchCommentByArticleId(@RequestParam(value="articleId") String articleId, Pageable pageable) throws IOException, InterruptedException {
        return this.commentService.getCommentByAritcleId(articleId, pageable);
    }

    @PostMapping(value={"search/comment/commentid"})
    public Page<Comment> searchCommentByCommentId(@RequestParam(value="commentId") String commentId, Pageable pageable) throws IOException, InterruptedException {
        return this.commentService.getCommentByCommentId(commentId, pageable);
    }

    @PostMapping(value={"delete/comment"})
    public void deleteCommentById(@RequestParam(value="commentId") String commentId) throws IOException, InterruptedException {
        this.commentService.deleteCommentById(commentId);
    }

    @PostMapping(value={"delete/article"})
    public void deleteArticleById(@RequestParam(value="articleId") String articleId) throws IOException, InterruptedException {
        this.articleBaseService.deleteArticleById(articleId);
    }

    @PostMapping(value={"update/article"})
    public void updateArticleById(@RequestBody Article article) throws IOException, InterruptedException {
        article.setUpdatetime(new Date());
        this.articleBaseService.updateArticleEsData(article);
    }

    @PostMapping(value={"update/comment"})
    public void updateComment(@RequestBody Comment comment) throws IOException, InterruptedException {
        comment.setUpdatetime(new Date());
        comment.setChildren(null);
        this.commentService.updateComment(comment);
    }

    @PostMapping(value={"search/index/article"})
    public List<Article> getArticleByCatgoryId(@RequestParam(value="categoryid") String categoryid) throws IOException, InterruptedException {
        return this.articleBaseService.getArticleByCatgoryId(categoryid);
    }

    @PostMapping(value={"search/article/fuzz"})
    public Page<Article> getArticleFuzz(@RequestParam(value="query") String query, Pageable pageable) throws IOException, InterruptedException {
        return this.articleBaseService.getArticleByFuzzines(query, pageable);
    }

    @PostMapping(value={"get/index"})
    public List<Index> getParentIndex() throws IOException, InterruptedException {
        return this.indexService.getParentIndex();
    }

    @PostMapping(value={"add/index"})
    public String addIndex(@RequestBody Index index) throws IOException, InterruptedException {
        return this.indexService.addIndex(index);
    }

    @PostMapping(value={"update/index"})
    public boolean updateIndex(@RequestBody Index index) throws IOException, InterruptedException {
        return this.indexService.updateIndex(index);
    }

    @PostMapping(value={"get/parentid"})
    public List<Index> getParentIdIndex(@RequestParam(value="parentId") String parentId) throws IOException, InterruptedException {
        return this.indexService.getIndexByParentId(parentId);
    }

    @PostMapping(value={"delete/index"})
    public boolean deleteIndex(@RequestParam(value="indexId") String indexId) throws IOException, InterruptedException {
        return this.indexService.deleteIndex(indexId);
    }

    @PostMapping(value={"get/indexId"})
    public Index getIndxById(@RequestParam(value="indexId") String indexId) throws IOException, InterruptedException {
        return this.indexService.searchIndexById(indexId);
    }
}

