/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dev.service.impl;

import cn.gtmap.dev.service.IndexService;
import cn.gtmap.dev.util.EsUtil;
import cn.gtmap.gtcc.domain.dev.EsEntity;
import cn.gtmap.gtcc.domain.dev.Index;
import cn.gtmap.gtcc.domain.dev.search.DSLParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.client.RestClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class IndexServcieImpl
implements IndexService {
    @Autowired
    RestClient restClient;

    public RestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public String addIndex(Index index) throws IOException, InterruptedException {
        index.setChildren(null);
        return EsUtil.addBeanToEs((String)"myindex/mulu", (EsEntity)index, (RestClient)this.restClient);
    }

    public boolean deleteIndex(String indexId) throws IOException, InterruptedException {
        return EsUtil.deleteBeanToEs((String)"myindex/mulu", (String)indexId, (RestClient)this.restClient);
    }

    public boolean updateIndex(Index index) throws InterruptedException {
        index.setChildren(null);
        return EsUtil.updateBeanToEs((String)"myindex/mulu", (EsEntity)index, (RestClient)this.restClient);
    }

    public Index searchIndexById(String id) throws IOException, InterruptedException {
        PageRequest pageRequest = new PageRequest(0, 1);
        DSLParam dslParam = new DSLParam();
        dslParam.setSearchParam("id", id);
        List indexs = EsUtil.searchBeanFrommEs((String)"myindex/mulu", (DSLParam)dslParam, (RestClient)this.restClient, (Pageable)pageRequest, Index.class).getContent();
        if (!indexs.isEmpty()) {
            return (Index)indexs.get(0);
        }
        return null;
    }

    public List<Index> getParentIndex() throws IOException, InterruptedException {
        PageRequest pageRequest = new PageRequest(0, 1000);
        DSLParam dslParam = new DSLParam();
        dslParam.setSearchParam("isroot", "true");
        List indexs = EsUtil.searchBeanFrommEs((String)"myindex/mulu", (DSLParam)dslParam, (RestClient)this.restClient, (Pageable)pageRequest, Index.class).getContent();
        if (!indexs.isEmpty()) {
            return indexs;
        }
        return new ArrayList<Index>();
    }

    public List<Index> getIndexByParentId(String parentId) throws IOException, InterruptedException {
        PageRequest pageRequest = new PageRequest(0, 1000);
        DSLParam dslParam = new DSLParam();
        dslParam.setSearchParam("parentid", parentId);
        List indexs = EsUtil.searchBeanFrommEs((String)"myindex/mulu", (DSLParam)dslParam, (RestClient)this.restClient, (Pageable)pageRequest, Index.class).getContent();
        if (!indexs.isEmpty()) {
            return indexs;
        }
        return new ArrayList<Index>();
    }
}

