/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dev.service.impl;

import cn.gtmap.dev.service.CommentService;
import cn.gtmap.dev.util.EsUtil;
import cn.gtmap.gtcc.domain.dev.Comment;
import cn.gtmap.gtcc.domain.dev.EsEntity;
import cn.gtmap.gtcc.domain.dev.search.DSLParam;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.client.RestClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommentServiceImpl
implements CommentService {
    @Autowired
    RestClient restClient;

    public String addComment(Comment comment) throws IOException, InterruptedException {
        return EsUtil.addBeanToEs((String)"comment/abusivearea", (EsEntity)comment, (RestClient)this.restClient);
    }

    public void deleteCommentById(String id) throws IOException, InterruptedException {
        EsUtil.deleteBeanToEs((String)"comment/abusivearea", (String)id, (RestClient)this.restClient);
    }

    public void updateComment(Comment comment) throws IOException, InterruptedException {
        EsUtil.updateBeanToEs((String)"comment/abusivearea", (EsEntity)comment, (RestClient)this.restClient);
    }

    public Comment getCommentById(String id) throws IOException, InterruptedException {
        PageRequest pageRequest = new PageRequest(0, 1);
        DSLParam dslParam = new DSLParam();
        dslParam.setSearchParam("commentid", id);
        List comments = EsUtil.searchBeanFrommEs((String)"comment/abusivearea", (DSLParam)dslParam, (RestClient)this.restClient, (Pageable)pageRequest, Comment.class).getContent();
        if (!CollectionUtils.isEmpty((Collection)comments)) {
            return (Comment)comments.get(0);
        }
        return null;
    }

    public Page<Comment> getCommentByAritcleId(String articleId, Pageable pageable) throws IOException, InterruptedException {
        DSLParam dslParam = new DSLParam();
        dslParam.setSearchParam("articleid", articleId);
        return EsUtil.searchBeanFrommEs((String)"comment/abusivearea", (DSLParam)dslParam, (RestClient)this.restClient, (Pageable)pageable, Comment.class);
    }

    public Page<Comment> getCommentByCommentId(String commmentId, Pageable pageable) throws IOException, InterruptedException {
        DSLParam dslParam = new DSLParam();
        dslParam.setSearchParam("replyid", commmentId);
        return EsUtil.searchBeanFrommEs((String)"comment/abusivearea", (DSLParam)dslParam, (RestClient)this.restClient, (Pageable)pageable, Comment.class);
    }
}

