/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dev.service.impl;

import cn.gtmap.dev.service.ArticleBaseService;
import cn.gtmap.dev.util.EsUtil;
import cn.gtmap.gtcc.domain.dev.Article;
import cn.gtmap.gtcc.domain.dev.EsEntity;
import cn.gtmap.gtcc.domain.dev.search.DSLParam;
import cn.gtmap.gtcc.domain.dev.search.Fuzziness;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.client.RestClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ArticleBaseServiceImpl
implements ArticleBaseService {
    @Autowired
    RestClient restClient;

    public Article getArticleById(String id) throws IOException, InterruptedException {
        PageRequest pageRequest = new PageRequest(0, 1);
        DSLParam dslParam = new DSLParam();
        dslParam.setSearchParam("answersid", id);
        List articles = EsUtil.searchBeanFrommEs((String)"article/freezone", (DSLParam)dslParam, (RestClient)this.restClient, (Pageable)pageRequest, Article.class).getContent();
        if (!articles.isEmpty()) {
            return (Article)articles.get(0);
        }
        return null;
    }

    public Page<Article> getArticleBydCategoryid(String categoryid, Pageable pageable) throws IOException, InterruptedException {
        DSLParam dslParam = new DSLParam();
        dslParam.setSearchParam("categoryid", categoryid);
        return EsUtil.searchBeanFrommEs((String)"article/freezone", (DSLParam)dslParam, (RestClient)this.restClient, (Pageable)pageable, Article.class);
    }

    public boolean deleteArticleById(String articleId) throws IOException, InterruptedException {
        return EsUtil.deleteBeanToEs((String)"article/freezone", (String)articleId, (RestClient)this.restClient);
    }

    public String addArticle(Article article) throws IOException, InterruptedException {
        return EsUtil.addBeanToEs((String)"article/freezone", (EsEntity)article, (RestClient)this.restClient);
    }

    public boolean updateArticleEsData(Article article) throws InterruptedException {
        return EsUtil.updateBeanToEs((String)"article/freezone", (EsEntity)article, (RestClient)this.restClient);
    }

    public List<Article> getArticleByCatgoryId(String categoryid) throws IOException, InterruptedException {
        return EsUtil.searchBeanFrommEs1((String)"article/freezone", (String)categoryid, (RestClient)this.restClient, Article.class);
    }

    public Page<Article> getArticleByFuzzines(String query, Pageable pageable) throws IOException, InterruptedException {
        DSLParam dslParam = new DSLParam();
        Fuzziness fuzziness = new Fuzziness();
        ArrayList<String> data = new ArrayList<String>();
        data.add("htmlcontent");
        data.add("title");
        fuzziness.setFields(data);
        fuzziness.setQuery(query);
        fuzziness.setFuzziness("AUTO");
        return EsUtil.searchBeanFzinessFrommEs((String)"article/freezone", (DSLParam)dslParam, (RestClient)this.restClient, (Pageable)pageable, Article.class, (Fuzziness)fuzziness);
    }
}

