<@c.html title="智慧江苏时空大数据平台" import="layui,map" >

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    </head>
    <body>
    <script type="text/javascript">
        var tpl = ${tpl};
        var graphEnable = ${graphEnable!true};
        var url = "${url!}";
        var userName = "${username!}";
        var userId = "${userId!}";
        var smartSearchConfig = {
            searchInView: "${smartSearchSearchInView!}" === "true",
            searchOnMove: "${smartSearchSearchOnMove!}" === "true",
            clearOnPause: "${smartSearchClearOnPause!}" === "true"
        };
    </script>
    <div id="globalWidgets">
        <#--left widgets-->
        <nav class="left-widgets-pane">
            <div class="left-widgets">
                <ul class="map-left-menu" data-bind="foreach: {data: leftWidgets, as: 'wid'}">
                    <li class="widget-li"
                        data-bind="attr: {title: wid.label, id: wid.id + 'Li'},click: activeWidget">
                        <img data-bind="attr:{src: '/assets/images/'+ wid.id + '.png'}"/>
                    </li>
                </ul>
            </div>
            <div class="map-left-pane" data-bind="foreach: {data: leftWidgets, as: 'wid'}">
                <div class="map-pane-info"
                     data-bind="visible: wid.isShowPane, css: wid.id + '-pane'">
                    <div class="widget-head-label">
                        <img src="/assets/images/bgPanel.png"/>
                        <div class="widget-label" data-bind="text: wid.label"></div>
                        <div class="close-widget-pane icon-f-meun-fold" title="关闭面板"
                             data-bind="click: closeWidget"></div>
                    </div>
                    <div class="widget-pane-info" data-bind="attr: {id: wid.id + 'Widget'}"></div>
                </div>
            </div>

            <#--bottom!!!!!!!-->
            <div id="div-bottom-pane" class="map-left-bottom-pane" style="display: none">
                <i class="icon-f-left icon-card-close" title="关闭" id="showtable-close"></i>
                <div id="div-showtable">
                </div>
                <div id="echarts-components">
                </div>
            </div>
        </nav>

        <#--    tool widget-->
        <div class="tool-widgets-pane">
            <ul class="map-tool-menu" data-bind="foreach: {data: toolWidgets, as: 'tool'}">
                <li class="tool-widget-li"
                    data-bind="css: tool.iconCls , attr: {title: tool.label, id: tool.id + 'Li'}, click: activeWidget">
                    <span class="tool-widget-label" data-bind="text: tool.label"></span>
                </li>
            </ul>

            <div class="tool-widget-pane" data-bind="foreach: {data: toolWidgets, as: 'tool'}">
                <div class="tool-pane" data-bind="visible: tool.isShowPane , css: tool.id + '-pane'">
                    <div class="tool-header">
                        <img src="/assets/images/bgToolPanel2.png"/>
                        <div class="tool-header-label" data-bind="text: tool.label"></div>
                        <div class="close-tool-pane icon-f-close" title="关闭面板"
                             data-bind="click: closeWidget"></div>
                    </div>
                    <div class="tool-pane-info" data-bind="attr: {id: tool.id + 'Widget'}"></div>
                </div>
            </div>
        </div>


    </div>
    <#--mian map-->
    <div id="globalContainer" class="global-container"></div>
    <div id="splitGlobal" style="display: none"></div>
    <div class="map-footer">${appCopyright!}</div>
    <#--vedio-->
    <div id="video"></div>
    <#--heatmap-->
    <div class="heatmap">
        <div class="heatmap-canvas" width="50%" height="25%">
        </div>
    </div>
    <#--drawpopup-->
    <div class="main-map-popup">
    </div>
    <#--datalistpop-->
    <div class="card-triangle"></div>
    <div class="datalist-card">
        <div class="datalist-card-content">
            <div class="datalist-card-title">
                <i class="icon-f-left icon-card-close" title="关闭"></i>
                <p style="display: inline-block;vertical-align:super" class="card-title-name"></p>
                <i class="card-identify-icon icon-f-aim" style="display: none" title="属性识别"></i>
                <i class="icon-f-card-favourite1 icon-card-fav" id="icon-fav1" title="收藏"></i>
                <i class="icon-f-tool-mark icon-card-fav" id="icon-fav2" title="取消收藏"></i>
            </div>
            <div class="datalist-card-info"></div>
            <div class="datalist-card-fly"></div>
            <div class="datalist-card-timeline"></div>
            <div class="datalist-card-attr"></div>
            <div class="datalist-card-symbol"></div>
            <div class="datalist-card-legend"></div>
            <div class="datalist-card-coastline"></div>
        </div>
    </div>
    <#--特定图层单独显示图例-->
    <#--2020年3月30日 liujie 加，样式定义在/static/global/widgets/dataList/Style.css中-->
    <div class="datalist-legend">
        <div class="datalist-legend-title">
            <p style="display: inline-block;vertical-align:super" class="card-legend-title" title="图例">图例</p>
            <i id="legend-close" class="icon-f-close icon-card-close" style="float: right;font-size: 20px" title="关闭"></i>
        </div>
        <div class="datalist-legend-content">

        </div>
    </div>

    <#--鼠标提示框-->
    <div class="window-move-msg"></div>
    </body>
    <div style="display: none;" id="coastlineForm">
        <div class="layui-col-xs6">
            <div id="coastlineChart0" class="coastlineChart"></div>
            <div id="coastlineChart1" class="coastlineChart"></div>
            <div id="coastlineChart2" class="coastlineChart"></div>
            <div id="coastlineChart3" class="coastlineChart"></div>
        </div>
        <div class="layui-col-xs6">
            <p id="coastlineTableTitle"></p>
            <table class="layui-hide" id="coastlineTable" lay-filter="coastlineTable"></table>
        </div>
    </div>
    <script type="text/javascript">
        Pace.start({
            document: true,
            elements: false,
            restartOnRequestAfter: false,
            restartOnPushState: false
        });

        function showLoading(msg, selector) {
            //作为出现条件
            if (typeof msg == "function") {
                if (!msg()) {
                    return;
                } else {
                    msg = null;
                }
            }
            $(".my_loading").remove();
            selector = selector || ".map-left-pane";
            var divHtml =
                "<div class='my_loading'>" +
                "<div class='my_loading_center'>" +
                "<div class='my_loading_img'></div>" + (msg || "加载中...") +
                "</div></div>";
            if ($(selector).length == 0) {
                selector = ".map-left-pane";
            }
            var width = $(selector).width();

            var height = $(selector).height();

            $(divHtml).appendTo($(selector));
            if (selector == ".map-left-pane") {
                width = 380;
                height = "87vh";
                $(".my_loading_center").css("marginTop", "40vh");
            } else {
                $(".my_loading_center").css("marginTop", height / 2 - 10);
            }
            $(".my_loading").width(width);
            $(".my_loading").height(height);

            // $(".my_loading_center").css("marginLeft",width/2-10);
        }

        function closeLoading() {
            $(".my_loading").remove();
        }
    </script>
    <@layui/>
</@c.html>