<@c.html title="云资源列表" import="layui,public" css="css/yzy-list.css" js="datas/nav.js">
<div class="new-header"></div>
<div class="new-container">
    <p class="mbx">
        <img src="/images/zyxq/u741.png" alt="" />
        <span>
			<a href="">资源中心</a>
			<span class="arrow">></span>
			<a href="">资源列表</a>
			<span class="arrow">></span>
			<a href="">资源详情</a>
		</span>
    </p>
    <div class="yzylist-item">
        <div class="item-header">
            <div class="item-left fl">
                <span class="fl">筛选条件：</span>
                <ul class="condition-box">
                    <li class="condition fl">
                        <span>按主体分类</span>
                        <ul class="condition-zi layui-clear">
                            <li class="condition-zi-list">
                                <span class="condition-zi-title">现状类依据</span>
                                <div class="condition-zi-fenzu">
                                    <p class="condition-zi-yiji">基础地理</p>
                                    <p class="condition-zi-erji">栅格地图</p>
                                    <p class="condition-zi-erji">遥感影像</p>
                                </div>
                                <div class="condition-zi-fenzu">
                                    <p class="condition-zi-yiji">基础地质</p>
                                    <p class="condition-zi-erji">地质环境</p>
                                    <p class="condition-zi-erji">矿产</p>
                                </div>
                            </li>
                            <li class="condition-zi-list">
                                <span class="condition-zi-title">现状类依据</span>
                                <div class="condition-zi-fenzu">
                                    <p class="condition-zi-yiji">基础地理</p>
                                    <p class="condition-zi-erji">栅格地图</p>
                                    <p class="condition-zi-erji">遥感影像</p>
                                </div>
                            </li>
                            <li class="condition-zi-list">
                                <span class="condition-zi-title">现状类依据</span>
                                <div class="condition-zi-fenzu">
                                    <p class="condition-zi-yiji">基础地理</p>
                                    <p class="condition-zi-erji">栅格地图</p>
                                    <p class="condition-zi-erji">遥感影像</p>
                                </div>
                            </li>
                        </ul>
                    </li>
                    <li class="condition fl"><span>按服务类型</span></li>
                    <li class="condition fl"><span>按坐标系</span></li>
                </ul>
            </div>
            <div class="item-mid fl">
                <span class="gray">已选:</span>
                <span class="check-btn">
					<span>栅格地图</span>
					<span class="cancle">X</span>
				</span>
            </div>
            <div class="item-right fr">
                <!--<div class="search-box">
                    <i class="layui-icon layui-icon-search search-icon"></i>
                    <input type="" name="" id="" value="" placeholder="请输入关键字搜索" />
                </div>
                <span class="search-btn">搜索</span>-->
                <div class="input-box" id="new-search">
                    <input type="" name="" id="" value="" placeholder="请输入关键字" />
                    <i class="layui-icon layui-icon-search search-icon"></i>
                </div>
            </div>
        </div>
        <hr />
        <div class="item-table">
            <table class="layui-table" id="itemTable" lay-filter="itemTable">

                <!--<thead>
                  <tr>
                    <th>资源缩略图</th>
                    <th>标题描述</th>
                    <th>关键字</th>
                    <th>资源类型</th>
                    <th>发布机构</th>
                    <th>最后更新时间</th>
                    <th>操作</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td><img src=""/></td>
                    <td>江苏政区2016</td>
                    <td>基础地理</td>
                    <td>空间数据服务</td>
                    <td>江苏测绘局</td>
                    <td>2016-11-29</td>
                    <td>查看</td>
                  </tr>
                  <tr>
                    <td><img src=""/></td>
                    <td>江苏政区2016</td>
                    <td>基础地理</td>
                    <td>空间数据服务</td>
                    <td>江苏测绘局</td>
                    <td>2016-11-29</td>
                    <td>查看</td>
                  </tr>
                </tbody>-->
            </table>
        </div>
    </div>
</div>
    <@footer/>
</body>
</@c.html>
<script>
    layui.use(['element', 'layer','table'], function () {
        var element = layui.element,
                $ = layui.jquery,
                table=layui.table,
                layer = layui.layer;
        table.render({
            id: 'itemTable',
            elem: '#itemTable'
            ,url:'/yzy/query/all'
            ,cellMinWidth: 100 //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            ,skin: 'nob' //line （行边框风格） row （列边框风格） nob （无边框风格）
            ,even: true //开启隔行背景
            ,skin: 'line' //行边框风格
//			,size: 'lg' //小尺寸的表格
            ,page: {
                count: 100
                ,layout: [ 'prev', 'page', 'next', 'limit', 'skip']
                ,theme: '#1890FF'
                ,jump: function(obj){
                    console.log(obj)
                }
            } //开启分页
            ,limit:10
            ,cols: [[{
                title: '资源缩略图',
                field: 'sign',

                style:'height:80px',
                templet: function (obj) {

                    console.log(obj);

                    return  '<img src="/images/u1775.png" style="width:75px;height:75px;" />';
                }
            },{ //配置数据列
                title: '标题描述', //显示名称
                field: 'name', //字段名
                style:'font-weight:700;',
                templet: function (obj) {

                    console.log(obj);

                    return  obj.description;
                }
            }, { //配置数据列
                title: '关键字', //显示名称
                field: 'name', //字段名
                style:'color:#0099ff',
                templet: function (obj) {

                    console.log(obj);

                    return  obj.keywordIds;
                }
            }, { //配置数据列
                title: '资源类型', //显示名称
                field: 'name', //字段名
                templet: function (obj) {

                    console.log(obj);

                    return  obj.type;
                }
            },{ //配置数据列
                title: '发布机构', //显示名称
                field: 'name', //字段名
                style:'color:#a1a1a1;',
                templet: function (obj) {

                    console.log(obj);

                    return  obj.publisher;
                }
            },{
                title: '最新更新时间',
                style:'color:#a1a1a1;',
                field: 'createtime',
                templet: function (obj) {

                    console.log(obj);

                    return  obj.updateAt;
                }
            }, {
                title: '操作',
                field: 'tool',
                align: 'center',
                style:'cursor:pointer',
                toolbar: '#toolbar',
                // templet: function (val) {
                //     return "<a href='zyxq.html'>查看</a>";
                // }
            }]]
        });

        //监听表格里控件的点击事件
        table.on('tool(itemTable)', function (obj) {
            var data = obj.data;
            if (obj.event == 'detail') {
                var root = window.location.origin;
                location.href = root + "/yzy/yzyxq?id=" + data.id ;
            }
        });
    });
</script>

<script type="text/html" id="toolbar">
    <a class="layui-btn layui-btn-primary layui-btn-xs" lay-event="detail">查看</a>

</script>
