<#macro html title="" import="" css="" js="" headhide="">
    <!DOCTYPE html>
    <html>
    <head>
        <meta name="renderer" content="webkit">
        <meta http-equiv="X-UA-Compatible" content="IE=9; IE=8; IE=EDGE">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="Content-Type" content="text/html;charset=UTF-8"/>
        <title>${appTitle!}</title>
        <style type="text/css">

        </style>
        <#if import??>
            <#list import?split(",") as lib>
                <#switch lib>
                    <#case "layui">
                        <@style path="lib/layui/css/layui.css"></@style>
                        <@script path="lib/layui/layui.js"></@script>
                        <#break />
                    <#case "formSelects">
                        <@style path="lib/formselects/formSelects-v4.css"></@style>
                        <@script path="lib/formselects/formSelects-v4.min.js"></@script>
                        <#break />
                    <#case "font-awesome">
                        <@style path="css/font-awesome/css/font-awesome.min.css"></@style>
                        <#break />
                    <#case "leaflet">
                        <@style path="lib/leaflet/leaflet.css"></@style>
                        <@script path="lib/leaflet/leaflet.js"></@script>
                        <@script path="js/public/jquery-3.2.1.min.js"></@script>
                        <#break />
                    <#case "leftmenu">
                    <#--<@style path="css/sjzlzx-zi.css"></@style>-->
                        <@style path="css/sjzlzx.css"></@style>
                        <#break />
                    <#case "easy-map">
                        <@style path="css/gtmap.css"></@style>
                        <@script path="js/public/jquery-3.2.1.min.js"></@script>
                        <@script path="js/easy-map/gtmap.js"></@script>
                        <@script path="js/easy-map/proj4-compressed.js"></@script>
                        <#break >

                    <#case "public">
                        <@style path="css/global.css"></@style>
                        <@style path="css/setting.css"></@style>
                        <@style path="font/icon-font/iconfont.css"></@style>
                        <@script path="js/jquery-1.12.4.min.js"></@script>
                        <@script path="js/formHelper.js"></@script>
                    <#-- <@style path="css/demo-table.css"></@style>-->
                        <@script path="datas/nav.js"></@script>
                        <@script path="js/sidebar.js"></@script>
                        <@script path="js/echarts.min.js"></@script>
                    <#--<@style path="lib/formselects/formSelects-v4.css"></@style>-->
                    <#--<@script path="lib/formselects/formSelects-v4.min.js"></@script>-->
                        <@script path="js/sidebar.js"></@script>
                        <@script path="js/public.js"></@script>
                        <#break />
                    <#case "iconfont-extra">
                        <@style path="font/icon-font3/iconfont.css"></@style>
                        <#break />
                    <#case "echarts-gl">
                        <@script path="js/echarts-gl.min.js"></@script>
                        <#break />`
                    <#case "doc">
                        <@style path="tp/kindeditor/themes/default/default.css"></@style>
                        <@style path="tp/kindeditor/plugins/code/prettify.css"></@style>
                        <@script path="tp/kindeditor/kindeditor-all.js"></@script>
                        <@script path="tp/kindeditor/lang/zh-CN.js"></@script>
                        <@script path="tp/kindeditor/plugins/code/prettify.js"></@script>
                        <@script path="tp/scroll/jquery.slimscroll.js"></@script>

                    <#--ztree-->
                        <@script path="lib/ztree/js/jquery.ztree.all.js"></@script>
                        <@script path="lib/ztree/js/jquery.ztree.exhide.js"></@script>
                        <@script path="lib/ztree/js/jquery.ztree.core.js"></@script>
                        <@script path="lib/ztree/js/jquery.ztree.exedit.js"></@script>
                        <@script path="lib/ztree/js/jquery.ztree.excheck.js"></@script>
                        <@style path="lib/ztree/css/zTreeStyle.css"></@style>

                    <#--<@script path="tp/ztree/js/jquery.ztree.all.min.js"></@script>-->
                    <#--<@script path="tp/ztree/js/jquery.ztree.exhide.min.js"></@script>-->
                    <#--<@script path="tp/ztree/js/jquery.ztree.core.js"></@script>-->
                    <#--<@style path="tp/ztree/css/zTreeBlue.css"></@style>-->
                        <#break />
                    <#case "mustache">
                        <@script path="webjars/mustache.js/mustache.js"></@script>
                        <#break />
                    <#case "graph">
                        <@style path="css/zsfw/graphStyle.css"></@style>
                        <@style path="css/zsfw/styles.css"></@style>
                        <@script path="js/public/jquery-3.2.1.min.js"></@script>
                        <@script path="js/public/d3.v4.min.js"></@script>
                        <@script path="js/zsfw/utils.js"></@script>
                        <@script path="js/zsfw/graphConf.js"></@script>
                        <@script path="js/zsfw/graphShapes.js"></@script>
                        <@script path="js/zsfw/infobox.js"></@script>
                        <@script path="js/zsfw/graph_viz.js"></@script>
                        <@script path="js/zsfw/graphioGremlin.js"></@script>
                        <@script path="js/zsfw/editGraph.js"></@script>
                        <@script path="js/zsfw/knockout-3.5.0.js"></@script>
                        <#break />
                    <#case "map">
                        <@script path="lib/turf/turf.min.js"></@script>
                        <@style path="webjars/layui/css/layui.css"></@style>
                        <@style path="css/global/index.css"></@style>
                        <@style path="css/global/iconfont.css"></@style>
                        <@style path="css/global/pace.css"></@style>
                        <@style path="webjars/SuperMap_WebGL/Build/Cesium/Widgets/widgets.css"></@style>
                        <@style path="css/global/header.css"></@style>
                        <@style path="css/global/control.css"></@style>
                        <@script path="webjars/jquery/jquery.js"></@script>
                        <@script path="tp/webextension-polyfill/browser-polyfill.js"></@script>
                        <@script path="webjars/layui/layui.js"></@script>
                        <@script path="webjars/pace/pace.js"></@script>
                        <@script path="webjars/requirejs/require.js"></@script>
                        <@script path="global/config.js"></@script>
                        <@script path="global/init.js"></@script>
                        <#break />

                    <#case "step">
                        <@style path="css/step.css"></@style>
                        <@script path="js/step.js"></@script>
                    <#default>
                </#switch>
            </#list>
        </#if>
        <#--<script type="text/javascript">-->
        <#--var dgUIPath = "${dgUiPath!}";-->
        <#--</script>-->
        <#--${css!}-->
        <#if css?? && css!="">
            <#list css?split(",") as cssPath>
                <@style path=cssPath></@style>
            </#list>
        </#if>
    </head>
    <body class="${subStyle!}">
    <script>
        var rootPath = '${dgUiPath!}';
        var accountPath = '${accountPath!}';
        var storagePath = '${storagePath!}';
        var bpmPath = '${bpmPath!}';
        var loginPath = '${loginPath!}';
        var monitorPath = '${monitorPath!}';
        var storageServerPath = '${storageServerPath!}';
        var clientId = '${clientId!}';
        var appVersion = '${appVersion!}';
        var parseGeoFileUrl = '${parseGeoFileUrl!}';
        var datastorePath = '${datastorePath!}';
        var resourceProxyPath = '${resourceProxyPath!}';
        //var headPath=appVersion==""?"../common/head.ftl":"../common/head_"+appVersion+".ftl";
        <#--var documentPath='${documentPath}';-->
    </script>
    <#if headhide="true">
    <#else >
        <#import "../common/head${appVersion}.ftl" as head />
        <@head.main/>
    </#if>
    <#nested />
    <#if js?? && js!="">
        <#list js?split(",") as jsPath>
            <@script path=jsPath></@script>
        </#list>
    </#if>
    </body>
    </html>
</#macro>


<#macro rootPath>${dgUiPath!}</#macro>

<#macro script path>
    <script src="${urls.getForLookupPath('/'+path)}" type="text/javascript"></script>
</#macro>

<#macro style path>
    <link href="${urls.getForLookupPath('/'+path)}" type="text/css" media="screen" rel="stylesheet"/>
</#macro>



<#macro bread  title="" type="">
    <div class="yzylist-item-top">
        <p class="mbx">
            <span class="item-title">${title}</span>
            <img src="${dgUiPath!}/images/u2345.png"/>
            <a href="${dgUiPath!}/wdpt/index" target="_top">我的平台</a>
            <span class="arrow">&gt;</span>
            <a href="/dg/zl">数据治理中心</a>
            <span class="arrow">&gt;</span>
            <#if type??&& type=="">
                <a href="">${title}</a>
            </#if>
            <#if type?? && type!="">
                <#switch type>
                    <#case "fxrw">
                        <span>
					<a href="${dgUiPath!}/dw/data_mining">分析工具</a>
					<span class="arrow">></span>
					<a href="">分析任务</a>
                    </span>
                        <#break />
                    <#case "fxrw1">
                        <span>
                        <a href="${dgUiPath!}/dm/model/modelsmanager">分析决策模型</a>
                        <span class="arrow">></span>
                        <a href="">分析任务</a>
                    </span>
                        <#break />
                    <#case "rwrz">
                        <span>
                        <a href="${dgUiPath!}/view/dgk/jobManage">数据抓取</a>
                        <span class="arrow">></span>
                        <a href="">任务日志</a>
                    </span>
                        <#break />
                    <#case "metadata">
                        <span>
                        <a href="${dgUiPath!}/dw/tables_info">仓储管理</a>
                        <span class="arrow">></span>
                        <a href="">数据管理</a>
                    </span>
                        <#break />
                    <#case "dgk_metadata">
                        <span>
                        <a href="${dgUiPath!}/view/dgk/jobManage">数据抓取</a>
                        <span class="arrow">></span>
                        <a href="">数据仓储</a>
                    </span>
                        <#break />
                    <#case "version">
                        <span>
                        <a href="${dgUiPath!}/dw/tables_info">仓储管理</a>
                        <span class="arrow">></span>
                        <a href="">版本管理</a>
                    </span>
                        <#break />
                    <#default>
                </#switch>
            </#if>
            </span>
        </p>
    </div>
</#macro>

<#macro leftmenu>
    <div class="left-nav1" id="sideNav" lay-filter="changeNav" style="width: 320px;padding-top: 10px;">
        <div style="padding: 20px 53px;">
            <span class="nav-title">数据治理中心</span>
        </div>
        <ul class="layui-nav layui-nav-tree" lay-filter="test" lay-shrink="all">
            <li class="layui-nav-item layui-this">
                <a href="javascript:;" id="sjzl" code="${dgUiPath!}/dg/zl">
                    <i class="iconfont icon-appstore"></i>数据总览
                </a>
            </li>
            <#--            原版数据抓取目录，已修改-->
            <#--            <li class="layui-nav-item">-->
            <#--                <a href="javascript:;" id="sjzq" code="${dgUiPath!}/view/dgk/jobManage">-->
            <#--                    <i class="iconfont icon-barchart"></i>数据抓取-->
            <#--                </a>-->
            <#--            </li>-->

            <li class="layui-nav-item">
                <a href="javascript:;" id="sjzq" code="">
                    <i class="iconfont icon-barchart"></i>数据采集
                </a>
                <dl class="layui-nav-child">
                    <dd>
                        <a href="javascript:;" id="sjzq" code="${dgUiPath!}/view/dgk/jobManage">
                            <i class="icon-arr">></i>数据抓取
                        </a>
                    </dd>
                    <dd>
                        <a href="javascript:;" id="sjcl" code="${dgUiPath!}/dg/data_pro">
                            <i class="icon-arr">></i>数据处理
                        </a>
                    </dd>
                </dl>
            </li>
            <li class="layui-nav-item">
                <a href="javascript:;" id="sjcc" code="">
                    <i class="iconfont icon-shujuku"></i>数据仓储
                </a>
                <dl class="layui-nav-child">
                    <dd>
                        <a href="javascript:;" id="wjgj" code="${dgUiPath!}/dw/db_info">
                            <i class="icon-arr">></i>连接管理
                        </a>
                    </dd>
                    <dd>
                        <a href="javascript:;" code="${dgUiPath!}/dw/tables_info">
                            <i class="icon-arr">></i>仓储管理
                        </a>
                    </dd>
                </dl>
            </li>

            <li class="layui-nav-item">
                <a href="javascript:;" id="sjtyrk" code="">
                    <i class="iconfont icon-shujuku"></i>数据统一入库
                </a>
                <dl class="layui-nav-child">
                    <dd>
                        <a href="javascript:;" id="sjrk" code="${dgUiPath!}/dw/data-insert">
                            <i class="icon-arr">></i>数据入库
                        </a>
                    </dd>
                    <dd>
                        <a href="javascript:;" code="${dgUiPath!}/dw/batch-delete">
                            <i class="icon-arr">></i>批量删除
                        </a>
                    </dd>
                    <dd>
                        <a href="javascript:;" code="${dgUiPath!}/dw/data-tasklist">
                            <i class="icon-arr">></i>任务列表
                        </a>
                    </dd>
                </dl>
            </li>

            <li class="layui-nav-item">
                <a href="javascript:;" code="">
                    <i class="iconfont icon-moxing4"></i>服务管理
                </a>
                <dl class="layui-nav-child">
                    <dd>
                        <a href="javascript:;" id="fwgl" code="${dgUiPath!}/dw/service_info">
                            <i class="icon-arr">></i>服务管理
                        </a>
                    </dd>
                    <dd>
                        <a href="javascript:;" code="${dgUiPath!}/map/geoserver/style">
                            <i class="icon-arr">></i>样式管理
                        </a>
                    </dd>
                </dl>
            </li>
            <li class="layui-nav-item">
                <a href="javascript:;" code="">
                    <i class="iconfont icon-shebeikaifa1"></i>数据分析挖掘
                </a>
                <dl class="layui-nav-child">
                    <dd>
                        <a href="javascript:;" id="wjgj" code="${modelConfigUrl!}"
                           invalid="hidden"
                           authority="fxgjqx">
                            <i class="icon-arr">></i>分析工具
                        </a>
                    </dd>
                    <#--<dd>
                        <a href="javascript:;" code="${dgUiPath!}/dw/data_mining/result">
                            <i class="icon-arr">></i>分析记录
                        </a>
                    </dd>-->
                    <dd>
                        <a href="javascript:;" id="wjmx" code="${modelBuilderUrl!}">
                            <i class="icon-arr">></i>分析决策模型
                        </a>
                    </dd>
                </dl>
            </li>
        </ul>
    </div>
    <style>
        .nav-title {
            font-size: 22px;
            color: #333;
            font-weight: 700;
        }
    </style>
    <script type="text/javascript">
        layui.config({
            base: 'js/',
            // version: new Date().getTime()
        }).use('element', function () {
            var element = layui.element; //导航的hover效果、二级菜单等功能，需要依赖element模块

            $('#sideNav a').click(function () {
                element.render();
                if ($(this).attr("code") != "") {
                    $('.content .sjzl-iframe').attr("src", $(this).attr("code"));
                    /*$('.content').load($(this).attr("code"));*/
                }
            });

            // //监听导航点击
            // element.on('nav(changeNav)', function (elem) {
            //     console.log("1");
            // });
        });

    </script>
<#--<div class="left-nav" id="bigNav" lay-filter="changeNav">
    <script type="text/javascript">
        layui.config({
            base: 'js/',
            version: new Date().getTime()
        }).use(['sidebar'], function () {
                    sidebar = layui.sidebar,
            //导航加载
            sidebar.render({
                el: '#bigNav',
                data: '${dgUiPath!}/datas/sidebar.json'
            });
            sidebar.on('click(changeNav)', function (elem) {
                console.log(elem); //得到当前点击的DOM对象
                window.location.href = "${dgUiPath!}/" + elem.field.href;
            });
        });
    </script>
</div>-->
</#macro>

<#macro footer>
    <#if appVersion=="">
        <div class="dibu">
            <div class="dibu-content">
                <div class="dibu-content-total">
                    <div class="dibu-content-total-img">
                        <img src="<@rootPath/>/images/handshakedealp.png"/><span>友情链接</span>
                    </div>
                    <div class="dibu-content-total-item">
                        <span class="dibu-content-total-item-ex">自然资源部</span>
                        <a href="https://www.tianditu.gov.cn" target="third_system"><span
                                    style="padding-right: 18px;width: 189px;">天地图</span></a>
                        <a href="http://jiangsu.tianditu.gov.cn/nanjing/index/page/index.html"
                           target="third_system"><span>天地图·南京</span></a>
                        <a href="http://jiangsu.tianditu.gov.cn/wuxi" target="third_system"><span>天地图·无锡</span></a>
                        <a href="http://jiangsu.tianditu.gov.cn/xuzhou/indexopen.action"
                           target="third_system"><span>天地图·徐州</span></a>
                        <span class="dibu-content-total-item-ex">江苏省自然资源厅</span>
                        <a href="http://www.mapcz.com.cn" target="third_system"><span>天地图·常州</span></a>
                        <a href="http://map.suzhou.gov.cn" target="third_system"><span>天地图·苏州</span></a>
                        <a href="http://jiangsu.tianditu.gov.cn/nantong/nt/site.html"
                           target="third_system"><span>天地图·南通</span></a>
                        <a href="http://jiangsu.tianditu.gov.cn/lianyungang" target="third_system"><span>天地图·连云港</span></a>
                        <span class="dibu-content-total-item-ex"></span>
                        <a href="http://jiangsu.tianditu.gov.cn/huaian/ha/index.html"
                           target="third_system"><span>天地图·淮安</span></a>
                        <a href="http://map.yancheng.gov.cn/" target="third_system"><span>天地图·盐城</span></a>
                        <a href="http://map.yangzhou.gov.cn:8011/" target="third_system"><span>天地图·扬州</span></a>
                        <span></span>
                        <span class="dibu-content-total-item-ex"></span>
                        <a href="http://map.zhenjiang.gov.cn/" target="third_system"><span>天地图·镇江</span></a>
                        <a href="http://jiangsu.tianditu.gov.cn/taizhou/" target="third_system"><span>天地图·泰州</span></a>
                        <a href="http://jiangsu.tianditu.gov.cn/suqian/" target="third_system"><span>天地图·宿迁</span></a>
                    </div>
                </div>
                <div class="dibu-content-footer">
                    <p>江苏省自然资源厅主办 江苏省基础地理信息中心承办 版权所有 CopyRight©All Right Reserved.盗版必究</p>
                    <p><span style="color: #3f9df7;">使用前必读意见反馈备案序列号：苏ICP备10208858号</span> 审图号：苏S(2017)009号
                    </p>
                    <p>地址：南京市鼓楼区北京西路75号 邮编：210013 电话：025 83757180</p>
                </div>
            </div>
        </div>
    </#if>
</#macro>

<#macro layui>
    <script type="text/javascript">
        layui.config({
            base: 'js/',
            version: new Date().getTime()
        }).use(['element', 'layer', 'jquery', 'table'], function () {
            var element = layui.element,
                $ = layui.$,
                table = layui.table,
                layer = layui.layer;
            //地图切换点击事件
            $('.card1').click(function () {
                $('.full-page').css('background-color', 'pink');
            });
            $('.card2').click(function () {
                $('.full-page').css('background-color', 'burlywood');
            });
            $('.card3').click(function () {
                $('.full-page').css('background-color', 'deepskyblue');
            });
            //工具栏点击事件
            $('.tool').click(function () {
                $('.tool em').toggleClass('active');
                $('.tool').toggleClass('active');
                $('.detail-box').toggle();
            });
            //左侧菜单点击事件
            $('.fuWu').click(function () {
                $('#bar-search').removeClass('bar-show');
                $('#bar-fuWu').addClass('bar-show');
            });
            $('.search').click(function () {
                $('#bar-fuWu').removeClass('bar-show');
                $('#bar-search').addClass('bar-show');
            });
            $('.top-img').click(function () {
                $('.menu-bar').removeClass('bar-show');
            });
            //屏幕自适应高度
            autoheight();
            //屏幕分辨率变化时，屏幕自适应高度
            window.onresize = autoheight;

            function autoheight() {
                var winHeight = 0,
                    winWidth = 0;
                if (window.innerHeight) {
                    winHeight = window.innerHeight;
                    winWidth = window.innerWidth;
                } else if ((document.body) && (document.body.clientHeight)) {
                    winHeight = document.body.clientHeight;
                    winWidth = document.body.clientWidth;
                } else if (document.documentElement && document.documentElement.clientHeight) {
                    winHeight = document.documentElement.clientHeight;
                    winWidth = document.documentElement.clientWidth;
                }
                winHeight = winHeight - 70;
                console.log(winHeight);
                //设置屏幕的总高度
                $(".full-page").css("height", winHeight + "px");
            }

            table.render({
                elem: '#itemTable'
                , url: 'datas/table_data.json'
//		    ,height:560
//		    ,cellMinWidth: 30 //全局定义常规单元格的最小宽度，layui 2.2.1 新增
                , skin: 'line' //line （行边框风格） row （列边框风格） nob （无边框风格）不设置该参数才是默认的
                , even: false //开启隔行背景
                , id: 'idTest2'
                , size: 'lg' //小尺寸的表格
                , page: {
                    count: 20
                    , layout: ['prev', 'page', 'next', 'limit', 'count']
                    , theme: '#1890FF'
                    , groups: 2
                    , limits: [5, 10]
                    , jump: function (obj) {
                        console.log(obj)
                    }
                } //开启分页
                , limit: 5
                , cols: [[
//		    {
//		    	type:"checkbox",
//		    },

                    { //配置数据列
                        field: 'sign', //字段名
                        width: 200,
                        templet: function (obj) {
                            //id
//                      console.log(obj);
//                      '<img src="images/xx.png" style="height:200px;" />'

                            //返回值：格式化的纯文本或html文本
                            return '<img src="images/skclf/dizhi.png" style="width:18px;height:18px;margin-right:5px;" /><span style="color:#1497F2;">地质</span><span style="color:#333;font-weight:700;">灾害危险程度统计</span>';
                        }
                    },
                    {//配置数据列
                        field: 'id',
                        style: 'cursor:pointer',
                        templet: function (val) {
                            return '<img src="images/skclf/add.png" />';
                        }
                    }]]
                , done: function (res, curr, count) {
                    //如果是异步请求数据方式，res即为你接口返回的信息。
                    //如果是直接赋值的方式，res即为：{data: [], count: 99} data为当前页数据、count为数据总长度
//			    console.log(res);

                    //得到当前页码
//			    console.log(curr);

                    //得到数据总量
//			    console.log(count);
                    //执行表格“尺寸结构”的重置，这个必须要执行，否则获取的body的高度不准确
                    table.resize('idTest2');
                }
            });

        });
    </script>

    <script type="text/javascript">
        if ($(".left-nav1").length > 0) {
            if ($(".new-header-box").length > 0) {
                $(".left-nav1").css("height", window.innerHeight - $(".new-header-box").outerHeight() - 5);
            } else {
                $(".left-nav1").css("height", window.innerHeight - 5);
            }
            if ($(".content").length > 0) {
                $(".content").css("height", $(".left-nav1").outerHeight());
                $(".sjzl-iframe").css("height", $(".content").outerHeight() - 5);
            }
        }
    </script>
</#macro>

<#--&lt;#&ndash;消息提示框&ndash;&gt;-->
<#--<#macro msg>-->
<#--<div id="msgDiv" class="FromsToOk">-->
<#--</div>-->
<#--<script type="text/javascript">-->
<#--var processWidth=0;-->
<#--var processInterval=0;-->
<#--function loadMsgDiv(){-->
<#--processWidth=0;-->
<#--processInterval=0;-->
<#--var msgDiv=" <div class=\"progress progress-success  progress-striped active\"  id=\"alertdiv\" ><div id=\"processBar\" class=\"bar\" style=\"width: 5%;\"></div></div><div class=\"FromsToOkWord ToOk\" id=\"errorMsg\"></div>";-->
<#--$('#msgDiv').empty();-->
<#--$('#msgDiv').html(msgDiv);-->
<#--processInterval=setInterval(changeProcessBar,1000)-->
<#--}-->
<#--function changeProcessBar(){-->
<#--processWidth=processWidth+5;-->
<#--if(processWidth>=98)-->
<#--processWidth=98;-->
<#--$("#processBar")[0].style.width=processWidth+"%";-->
<#--}-->

<#--function alertProcess(){-->
<#--loadMsgDiv();-->
<#--$("#alertdiv").removeClass().addClass("progress progress-success  progress-striped active");-->
<#--}-->
<#--function alertSucess(html){-->

<#--clearInterval(processInterval);-->
<#--$("#errorMsg").removeClass().addClass("FromsToOkWord ToOk");-->
<#--$("#processBar")[0].style.width="100%";-->
<#--$("#errorMsg").html("<i class=\"icon_ok\"></i>"+html);-->
<#--$("#alertdiv").show();-->
<#--}-->
<#--function alertError(html){-->
<#--//        loadMsgDiv();-->
<#--$("#alertdiv").removeClass().addClass("progress progress-warning  progress-striped active");-->
<#--$("#errorMsg").removeClass().addClass("FromsToOkWord ToWrong");-->
<#--clearInterval(processInterval);-->
<#--$("#processBar")[0].style.width="100%";-->
<#--$("#errorMsg").html("<i class=\"icon_worng\"></i>"+html);-->
<#--$("#alertdiv").show();-->
<#--}-->
<#--</script>-->
<#--</#macro>-->

<#--&lt;#&ndash;进度条&ndash;&gt;-->
<#--<#macro loading width="" height="">-->
<#--<div id="loading" class="loading" style="position:absolute;top:0px;left:0px;z-index: 9999;width: ${width!};height:  ${height!};display: block;">-->
<#--<img src="../static/img/loading.gif" alt="" />-->
<#--</div>-->
<#--<script type="text/javascript">-->
<#--function showLoading(){-->
<#--$("#loading").show();-->
<#--//        document.getElementById("loading").style.display="block";-->
<#--}-->
<#--function hideLoading(){-->
<#--$("#loading").hide();-->
<#--//        document.getElementById("loading").style.display="none";-->
<#--}-->
<#--</script>-->
<#--</#macro>-->

<#--&lt;#&ndash;工具栏&ndash;&gt;-->
<#--<#macro toolbar show="save,print">-->
<#--<#if show??>-->
<#--<div class="toolbar pos-f ${subStyle!}">-->
<#--<#list show?split(",") as lib>-->
<#--<#switch lib>-->
<#--<#case "save">-->
<#--<button class="btn btn-success size-S goSave" id="goSave" type="button" onclick="goSave()">-->
<#--<i class="icon-save icon-large"></i> 保 存-->
<#--</button>-->
<#--<#break />-->
<#--<#case "print">-->
<#--<button class="btn btn-success size-S goPrint" id="goPrint" type="button" onclick="goPrint()">-->
<#--<i class="icon-print icon-large"></i> 打 印-->
<#--</button>-->
<#--<#break />-->
<#--<#case "add">-->
<#--<button class="btn btn-success size-S goAdd" id="goAdd" type="button" onclick="goAdd()">-->
<#--<img src="${ssnydUrl!}/images/jzd/new.png"> 新 建-->
<#--</button>-->
<#--<#break />-->
<#--<#case "edit">-->
<#--<button class="btn btn-success size-S goEdit" id="goEdit" type="button" onclick="goEdit()">-->
<#--<i class="icon-edit icon-large"></i> 修 改-->
<#--</button>-->
<#--<#break />-->
<#--<#case "del">-->
<#--<button class="btn btn-danger size-S goDel" id="goDel" type="button" onclick="goDel()">-->
<#--<i class="icon-trash icon-large"></i> 删 除-->
<#--</button>-->
<#--<#break />-->
<#--<#case "close">-->
<#--<button class="btn btn-danger size-S goClose" id="goClose" type="button" onclick="goClose()">-->
<#--<i class="icon-remove icon-large"></i> 关 闭-->
<#--</button>-->
<#--<#break />-->
<#--<#case "upload">-->
<#--<button class="btn btn-success size-S upload" type="button" id="upload"">-->
<#--<i class="icon-cloud-upload icon-large"></i> 上 传-->
<#--</button>-->
<#--<#break />-->
<#--<#case "surveyBoundZip6">-->
<#--<button class="btn btn-success size-S" type="button" id="surveyBoundZip6">-->
<#--<i class="icon-book icon-large"></i> 报盘6.0（zip）-->
<#--</button>-->
<#--<#break />-->
<#--<#case "surveyBoundZip7">-->
<#--<button class="btn btn-success size-S" type="button" id="surveyBoundZip7">-->
<#--<i class="icon-book icon-large"></i> 报盘7.0（zip）-->
<#--</button>-->
<#--<#break />-->
<#--<#case "surveyBoundZip">-->
<#--<button class="btn btn-success size-S" type="button" id="surveyBoundZip">-->
<#--<i class="icon-book icon-large"></i> 报盘勘测定界（zip）-->
<#--</button>-->
<#--<#break />-->
<#--<#case "surveyBoundXml">-->
<#--<button class="btn btn-success size-S" type="button" id="surveyBoundXml">-->
<#--<i class="icon-file-alt icon-large"></i> 地籍勘测定界（xml）-->
<#--</button>-->
<#--<#break />-->
<#--<#case "surveyBoundSelect">-->
<#--<button class="btn btn-success size-S" type="button" id="surveyBoundSelect">-->
<#--<i class="icon-folder-open-alt icon-large"></i> 选择勘测定界成果-->
<#--</button>-->
<#--<#break />-->
<#--<#case "reportExport">-->
<#--<button class="btn btn-success size-S" type="button" id="reportExport">-->
<#--<i class="icon-book icon-large"></i> 导出报件-->
<#--</button>-->
<#--<#break />-->
<#--<#case "createMap">-->
<#--<button class="btn btn-success size-S" type="button" id="createMap">-->
<#--<i class="icon-globe icon-large"></i> 生成图形-->
<#--</button>-->
<#--<#break />-->
<#--<#case "delMap">-->
<#--<button class="btn btn-danger size-S" type="button" id="delMap">-->
<#--<i class="icon-trash icon-large"></i> 删除图形-->
<#--</button>-->
<#--<#break />-->
<#--<#case "locationMap">-->
<#--<button class="btn btn-success size-S" type="button" id="locationMap">-->
<#--<img src="${ssnydUrl!}/images/jzd/dingwei_3.png"> 定位图形-->
<#--</button>-->
<#--<#break />-->
<#--<#case "goImpJzd">-->
<#--<button class="btn btn-success size-S" type="button" id="goImpJzd">-->
<#--<i class="icon-upload-alt icon-large"></i> 导入界址点-->
<#--</button>-->
<#--<#break />-->
<#--<#case "goExportExcel">-->
<#--<button class="btn btn-success size-S" type="button" id="goExportExcel" onclick="goExportExcel()">-->
<#--<i class="icon-table icon-large"></i> 导 出-->
<#--</button>-->
<#--<#break />-->
<#--<#case "syncMap">-->
<#--<button class="btn btn-success size-S <#if (sync!) != 'true'>hidden</#if>" type="button" id="syncMap">-->
<#--<i class="icon-refresh icon-large"></i> 属性同步-->
<#--</button>-->
<#--<#break />-->
<#--<#case "goPush">-->
<#--<button class="btn btn-success size-S" type="button" id="goPush">-->
<#--<i class="icon-signin icon-large"></i> 推 送-->
<#--</button>-->
<#--<#break />-->
<#--<#default>-->
<#--</#switch>-->
<#--</#list>-->
<#--<#nested/>-->
<#--</div>-->
<#--</#if>-->
<#--</#macro>-->

<#--&lt;#&ndash;表单标题&ndash;&gt;-->
<#--<#macro head title="" unit="">-->
<#--<div class="gt-head">-->
<#--<h3 style="font-size: 24px;" class="text-c">${title}</h3>-->
<#--<h5 class="text-r">${unit}</h5>-->
<#--</div>-->
<#--</#macro>-->
<#--&lt;#&ndash;资源分区权限&ndash;&gt;-->
<#--<#macro authority dataJson="" disable="">-->
<#--<script type="text/javascript">-->
<#--$(function () {-->
<#--// 资源分区控制---未办结-->
<#--distableControls(JSON.parse('${dataJson!}'));-->
<#--// 资源分区控制---已办结-->
<#--disableControlByEnd(disable);-->
<#--});-->
<#--</script>-->
<#--</#macro>-->

<#--&lt;#&ndash;分页标签&ndash;&gt;-->
<#--<#macro page id="" url="" param="" targetUrl="">-->
<#--<div class="${id!}"></div>-->
<#--<div id="${id!}" style="border:1px solid #ddd;border-top:0;padding:9px 0 6px 3px"></div>-->
<#--<script type="text/javascript">-->
<#--$(function(){-->
<#--// 分页查询-->
<#--${id!}_pagination();-->
<#--});-->

<#--// 分页查询-->
<#--function ${id!}_pagination() {-->
<#--var index;-->
<#--var total = 0;-->
<#--var curSize = 0;-->
<#--var pageSize = 10;-->
<#--$("#${id!}").myPagination({-->
<#--cssStyle: 'badoo1',-->
<#--pageNumber: '0',-->
<#--panel: {-->
<#--first: '<i class="icon-step-backward"></i>',-->
<#--prev: '<i class="icon-backward"></i>',-->
<#--next: '<i class="icon-forward"></i>',-->
<#--last: '<i class="icon-step-forward"></i>',-->
<#--tipInfo_on: true,-->
<#--tipInfo: '　跳{input}/{sumPage}页'-->
<#--},-->
<#--ajax: {-->
<#--on: true,-->
<#--url: "${url!}",-->
<#--dataType: "html",-->
<#--pageCountId: "${id!}_pageCount",-->
<#--ajaxStart: function() {-->
<#--index = layer.load(2);-->
<#--},-->
<#--callback: function(data) {-->
<#--$(".${id!}").html(data);-->
<#--total = $(data).find("#${id!}_total").val();-->
<#--curSize = $(data).find("#${id!}_curSize").val();-->
<#--pageSize = $(data).find("#${id!}_pageSize").val();-->
<#--layer.close(index);-->
<#--},-->
<#--ajaxStop: function() {-->
<#--layer.close(index);-->
<#--setTimeout(function() {-->
<#--if ($("#${id!}").html() != "") {-->
<#--if (curSize && curSize > 0) {-->
<#--$("#${id!}").append("　<select id='${id!}_showSize' onchange='${id!}_pagination()'><option value='10'>10</option><option value='20'>20</option><option value='30'>30</option></select>　本页" + curSize + "条, 共" + total + "条");-->
<#--$("#${id!}_showSize option[value='"+pageSize+"']").attr("selected", true);-->
<#--}-->
<#--}-->
<#--}, 100);-->
<#--},-->
<#--param: "param="+${param!}-->
<#--}-->
<#--});-->
<#--}-->
<#--</script>-->
<#--</#macro>-->