<@c.html title="挖掘工具"  import="layui,public,doc"  headhide="true">
<style type="text/css">
    .ke-edit{
        height: 650px !important;
    }
    .ke-edit-iframe{
        height: 650px !important;
    }

    .ztree li span.button.add{
        margin-left:2px;
        margin-right: -1px;
        background-position:-144px 0;
        vertical-align:top;
    }

    #menuTree{
        width: 20%;
        height: 650px;
        position: absolute;
    }

    .btn_container{
        width: 400px;
        margin-left: 48%;
        margin-top: 80px;
    }
</style>

<div>
    <div id="menuTree"  class="ztree"></div>
</div>
<div style="width: 79%;margin-left: 21%;">
    <textarea id="content" name="content" cols="100" rows="8" style="width: 100%;height:700px:hidden;"></textarea>
</div>
<div class="btn_container">
    <a class="layui-btn" name="save">保存</a>
    <a class="layui-btn" name="reset">重置</a>
</div>
<script type="text/javascript">
    var zTree,editor;
    var tplName = "${tplName}";
    var treeData=null;
    var article =null;
    var lastTreeNode=null;
    function initEditor() {
        KindEditor.ready(function(K) {
            editor  = K.create('textarea[name="content"]', {
                cssPath : '../plugins/code/prettify.css',
                // fileManagerJson : rootPath+ '/api/upload',
                uploadJson : rootPath+ '/api/upload',
                allowFileManager : true,
                filePostName: 'fileName',
                afterCreate : function() {
                    var self = this;
                    K.ctrl(document, 13, function() {
                        self.sync();
                        document.forms['example'].submit();
                    });
                    K.ctrl(self.edit.doc, 13, function() {
                        self.sync();
                        document.forms['example'].submit();
                    });
                }
            });
            prettyPrint();
        });
    }
    //初始化树
    function initTree(){
        $.ajax({
            url:rootPath+"/api/menu/get?tplName="+tplName,
            success:function (data) {
                if(!data.data){
                    layer.msg("数据加载错误");
                    return;
                }
                treeData = data.data;
                if(typeof treeData.content=="string"){
                    treeData.content =JSON.parse(treeData.content);
                }
                zTree = $.fn.zTree.init($("#menuTree"), {
                    view: {
                        addHoverDom: addHoverDom,
                        removeHoverDom: removeHoverDom,
                        selectedMulti: false
                    },
                    edit: {
                        enable: true,
                        editNameSelectAll: true,
                        // showRemoveBtn: showRemoveBtn,
                        // showRenameBtn: showRenameBtn
                    },
                    data: {
                        simpleData: {
                            enable: true
                        }
                    },
                    callback: {
                        // beforeDrag: beforeDrag,
                        // beforeEditName: beforeEditName,
                        // beforeRemove: beforeRemove,
                        // beforeRename: beforeRename,
                        // onRemove: onRemove,
                        // onRename: onRename
                        onClick:onNodeClick
                    }
                },treeData.content);
            }
        });

        function addHoverDom(treeId, treeNode) {
            var sObj = $("#" + treeNode.tId + "_span");
            if (treeNode.editNameFlag || $("#addBtn_"+treeNode.tId).length>0) return;
            var addStr = "<span class='button add' id='addBtn_" + treeNode.tId
                    + "' title='add node' onfocus='this.blur();'></span>";
            sObj.after(addStr);
            var btn = $("#addBtn_"+treeNode.tId);
            if (btn) btn.bind("click", function(){
                var parentId = treeNode.id;
                var nodeId="";
                if(!treeNode.children){
                    nodeId = parentId+"_0";
                }else {
                    nodeId = parentId+"_"+treeNode.children.length;
                }
                zTree.addNodes(treeNode, {id:nodeId, pId:treeNode.id, name:"new node"});
                return false;
            });
        };
        function removeHoverDom(treeId, treeNode) {
            $("#addBtn_"+treeNode.tId).unbind().remove();
        };
    }
    //绑定事件
    function bindEvent(){
        $("[name=save]").click(function (i,e) {
            if(article&&editor.html()){
                //保存文章
                $.ajax({
                    url:rootPath+"/api/article/set",
                    data:{
                        html: editor.html(),
                        menuId:lastTreeNode.id
                    },
                    success:function (data) {
                        console.log( "保存成功")
                    }
                });
            }

            //保存树状json
            var nodes = zTree.getNodes();
            treeData.content = JSON.stringify(nodes);
            $.ajax({
                url:rootPath+"/api/menu/set",
                data:treeData,
                success:function (data) {
                    console.log( "保存成功");
                    alert("保存成功");
                }
            });
        });

    }

    initEditor();
    initTree();
    bindEvent();
    function onNodeClick (event, treeId, treeNode, clickFlag) {
        //加载文章
        if(article&&editor.html()){
            //保存文章
            $.ajax({
                url:rootPath+"/api/article/set",
                data:{
                    html: editor.html(),
                    menuId:lastTreeNode.id
                },
                success:function (data) {
                    console.log( "保存成功")
                }
            });
        }
        lastTreeNode = treeNode;
        //获取文章
        $.ajax({
            url:rootPath+"/api/article/get",
            data:{
                menuId:lastTreeNode.id
            },
            success:function (data) {
                article =data.data;
                if(data.data&&data.data.content){
                    editor.html(data.data.content);
                }

            }
        });

    }
</script>
</@c.html>
