/*
 bytebuffer.js (c) 2015 Daniel Wirtz <dcode@dcode.io>
 Backing buffer: ArrayBuffer, Accessor: Uint8Array
 Released under the Apache License, Version 2.0
 see: https://github.com/dcodeIO/bytebuffer.js for details
*/
(function (k, m) {
    if ("function" === typeof define && define.amd) define(["long"], m); else if ("function" === typeof require && "object" === typeof module && module && module.exports) {
        var r = module, s;
        try {
            s = require("long")
        } catch (u) {
        }
        s = m(s);
        r.exports = s
    } else (k.dcodeIO = k.dcodeIO || {}).ByteBuffer = m(k.dcodeIO.Long)
})(this, function (k) {
    function m(a) {
        var b = 0;
        return function () {
            return b < a.length ? a.charCodeAt(b++) : null
        }
    }

    function r() {
        var a = [], b = [];
        return function () {
            if (0 === arguments.length) return b.join("") + w.apply(String, a);
            1024 < a.length +
            arguments.length && (b.push(w.apply(String, a)), a.length = 0);
            Array.prototype.push.apply(a, arguments)
        }
    }

    function s(a, b, c, d, f) {
        var l;
        l = 8 * f - d - 1;
        var g = (1 << l) - 1, e = g >> 1, h = -7;
        f = c ? f - 1 : 0;
        var k = c ? -1 : 1, p = a[b + f];
        f += k;
        c = p & (1 << -h) - 1;
        p >>= -h;
        for (h += l; 0 < h; c = 256 * c + a[b + f], f += k, h -= 8) ;
        l = c & (1 << -h) - 1;
        c >>= -h;
        for (h += d; 0 < h; l = 256 * l + a[b + f], f += k, h -= 8) ;
        if (0 === c) c = 1 - e; else {
            if (c === g) return l ? NaN : Infinity * (p ? -1 : 1);
            l += Math.pow(2, d);
            c -= e
        }
        return (p ? -1 : 1) * l * Math.pow(2, c - d)
    }

    function u(a, b, c, d, f, l) {
        var g, e = 8 * l - f - 1, h = (1 << e) - 1, k = h >> 1, p = 23 === f ?
            Math.pow(2, -24) - Math.pow(2, -77) : 0;
        l = d ? 0 : l - 1;
        var m = d ? 1 : -1, n = 0 > b || 0 === b && 0 > 1 / b ? 1 : 0;
        b = Math.abs(b);
        isNaN(b) || Infinity === b ? (b = isNaN(b) ? 1 : 0, d = h) : (d = Math.floor(Math.log(b) / Math.LN2), 1 > b * (g = Math.pow(2, -d)) && (d--, g *= 2), b = 1 <= d + k ? b + p / g : b + p * Math.pow(2, 1 - k), 2 <= b * g && (d++, g /= 2), d + k >= h ? (b = 0, d = h) : 1 <= d + k ? (b = (b * g - 1) * Math.pow(2, f), d += k) : (b = b * Math.pow(2, k - 1) * Math.pow(2, f), d = 0));
        for (; 8 <= f; a[c + l] = b & 255, l += m, b /= 256, f -= 8) ;
        d = d << f | b;
        for (e += f; 0 < e; a[c + l] = d & 255, l += m, d /= 256, e -= 8) ;
        a[c + l - m] |= 128 * n
    }

    var h = function (a, b, c) {
        "undefined" ===
        typeof a && (a = h.DEFAULT_CAPACITY);
        "undefined" === typeof b && (b = h.DEFAULT_ENDIAN);
        "undefined" === typeof c && (c = h.DEFAULT_NOASSERT);
        if (!c) {
            a |= 0;
            if (0 > a) throw RangeError("Illegal capacity");
            b = !!b;
            c = !!c
        }
        this.buffer = 0 === a ? v : new ArrayBuffer(a);
        this.view = 0 === a ? null : new Uint8Array(this.buffer);
        this.offset = 0;
        this.markedOffset = -1;
        this.limit = a;
        this.littleEndian = b;
        this.noAssert = c
    };
    h.VERSION = "5.0.1";
    h.LITTLE_ENDIAN = !0;
    h.BIG_ENDIAN = !1;
    h.DEFAULT_CAPACITY = 16;
    h.DEFAULT_ENDIAN = h.BIG_ENDIAN;
    h.DEFAULT_NOASSERT = !1;
    h.Long = k ||
        null;
    var e = h.prototype;
    Object.defineProperty(e, "__isByteBuffer__", {value: !0, enumerable: !1, configurable: !1});
    var v = new ArrayBuffer(0), w = String.fromCharCode;
    h.accessor = function () {
        return Uint8Array
    };
    h.allocate = function (a, b, c) {
        return new h(a, b, c)
    };
    h.concat = function (a, b, c, d) {
        if ("boolean" === typeof b || "string" !== typeof b) d = c, c = b, b = void 0;
        for (var f = 0, l = 0, g = a.length, e; l < g; ++l) h.isByteBuffer(a[l]) || (a[l] = h.wrap(a[l], b)), e = a[l].limit - a[l].offset, 0 < e && (f += e);
        if (0 === f) return new h(0, c, d);
        b = new h(f, c, d);
        for (l =
                 0; l < g;) c = a[l++], e = c.limit - c.offset, 0 >= e || (b.view.set(c.view.subarray(c.offset, c.limit), b.offset), b.offset += e);
        b.limit = b.offset;
        b.offset = 0;
        return b
    };
    h.isByteBuffer = function (a) {
        return !0 === (a && a.__isByteBuffer__)
    };
    h.type = function () {
        return ArrayBuffer
    };
    h.wrap = function (a, b, c, d) {
        "string" !== typeof b && (d = c, c = b, b = void 0);
        if ("string" === typeof a) switch ("undefined" === typeof b && (b = "utf8"), b) {
            case "base64":
                return h.fromBase64(a, c);
            case "hex":
                return h.fromHex(a, c);
            case "binary":
                return h.fromBinary(a, c);
            case "utf8":
                return h.fromUTF8(a,
                    c);
            case "debug":
                return h.fromDebug(a, c);
            default:
                throw Error("Unsupported encoding: " + b);
        }
        if (null === a || "object" !== typeof a) throw TypeError("Illegal buffer");
        if (h.isByteBuffer(a)) return b = e.clone.call(a), b.markedOffset = -1, b;
        if (a instanceof Uint8Array) b = new h(0, c, d), 0 < a.length && (b.buffer = a.buffer, b.offset = a.byteOffset, b.limit = a.byteOffset + a.byteLength, b.view = new Uint8Array(a.buffer)); else if (a instanceof ArrayBuffer) b = new h(0, c, d), 0 < a.byteLength && (b.buffer = a, b.offset = 0, b.limit = a.byteLength, b.view = 0 <
        a.byteLength ? new Uint8Array(a) : null); else if ("[object Array]" === Object.prototype.toString.call(a)) for (b = new h(a.length, c, d), b.limit = a.length, c = 0; c < a.length; ++c) b.view[c] = a[c]; else throw TypeError("Illegal buffer");
        return b
    };
    e.writeBitSet = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if (!(a instanceof Array)) throw TypeError("Illegal BitSet: Not an array");
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 >
                this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        var d = b, f = a.length, e = f >> 3, g = 0, h;
        for (b += this.writeVarint32(f, b); e--;) h = !!a[g++] & 1 | (!!a[g++] & 1) << 1 | (!!a[g++] & 1) << 2 | (!!a[g++] & 1) << 3 | (!!a[g++] & 1) << 4 | (!!a[g++] & 1) << 5 | (!!a[g++] & 1) << 6 | (!!a[g++] & 1) << 7, this.writeByte(h, b++);
        if (g < f) {
            for (h = e = 0; g < f;) h |= (!!a[g++] & 1) << e++;
            this.writeByte(h, b++)
        }
        return c ? (this.offset = b, this) : b - d
    };
    e.readBitSet = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        var c = this.readVarint32(a),
            d = c.value, f = d >> 3, e = 0, g = [];
        for (a += c.length; f--;) c = this.readByte(a++), g[e++] = !!(c & 1), g[e++] = !!(c & 2), g[e++] = !!(c & 4), g[e++] = !!(c & 8), g[e++] = !!(c & 16), g[e++] = !!(c & 32), g[e++] = !!(c & 64), g[e++] = !!(c & 128);
        if (e < d) for (f = 0, c = this.readByte(a++); e < d;) g[e++] = !!(c >> f++ & 1);
        b && (this.offset = a);
        return g
    };
    e.readBytes = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + a > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " +
                b + " (+" + a + ") <= " + this.buffer.byteLength);
        }
        var d = this.slice(b, b + a);
        c && (this.offset += a);
        return d
    };
    e.writeBytes = e.append;
    e.writeInt8 = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal value: " + a + " (not an integer)");
            a |= 0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        b += 1;
        var d = this.buffer.byteLength;
        b > d && this.resize((d *= 2) > b ? d : b);
        this.view[b - 1] = a;
        c && (this.offset += 1);
        return this
    };
    e.writeByte = e.writeInt8;
    e.readInt8 = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 1 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+1) <= " + this.buffer.byteLength);
        }
        a = this.view[a];
        128 === (a & 128) && (a = -(255 - a + 1));
        b && (this.offset +=
            1);
        return a
    };
    e.readByte = e.readInt8;
    e.writeUint8 = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal value: " + a + " (not an integer)");
            a >>>= 0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        b += 1;
        var d = this.buffer.byteLength;
        b > d && this.resize((d *= 2) > b ? d : b);
        this.view[b - 1] = a;
        c && (this.offset += 1);
        return this
    };
    e.writeUInt8 = e.writeUint8;
    e.readUint8 = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 1 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+1) <= " + this.buffer.byteLength);
        }
        a = this.view[a];
        b && (this.offset += 1);
        return a
    };
    e.readUInt8 = e.readUint8;
    e.writeInt16 = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal value: " + a + " (not an integer)");
            a |= 0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        b += 2;
        var d = this.buffer.byteLength;
        b > d && this.resize((d *= 2) > b ? d : b);
        b -= 2;
        this.littleEndian ? (this.view[b + 1] = (a & 65280) >>> 8, this.view[b] = a & 255) : (this.view[b] = (a & 65280) >>>
            8, this.view[b + 1] = a & 255);
        c && (this.offset += 2);
        return this
    };
    e.writeShort = e.writeInt16;
    e.readInt16 = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 2 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+2) <= " + this.buffer.byteLength);
        }
        var c = 0;
        this.littleEndian ? (c = this.view[a], c |= this.view[a + 1] << 8) : (c = this.view[a] << 8, c |= this.view[a + 1]);
        32768 === (c & 32768) &&
        (c = -(65535 - c + 1));
        b && (this.offset += 2);
        return c
    };
    e.readShort = e.readInt16;
    e.writeUint16 = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal value: " + a + " (not an integer)");
            a >>>= 0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        b += 2;
        var d = this.buffer.byteLength;
        b > d && this.resize((d *= 2) > b ? d : b);
        b -= 2;
        this.littleEndian ? (this.view[b + 1] = (a & 65280) >>> 8, this.view[b] = a & 255) : (this.view[b] = (a & 65280) >>> 8, this.view[b + 1] = a & 255);
        c && (this.offset += 2);
        return this
    };
    e.writeUInt16 = e.writeUint16;
    e.readUint16 = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 2 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+2) <= " + this.buffer.byteLength);
        }
        var c = 0;
        this.littleEndian ? (c = this.view[a], c |= this.view[a + 1] << 8) : (c = this.view[a] << 8, c |= this.view[a + 1]);
        b && (this.offset += 2);
        return c
    };
    e.readUInt16 = e.readUint16;
    e.writeInt32 = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal value: " + a + " (not an integer)");
            a |= 0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " +
                b + " (+0) <= " + this.buffer.byteLength);
        }
        b += 4;
        var d = this.buffer.byteLength;
        b > d && this.resize((d *= 2) > b ? d : b);
        b -= 4;
        this.littleEndian ? (this.view[b + 3] = a >>> 24 & 255, this.view[b + 2] = a >>> 16 & 255, this.view[b + 1] = a >>> 8 & 255, this.view[b] = a & 255) : (this.view[b] = a >>> 24 & 255, this.view[b + 1] = a >>> 16 & 255, this.view[b + 2] = a >>> 8 & 255, this.view[b + 3] = a & 255);
        c && (this.offset += 4);
        return this
    };
    e.writeInt = e.writeInt32;
    e.readInt32 = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a %
                1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 4 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+4) <= " + this.buffer.byteLength);
        }
        var c = 0;
        this.littleEndian ? (c = this.view[a + 2] << 16, c |= this.view[a + 1] << 8, c |= this.view[a], c += this.view[a + 3] << 24 >>> 0) : (c = this.view[a + 1] << 16, c |= this.view[a + 2] << 8, c |= this.view[a + 3], c += this.view[a] << 24 >>> 0);
        b && (this.offset += 4);
        return c | 0
    };
    e.readInt = e.readInt32;
    e.writeUint32 = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal value: " + a + " (not an integer)");
            a >>>= 0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        b += 4;
        var d = this.buffer.byteLength;
        b > d && this.resize((d *= 2) > b ? d : b);
        b -= 4;
        this.littleEndian ? (this.view[b + 3] = a >>> 24 & 255, this.view[b + 2] = a >>> 16 & 255, this.view[b + 1] = a >>> 8 & 255, this.view[b] =
            a & 255) : (this.view[b] = a >>> 24 & 255, this.view[b + 1] = a >>> 16 & 255, this.view[b + 2] = a >>> 8 & 255, this.view[b + 3] = a & 255);
        c && (this.offset += 4);
        return this
    };
    e.writeUInt32 = e.writeUint32;
    e.readUint32 = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 4 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+4) <= " + this.buffer.byteLength);
        }
        var c = 0;
        this.littleEndian ? (c = this.view[a +
        2] << 16, c |= this.view[a + 1] << 8, c |= this.view[a], c += this.view[a + 3] << 24 >>> 0) : (c = this.view[a + 1] << 16, c |= this.view[a + 2] << 8, c |= this.view[a + 3], c += this.view[a] << 24 >>> 0);
        b && (this.offset += 4);
        return c
    };
    e.readUInt32 = e.readUint32;
    k && (e.writeInt64 = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" === typeof a) a = k.fromNumber(a); else if ("string" === typeof a) a = k.fromString(a); else if (!(a && a instanceof k)) throw TypeError("Illegal value: " + a + " (not an integer or Long)");
            if ("number" !==
                typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        "number" === typeof a ? a = k.fromNumber(a) : "string" === typeof a && (a = k.fromString(a));
        b += 8;
        var d = this.buffer.byteLength;
        b > d && this.resize((d *= 2) > b ? d : b);
        b -= 8;
        var d = a.low, f = a.high;
        this.littleEndian ? (this.view[b + 3] = d >>> 24 & 255, this.view[b + 2] = d >>> 16 & 255, this.view[b + 1] = d >>> 8 & 255, this.view[b] = d & 255, b += 4, this.view[b + 3] =
            f >>> 24 & 255, this.view[b + 2] = f >>> 16 & 255, this.view[b + 1] = f >>> 8 & 255, this.view[b] = f & 255) : (this.view[b] = f >>> 24 & 255, this.view[b + 1] = f >>> 16 & 255, this.view[b + 2] = f >>> 8 & 255, this.view[b + 3] = f & 255, b += 4, this.view[b] = d >>> 24 & 255, this.view[b + 1] = d >>> 16 & 255, this.view[b + 2] = d >>> 8 & 255, this.view[b + 3] = d & 255);
        c && (this.offset += 8);
        return this
    }, e.writeLong = e.writeInt64, e.readInt64 = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 8 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+8) <= " + this.buffer.byteLength);
        }
        var c = 0, d = 0;
        this.littleEndian ? (c = this.view[a + 2] << 16, c |= this.view[a + 1] << 8, c |= this.view[a], c += this.view[a + 3] << 24 >>> 0, a += 4, d = this.view[a + 2] << 16, d |= this.view[a + 1] << 8, d |= this.view[a], d += this.view[a + 3] << 24 >>> 0) : (d = this.view[a + 1] << 16, d |= this.view[a + 2] << 8, d |= this.view[a + 3], d += this.view[a] << 24 >>> 0, a += 4, c = this.view[a + 1] << 16, c |= this.view[a + 2] << 8, c |= this.view[a + 3], c += this.view[a] << 24 >>> 0);
        a = new k(c, d, !1);
        b && (this.offset += 8);
        return a
    }, e.readLong = e.readInt64, e.writeUint64 = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" === typeof a) a = k.fromNumber(a); else if ("string" === typeof a) a = k.fromString(a); else if (!(a && a instanceof k)) throw TypeError("Illegal value: " + a + " (not an integer or Long)");
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " +
                b + " (+0) <= " + this.buffer.byteLength);
        }
        "number" === typeof a ? a = k.fromNumber(a) : "string" === typeof a && (a = k.fromString(a));
        b += 8;
        var d = this.buffer.byteLength;
        b > d && this.resize((d *= 2) > b ? d : b);
        b -= 8;
        var d = a.low, f = a.high;
        this.littleEndian ? (this.view[b + 3] = d >>> 24 & 255, this.view[b + 2] = d >>> 16 & 255, this.view[b + 1] = d >>> 8 & 255, this.view[b] = d & 255, b += 4, this.view[b + 3] = f >>> 24 & 255, this.view[b + 2] = f >>> 16 & 255, this.view[b + 1] = f >>> 8 & 255, this.view[b] = f & 255) : (this.view[b] = f >>> 24 & 255, this.view[b + 1] = f >>> 16 & 255, this.view[b + 2] = f >>> 8 & 255,
            this.view[b + 3] = f & 255, b += 4, this.view[b] = d >>> 24 & 255, this.view[b + 1] = d >>> 16 & 255, this.view[b + 2] = d >>> 8 & 255, this.view[b + 3] = d & 255);
        c && (this.offset += 8);
        return this
    }, e.writeUInt64 = e.writeUint64, e.readUint64 = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 8 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+8) <= " + this.buffer.byteLength);
        }
        var c = 0, d = 0;
        this.littleEndian ?
            (c = this.view[a + 2] << 16, c |= this.view[a + 1] << 8, c |= this.view[a], c += this.view[a + 3] << 24 >>> 0, a += 4, d = this.view[a + 2] << 16, d |= this.view[a + 1] << 8, d |= this.view[a], d += this.view[a + 3] << 24 >>> 0) : (d = this.view[a + 1] << 16, d |= this.view[a + 2] << 8, d |= this.view[a + 3], d += this.view[a] << 24 >>> 0, a += 4, c = this.view[a + 1] << 16, c |= this.view[a + 2] << 8, c |= this.view[a + 3], c += this.view[a] << 24 >>> 0);
        a = new k(c, d, !0);
        b && (this.offset += 8);
        return a
    }, e.readUInt64 = e.readUint64);
    e.writeFloat32 = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" !==
                typeof a) throw TypeError("Illegal value: " + a + " (not a number)");
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        b += 4;
        var d = this.buffer.byteLength;
        b > d && this.resize((d *= 2) > b ? d : b);
        u(this.view, a, b - 4, this.littleEndian, 23, 4);
        c && (this.offset += 4);
        return this
    };
    e.writeFloat = e.writeFloat32;
    e.readFloat32 = function (a) {
        var b = "undefined" === typeof a;
        b &&
        (a = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 4 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+4) <= " + this.buffer.byteLength);
        }
        a = s(this.view, a, this.littleEndian, 23, 4);
        b && (this.offset += 4);
        return a
    };
    e.readFloat = e.readFloat32;
    e.writeFloat64 = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a) throw TypeError("Illegal value: " + a + " (not a number)");
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        b += 8;
        var d = this.buffer.byteLength;
        b > d && this.resize((d *= 2) > b ? d : b);
        u(this.view, a, b - 8, this.littleEndian, 52, 8);
        c && (this.offset += 8);
        return this
    };
    e.writeDouble = e.writeFloat64;
    e.readFloat64 = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !==
                a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 8 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+8) <= " + this.buffer.byteLength);
        }
        a = s(this.view, a, this.littleEndian, 52, 8);
        b && (this.offset += 8);
        return a
    };
    e.readDouble = e.readFloat64;
    h.MAX_VARINT32_BYTES = 5;
    h.calculateVarint32 = function (a) {
        a >>>= 0;
        return 128 > a ? 1 : 16384 > a ? 2 : 2097152 > a ? 3 : 268435456 > a ? 4 : 5
    };
    h.zigZagEncode32 = function (a) {
        return ((a |= 0) << 1 ^ a >> 31) >>> 0
    };
    h.zigZagDecode32 = function (a) {
        return a >>> 1 ^ -(a &
            1) | 0
    };
    e.writeVarint32 = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal value: " + a + " (not an integer)");
            a |= 0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        var d = h.calculateVarint32(a), f;
        b += d;
        f = this.buffer.byteLength;
        b > f && this.resize((f *= 2) > b ? f : b);
        b -= d;
        for (a >>>= 0; 128 <= a;) f = a & 127 | 128, this.view[b++] = f, a >>>= 7;
        this.view[b++] = a;
        return c ? (this.offset = b, this) : d
    };
    e.writeVarint32ZigZag = function (a, b) {
        return this.writeVarint32(h.zigZagEncode32(a), b)
    };
    e.readVarint32 = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 1 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+1) <= " + this.buffer.byteLength);
        }
        var c = 0, d = 0, f;
        do {
            if (!this.noAssert && a > this.limit) throw a = Error("Truncated"), a.truncated = !0, a;
            f = this.view[a++];
            5 > c && (d |= (f & 127) << 7 * c);
            ++c
        } while (0 !== (f & 128));
        d |= 0;
        return b ? (this.offset = a, d) : {value: d, length: c}
    };
    e.readVarint32ZigZag = function (a) {
        a = this.readVarint32(a);
        "object" === typeof a ? a.value = h.zigZagDecode32(a.value) : a = h.zigZagDecode32(a);
        return a
    };
    k && (h.MAX_VARINT64_BYTES = 10, h.calculateVarint64 = function (a) {
        "number" === typeof a ? a = k.fromNumber(a) : "string" === typeof a && (a = k.fromString(a));
        var b = a.toInt() >>>
            0, c = a.shiftRightUnsigned(28).toInt() >>> 0;
        a = a.shiftRightUnsigned(56).toInt() >>> 0;
        return 0 == a ? 0 == c ? 16384 > b ? 128 > b ? 1 : 2 : 2097152 > b ? 3 : 4 : 16384 > c ? 128 > c ? 5 : 6 : 2097152 > c ? 7 : 8 : 128 > a ? 9 : 10
    }, h.zigZagEncode64 = function (a) {
        "number" === typeof a ? a = k.fromNumber(a, !1) : "string" === typeof a ? a = k.fromString(a, !1) : !1 !== a.unsigned && (a = a.toSigned());
        return a.shiftLeft(1).xor(a.shiftRight(63)).toUnsigned()
    }, h.zigZagDecode64 = function (a) {
        "number" === typeof a ? a = k.fromNumber(a, !1) : "string" === typeof a ? a = k.fromString(a, !1) : !1 !== a.unsigned &&
            (a = a.toSigned());
        return a.shiftRightUnsigned(1).xor(a.and(k.ONE).toSigned().negate()).toSigned()
    }, e.writeVarint64 = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" === typeof a) a = k.fromNumber(a); else if ("string" === typeof a) a = k.fromString(a); else if (!(a && a instanceof k)) throw TypeError("Illegal value: " + a + " (not an integer or Long)");
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " +
                b + " (+0) <= " + this.buffer.byteLength);
        }
        "number" === typeof a ? a = k.fromNumber(a, !1) : "string" === typeof a ? a = k.fromString(a, !1) : !1 !== a.unsigned && (a = a.toSigned());
        var d = h.calculateVarint64(a), f = a.toInt() >>> 0, e = a.shiftRightUnsigned(28).toInt() >>> 0,
            g = a.shiftRightUnsigned(56).toInt() >>> 0;
        b += d;
        var t = this.buffer.byteLength;
        b > t && this.resize((t *= 2) > b ? t : b);
        b -= d;
        switch (d) {
            case 10:
                this.view[b + 9] = g >>> 7 & 1;
            case 9:
                this.view[b + 8] = 9 !== d ? g | 128 : g & 127;
            case 8:
                this.view[b + 7] = 8 !== d ? e >>> 21 | 128 : e >>> 21 & 127;
            case 7:
                this.view[b + 6] =
                    7 !== d ? e >>> 14 | 128 : e >>> 14 & 127;
            case 6:
                this.view[b + 5] = 6 !== d ? e >>> 7 | 128 : e >>> 7 & 127;
            case 5:
                this.view[b + 4] = 5 !== d ? e | 128 : e & 127;
            case 4:
                this.view[b + 3] = 4 !== d ? f >>> 21 | 128 : f >>> 21 & 127;
            case 3:
                this.view[b + 2] = 3 !== d ? f >>> 14 | 128 : f >>> 14 & 127;
            case 2:
                this.view[b + 1] = 2 !== d ? f >>> 7 | 128 : f >>> 7 & 127;
            case 1:
                this.view[b] = 1 !== d ? f | 128 : f & 127
        }
        return c ? (this.offset += d, this) : d
    }, e.writeVarint64ZigZag = function (a, b) {
        return this.writeVarint64(h.zigZagEncode64(a), b)
    }, e.readVarint64 = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !==
                typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 1 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+1) <= " + this.buffer.byteLength);
        }
        var c = a, d = 0, f = 0, e = 0, g = 0, g = this.view[a++], d = g & 127;
        if (g & 128 && (g = this.view[a++], d |= (g & 127) << 7, g & 128 || this.noAssert && "undefined" === typeof g) && (g = this.view[a++], d |= (g & 127) << 14, g & 128 || this.noAssert && "undefined" === typeof g) && (g = this.view[a++], d |= (g & 127) << 21, g & 128 || this.noAssert && "undefined" === typeof g) && (g = this.view[a++],
            f = g & 127, g & 128 || this.noAssert && "undefined" === typeof g) && (g = this.view[a++], f |= (g & 127) << 7, g & 128 || this.noAssert && "undefined" === typeof g) && (g = this.view[a++], f |= (g & 127) << 14, g & 128 || this.noAssert && "undefined" === typeof g) && (g = this.view[a++], f |= (g & 127) << 21, g & 128 || this.noAssert && "undefined" === typeof g) && (g = this.view[a++], e = g & 127, g & 128 || this.noAssert && "undefined" === typeof g) && (g = this.view[a++], e |= (g & 127) << 7, g & 128 || this.noAssert && "undefined" === typeof g)) throw Error("Buffer overrun");
        d = k.fromBits(d | f << 28, f >>> 4 |
            e << 24, !1);
        return b ? (this.offset = a, d) : {value: d, length: a - c}
    }, e.readVarint64ZigZag = function (a) {
        (a = this.readVarint64(a)) && a.value instanceof k ? a.value = h.zigZagDecode64(a.value) : a = h.zigZagDecode64(a);
        return a
    });
    e.writeCString = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        var d, f = a.length;
        if (!this.noAssert) {
            if ("string" !== typeof a) throw TypeError("Illegal str: Not a string");
            for (d = 0; d < f; ++d) if (0 === a.charCodeAt(d)) throw RangeError("Illegal str: Contains NULL-characters");
            if ("number" !== typeof b ||
                0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        f = n.calculateUTF16asUTF8(m(a))[1];
        b += f + 1;
        d = this.buffer.byteLength;
        b > d && this.resize((d *= 2) > b ? d : b);
        b -= f + 1;
        n.encodeUTF16toUTF8(m(a), function (a) {
            this.view[b++] = a
        }.bind(this));
        this.view[b++] = 0;
        return c ? (this.offset = b, this) : f
    };
    e.readCString = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !==
                typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 1 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+1) <= " + this.buffer.byteLength);
        }
        var c = a, d, f = -1;
        n.decodeUTF8toUTF16(function () {
            if (0 === f) return null;
            if (a >= this.limit) throw RangeError("Illegal range: Truncated data, " + a + " < " + this.limit);
            f = this.view[a++];
            return 0 === f ? null : f
        }.bind(this), d = r(), !0);
        return b ? (this.offset = a, d()) : {string: d(), length: a - c}
    };
    e.writeIString = function (a, b) {
        var c =
            "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("string" !== typeof a) throw TypeError("Illegal str: Not a string");
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        var d = b, f;
        f = n.calculateUTF16asUTF8(m(a), this.noAssert)[1];
        b += 4 + f;
        var e = this.buffer.byteLength;
        b > e && this.resize((e *= 2) > b ? e : b);
        b -= 4 + f;
        this.littleEndian ? (this.view[b +
        3] = f >>> 24 & 255, this.view[b + 2] = f >>> 16 & 255, this.view[b + 1] = f >>> 8 & 255, this.view[b] = f & 255) : (this.view[b] = f >>> 24 & 255, this.view[b + 1] = f >>> 16 & 255, this.view[b + 2] = f >>> 8 & 255, this.view[b + 3] = f & 255);
        b += 4;
        n.encodeUTF16toUTF8(m(a), function (a) {
            this.view[b++] = a
        }.bind(this));
        if (b !== d + 4 + f) throw RangeError("Illegal range: Truncated data, " + b + " == " + (b + 4 + f));
        return c ? (this.offset = b, this) : b - d
    };
    e.readIString = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " +
                a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 4 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+4) <= " + this.buffer.byteLength);
        }
        var c = a, d = this.readUint32(a), d = this.readUTF8String(d, h.METRICS_BYTES, a += 4);
        a += d.length;
        return b ? (this.offset = a, d.string) : {string: d.string, length: a - c}
    };
    h.METRICS_CHARS = "c";
    h.METRICS_BYTES = "b";
    e.writeUTF8String = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " +
                b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        var d, f = b;
        d = n.calculateUTF16asUTF8(m(a))[1];
        b += d;
        var e = this.buffer.byteLength;
        b > e && this.resize((e *= 2) > b ? e : b);
        b -= d;
        n.encodeUTF16toUTF8(m(a), function (a) {
            this.view[b++] = a
        }.bind(this));
        return c ? (this.offset = b, this) : b - f
    };
    e.writeString = e.writeUTF8String;
    h.calculateUTF8Chars = function (a) {
        return n.calculateUTF16asUTF8(m(a))[0]
    };
    h.calculateUTF8Bytes = function (a) {
        return n.calculateUTF16asUTF8(m(a))[1]
    };
    h.calculateString = h.calculateUTF8Bytes;
    e.readUTF8String = function (a, b, c) {
        "number" === typeof b && (c = b, b = void 0);
        var d = "undefined" === typeof c;
        d && (c = this.offset);
        "undefined" === typeof b && (b = h.METRICS_CHARS);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal length: " + a + " (not an integer)");
            a |= 0;
            if ("number" !== typeof c || 0 !== c % 1) throw TypeError("Illegal offset: " + c + " (not an integer)");
            c >>>= 0;
            if (0 > c || c + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + c + " (+0) <= " +
                this.buffer.byteLength);
        }
        var f = 0, e = c, g;
        if (b === h.METRICS_CHARS) {
            g = r();
            n.decodeUTF8(function () {
                return f < a && c < this.limit ? this.view[c++] : null
            }.bind(this), function (a) {
                ++f;
                n.UTF8toUTF16(a, g)
            });
            if (f !== a) throw RangeError("Illegal range: Truncated data, " + f + " == " + a);
            return d ? (this.offset = c, g()) : {string: g(), length: c - e}
        }
        if (b === h.METRICS_BYTES) {
            if (!this.noAssert) {
                if ("number" !== typeof c || 0 !== c % 1) throw TypeError("Illegal offset: " + c + " (not an integer)");
                c >>>= 0;
                if (0 > c || c + a > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " +
                    c + " (+" + a + ") <= " + this.buffer.byteLength);
            }
            var k = c + a;
            n.decodeUTF8toUTF16(function () {
                return c < k ? this.view[c++] : null
            }.bind(this), g = r(), this.noAssert);
            if (c !== k) throw RangeError("Illegal range: Truncated data, " + c + " == " + k);
            return d ? (this.offset = c, g()) : {string: g(), length: c - e}
        }
        throw TypeError("Unsupported metrics: " + b);
    };
    e.readString = e.readUTF8String;
    e.writeVString = function (a, b) {
        var c = "undefined" === typeof b;
        c && (b = this.offset);
        if (!this.noAssert) {
            if ("string" !== typeof a) throw TypeError("Illegal str: Not a string");
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: " + b + " (not an integer)");
            b >>>= 0;
            if (0 > b || b + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + b + " (+0) <= " + this.buffer.byteLength);
        }
        var d = b, f, e;
        f = n.calculateUTF16asUTF8(m(a), this.noAssert)[1];
        e = h.calculateVarint32(f);
        b += e + f;
        var g = this.buffer.byteLength;
        b > g && this.resize((g *= 2) > b ? g : b);
        b -= e + f;
        b += this.writeVarint32(f, b);
        n.encodeUTF16toUTF8(m(a), function (a) {
            this.view[b++] = a
        }.bind(this));
        if (b !== d + f + e) throw RangeError("Illegal range: Truncated data, " +
            b + " == " + (b + f + e));
        return c ? (this.offset = b, this) : b - d
    };
    e.readVString = function (a) {
        var b = "undefined" === typeof a;
        b && (a = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 1 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+1) <= " + this.buffer.byteLength);
        }
        var c = a, d = this.readVarint32(a), d = this.readUTF8String(d.value, h.METRICS_BYTES, a += d.length);
        a += d.length;
        return b ? (this.offset = a, d.string) : {
            string: d.string,
            length: a - c
        }
    };
    e.append = function (a, b, c) {
        if ("number" === typeof b || "string" !== typeof b) c = b, b = void 0;
        var d = "undefined" === typeof c;
        d && (c = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof c || 0 !== c % 1) throw TypeError("Illegal offset: " + c + " (not an integer)");
            c >>>= 0;
            if (0 > c || c + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + c + " (+0) <= " + this.buffer.byteLength);
        }
        a instanceof h || (a = h.wrap(a, b));
        b = a.limit - a.offset;
        if (0 >= b) return this;
        c += b;
        var f = this.buffer.byteLength;
        c > f && this.resize((f *= 2) >
        c ? f : c);
        c -= b;
        this.view.set(a.view.subarray(a.offset, a.limit), c);
        a.offset += b;
        d && (this.offset += b);
        return this
    };
    e.appendTo = function (a, b) {
        a.append(this, b);
        return this
    };
    e.assert = function (a) {
        this.noAssert = !a;
        return this
    };
    e.capacity = function () {
        return this.buffer.byteLength
    };
    e.clear = function () {
        this.offset = 0;
        this.limit = this.buffer.byteLength;
        this.markedOffset = -1;
        return this
    };
    e.clone = function (a) {
        var b = new h(0, this.littleEndian, this.noAssert);
        a ? (b.buffer = new ArrayBuffer(this.buffer.byteLength), b.view = new Uint8Array(b.buffer)) :
            (b.buffer = this.buffer, b.view = this.view);
        b.offset = this.offset;
        b.markedOffset = this.markedOffset;
        b.limit = this.limit;
        return b
    };
    e.compact = function (a, b) {
        "undefined" === typeof a && (a = this.offset);
        "undefined" === typeof b && (b = this.limit);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal begin: Not an integer");
            a >>>= 0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal end: Not an integer");
            b >>>= 0;
            if (0 > a || a > b || b > this.buffer.byteLength) throw RangeError("Illegal range: 0 <= " + a + " <= " +
                b + " <= " + this.buffer.byteLength);
        }
        if (0 === a && b === this.buffer.byteLength) return this;
        var c = b - a;
        if (0 === c) return this.buffer = v, this.view = null, 0 <= this.markedOffset && (this.markedOffset -= a), this.limit = this.offset = 0, this;
        var d = new ArrayBuffer(c), f = new Uint8Array(d);
        f.set(this.view.subarray(a, b));
        this.buffer = d;
        this.view = f;
        0 <= this.markedOffset && (this.markedOffset -= a);
        this.offset = 0;
        this.limit = c;
        return this
    };
    e.copy = function (a, b) {
        "undefined" === typeof a && (a = this.offset);
        "undefined" === typeof b && (b = this.limit);
        if (!this.noAssert) {
            if ("number" !==
                typeof a || 0 !== a % 1) throw TypeError("Illegal begin: Not an integer");
            a >>>= 0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal end: Not an integer");
            b >>>= 0;
            if (0 > a || a > b || b > this.buffer.byteLength) throw RangeError("Illegal range: 0 <= " + a + " <= " + b + " <= " + this.buffer.byteLength);
        }
        if (a === b) return new h(0, this.littleEndian, this.noAssert);
        var c = b - a, d = new h(c, this.littleEndian, this.noAssert);
        d.offset = 0;
        d.limit = c;
        0 <= d.markedOffset && (d.markedOffset -= a);
        this.copyTo(d, 0, a, b);
        return d
    };
    e.copyTo = function (a,
                         b, c, d) {
        var f, e;
        if (!this.noAssert && !h.isByteBuffer(a)) throw TypeError("Illegal target: Not a ByteBuffer");
        b = (e = "undefined" === typeof b) ? a.offset : b | 0;
        c = (f = "undefined" === typeof c) ? this.offset : c | 0;
        d = "undefined" === typeof d ? this.limit : d | 0;
        if (0 > b || b > a.buffer.byteLength) throw RangeError("Illegal target range: 0 <= " + b + " <= " + a.buffer.byteLength);
        if (0 > c || d > this.buffer.byteLength) throw RangeError("Illegal source range: 0 <= " + c + " <= " + this.buffer.byteLength);
        var g = d - c;
        if (0 === g) return a;
        a.ensureCapacity(b + g);
        a.view.set(this.view.subarray(c, d), b);
        f && (this.offset += g);
        e && (a.offset += g);
        return this
    };
    e.ensureCapacity = function (a) {
        var b = this.buffer.byteLength;
        return b < a ? this.resize((b *= 2) > a ? b : a) : this
    };
    e.fill = function (a, b, c) {
        var d = "undefined" === typeof b;
        d && (b = this.offset);
        "string" === typeof a && 0 < a.length && (a = a.charCodeAt(0));
        "undefined" === typeof b && (b = this.offset);
        "undefined" === typeof c && (c = this.limit);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal value: " + a + " (not an integer)");
            a |=
                0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal begin: Not an integer");
            b >>>= 0;
            if ("number" !== typeof c || 0 !== c % 1) throw TypeError("Illegal end: Not an integer");
            c >>>= 0;
            if (0 > b || b > c || c > this.buffer.byteLength) throw RangeError("Illegal range: 0 <= " + b + " <= " + c + " <= " + this.buffer.byteLength);
        }
        if (b >= c) return this;
        for (; b < c;) this.view[b++] = a;
        d && (this.offset = b);
        return this
    };
    e.flip = function () {
        this.limit = this.offset;
        this.offset = 0;
        return this
    };
    e.mark = function (a) {
        a = "undefined" === typeof a ? this.offset : a;
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal offset: " + a + " (not an integer)");
            a >>>= 0;
            if (0 > a || a + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + a + " (+0) <= " + this.buffer.byteLength);
        }
        this.markedOffset = a;
        return this
    };
    e.order = function (a) {
        if (!this.noAssert && "boolean" !== typeof a) throw TypeError("Illegal littleEndian: Not a boolean");
        this.littleEndian = !!a;
        return this
    };
    e.LE = function (a) {
        this.littleEndian = "undefined" !== typeof a ? !!a : !0;
        return this
    };
    e.BE = function (a) {
        this.littleEndian =
            "undefined" !== typeof a ? !a : !1;
        return this
    };
    e.prepend = function (a, b, c) {
        if ("number" === typeof b || "string" !== typeof b) c = b, b = void 0;
        var d = "undefined" === typeof c;
        d && (c = this.offset);
        if (!this.noAssert) {
            if ("number" !== typeof c || 0 !== c % 1) throw TypeError("Illegal offset: " + c + " (not an integer)");
            c >>>= 0;
            if (0 > c || c + 0 > this.buffer.byteLength) throw RangeError("Illegal offset: 0 <= " + c + " (+0) <= " + this.buffer.byteLength);
        }
        a instanceof h || (a = h.wrap(a, b));
        b = a.limit - a.offset;
        if (0 >= b) return this;
        var f = b - c;
        if (0 < f) {
            var e = new ArrayBuffer(this.buffer.byteLength +
                f), g = new Uint8Array(e);
            g.set(this.view.subarray(c, this.buffer.byteLength), b);
            this.buffer = e;
            this.view = g;
            this.offset += f;
            0 <= this.markedOffset && (this.markedOffset += f);
            this.limit += f;
            c += f
        } else new Uint8Array(this.buffer);
        this.view.set(a.view.subarray(a.offset, a.limit), c - b);
        a.offset = a.limit;
        d && (this.offset -= b);
        return this
    };
    e.prependTo = function (a, b) {
        a.prepend(this, b);
        return this
    };
    e.printDebug = function (a) {
        "function" !== typeof a && (a = console.log.bind(console));
        a(this.toString() + "\n-------------------------------------------------------------------\n" +
            this.toDebug(!0))
    };
    e.remaining = function () {
        return this.limit - this.offset
    };
    e.reset = function () {
        0 <= this.markedOffset ? (this.offset = this.markedOffset, this.markedOffset = -1) : this.offset = 0;
        return this
    };
    e.resize = function (a) {
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal capacity: " + a + " (not an integer)");
            a |= 0;
            if (0 > a) throw RangeError("Illegal capacity: 0 <= " + a);
        }
        if (this.buffer.byteLength < a) {
            a = new ArrayBuffer(a);
            var b = new Uint8Array(a);
            b.set(this.view);
            this.buffer = a;
            this.view = b
        }
        return this
    };
    e.reverse = function (a, b) {
        "undefined" === typeof a && (a = this.offset);
        "undefined" === typeof b && (b = this.limit);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal begin: Not an integer");
            a >>>= 0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal end: Not an integer");
            b >>>= 0;
            if (0 > a || a > b || b > this.buffer.byteLength) throw RangeError("Illegal range: 0 <= " + a + " <= " + b + " <= " + this.buffer.byteLength);
        }
        if (a === b) return this;
        Array.prototype.reverse.call(this.view.subarray(a, b));
        return this
    };
    e.skip = function (a) {
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal length: " + a + " (not an integer)");
            a |= 0
        }
        var b = this.offset + a;
        if (!this.noAssert && (0 > b || b > this.buffer.byteLength)) throw RangeError("Illegal length: 0 <= " + this.offset + " + " + a + " <= " + this.buffer.byteLength);
        this.offset = b;
        return this
    };
    e.slice = function (a, b) {
        "undefined" === typeof a && (a = this.offset);
        "undefined" === typeof b && (b = this.limit);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal begin: Not an integer");
            a >>>= 0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal end: Not an integer");
            b >>>= 0;
            if (0 > a || a > b || b > this.buffer.byteLength) throw RangeError("Illegal range: 0 <= " + a + " <= " + b + " <= " + this.buffer.byteLength);
        }
        var c = this.clone();
        c.offset = a;
        c.limit = b;
        return c
    };
    e.toBuffer = function (a) {
        var b = this.offset, c = this.limit;
        if (!this.noAssert) {
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal offset: Not an integer");
            b >>>= 0;
            if ("number" !== typeof c || 0 !== c % 1) throw TypeError("Illegal limit: Not an integer");
            c >>>= 0;
            if (0 > b || b > c || c > this.buffer.byteLength) throw RangeError("Illegal range: 0 <= " + b + " <= " + c + " <= " + this.buffer.byteLength);
        }
        if (!a && 0 === b && c === this.buffer.byteLength) return this.buffer;
        if (b === c) return v;
        a = new ArrayBuffer(c - b);
        (new Uint8Array(a)).set((new Uint8Array(this.buffer)).subarray(b, c), 0);
        return a
    };
    e.toArrayBuffer = e.toBuffer;
    e.toString = function (a, b, c) {
        if ("undefined" === typeof a) return "ByteBufferAB(offset=" + this.offset + ",markedOffset=" + this.markedOffset + ",limit=" + this.limit + ",capacity=" + this.capacity() +
            ")";
        "number" === typeof a && (c = b = a = "utf8");
        switch (a) {
            case "utf8":
                return this.toUTF8(b, c);
            case "base64":
                return this.toBase64(b, c);
            case "hex":
                return this.toHex(b, c);
            case "binary":
                return this.toBinary(b, c);
            case "debug":
                return this.toDebug();
            case "columns":
                return this.toColumns();
            default:
                throw Error("Unsupported encoding: " + a);
        }
    };
    var x = function () {
        for (var a = {}, b = [65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
            114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47], c = [], d = 0, f = b.length; d < f; ++d) c[b[d]] = d;
        a.encode = function (a, c) {
            for (var d, f; null !== (d = a());) c(b[d >> 2 & 63]), f = (d & 3) << 4, null !== (d = a()) ? (f |= d >> 4 & 15, c(b[(f | d >> 4 & 15) & 63]), f = (d & 15) << 2, null !== (d = a()) ? (c(b[(f | d >> 6 & 3) & 63]), c(b[d & 63])) : (c(b[f & 63]), c(61))) : (c(b[f & 63]), c(61), c(61))
        };
        a.decode = function (a, b) {
            function d(a) {
                throw Error("Illegal character code: " + a);
            }

            for (var f, e, h; null !== (f = a());) if (e = c[f], "undefined" === typeof e && d(f), null !== (f = a()) &&
            (h = c[f], "undefined" === typeof h && d(f), b(e << 2 >>> 0 | (h & 48) >> 4), null !== (f = a()))) {
                e = c[f];
                if ("undefined" === typeof e) if (61 === f) break; else d(f);
                b((h & 15) << 4 >>> 0 | (e & 60) >> 2);
                if (null !== (f = a())) {
                    h = c[f];
                    if ("undefined" === typeof h) if (61 === f) break; else d(f);
                    b((e & 3) << 6 >>> 0 | h)
                }
            }
        };
        a.test = function (a) {
            return /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(a)
        };
        return a
    }();
    e.toBase64 = function (a, b) {
        "undefined" === typeof a && (a = this.offset);
        "undefined" === typeof b && (b = this.limit);
        a |= 0;
        b |= 0;
        if (0 > a || b > this.capacity ||
            a > b) throw RangeError("begin, end");
        var c;
        x.encode(function () {
            return a < b ? this.view[a++] : null
        }.bind(this), c = r());
        return c()
    };
    h.fromBase64 = function (a, b) {
        if ("string" !== typeof a) throw TypeError("str");
        var c = new h(a.length / 4 * 3, b), d = 0;
        x.decode(m(a), function (a) {
            c.view[d++] = a
        });
        c.limit = d;
        return c
    };
    h.btoa = function (a) {
        return h.fromBinary(a).toBase64()
    };
    h.atob = function (a) {
        return h.fromBase64(a).toBinary()
    };
    e.toBinary = function (a, b) {
        "undefined" === typeof a && (a = this.offset);
        "undefined" === typeof b && (b = this.limit);
        a |= 0;
        b |= 0;
        if (0 > a || b > this.capacity() || a > b) throw RangeError("begin, end");
        if (a === b) return "";
        for (var c = [], d = []; a < b;) c.push(this.view[a++]), 1024 <= c.length && (d.push(String.fromCharCode.apply(String, c)), c = []);
        return d.join("") + String.fromCharCode.apply(String, c)
    };
    h.fromBinary = function (a, b) {
        if ("string" !== typeof a) throw TypeError("str");
        for (var c = 0, d = a.length, f, e = new h(d, b); c < d;) {
            f = a.charCodeAt(c);
            if (255 < f) throw RangeError("illegal char code: " + f);
            e.view[c++] = f
        }
        e.limit = d;
        return e
    };
    e.toDebug = function (a) {
        for (var b =
            -1, c = this.buffer.byteLength, d, f = "", e = "", g = ""; b < c;) {
            -1 !== b && (d = this.view[b], f = 16 > d ? f + ("0" + d.toString(16).toUpperCase()) : f + d.toString(16).toUpperCase(), a && (e += 32 < d && 127 > d ? String.fromCharCode(d) : "."));
            ++b;
            if (a && 0 < b && 0 === b % 16 && b !== c) {
                for (; 51 > f.length;) f += " ";
                g += f + e + "\n";
                f = e = ""
            }
            f = b === this.offset && b === this.limit ? f + (b === this.markedOffset ? "!" : "|") : b === this.offset ? f + (b === this.markedOffset ? "[" : "<") : b === this.limit ? f + (b === this.markedOffset ? "]" : ">") : f + (b === this.markedOffset ? "'" : a || 0 !== b && b !== c ? " " : "")
        }
        if (a && " " !==
            f) {
            for (; 51 > f.length;) f += " ";
            g += f + e + "\n"
        }
        return a ? g : f
    };
    h.fromDebug = function (a, b, c) {
        var d = a.length;
        b = new h((d + 1) / 3 | 0, b, c);
        for (var f = 0, e = 0, g, k = !1, m = !1, n = !1, p = !1, q = !1; f < d;) {
            switch (g = a.charAt(f++)) {
                case "!":
                    if (!c) {
                        if (m || n || p) {
                            q = !0;
                            break
                        }
                        m = n = p = !0
                    }
                    b.offset = b.markedOffset = b.limit = e;
                    k = !1;
                    break;
                case "|":
                    if (!c) {
                        if (m || p) {
                            q = !0;
                            break
                        }
                        m = p = !0
                    }
                    b.offset = b.limit = e;
                    k = !1;
                    break;
                case "[":
                    if (!c) {
                        if (m || n) {
                            q = !0;
                            break
                        }
                        m = n = !0
                    }
                    b.offset = b.markedOffset = e;
                    k = !1;
                    break;
                case "<":
                    if (!c) {
                        if (m) {
                            q = !0;
                            break
                        }
                        m = !0
                    }
                    b.offset = e;
                    k = !1;
                    break;
                case "]":
                    if (!c) {
                        if (p ||
                            n) {
                            q = !0;
                            break
                        }
                        p = n = !0
                    }
                    b.limit = b.markedOffset = e;
                    k = !1;
                    break;
                case ">":
                    if (!c) {
                        if (p) {
                            q = !0;
                            break
                        }
                        p = !0
                    }
                    b.limit = e;
                    k = !1;
                    break;
                case "'":
                    if (!c) {
                        if (n) {
                            q = !0;
                            break
                        }
                        n = !0
                    }
                    b.markedOffset = e;
                    k = !1;
                    break;
                case " ":
                    k = !1;
                    break;
                default:
                    if (!c && k) {
                        q = !0;
                        break
                    }
                    g = parseInt(g + a.charAt(f++), 16);
                    if (!c && (isNaN(g) || 0 > g || 255 < g)) throw TypeError("Illegal str: Not a debug encoded string");
                    b.view[e++] = g;
                    k = !0
            }
            if (q) throw TypeError("Illegal str: Invalid symbol at " + f);
        }
        if (!c) {
            if (!m || !p) throw TypeError("Illegal str: Missing offset or limit");
            if (e < b.buffer.byteLength) throw TypeError("Illegal str: Not a debug encoded string (is it hex?) " + e + " < " + d);
        }
        return b
    };
    e.toHex = function (a, b) {
        a = "undefined" === typeof a ? this.offset : a;
        b = "undefined" === typeof b ? this.limit : b;
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal begin: Not an integer");
            a >>>= 0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal end: Not an integer");
            b >>>= 0;
            if (0 > a || a > b || b > this.buffer.byteLength) throw RangeError("Illegal range: 0 <= " + a + " <= " + b + " <= " +
                this.buffer.byteLength);
        }
        for (var c = Array(b - a), d; a < b;) d = this.view[a++], 16 > d ? c.push("0", d.toString(16)) : c.push(d.toString(16));
        return c.join("")
    };
    h.fromHex = function (a, b, c) {
        if (!c) {
            if ("string" !== typeof a) throw TypeError("Illegal str: Not a string");
            if (0 !== a.length % 2) throw TypeError("Illegal str: Length not a multiple of 2");
        }
        var d = a.length;
        b = new h(d / 2 | 0, b);
        for (var f, e = 0, g = 0; e < d; e += 2) {
            f = parseInt(a.substring(e, e + 2), 16);
            if (!c && (!isFinite(f) || 0 > f || 255 < f)) throw TypeError("Illegal str: Contains non-hex characters");
            b.view[g++] = f
        }
        b.limit = g;
        return b
    };
    var n = function () {
        var a = {
            MAX_CODEPOINT: 1114111, encodeUTF8: function (a, c) {
                var d = null;
                "number" === typeof a && (d = a, a = function () {
                    return null
                });
                for (; null !== d || null !== (d = a());) 128 > d ? c(d & 127) : (2048 > d ? c(d >> 6 & 31 | 192) : (65536 > d ? c(d >> 12 & 15 | 224) : (c(d >> 18 & 7 | 240), c(d >> 12 & 63 | 128)), c(d >> 6 & 63 | 128)), c(d & 63 | 128)), d = null
            }, decodeUTF8: function (a, c) {
                for (var d, f, e, g, h = function (a) {
                    a = a.slice(0, a.indexOf(null));
                    var b = Error(a.toString());
                    b.name = "TruncatedError";
                    b.bytes = a;
                    throw b;
                }; null !== (d = a());) if (0 ===
                    (d & 128)) c(d); else if (192 === (d & 224)) null === (f = a()) && h([d, f]), c((d & 31) << 6 | f & 63); else if (224 === (d & 240)) null !== (f = a()) && null !== (e = a()) || h([d, f, e]), c((d & 15) << 12 | (f & 63) << 6 | e & 63); else if (240 === (d & 248)) null !== (f = a()) && null !== (e = a()) && null !== (g = a()) || h([d, f, e, g]), c((d & 7) << 18 | (f & 63) << 12 | (e & 63) << 6 | g & 63); else throw RangeError("Illegal starting byte: " + d);
            }, UTF16toUTF8: function (a, c) {
                for (var d, e = null; null !== (d = null !== e ? e : a());) 55296 <= d && 57343 >= d && null !== (e = a()) && 56320 <= e && 57343 >= e ? (c(1024 * (d - 55296) + e - 56320 + 65536),
                    e = null) : c(d);
                null !== e && c(e)
            }, UTF8toUTF16: function (a, c) {
                var d = null;
                "number" === typeof a && (d = a, a = function () {
                    return null
                });
                for (; null !== d || null !== (d = a());) 65535 >= d ? c(d) : (d -= 65536, c((d >> 10) + 55296), c(d % 1024 + 56320)), d = null
            }, encodeUTF16toUTF8: function (b, c) {
                a.UTF16toUTF8(b, function (b) {
                    a.encodeUTF8(b, c)
                })
            }, decodeUTF8toUTF16: function (b, c) {
                a.decodeUTF8(b, function (b) {
                    a.UTF8toUTF16(b, c)
                })
            }, calculateCodePoint: function (a) {
                return 128 > a ? 1 : 2048 > a ? 2 : 65536 > a ? 3 : 4
            }, calculateUTF8: function (a) {
                for (var c, d = 0; null !== (c = a());) d +=
                    128 > c ? 1 : 2048 > c ? 2 : 65536 > c ? 3 : 4;
                return d
            }, calculateUTF16asUTF8: function (b) {
                var c = 0, d = 0;
                a.UTF16toUTF8(b, function (a) {
                    ++c;
                    d += 128 > a ? 1 : 2048 > a ? 2 : 65536 > a ? 3 : 4
                });
                return [c, d]
            }
        };
        return a
    }();
    e.toUTF8 = function (a, b) {
        "undefined" === typeof a && (a = this.offset);
        "undefined" === typeof b && (b = this.limit);
        if (!this.noAssert) {
            if ("number" !== typeof a || 0 !== a % 1) throw TypeError("Illegal begin: Not an integer");
            a >>>= 0;
            if ("number" !== typeof b || 0 !== b % 1) throw TypeError("Illegal end: Not an integer");
            b >>>= 0;
            if (0 > a || a > b || b > this.buffer.byteLength) throw RangeError("Illegal range: 0 <= " +
                a + " <= " + b + " <= " + this.buffer.byteLength);
        }
        var c;
        try {
            n.decodeUTF8toUTF16(function () {
                return a < b ? this.view[a++] : null
            }.bind(this), c = r())
        } catch (d) {
            if (a !== b) throw RangeError("Illegal range: Truncated data, " + a + " != " + b);
        }
        return c()
    };
    h.fromUTF8 = function (a, b, c) {
        if (!c && "string" !== typeof a) throw TypeError("Illegal str: Not a string");
        var d = new h(n.calculateUTF16asUTF8(m(a), !0)[1], b, c), e = 0;
        n.encodeUTF16toUTF8(m(a), function (a) {
            d.view[e++] = a
        });
        d.limit = e;
        return d
    };
    return h
});
