define(['echarts',
        'echartsGL',
        '../tp/echartsCesium/extension/CompositeMap'
        ],function (echarts) {

    /*
    *
    * 暂时在散点图(scatterGl) 和 折线(lines)下实现效果，设置折线的动态样式可以模拟流入流出的迁徙效果
    * 【extension：为echarts增加自定义的一个地图类】
    * 1 为echarts-gl组件新加一个GlMap的继承
    * 2 使用echarts渲染gl效果时，在seris中的coordinateSystem参数中增加一个GLMap的自定义坐标系统
    * 3 使用时需要加上GLMap:{}
    * 4 监听cesium地图的移动的鼠标事件并添加到echarts-gl的事件监听中去
    * 5 echarts-gl方法中会随着地图的移动reset数据
    * */

    ////////////////////////////////////////////////【接口】///////////////////////////

    /*
    * id 主地图id
    * option echarts渲染option
    * viewer 实例化的地图
    *
    * */
    var drawResult = null;
    var _overlay = null;
        function CompositeView(id,viewer) {
                this._id = id;
                this._mapContainer = viewer;
        }

        /*创建一个echarts的覆盖*/
         CompositeView.prototype._createChartOverlay = function(container, option) {
             if(drawResult){
                 this._mapContainer.container.removeChild(drawResult);
                 drawResult = null;
             }
             if(_overlay){
                 _overlay.dispose();
                 _overlay = null;
             }
            //新建一个虚拟节点
            var chartContainer = document.createElement('div');
            var scene = container.scene;
            scene.canvas.setAttribute('tabIndex', 0);
            chartContainer.style.position = 'absolute';
            chartContainer.style.top = '0px';
            chartContainer.style.left = '0px';
            chartContainer.style.width = scene.canvas.width + 'px';
            chartContainer.style.height = scene.canvas.height + 'px';
            chartContainer.style.pointerEvents = 'none';
            chartContainer.setAttribute('id', 'echarts');
            chartContainer.setAttribute('class', 'echartMap');
            container.container.appendChild(chartContainer);
             drawResult = chartContainer;
            //改写echarts渲染的画布并重新init
            echarts.glMap = scene;
            var myChart = echarts.init(chartContainer);
            return myChart;
     };




        /*更新echarts图层option*/
        CompositeView.prototype.updateOverlay = function(option) {
                this._overlay = this._createChartOverlay(this._mapContainer, option);
                _overlay = this._overlay;
                this._overlay.setOption(option);
        };

        /*获取三维地图实例*/
        CompositeView.prototype.getMap = function() {
                return this._mapContainer;
        };

        /*获取覆盖层*/
        CompositeView.prototype.getOverlay = function() {
                return this._overlay;
        };

        CompositeView.prototype.show = function() {
                var container = document.getElementById(this._id);
                container.style.visibility = "visible";
            };

        CompositeView.prototype.hide = function() {
                var container = document.getElementById(this._id);
                container.style.visibility = "hidden";
            };

        /*删除echarts渲染*/
        CompositeView.prototype.dispose = function () {
            if(this._echartsContainer){
                this._mapContainer.container.removeChild(this._echartsContainer);
                this._echartsContainer = null;
            }
            if(this._overlay){
                this._overlay.dispose();
                this._overlay = null;
            }
        };

        CompositeView.prototype.destroy = function () {
            if(drawResult){
                this._mapContainer.container.removeChild(drawResult);
                drawResult = null;
            }
            if(_overlay){
                _overlay.dispose();
                _overlay = null;
            }
        };

        return  CompositeView;

});