/**
 * @author zenglihuan
 * @create 2018/08/22 16:09
 * @discription 通用方法
 */
layui.define([], function(exports){
    var $ = layui.$;

    var common_util = {

        parseExtension: function(name, type){
            if(name.indexOf(".") > -1){
                var index = name.lastIndexOf(".");
                return [name.substring(0, index), name.substring(index + 1, name.length)];
            }
            return [name, ""];
        },

        /**
         * 获取数组中field字段值，返回数组
         * @param objs
         * @param field 字段名
         */
        object2Field: function (objs, field) {
            var fields = [];
            if(!isArrayEmpty(objs)){
                for(var i = 0; i<objs.length; i++){
                    fields.push(objs[i][field]);
                };
            }
            return fields;
        },
        /**
         * 获取数组中field字段值，返回字符串，逗号分开
         * @param objs
         * @param field 字段名
         */
        object2String: function (objs, field) {
            var str = "";
            if(!isArrayEmpty(objs)){
                for(var i = 0; i<objs.length; i++){
                    str += objs[i][field];
                    if(i < objs.length - 1){
                        str += ",";
                    }
                }
            }
            return str;
        },
        /**
         * 与object2Field操作相反
         * @param vals
         * @param field 字段名
         */
        field2Object: function (vals, field) {
            var objs = [];
            if(!isArrayEmpty(vals)){
                for(var i = 0; i<vals.length; i++){
                    var obj = {};
                    obj[field] = vals[i];
                    objs.push(obj);
                }
            }
            return objs;
        },

        /**
         * 将数组转为MAP
         * key可重复
         * @param objs 对象数组
         * @param key map中的key字段
         * @returns {}
         */
        object2Map: function (objs, key) {
            var _map = {};
            if(!isArrayEmpty(objs)){
                for(var i = 0; i<objs.length; i++){
                    _map[objs[i][key]] = obj;
                };
            }
            return _map;
        },

        /**
         * 判断是否为空
         * @param temp
         */
        isEmpty: function(obj){
            return isEmpty(obj);
        },

        isBlank: function(obj){
            return isBlank(obj);
        },

        /**
         * 数组是否有值
         * @param arr
         * @returns {boolean}
         */
        isArrayEmpty: function(arr){
            return isArrayEmpty(arr);
        },
        /**
         * 删除左右两端的空格
         */
        trim: function(str){
            return trim(str);
        }
    }

    function isArrayEmpty(arr){
        return (arr == null || arr == undefined || arr.length == 0);
    }

    function isEmpty(obj){
        return (obj == null || obj == undefined);
    }

    function isBlank(obj){
        return (obj == null || obj == undefined || trim(obj) == "");
    }

    function trim(obj){
        return obj.replace(/(^\s*)|(\s*$)/g, "");
    }

    function isArray(temp){
        return (typeof temp=="object")&&temp.constructor==Array;
    }

    function isString(temp){
        return (typeof temp=="string")&&temp.constructor==String;
    }

    exports("common_util", common_util);

});













