// Interface between the visualization and the Gremlin server.

var traversal_source = getUrlParameter('ts');
if (traversal_source == null) {
    traversal_source = "g"
}

var graphioGremlin = (function () {
    "use strict";

    function search_query(query, isQuery) {
        var gremlin_query = null;
        if (isQuery) {
            gremlin_query = query;
        } else {
            graph_viz.clear();
            var input_string = query;
            var input_field = "name";
            var label_field = "";
            var limit_field = "1000";
            var search_type = "eq";
            var filtered_string = input_string;
            if (filtered_string.length > 50) filtered_string = filtered_string.substring(0, 50); // limit string length
            var has_str = "";
            if (label_field !== "") {
                has_str = ".hasLabel('" + label_field + "')";
            }
            if (input_field !== "" && input_string !== "") {
                has_str += ".has('" + input_field + "',";
                switch (search_type) {
                    case "eq":
                        if (isInt(input_string)) {
                            has_str += filtered_string + ")"
                        } else {
                            has_str += "'" + filtered_string + "')"
                        }
                        break;
                    case "contains":
                        has_str += "textContains('" + filtered_string + "'))";
                        break;
                }
            } else if (limit_field === "" || limit_field < 0) {
                limit_field = node_limit_per_request;
            }
            var gremlin_query_nodes = 'nodes = ' + traversal_source + '.V()' + has_str + '.as("node").both().as("node").select(all,"node").inject(' + traversal_source + '.V()' + has_str + ').unfold();'
            var gremlin_query_edges = "edges = " + traversal_source + ".V()" + has_str + ".bothE()";
            gremlin_query = gremlin_query_nodes + gremlin_query_edges + ';[nodes.toList(),edges.toList()]'

        }
        send_to_server(gremlin_query, 'search', null);
    }

    function isInt(value) {
        return !isNaN(value) &&
            parseInt(Number(value)) == value &&
            !isNaN(parseInt(value, 10));
    }

    function click_query(d) {
        var id = d.id;
        if (isNaN(id)) {
            id = '"' + id + '"';
        }
        var gremlin_query_nodes = 'nodes = ' + traversal_source + '.V(' + id + ').as("node").both().as("node").select(all,"node").inject(' + traversal_source + '.V(' + id + ')).unfold()'
        var gremlin_query_edges = "edges = " + traversal_source + ".V(" + id + ").bothE()";
        var gremlin_query = gremlin_query_nodes + '\n' + gremlin_query_edges + '\n' + '[nodes.toList(),edges.toList()]'
        send_to_server(gremlin_query, 'click', d.id);
    }

    function send_to_server(gremlin_query, query_type, active_node, callback) {
        var server_url = url;
        run_ajax_request(gremlin_query, server_url, query_type, active_node, callback);
    }

    function run_ajax_request(gremlin_query, server_url, query_type, active_node, callback) {
        $.ajax({
            type: "POST",
            accept: "application/json",
            async: false,
            url: server_url,
            data: JSON.stringify({"gremlin": gremlin_query}),
            success: function (data, textStatus, jqXHR) {
                var Data = data.result.data;
                if (Data["@value"][0]["@value"].length + Data["@value"][1]["@value"].length === 0) {
                    layui.use(['layer'], function () {
                        var layer = layui.layer;
                        layer.msg('查询无结果');
                    });
                    return false;
                }
                if (callback) {
                    callback(Data);
                } else {
                    handle_server_answer(Data, query_type, active_node);
                }
            },
            error: function (result, status, error) {
                console.log("Connection failed. " + status);
                var msgs = [];
                if (query_type == 'editGraph') {
                    msgs.push('Problem accessing the database using REST at ' + server_url);
                    msgs.push('Message: ' + status + ', ' + error);
                    msgs.push('Possible cause: creating an edge with bad node ids ' +
                        '(linking nodes not existing in the DB).');
                } else {
                    msgs.push('Can\'t access database using REST at ' + server_url);
                    msgs.push('Message: ' + status + ', ' + error);
                    msgs.push('Check the server configuration ' +
                        'or try increasing the REST_TIMEOUT value in the config file.');
                }
                if (result.status === 400
                    && SINGLE_COMMANDS_AND_NO_VARS === false
                    && result.hasOwnProperty('responseJSON')
                    && result.responseJSON.code === 'MalformedQueryException') {
                    msgs.push('If connecting to an Amazon Neptune databse, ensure that ' +
                        'SINGLE_COMMANDS_AND_NO_VARS is set to true in the config file.');
                }
            }
        });
    }

    function handle_server_answer(data, query_type, active_node, with_active_node) {
        data = graphson3to1(data);
        var arrange_data = arrange_datav3;
        var graph = arrange_data(data);
        if (query_type == 'click') var center_f = 0;
        else if (query_type == 'search') var center_f = 1;
        else return;
        graph_viz.refresh_data(graph, center_f, active_node, with_active_node);
    }

    function idIndex(list, elem) {
        for (var i = 0; i < list.length; i++) {
            if (list[i].id == elem) return i;
        }
        return null;
    }

    function arrange_datav3(data) {
        // Extract node and edges from the data returned for 'search' and 'click' request
        // Create the graph object
        var nodes = [], links = [];
        if (data != null) {
            for (var key in data) {
                if (data[key] != null) {
                    data[key].forEach(function (item) {
                        if (!("inV" in item) && idIndex(nodes, item.id) == null) { // if vertex and not already in the list
                            item.type = "vertex";
                            nodes.push(extract_infov3(item));
                        }
                        if (("inV" in item) && idIndex(links, item.id) == null) {
                            item.type = "edge";
                            links.push(extract_infov3(item));
                        }
                    });
                }
            }
        }
        return {nodes: nodes, links: links};
    }

    function extract_infov3(data) {
        var data_dic = {id: data.id, label: data.label, type: data.type, properties: {}}
        var prop_dic = data.properties
        for (var key in prop_dic) {
            if (prop_dic.hasOwnProperty(key)) {
                if (data.type == 'vertex') {// Extracting the Vertexproperties (properties of properties for vertices)
                    var property = prop_dic[key];
                    property['summary'] = get_vertex_prop_in_list(prop_dic[key]).toString();
                } else {
                    var property = prop_dic[key]['value'];
                }
                data_dic.properties[key] = property;
                // If  a node position is defined in the DB, the node will be positioned accordingly
                // a value in fx and/or fy tells D3js to fix the position at this value in the layout
                if (key == node_position_x) {
                    data_dic.fx = prop_dic[node_position_x]['0']['value'];
                }
                if (key == node_position_y) {
                    data_dic.fy = prop_dic[node_position_y]['0']['value'];
                }
            }
        }
        if (data.type == "edge") {
            data_dic.source = data.outV;
            data_dic.target = data.inV;
            if (data.id !== null && typeof data.id === 'object') {
                console.log('Warning the edge id is an object')
                if ("relationId" in data.id) {
                    data_dic.id = data.id.relationId;
                }
            }
        }
        return data_dic
    }

    function get_vertex_prop_in_list(vertexProperty) {
        var prop_value_list = [];
        for (var key in vertexProperty) {
            prop_value_list.push(vertexProperty[key]['value']);
        }
        return prop_value_list;
    }

    function graphson3to1(data) {
        if (!(Array.isArray(data) || ((typeof data === "object") && (data !== null)))) return data;
        if ('@type' in data) {
            if (data['@type'] == 'g:List') {
                data = data['@value'];
                return graphson3to1(data);
            } else if (data['@type'] == 'g:Set') {
                data = data['@value'];
                return data;
            } else if (data['@type'] == 'g:Map') {
                var data_tmp = {}
                for (var i = 0; i < data['@value'].length; i += 2) {
                    var data_key = data['@value'][i];
                    if ((typeof data_key === "object") && (data_key !== null)) data_key = graphson3to1(data_key);
                    if (Array.isArray(data_key)) data_key = JSON.stringify(data_key).replace(/\"/g, ' ');//.toString();
                    data_tmp[data_key] = graphson3to1(data['@value'][i + 1]);
                }
                data = data_tmp;
                return data;
            } else {
                data = data['@value'];
                if ((typeof data === "object") && (data !== null)) data = graphson3to1(data);
                return data;
            }
        } else if (Array.isArray(data) || ((typeof data === "object") && (data !== null))) {
            for (var key in data) {
                data[key] = graphson3to1(data[key]);
            }
            return data;
        }
        return data;
    }

    return {
        search_query: search_query,
        click_query: click_query,
        send_to_server: send_to_server
    }
})();
