var indexTable = null;
var historyShow = false;
var proShow = false;
var mapShow = false;
var tools = (function () {
    function getQueryVariable(variable) {
        var query = window.location.search.substring(1);
        var vars = query.split("&");
        for (var i = 0; i < vars.length; i++) {
            var pair = vars[i].split("=");
            if (pair[0] == variable) {
                return pair[1];
            }
        }
        return false;
    }

    function search_query(initQueryString) {
        if (!initQueryString) {
            initQueryString = "智慧江苏";
        }
        var ini_gremlin_query = 'nodes = g.V().has("name","' + initQueryString + '").as("node").both().as("node").select(all,"node").inject( g.V().has("name","' + initQueryString + '")).unfold();'
            + 'edges = g.V().has("name","' + initQueryString + '").bothE();[nodes.toList(),edges.toList()]';
        graphioGremlin.search_query(ini_gremlin_query, true);
    }

    function hideInfo() {
        var node = $('#timeline');
        var table = $('#nodeInfo');

        if (node.is(':visible') && historyShow) {
            $('#timeline').hide();
        }
        if (proShow) {
            layui.use(["table"], function () {
                var table = layui.table;
                $('#nodeInfo').hide();
            });
        }
        if (mapShow) {
            $('#map_container').hide();
        }
        proShow = true;
        historyShow = true;
        mapShow = true;
    }

    return {
        getQueryVariable: getQueryVariable,
        search_query: search_query,
        hideInfo: hideInfo
    }
})();

layui.use(["form", "table", "layer", "laypage"], function () {
    var form = layui.form,
        table = layui.table,
        layer = layui.layer,
        laypage = layui.laypage;

    $(document).ready(function () {
        $('.layui-row').css('height', $(window).height() - 70);
        $('#left-panel').css('height', $('.layui-row').height() - 5);
        $('#zsfw').css('height', $('.layui-row').height() - 5);
        initElem();
        initMap();
        bindEvents();
        if (appVersion !== "_shengting") $('#searchSelect').show();
    });

    function initElem() {
        graph_viz.init("#zsfw");
        graph_viz.addzoom();

        if (searchValue !== "") {
            graphioGremlin.search_query(searchValue, false);
        } else {
            tools.search_query(initQuery);
        }

        indexTable = table.render({
            elem: '#nodePropertyTable',
            id: 'nodePropertyTable',
            skin: 'row',
            even: true,
            cols: [[
                {field: 'key', title: '属性', width: '20%'}
                , {field: 'value', title: '值', width: '80%'}
            ]],
            // height: 400,
            limit: 200,
            // visible:hidden,
            data: []
        });
        indexTable.resize();
    }

    function bindEvents() {
        $('#searchbtn').click(function () {
            var searchValue = $("#searchInput").val();
            if (searchValue === "") {
                layer.msg("请输入关键字");
                return;
            }
            $.ajax({
                url: fuzzyQueryByNameUrl + "?name=" + searchValue
            }).done(function (res) {
                if (res.data.count > 0) {
                    var nameList = res.data.names;
                    if (searchValue === nameList[0]) {
                        tools.hideInfo();
                        graphioGremlin.search_query(searchValue, false);
                    }
                    $('#keywordList').empty();
                    laypage.render({
                        elem: "keywordPage"
                        , count: nameList.length
                        , limit: 5
                        , jump: function (obj) {
                            $('#keywordList').html(function () {
                                var arr = []
                                    , thisData = nameList.concat().splice(obj.curr * obj.limit - obj.limit, obj.limit);
                                $.each(thisData, function (index, item) {
                                    arr.push('<li title="' + item + '">' + item + '</li>');
                                });
                                return arr.join('');
                            });
                        }
                    });
                    $("#searchGuess").show();
                } else {
                    layer.msg("未查到相关内容");
                    $("#searchGuess").hide();
                }
            });
        });

        $(document).on('click', '#keywordList > li', function () {
            tools.hideInfo();
            graphioGremlin.search_query($(this).attr("title"), false);
        });

        $("#searchInput").keyup(function (event) {
            if (event.keyCode === 13) {
                $('#searchbtn').trigger('click');
            }
        });

        $(document).on('click', '#zsfw', tools.hideInfo);

        $(window).resize(function () {
            $('.layui-row').css('height', $(window).height() - 70);
            $('#left-panel').css('height', $('.layui-row').height() - 5);
            $('#zsfw').css('height', $('.layui-row').height() - 5);
            $('#zsfw svg').css('height', $('#zsfw').height());
        });

        $('.switch').on({
            mousemove: function (e) {
                document.querySelector('.tips').style.display = "block";
                e.preventDefault();
            },
            mouseout: function (e) {
                // e.stopPropagation();   //阻止事件冒泡
                document.querySelector('.tips').style.display = "none";
                // return false;     //阻止回调执行
                e.preventDefault(); //阻止默认行为
            },
            click: function (e) {
                if ($(this).hasClass('switch-off')) {
                    $('#left-panel').css('display', 'block');
                    $('.tips').html('收起侧边面板');
                    $(this).removeClass('switch-off');
                    $(this).addClass('switch-on');
                    $('#zsfw').removeClass('layui-col-xs12');
                    $('#zsfw').addClass('layui-col-xs9');
                } else {
                    // alert(1212)
                    $('#left-panel').hide();
                    $('.tips').html('展开侧边面板');
                    $(this).removeClass('switch-on');
                    $(this).addClass('switch-off');
                    $('#zsfw').removeClass('layui-col-xs9');
                    $('#zsfw').addClass('layui-col-xs12');
                }
                e.preventDefault();
            }
        });

        $(document).on('click', '.switch', function () {
            indexTable.resize();
            // graph_viz.init("#zsfw");
        });
    }

    /**
     * 初始化地图界面
     */
    function initMap() {
        var url = rootPath + "/map/easy_map?map_type=zsfw_map";
        $.ajax({
            url: url,
            dataType: "html",
            success: function (html) {
                $(".map_container").html(html);
            }
        });
    }
});
