
// configuration for the graph database access

// if host is set, will override default localhost server option
//const host = "some_gremlin_server"
var host = false;

// For implementations like Neptune where only single commands are allowed per request
// set to true
var SINGLE_COMMANDS_AND_NO_VARS = false;

// Time out for the REST protocol. Increase it if the graphDB is slow.
var REST_TIMEOUT = 2000;
// TODO: configuration for the secure server


// Graph configuration
var default_nb_of_layers =1;
var node_limit_per_request = 1000;

// Simulation
var force_strength = -400;
var link_strength = 0.1;
var force_x_strength = -0.01;
var force_y_strength = -0.01;

// Nodes
var default_node_size = 40;
var default_stroke_width =12;
var default_stroke_color ="#f5f5f5";
var default_stroke_opacity=0.5;
//const default_node_color = "#80E810";
var default_node_color = "#F4606C";
var active_node_margin = 0;
var active_node_margin_opacity = 0.3;
// Node position info in the DB
// Replace by the key storing the node position inside the DB if any
var node_position_x = 'graphexpx'
var node_position_y = 'graphexpy'

// Edges
var default_edge_stroke_width =2;
var default_nodetext_color = "#fff";
var default_nodetext_size = 18;
var default_edge_color = "#ccc";
var edge_label_color = "#CFD8DC";
// Choose between curved (true) and straight edges (false). 
// If set to false, multiple edges between 2 nodes will all be straight and overlap.
var use_curved_edges = false  ;
