/**
 *@Author: liujie<liu.im.jie@gmail.com>
 *@Created in 2019-08-28 16:40
 *@Description: 叠加分析
 *@Modify By:
 */

define(["global/core/Model", "global/utils/WidgetUtils"], function (model, WidgetUtils) {
    var instance = {
        init: function () {
            initLayui();
            // $(".form-box").parent().css("overflow", "visible").parent().parent().css("overflow", "visible");
        },
        onOpen: function () {
        },
        onClose: function () {
            model.clear();
        },
        onPause: function () {
        },
    };
    var initLayui = function () {
        layui.config({base: "./js/"}).use(["element", "form", "layer", "upload", "table"], function () {
            var elem = layui.element, form = layui.form, layer = layui.layer, upload = layui.upload, $ = layui.jquery,
                table = layui.table;
            var chooseFile, listCrs = [], layerIndex_wait, models = [], overlayer;
            var layers = [
                {
                    name: "RESABH_135",
                    alisa: "居民地",
                    cols: [[
                        {field: "SHIMC", title: "区县", width: "100"},
                        {field: "TYPE", title: "类型", width: "100"},
                        {field: "Shape_Area", title: "面积", width: "200"}
                    ]],
                },
                {
                    name: "HPSK_135",
                    alisa: "水系",
                    cols: [[{field: "Id", title: "Id"}]],
                },
                {
                    name: "UV_LCRA_2018ZBBH",
                    alisa: "植被",
                    cols: [[
                        {field: "OBJECTID", title: "OBJECTID", width: "100"},
                        {field: "TYPE", title: "类型", width: "100"},
                        {field: "SHAPE_Area", title: "面积", width: "200"}
                    ]],
                }
            ];

            form.render('select');

            var bindTableName = $.get("/tablesinfo/search?page=1&limit=100&keyword=&moduleCode=ccglzy").done(function (obj) {
                var data = obj.data;
                if (data) {
                    var option = "<option></option>";
                    for (var i = 0; i < data.length; i++) {
                        var name = data[i].tableName;
                        option += "<option value=\"" + data[i].id + "\">" + name + "</option>";
                    }
                    $('[name=tableName]').html(option);
                    form.render('select');
                }
            });

            var bindLayerName = $.ajax({
                type: "post",
                url: "http://192.168.19.47:8080/service/servicesinfo/findpagelist",
                contentType: "application/json;charset=utf-8",
                dataType: 'json',
                data: JSON.stringify({
                    "pageIndex": 0,
                    "pageSize": 1000
                }),
                success: function (obj) {
                    var data = obj.data.dataSource;
                    if (data) {
                        var option = "<option></option>";
                        for (var i = 0; i < data.length; i++) {
                            if (data[i].catalogPath.indexOf("交通") >= 0) {
                                var name = data[i].name;
                                if (option.indexOf(name) < 0) {
                                    listCrs[name] = data[i].crs;
                                    option += "<option value=\"" + name + "\">" + name + "</option>";
                                }
                            }
                        }
                        $('[name=selectLayer]').html(option);
                        form.render('select');
                    }
                }
            });

            var uploadShp = upload.render({
                elem: "#btn-uploadShp",
                url: "/dm/tool/execute",
                accept: 'file',
                exts: 'zip',
                auto: false,
                choose: function (obj) {
                    obj.preview(function (index, file, result) {
                        chooseFile = file;
                        delete file[index];
                    })
                },
            });

            form.on("select(geometry-type)", function (obj) {
                if (obj.value == 1) {
                    $("#div-file").show();
                    $("#div-tableName").hide();
                } else if (obj.value == 2) {
                    $("#div-file").hide();
                    $("#div-tableName").show();

                }
                form.render('select');
            });

            form.on("submit(submit)", function (obj) {
                if (chooseFile.length <= 0 && data.tableName == "") {
                    return layer.msg("请选择分析范围！");
                }
                models = [];
                var data = obj.field;
                console.log(obj.field);
                //获取geojson
                var formData = new FormData();
                formData.append("geometry", data.geometry);
                if (data.geometry == 1) {
                    formData.append("file", chooseFile);
                }
                else {
                    formData.append("layerName", data.tableName);
                }
                $.ajax({
                    type: "POST",
                    url: "/dm/tool/getGeoJson",
                    contentType: false,
                    processData: false,
                    async: true,
                    data: formData,
                    beforeSend: function () {
                        layerIndex_wait = layer.msg("正在执行分析", {
                            icon: 16,
                            shade: [0.5, '#f5f5f5'],
                            scrollbar: false,
                            offset: 'auto',
                            time: 100000
                        });
                    },
                    success: function (result) {
                        var geoJson = result.data;
                        overlayer = geoJson;
                        for (var k = 0; k < layers.length; k++) {
                            var curLayer = layers[k].name;
                            var curAlisa = layers[k].alisa;
                            var curCols = layers[k].cols;
                            var params = JSON.stringify({
                                "operate": "intersect",
                                // "destCrs": listCrs[data.selectLayer],
                                "destCrs": "EPSG:4490",
                                "layerName": curLayer,
                                "features": geoJson
                            });
                            var count = 0;
                            $.ajax({
                                type: "POST",
                                url: "http://192.168.19.46:8030/hgis/wps",
                                async: false,
                                data: {
                                    service: "wps",
                                    request: "featuresIntersect",
                                    version: "2017.06.21",
                                    featuresIntersect: params
                                },
                                success: function (data) {
                                    if (typeof(data) != "string") {
                                        return;
                                    }
                                    var dataJson = JSON.parse(data);
                                    var templayer = dataJson.data;
                                    $.ajax({
                                        type: "POST",
                                        url: "http://192.168.19.46:8030/hgis/wfs",
                                        async: false,
                                        data: {
                                            request: "GetFeature",
                                            version: "1.1.0",
                                            typeName: templayer,
                                            outputFormat: "application/json"
                                        },
                                        success: function (obj) {
                                            models.push({name: curAlisa, value: obj});
                                            // model.addModel(obj, "geojson");
                                            var JSONResult = obj;
                                            var features = JSONResult.features;
                                            var showlist = [];
                                            for (var l = 0; l < features.length; l++) {
                                                var properties = features[l].properties;
                                                showlist.push(properties);
                                            }
                                            var tableId = "#" + curLayer;
                                            table.render({
                                                elem: tableId,
                                                data: showlist,
                                                even: false,
                                                cols: curCols,
                                                page: {
                                                    layout: ['page', 'skip'],
                                                    theme: '#1890FF',
                                                },
                                                limit: 10,
                                                done: function (res, curr, count) {
                                                    table.resize(curLayer);
                                                }
                                            });
                                            count++;
                                        }
                                    })
                                },
                            });
                        }
                        $(".form-dlgq").hide();
                        $(".form-result").show();
                        layer.close(layerIndex_wait);
                        layer.msg("分析完成！");
                    },
                    error: function () {
                        layer.close(layerIndex_wait);
                        layer.msg("分析失败！");
                    }
                });
                return false;
            });

            $("#btn-return").click(function () {
                $(".form-dlgq").show();
                $(".form-result").hide();
            });

            $("#btn-model").click(function () {
                model.clear();
                model.addModel(overlayer, "geojson");
                var name = $(".form-result li.layui-this")[0].innerText;
                for (var i = 0; i < models.length; i++) {
                    if (models[i].name == name) {
                        model.addModel(models[i].value, "geojson");
                    }
                }
            });
        })
    };
    return instance;
})