layui.config({
    base: './js/'
}).use(['layer', 'table', 'form'], function () {
    var table = layui.table,
        form = layui.form;
    var keywords = '',
        page = 1;

    var height = $(".right-content").outerHeight() - $(".item-top").outerHeight();
    //表初始化加载数据
    var tableIns = table.render({
        elem: '#data-table',
        url: rootPath + '/rest/rapid/jobs?id=' + id,
        skin: 'line',
        even: false,
        id: 'data-table',
        height: height,
        /*where: {
            keyword: keywords
        },*/
        page: {
            count: 10,
            layout: ['prev', 'page', 'next', 'limit', 'skip', 'count'],
            theme: '#1890FF'
        },
        limit: 10,
        cols: [
            [{
                type: 'checkbox'
            },
                {
                    title: 'ID',
                    field: 'id',
                    hide: true,
                    templet: function (obj) {
                        return obj.id;
                    }
                },
                {
                    title: '名称',
                    field: 'location',
                    templet: function (obj) {
                        return obj.location;
                    }
                },
                {
                    title: '状态',
                    field: 'state',
                    templet: function (obj) {
                        return obj.state;
                    }
                },
                {
                    title: '创建时间',
                    field: 'createdAt',
                    templet: function (obj) {
                        return renderDate(obj.createdAt);
                    }
                },
                {
                    title: '开始时间',
                    field: 'startedAt',
                    templet: function (obj) {
                        return renderDate(obj.startedAt);
                    }
                },
                {
                    title: '结束时间',
                    field: 'endedAt',
                    templet: function (obj) {
                        return renderDate(obj.endedAt);
                    }
                },
                {
                    title: '操作',
                    field: 'tool',
                    align: 'center',
                    style: 'cursor:pointer',
                    toolbar: '#toolbar'
                }
            ]
        ],
        done: function (res, curr, count) {
            page = curr;
            table.resize('data-table');
        }
    });

    //监听表格里控件的点击事件
    table.on('tool(data-table)', function (obj) {
        var data = obj.data;
        if (obj.event == 'del') {
            layer.confirm('确认停止该任务吗？', function (index) {
                var id = data.id;
                $.ajax({
                    type: 'POST',
                    url: rootPath + '/rest/rapid/delete/job/' + id,
                    data: null,
                    success: function (data) {
                        layerAlert(data.msg);
                    },
                    error: function (e, state, errorThrown) {
                        console.log(e);
                    }
                });
                layer.close(index);
            });
        }
        else if (obj.event == 'detail') {
            layerOpen(rootPath + '/rest/rapid/log/job/' + data.id, "日志");
        }
    });

    $(document).on('click', '#addbtn', function () {
        var data = getData(id);
        var params = JSON.parse(data.paramJson);
        var html = createParamHtml(params);
        var config = {
            title: "新增",
            shadeClose: true,
            type: 1,
            area: ['60%', '75%'],
            // maxHeight: 300,
            // maxWidth: 700,
            content: html
        };
        paramValueIndex = layer.open(config);
        $(".tool-execute").data(data);
        if ($("[dict-name]").length > 0) {
            //绑定
            $("[dict-name]").each(function () {
                helper.bindDict(this, $(this).attr("dict-name"));
                form.render("select");
            });
        }
    });

    $(document).on('click', '#tj', function () {
        $.ajax({
            type: 'POST',
            url: rootPath + '/rest/rapid/delete/job/' + id,
            data: null,
            success: function (data) {
                layerAlert(data.msg);
            },
            error: function (e, state, errorThrown) {
                console.log(e);
            }
        });
        layer.close(index);
    });


    // 根据id获取该工具的数据
    function getData(toolId) {
        var result = null;
        $.ajax({
            url: rootPath + "/rest/dm/tool/find/" + toolId,
            async: false,
            success: function (evt) {
                result = evt.data;
            }
        });
        return result;
    };

    function createParamHtml(param) {
        var dt = {};
        param = param || [];
        dt.params = param;
        dt.isSelect = function () {
            if (this.type == "select") {
                return true;
            } else {
                return false;
            }
        }
        return Mustache.render($("#tool-execute").html(), dt);
    };
});