layui.config({
    base: './js/'
}).use(['layer', 'table', 'laytpl', 'code', 'util'], function () {
    var $ = layui.jquery,
        layer = layui.layer,
        table = layui.table,
        laytpl = layui.laytpl,
        util = layui.util;

    var height = $(".right-content").outerHeight() - $(".item-top").outerHeight();
    $.ajax({
        url: "http://192.168.2.55:8100/define/rest/model/" + processDefKey + "/workflows"
    }).done(function (data) {
        if (data) {
            var tablelns = table.render({
                elem: '#data-table',
                url: "http://192.168.2.55:8100/define/rest/model/" + processDefKey + "/process-instances?workflowVersion=" + data.workflows.length,
                skin: 'line',
                even: false,
                id: 'data-table',
                height: height,
                cellMinWidth: 100,
                page: false,
                // page: {
                //     count: 10,
                //     layout: ['prev', 'page', 'next', 'limit', 'skip', 'count'],
                //     theme: '#1890FF'
                // },
                limit: Number.MAX_VALUE,
                cols: [[
                    {title: '实例ID', field: 'id', align: 'center', hide: true},
                    {title: '流程ID', field: 'workflowId', align: 'center', hide: true},
                    {title: '流程名称', field: 'workflowName', align: 'center'},
                    {title: '流程版本', field: 'workflowVersion', align: 'center'},
                    {
                        title: '开始时间', field: 'startDate', align: 'center', templet: function (obj) {
                            return util.toDateString(Date.parse(obj.startDate), 'yyyy-MM-dd HH:mm:ss');
                        }
                    },
                    {
                        title: '结束时间', field: 'endDate', align: 'center', templet: function (obj) {
                            return util.toDateString(Date.parse(obj.endDate), 'yyyy-MM-dd HH:mm:ss');
                        }
                    },
                    {title: '实例状态', field: 'state', align: 'center'},
                    {title: 'hasActiveOperation', field: 'hasActiveOperation', hide: true}
                    // {title: '操作', field: 'tool', align: 'center', toolbar: '#bar'}
                ]], parseData: function (res) {
                    return {
                        msg: "",
                        code: 0,
                        count: res.totalCount,
                        data: res.workflowInstances
                    }
                }, done: function (res, curr, count) {
                    tablelns.resize();
                }
            });
        }
    });

    table.on('tool(data-table)', function (obj) {
        switch (obj.event) {
            case 'result':
                $.ajax({
                    url: "http://192.168.2.55:8100/define/api/workflow-instances/" + obj.data.id + "/variables"
                }).done(function (data) {
                    var haveResult = false;
                    $.each(data, function (index, value) {
                        if (value.name === "result") {
                            haveResult = true;
                            var gettpl = $("#resultCodeTemplet").html();
                            laytpl(gettpl).render(JSON.stringify(JSON.parse(value.value), null, 4), function (html) {
                                $('#resultCode').html(html);
                            });
                            layer.open({
                                type: 1,
                                title: "运行结果",
                                shadeClose: true,
                                area: ["800px"],
                                maxHeight: 400,
                                maxWidth: 1000,
                                maxmin: true,
                                content: $("#resultCode"),
                                success: function () {
                                    layui.code();
                                }
                            });
                        }
                    });
                    if (!haveResult) {
                        layer.msg("暂无结果");
                    }
                }).error(function (err) {
                    layer.msg("网络异常!")
                });
                break;
            default:
                break;
        }
    })
});