layui.use(["table", "layer", "form", "upload", "laytpl"], function () {
    // 启用模块
    var $ = layui.jquery,
        table = layui.table,
        layer = layui.layer,
        form = layui.form,
        upload = layui.upload,
        laytpl = layui.laytpl,
        formSelects = layui.formSelects;

    // 弹窗标识
    var addModelLayer,
        editModelLayer,
        execModelLayer;

    var paramdata,// 参数表缓存
        tablelns,//数据表
        tableparam;//参数表

    var modeltype = "bpm";

    // 辅助工具
    var tools = (function () {
        //根据字段名返回标签名
        function getLabelByName(name) {
            var obj = {
                "": "",
                "string": "字符串",
                "number": "数字",
                "file": "文件",
                "select": "选择框",
                "datasource": "数据源",
                "bpm": "BPM",
                "rm": "RM"
            };
            return obj[name];
        }

        // 返回随机字符串
        function randomNum(len) {
            len = len || 32;
            var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678';
            /****默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1****/
            var maxPos = $chars.length;
            var pwd = '';
            for (var i = 0; i < len; i++) {
                pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
            }
            return pwd;
        }

        // 根据模型类型判断
        function modelTypeChange(modelType) {
            if (modelType === "rm") {
                $('.rm-item').removeClass("layui-hide");
                if ($("[name=thumbImagePath]").val()) {
                    $(".thumb-img").attr("src", $("[name=thumbImagePath]").val());
                    $(".thumb").show();
                } else {
                    $(".thumb").hide();
                }
            } else if (modelType === "bpm") {
                $('#location').val("");
                $('.rm-item').addClass("layui-hide");
            } else {
                $('#location').val("");
                $('.rm-item').addClass("layui-hide");
            }
        }

        // 参数设置表验证
        function checkParams(paramdata) {
            var f = 0;
            // 验证是否存在空值
            for (var i = 0; i < paramdata.length; i++) {
                if (paramdata[i].name === "" || paramdata[i].label === "") {
                    f = 1;
                    break;
                }
            }
            // 验证是否有重复的字段名
            if (f === 0) {
                var namehash = {},
                    labelhash = {};
                for (var i in paramdata) {
                    if (namehash[paramdata[i].name]) {
                        f = 1;
                        break;
                    }
                    if (labelhash[paramdata[i].label]) {
                        f = 1;
                        break;
                    }
                    namehash[paramdata[i].name] = true;
                    labelhash[paramdata[i].label] = true;
                }
            }
            if (f === 0) {
                return true; // 符合要求
            } else {
                return false; // 存在问题
            }


        }

        function bindParams(elem, keyName) {
            var url = rootPath + "/common/get-dict?key=" + keyName;
            var formData;
            var renderData;
            $.ajax({
                url: url,
                async: false,
                success: function (result) {
                    formData = result;
                },
                error: function (e, state, error) {
                    console.log(e);
                },
            });
            if (formData) {
                renderData = formData["data"];
                if (!renderData || (!renderData["children"] || (renderData["children"].length === 0))) {
                    layer.msg("key值无效");
                    return;
                }
                renderData = formData["data"]["children"];
                for (var i = 0; i < renderData.length; i++) {
                    var dict = renderData[i];
                    dict["name"] = dict["title"];
                    dict["id"] = dict["value"];
                }
                if (!renderData) {
                    return;
                }
                var option = "";
                for (var i = 0; i < renderData.length; i++) {
                    option += "<option value=" + renderData[i].id + " {{#if(equals(d.type,'" + renderData[i].id + "')){}}selected{{#}}}>" + renderData[i].name + "</option>\n";
                }
                $(elem).html(option);
            } else {
                return;
            }
        }

        return {
            getLabelByName: getLabelByName, // 根据字段名返回标签名
            randomNum: randomNum, // 返回随机字符串
            modelTypeChange: modelTypeChange,
            checkParams: checkParams,
            bindParams: bindParams
        }
    })();

    renderElem();
    bindEvent();

    function renderElem() {
        formSelects.render('keywords');

        // 绑定参数类型字典表
        tools.bindParams('#type', 'dmmodel_param_type');

        // 绑定模型类型字典表
        helper.bindDict('#modelType', 'modelType');

        // 渲染数据表格
        var height = $(".right-content").outerHeight() - $(".item-top").outerHeight();
        tablelns = table.render({
            elem: "#data-table",
            title: "挖掘模型信息表",
            url: rootPath + "/rest/dmm/modeltype/page",
            skin: 'line',
            even: true,
            id: 'data-table',
            height: height,
            where: {
                modeltype: modeltype
            },
            page: {
                layout: ['prev', 'page', 'next', 'limit', 'skip'],
                theme: '#1890FF',
            },
            request: {
                pageName: "page",
                limitName: "size"
            },
            cols: [
                [
                    {type: 'checkbox'},
                    {title: 'ID', field: 'id', hide: true},
                    {title: "流程ID", field: 'processId', hide: true},
                    {title: "流程Key", field: 'processKey', hide: true},
                    {title: "名称", field: "name", minWidth: 100},
                    {title: "创建人", field: "createBy", minWidth: 100},
                    {
                        title: "模型类型", field: "modelType", minWidth: 150, templet: function (obj) {
                            return tools.getLabelByName(obj.modelType);
                        }
                    },
                    {title: "关键字", field: "keywords", minWidth: 150},
                    {title: "描述", field: "description", minWidth: 150},
                    {title: "创建时间", field: "createTime", minWidth: 180},
                    {title: "调度地址", field: "location", hide: true},
                    {title: "操作", field: 'tool', align: 'center', toolbar: "#bar", minWidth: 250}
                ]
            ]
        });

        //渲染参数表格
        tableparam = table.render({
            elem: "#param-table",
            title: "参数表",
            skin: 'line',
            even: true,
            toolbar: '#paramtoolbar',
            id: 'param-table',
            defaultToolbar: [],
            cols: [[
                {title: '字段名', field: 'name', edit: true},
                {title: '显示名称', field: 'label', edit: true},
                {title: '数据类型', field: 'type', templet: '#selectTool'},
                {title: '操作', field: 'tool', align: 'center', toolbar: '#parambar'}
            ]],
            done: function (res, curr, count) {
                paramdata = res.data;
            }
        });

        // 上传RM任务缩略图
        upload.render({
            elem: '#btn-uploadImg',
            url: rootPath + "/common/upload",
            before: function (obj) {
                obj.preview(function (index, file, result) {
                    $(".thumb-img").attr("src", result);
                    $(".thumb").show();
                });
            },
            done: function (res) {
                if (res.code > 0) {
                    return layer.msg('上传失败');
                }
                $("[name=thumbImagePath]").val(res.data.downUrl);
                $(".thumb-img").attr("src", res.data.downUrl);
            },
            error: function () {
                return layer.msg('上传失败');
            }
        });
    }

    function bindEvent() {
        // 点击新增模型打开弹窗
        $(document).on("click", "#addbtn", function () {
            editModelLayer = null;
            tools.modelTypeChange();
            $('#modelType').attr("disabled", false);
            addModelLayer = layer.open({
                type: 1,
                title: "新增模型",
                shadeClose: true,
                area: ["800px", "400px"],
                maxHeight: 400,
                maxWidth: 1000,
                content: $("#addform"),
                success: function () {
                    tableparam.reload({
                        cellMinWidth: 80,
                        data: [],
                        done: function () {
                            tableparam.resize();
                        }
                    });
                    $("#resetbtn").click();
                }
            });
        });

        // 删除选中模型
        $(document).on('click', '#deletebtn', function () {
            var checkStatus = table.checkStatus('data-table');
            var data = checkStatus.data;
            if (data.length > 0) {
                layer.confirm('确认删除选中项？', function (index) {
                    for (var i = 0; i < data.length; i++) {
                        if (data[i].modelType === "bpm") {
                            // $.ajax({
                            //     type: "DELETE",
                            //     url: rootPath + "/rest/process-models/delete/" + data[i].processId,
                            //     success: function () {
                            $.ajax({
                                type: "DELETE",
                                url: rootPath + "/rest/dmm/model/" + data[i].id,
                                success: function () {
                                    tablelns.reload();
                                },
                                error: function (err) {
                                    console.log(err);
                                }
                            });
                            // },
                            // error: function (err) {
                            //     console.log(err);
                            // }
                            // });
                        } else {
                            $.ajax({
                                type: "DELETE",
                                url: rootPath + "/rest/dmm/model/" + data[i].id,
                                success: function () {
                                    tablelns.reload();
                                },
                                error: function (err) {
                                    console.log(err);
                                }
                            });
                        }
                    }
                    layer.close(index);
                });
            } else {
                layer.msg('请选择需要删除的数据！');
            }
        });

        // 导出所选模型
        $(document).on('click', '#importbtn', function () {
            var checkStatus = table.checkStatus('data-table');
            var data = checkStatus.data;
            if (data.length > 0) {
                layer.confirm('确认导出选中项？', function (index) {
                    table.exportFile(tablelns.config.id, data, 'xls');
                    layer.close(index);
                });
            } else {
                layer.msg('请选择需要导出的数据！');
            }
        });

        // 搜索模型
        $(document).on('click', "#searchbtn", function () {
            tablelns.reload({
                page: {
                    curr: 1
                }
                , where: {
                    modeltype: modeltype,
                    keywords: $('#search-text').val()
                }
            })
        });

        // 监听reset，重置参数表
        $(document).on('click', 'button[type=reset]', function () {
            paramdata = [];
            tableparam.reload({
                data: paramdata,
                done: function () {
                    tableparam.resize();
                }
            })
        });

        // 切换modeltype筛选
        $(document).on('click', '#li-bpm', function () {
            if (modeltype === "bpm") {
                return;
            }
            $('#li-bpm').css('background-color', '#377BFE');
            $('#li-bpm').css('color', '#fff');
            $('#li-rm').css('background-color', '#d2d2d2');
            $('#li-rm').css('color', '#333');
            modeltype = "bpm";
            tablelns.reload({
                where: {
                    modeltype: modeltype
                }
            });
        });
        $(document).on('click', '#li-rm', function () {
            if (modeltype === "rm") {
                return;
            }
            $('#li-rm').css('background-color', '#377BFE');
            $('#li-rm').css('color', '#fff');
            $('#li-bpm').css('background-color', '#d2d2d2');
            $('#li-bpm').css('color', '#333');
            modeltype = "rm";
            tablelns.reload({
                where: {
                    modeltype: modeltype
                }
            });
        });

        form.verify({
            string: function (value, item) {
                var val = value.replace(/\s/g, '');
                if (!new RegExp("^[0-9a-zA-Z]+$").test(val)) {
                    return '只能填写字母或数字';
                }
            }
            , file: function (value, item) {
                if (item.innerHTML.trim() === '无文件') {
                    return '请上传文件';
                }
            }
        });

        // 新建或修改模型提交
        form.on("submit(submit)", function (data) {
            // 参数设置表验证
            if (tools.checkParams(paramdata)) {
                // 新增模型提交
                if (addModelLayer) {
                    var new_task = data.field;
                    new_task.createById = userId;
                    new_task.keywordsIndex = formSelects.value('keywords', 'valStr');
                    new_task.keywords = formSelects.value('keywords', 'nameStr');
                    new_task.paramJson = JSON.stringify(paramdata);
                    if (new_task.modelType === "bpm") {
                        var new_process = {
                            "id": "",
                            "name": new_task.name,
                            "description": new_task.description,
                            "modelCategoryKey": tools.getLabelByName(new_task.modelType),
                            "modelCategoryName": tools.getLabelByName(new_task.modelType),
                            "modelStatusKey": "activity",
                            "modelStatusName": "编辑",
                            "modelKey": tools.randomNum(16)
                        };
                        // 新建流程模型
                        // $.ajax({
                        //     type: "POST",
                        //     url: rootPath + "/rest/process-models/add?userId=" + new_task.createById,
                        //     contentType: "application/json",
                        //     data: JSON.stringify(new_process),
                        //     dataType: "json",
                        //     success: function (data) {
                        new_task.processKey = new_process.modelKey;
                        new_task.processId = data.id;
                        // 新建BPM模型记录
                        $.ajax({
                            type: "POST",
                            url: rootPath + "/rest/dmm/model",
                            contentType: "application/json",
                            data: JSON.stringify(new_task),
                            dataType: "json",
                            success: function () {
                                tablelns.reload({
                                    page: {
                                        curr: 1
                                    }
                                });
                                layer.close(addModelLayer);
                                addModelLayer = null;
                                layerOpenFull('http://192.168.2.101:18085/bpm-ui/modler/index.html#/editor/' + new_task.processId, '流程设计器');
                                layer.msg("创建成功");
                            },
                            error: function (err) {
                                layer.close(addModelLayer);
                                addModelLayer = null;
                                layer.msg("创建失败");
                                console.log(err);
                            }
                        });
                        //     }, error: function (err) {
                        //         layer.close(addModelLayer);
                        //         addModelLayer = null;
                        //         layer.msg("创建失败");
                        //         console.log(err);
                        //     }
                        // });
                    } else if (new_task.modelType === "rm") {
                        // 新建RM模型记录
                        $.ajax({
                            type: "POST",
                            url: rootPath + "/rest/dmm/model",
                            contentType: "application/json",
                            data: JSON.stringify(new_task),
                            dataType: "json",
                            success: function () {
                                tablelns.reload({
                                    page: {
                                        curr: 1
                                    }
                                });
                                layer.close(addModelLayer);
                                addModelLayer = null;
                                layer.msg("创建成功");
                            },
                            error: function (err) {
                                layer.close(addModelLayer);
                                addModelLayer = null;
                                layer.msg("创建失败");
                                console.log(err);
                            }
                        });
                    }
                }
                //修改模型提交
                if (editModelLayer) {
                    var edit_task = data.field;
                    edit_task.keywordsIndex = formSelects.value('keywords', 'valStr');
                    edit_task.keywords = formSelects.value('keywords', 'nameStr');
                    edit_task.paramJson = JSON.stringify(paramdata);
                    if (edit_task.modelType === "bpm") {
                        var edit_process = {
                            "description": edit_task.description,
                            "id": edit_task.processId,
                            "modelCategoryKey": tools.getLabelByName(edit_task.modelType),
                            "modelCategoryName": tools.getLabelByName(edit_task.modelType),
                            "modelKey": edit_task.processKey,
                            "modelStatusKey": "activity",
                            "modelStatusName": "编辑",
                            "name": edit_task.name
                        };

                        // $.ajax({
                        //     type: "PATCH",
                        //     url: rootPath + "/rest/process-models/update/1",
                        //     contentType: "application/json",
                        //     data: JSON.stringify(edit_process),
                        //     dataType: "json",
                        //     success: function () {
                        $.ajax({
                            type: "POST",
                            url: rootPath + "/rest/dmm/model",
                            contentType: "application/json",
                            data: JSON.stringify(edit_task),
                            dataType: "json",
                            success: function () {
                                tablelns.reload();
                                layer.close(editModelLayer);
                                editModelLayer = null;
                                layerOpenFull('http://192.168.2.55:8080/#/bpmn?theme=hide&id=' + edit_task.processId, '流程详细');
                                layer.msg("修改成功");
                            },
                            error: function (err) {
                                layer.close(editModelLayer);
                                editModelLayer = null;
                                layer.msg("修改失败");
                                console.log(err);
                            }
                        });
                        //     },
                        //     error: function (err) {
                        //         layer.close(editModelLayer);
                        //         editModelLayer = null;
                        //         layer.msg("修改失败");
                        //         console.log(err);
                        //     }
                        // });
                    } else if (edit_task.modelType === "rm") {
                        $.ajax({
                            type: "POST",
                            url: rootPath + "/rest/dmm/model",
                            contentType: "application/json",
                            data: JSON.stringify(edit_task),
                            dataType: "json",
                            success: function () {
                                tablelns.reload();
                                layer.close(editModelLayer);
                                editModelLayer = null;
                                layer.msg("修改成功");
                            },
                            error: function (err) {
                                layer.close(editModelLayer);
                                editModelLayer = null;
                                layer.msg("修改失败");
                                console.log(err);
                            }
                        });
                    }
                }
            } else {
                layer.msg("请确保参数设置正确！");
            }
            return false;
        });

        // 提交运行
        form.on('submit(run-submit)', function (data) {
            var res = data.field;
            var processDefKey = res.processDefKey;
            res.instanceId = "003148dd-aa80-42a3-bf1b-0caae4573094";
            // var processDefId = res.processDefId;
            delete res["processDefKey"];
            delete res["processDefId"];
            $.ajax({
                type: "POST",
                url: "http://192.168.90.33:8888/mso/workflow/process/" + processDefKey,
                // rootPath + "/rest/process-instances/createNewTaskAuto?"
                // + "processDefKey=" + processDefKey + "&processDefId=" + processDefId,
                contentType: "application/json",
                data: JSON.stringify(res),
                dataType: "json",
                success: function (data) {
                    layer.close(execModelLayer);
                    layer.msg("创建实例成功");
                },
                error: function (err) {
                    layer.close(execModelLayer);
                    layer.msg("创建实例失败");
                    console.log(err);
                }
            });
        });

        // 监听模型类别更改
        form.on('select(modelType)', function (data) {
            tools.modelTypeChange(data.value);
        });

        //监听参数类别更改
        form.on('select(type)', function (data) {
            var elem = data.othis.parents('tr');
            var dataindex = elem.attr('data-index');
            paramdata[dataindex].type = data.value;
        });

        // 监听模型表行工具栏事件
        table.on("tool(data-table)", function (obj) {
            switch (obj.event) {
                // 编辑模型
                case 'edit':
                    addModelLayer = null;
                    $('#modelType').attr("disabled", true);
                    editModelLayer = layer.open({
                        type: 1,
                        title: "编辑模型",
                        shadeClose: true,
                        area: ["800px", "400px"],
                        maxHeight: 400,
                        maxWidth: 1000,
                        content: $("#addform"),
                        success: function () {
                            if (obj.data.paramJson) {
                                paramdata = JSON.parse(obj.data.paramJson);
                            } else {
                                paramdata = [];
                            }
                            tableparam.reload({
                                data: paramdata,
                                done: function () {
                                    tableparam.resize();
                                }
                            });
                            var data = obj.data;
                            form.val("addform", data);
                            tools.modelTypeChange(data.modelType);
                            var keywordsIndexStr = data.keywordsIndex.split(",");
                            var keywordsIndex = keywordsIndexStr.map(Number);
                            formSelects.value('keywords', keywordsIndex, true);
                        }
                    });
                    break;
                // 删除模型
                case 'del':
                    layer.confirm(
                        "确定要删除吗？",
                        {
                            btn: ["确定", "取消"]
                        },
                        function (index) {
                            if (obj.data.modelType === "bpm") {
                                $.ajax({
                                    type: "DELETE",
                                    url: rootPath + "/rest/process-models/delete/" + obj.data.processId,
                                    success: function () {
                                        $.ajax({
                                            type: "DELETE",
                                            url: rootPath + "/rest/dmm/model/" + obj.data.id,
                                            success: function () {
                                                tablelns.reload();
                                                layer.close(index);
                                                layer.msg("删除成功");
                                            },
                                            error: function (err) {
                                                layer.close(index);
                                                layer.msg('删除失败');
                                                console.log(err);
                                            }
                                        });
                                    },
                                    error: function (err) {
                                        layer.close(index);
                                        layer.msg('删除失败');
                                        console.log(err);
                                    }
                                })
                            } else if (obj.data.modelType === "rm") {
                                $.ajax({
                                    type: "DELETE",
                                    url: rootPath + "/rest/dmm/model/" + obj.data.id,
                                    success: function () {
                                        tablelns.reload();
                                        layer.close(index);
                                        layer.msg("删除成功");
                                    },
                                    error: function (err) {
                                        layer.close(index);
                                        layer.msg('删除失败');
                                        console.log(err);
                                    }
                                });
                            }
                        }
                    );
                    break;
                // 查看任务实例
                case 'view-task':
                    // 类型为RM
                    if (obj.data.modelType === "rm") {
                        location.href = rootPath + "/dm/model/rapid/jobs?id=" + obj.data.id;
                    }
                    // 类型为BPM
                    else if (obj.data.modelType === "bpm") {
                        location.href = rootPath + "/dm/model/process/task?processDefKey=" + obj.data.processKey;
                    }
                    break;
                // 查看流程图，流程设计器 查看缩略图
                case 'view':
                    if (obj.data.modelType === "bpm") {
                        layerOpenFull('http://192.168.2.55:8080/#/bpmn?theme=hide&id=' + obj.data.processId, '流程详细');
                        // layerOpenFull('http://192.168.2.101:18085/bpm-ui/modler/index.html#/editor/' + obj.data.processId, '流程详细');
                    } else if (obj.data.modelType === "rm") {
                        layerImage(obj.data.thumbImagePath);
                        // layerOpenFull(obj.data.thumbImagePath, '缩略图');
                    }
                    break;
                // 执行模型，创建实例
                case 'run':
                    if (obj.data.modelType === "bpm") {
                        // layerConfirm("是否确定要执行？", function () {
                        var gettpl = $("#templet-execute").html();
                        laytpl(gettpl).render(obj.data, function (html) {
                            $('#tool-execute').html(html);
                        });

                        execModelLayer = layer.open({
                            type: 1,
                            title: "运行模型",
                            shadeClose: true,
                            area: ["800px"],
                            maxHeight: 400,
                            maxWidth: 1000,
                            maxmin: true,
                            content: $("#tool-execute"),
                            success: function () {
                                form.val('tool-execute-form', {
                                    processDefKey: obj.data.processKey
                                    // processDefId: obj.data.processId
                                });
                                var params = JSON.parse(obj.data.paramJson);
                                for (var i = 0; i < params.length; i++) {
                                    if (params[i].type === 'file') {
                                        var btn_id = "#btn-upload" + params[i].name;
                                        var filename_id = "#filename-" + params[i].name;
                                        var filepath_id = "#filepath-" + params[i].name;
                                        upload.render({
                                            elem: btn_id,
                                            url: parseGeoFileUrl,
                                            accept: 'file',
                                            done: function (res) {
                                                // if (res.code > 0) {
                                                //     return layer.msg('上传失败');
                                                // }
                                                $(filename_id).html('已上传');
                                                $(filepath_id).val(JSON.stringify(res.value));
                                            },
                                            error: function () {
                                                return layer.msg('上传失败');
                                            }
                                        });
                                    }
                                }
                            }
                        });
                        // });
                    } else if (obj.data.modelType === "rm") {
                        layerOpenFull(rootPath + '/kjkf/jt?id=' + obj.data.id, '执行');
                    }
                    break;
                default:
                    break;
            }
        });

        //监听参数表头工具栏事件
        table.on("toolbar(param-table)", function (obj) {
            if (obj.event === 'paramadd') {
                // 增加参数
                paramdata.push({
                    "name": "",
                    "label": "",
                    "type": "string"
                });
                tableparam.reload({
                    data: paramdata
                });
            }
        });

        //监听参数表行工具栏事件
        table.on("tool(param-table)", function (obj) {
            if (obj.event === 'paramdel') {
                // 删除参数
                var dataindex = obj.tr.selector.match(/data-index="(\S*)"]/)[1];
                paramdata.splice(dataindex, 1);
                tableparam.reload({
                    data: paramdata
                });
            }
        });

        $(document).on("mousewheel DOMMouseScroll", ".layui-layer-phimg img", function (e) {
            var delta = (e.originalEvent.wheelDelta && (e.originalEvent.wheelDelta > 0 ? 1 : -1)) || // chrome & ie
                (e.originalEvent.detail && (e.originalEvent.detail > 0 ? -1 : 1)); // firefox
            var imagep = $(".layui-layer-phimg").parent().parent();
            var image = $(".layui-layer-phimg").parent();
            var h = image.height();
            var w = image.width();
            if (delta > 0) {
                h = h * 1.05;
                w = w * 1.05;
            } else if (delta < 0) {
                if (h > 100) {
                    h = h * 0.95;
                    w = w * 0.95;
                }
            }
            // imagep.css("top", (window.innerHeight - h) / 2);
            // imagep.css("left", (window.innerWidth - w) / 2);
            image.height(h);
            image.width(w);
            imagep.height(h);
            imagep.width(w);
        });
    }
});
