layui.config({
    base: './js/'
}).use(['moduleAuthority', 'layer', 'upload', 'form', 'table'], function () {
    var $ = layui.jquery, table = layui.table, layer = layui.layer, upload = layui.upload, form = layui.form,
        formSelects = layui.formSelects;

    var layerIndex_tools,        //添加/编辑工具弹出层的索引
        layerIndex_wait,            //等待弹出层的索引
        paramTableIns,          //参数表格的实例
        params = [];    //用于记录新增或编辑时的参数信息

    var currentTool,            //用于记录用户执行工具的名称
        currentToolId,          //用于记录用户执行工具的id
        currentUrl,             //用于记录用户执行工具的url
        currentToolType,        //用于记录用户执行工具的toolType
        choosefile = {},         //用于存储用户选择的工具中的文件数据源
        currentfilename;        //用于记录当前用户选择文件所属的参数名称

    init();

    /**
     * 初始化
     */
    function init() {
        bindUploadImg();
        bindParamsTable();
        bindEvent();
    }

    /**
     * 绑定上传图片
     */
    function bindUploadImg() {
        upload.render({
            elem: '#btn-uploadImg',
            url: rootPath + "/common/upload",
            done: function (res) {
                if (res.code > 0) {
                    return layer.msg("上传失败");
                }
                $('[name=thumbImagePath]').val(res.data.downUrl);
                $('#img-uploadImg').attr("src", res.data.downUrl);
            },
            error: function () {
                return layer.msg('上传失败');
            }
        });
        upload.render({
            elem: '#btn-uploadTopImg',
            url: rootPath + "/common/upload",
            done: function (res) {
                if (res.code > 0) {
                    return layer.msg('上传失败');
                }
                $("[name=topImagePath]").val(res.data.downUrl);
                $("#img-uploadTopImg").attr("src", res.data.downUrl);
            },
            error: function () {
                return layer.msg('上传失败');
            }
        });
    }

    /**
     * 绑定工具弹出层的参数表
     */
    function bindParamsTable() {
        paramTableIns = table.render({
            elem: '#table-params',
            toolbar: '#toolbar-addparams',
            defaultToolbar: [],
            id: 'table-params',
            data: params,
            limit: 100,
            text: {none: "无参数"},
            cols: [[
                {
                    field: 'name', title: '参数名称', align: 'center', width: 130, edit: 'text', templet: function (obj) {
                        return obj.name;
                    }
                },
                {
                    field: 'label', title: '显示名称', align: 'center', width: 135, edit: 'text', templet: function (obj) {
                        return obj.label;
                    }
                },
                {field: 'type', title: '数据类型', width: 160, align: 'center', templet: '#params-select-type'},
                {
                    field: 'dict', title: '数据类型配置', width: 160, align: 'center', edit: 'text', templet: function (obj) {
                        if (obj.type != "datasource") {
                            return obj.dict;
                        } else {
                            return "";
                        }
                    }
                },
                {field: 'operation', title: '操作', width: 60, toolbar: '#bar-delete', align: 'center'}
            ]],
            done: function (res, curr, count) {
                var dataTemp = table.cache[this.id];
                var tableElem = this.elem.next();
                layui.each(dataTemp, function (index, data) {
                    var typeElem = tableElem.find('tr[data-index="' + index + '"]').find('td[data-field="type"]').find('div.layui-table-cell')[0];
                    if (typeElem) {
                        typeElem.style.padding = "0";
                        var type = params[index].type;
                        typeElem.children[0].value = type;
                        if (type == "datasource") {
                            var sourceElem = tableElem.find('tr[data-index="' + index + '"]').find('td[data-field="dict"]').removeAttr('data-edit').find('div.layui-table-cell')[0];
                            sourceElem.style.padding = "0";
                            $($('#datasource-type').html()).appendTo(sourceElem);
                            if (params[index].analysis_data) {
                                var analysis_data = params[index].analysis_data;
                                sourceElem.children[0].value = analysis_data;
                            }
                        }
                        else if (type != "select") {
                            var sourceElem = tableElem.find('tr[data-index="' + index + '"]').find('td[data-field="dict"]').removeAttr('data-edit');
                        }
                    }
                });
                form.render('select');
                table.resize('table-params');
            }
        });
    }

    /**
     * 绑定监听事件
     */
    function bindEvent() {
        /**
         * 新增工具弹出层
         */
        $('#btn-addtool').click(function (evt) {
            $('#form-params')[0].reset();
            params = [];
            paramTableIns.reload({data: params});
            showLayer("add-params");
        });
        /**
         * 新增参数
         */
        table.on('toolbar(table-params)', function (obj) {
            if ("addparam" == obj.event) {
                if (params.length == obj.config.data.length) {
                    params.push({name: "", label: "", type: "string", dict: ""});
                    paramTableIns.reload({data: params});
                }
            }
        });
        /**
         * 编辑参数时保存编辑值
         */
        table.on('edit(table-params)', function (obj) {
            params = table.cache['table-params'];
        });
        /**
         * 删除参数
         */
        table.on('tool(table-params)', function (obj) {
            if (obj.event == "del") {
                var index = obj.tr[0].attributes[0].value;
                params.splice(index, 1);
                paramTableIns.reload({data: params});
            }
        });
        /**
         * 选择参数类型时保存选择的值
         */
        form.on('select(param-type)', function (obj) {
            var select = obj.elem;
            var tr = select.parentElement.parentElement.parentElement;
            params[tr.attributes[0].nodeValue].type = obj.value;
            paramTableIns.reload({data: params});
        });
        /**
         * 提交数据，生成工具
         */
        form.on('submit(btn-params-submit)', function (obj) {
            for (var i = 0; i < params.length; i++) {
                if (params[i].name == "" || params[i].label == "") {
                    layer.msg("请将参数名称和显示名称填写完整！");
                    return false;
                }
            }
            var data = obj.field;
            data.id=currentToolId;
            data.paramJson = JSON.stringify(params);
            saveTool(data);
            layer.close(layerIndex_tools);
            return false;
        });
        /**
         * 选择数据源类型时保存选择的值
         */
        form.on('select(datasource-type)', function (obj) {
            var select = obj.elem;
            var tr = select.parentElement.parentElement.parentElement;
            params[tr.attributes[0].nodeValue].analysis_data = obj.value;
            paramTableIns.reload({data: params});
        });
        /**
         * 重置时将表格清空
         */
        $('#btn-params-reset').click(function (obj) {
            params = [];
            paramTableIns.reload({data: params});
        });
        /**
         * 编辑工具属性，弹出层
         */
        $('.btn-edit').click(function (evt) {
            var toolId = $(evt.currentTarget).attr("tool-id");
            currentToolId=toolId;
            var formData = getToolParams(toolId);
            params = JSON.parse(formData.paramJson);
            form.val('form-params', formData);
            $('#img-uploadImg').attr("src", formData.thumbImagePath);
            $('#img-uploadTopImg').attr("src", formData.topImagePath);
            paramTableIns.reload({data: params});
            table.resize('table-params');
            showLayer("edit-params");
        });
        /**
         * 删除工具
         */
        $('.btn-delete').click(function (evt) {
            var toolId = $(evt.currentTarget).attr("tool-id");
            layer.confirm("此操作将永久删除该工具！", function (index) {
                deleteTool(toolId);
                layer.close(index);
            });
        });
        /**
         * 执行工具
         */
        $('.btn-view').click(function (evt) {
            var toolId = $(evt.currentTarget).attr("tool-id");
            clickCard(toolId);
        });
        $('.img-container').click(function (evt) {
            var toolId = $(evt.currentTarget).attr("tool-id");
            clickCard(toolId);
        })
        /**
         * 根据数据源的选择展示不同的控件
         */
        form.on('select(datasource)', function (obj) {
            var value = obj.value;
            var id = obj.elem.id;
            if (value == "shp") {
                $('#div-json-' + id).css("display", "none");
                $('#div-shp-' + id).css("display", "block");
                $('#div-store-' + id).css("display", "none");
            }
            else if (value == "geojson") {
                $('#div-json-' + id).css("display", "block");
                $('#div-shp-' + id).css("display", "none");
                $('#div-store-' + id).css("display", "none");
            }
            else if (value == "tablesinfo") {
                $('#div-json-' + id).css("display", "none");
                $('#div-shp-' + id).css("display", "none");
                $('#div-store-' + id).css("display", "block");
            }
        });
        /**
         * 使用name来标识shp文件
         */
        $(document).on('click', '.btn-shp', function (evt) {
            currentfilename = $(this)[0].name;
        });
        /**
         * 处理用户输入的数据，传至后台执行
         */
        form.on('submit(btn-tool-execute)', function (obj) {
            var data = obj.field;
            var executeData = [];
            for (var i = 0; i < params.length; i++) {
                var paramName = params[i].name;
                if (params[i].type != "datasource") {
                    var paramValue = data[paramName];
                    executeData.push({"name": paramName, "value": paramValue});
                }
                else {
                    var inputType = data[paramName + "-type"];
                    var paramValue = "";
                    if (inputType == "geojson") {
                        paramValue = data[paramName + "-json"];
                    }
                    else if (inputType == "tablesinfo") {
                        paramValue = data[paramName + "-table"];
                    }
                    executeData.push({
                        "name": paramName,
                        "value": paramValue,
                        "analysis_data": params[i].analysis_data,
                        "source_type": inputType
                    });
                }
            }
            executeRequest(currentUrl, executeData, currentToolType, choosefile, data["saveName"]);
            return false;
        })
    }

    /**
     * 弹出层
     * @param evt
     * @param data
     */
    function showLayer(evt, data) {
        var config = {
            shadeClose: true,
            type: 1,
            area: ['700px', '500px'],
        }
        if (evt == "add-params") {
            config.title = "添加工具";
            config.content = $('#div-params');
        }
        else if (evt == "edit-params") {
            config.title = "编辑工具";
            config.content = $('#div-params');
        }
        else if (evt == "execute") {
            config.title = "执行";
            config.content = data;
        }
        layerIndex_tools = layer.open(config);
    };

    /**
     * 将工具的数据保存到数据库中
     * @param data
     */
    function saveTool(data) {
        $.ajax({
            type: 'POST',
            url: rootPath + '/rest/dm/tool/save',
            data: data,
            beforeSend: function () {
                layerIndex_wait = helper.showLoad("正在保存工具...");
            },
            success: function (obj) {
                helper.closeLoad(layerIndex_wait);
                layer.msg('保存成功！');
                window.location.reload();
            },
            error: function (e, state, errorThrown) {
                helper.closeLoad(layerIndex_wait);
                layer.msg('保存失败！');
                console.log(e);
            }
        });
    };

    /**
     * 获取工具的信息
     * @param id 工具id
     * @returns {*}
     */
    function getToolParams(id) {
        var result = null;
        $.ajax({
            url: rootPath + "/rest/dm/tool/find/" + id,
            async: false,
            success: function (obj) {
                result = obj.data;
            }
        });
        return result;
    };

    /**
     * 根据工具id删除工具
     * @param id
     */
    function deleteTool(id) {
        $.ajax({
            url: rootPath + "/rest/dm/tool/delete/" + toolId,
            type: "GET",
            success: function (evt) {
                layer.msg('删除成功');
                window.location.reload();
            }
        });
    };

    /**
     * 根据参数配置HTML表单
     * @param data
     * @returns {*}
     */
    function createExecuteHtml(data) {
        var mustacheHtml = {};
        mustacheHtml.params = data;
        mustacheHtml.isSelect = function () {
            return this.type == "select" ? true : false;
        }
        mustacheHtml.isDataSource = function () {
            return this.type == "datasource" ? true : false;
        }
        return Mustache.render($("#tool-execute").html(), mustacheHtml);
    };

    /**
     * 数据源：获取已注册表
     */
    function bindRegisterTable() {
        $.ajax({
            type: 'GET',
            url: '/tablesinfo/search?page=1&limit=100&keyword=&moduleCode=ccglzy',
            beforeSend: function () {
                layerIndex_wait = helper.showLoad("正在拉取表单...");
            },
            success: function (obj) {
                helper.closeLoad(layerIndex_wait);
                if (obj.data) {
                    var data = obj.data;
                    var option;
                    if (data.length != 0) {
                        for (var i = 0; i < data.length; i++) {
                            option += "<option value=\"" + data[i].id + "\">" + data[i].layerName + "</option>";
                        }
                        $('.select-tablestore').html(option);
                        form.render('select');
                    }
                }
            },
            error: function (e, state, error) {
                console.log(e);
            },
        })
    };

    /**
     * 调用ajax执行
     * @param url
     * @param data
     * @param tooltype
     * @param files
     * @param saveName
     */
    function executeRequest(url, data, tooltype, files, saveName) {
        var formData = new FormData();
        formData.append("url", url);
        formData.append("paramJson", JSON.stringify(data));
        formData.append("tooltype", tooltype);
        formData.append("saveName", saveName);
        var fileJson = {};
        $.each(files, function (key, value) {
            fileJson[key] = value.name;
            formData.append("file", value);
        });
        formData.append("fileJson", JSON.stringify(fileJson));
        $.ajax({
            url: "/dm/tool/execute",
            type: "POST",
            contentType: false,
            processData: false,
            data: formData,
            beforeSend: function () {
                layerIndex_wait = helper.showLoad("正在执行中...");
            },
            success: function (result) {
                helper.closeLoad(layerIndex_wait);
                if (result.code == 0) {
                    layer.msg("执行成功,结果已保存！");
                    saveToolResult("success");
                }
                else {
                    layer.msg("执行失败！");
                    saveToolResult("fail");
                }
                layer.close(layerIndex_tools);
            },
            error: function (e, state, error) {
                layer.msg("执行失败！");
                saveToolResult("fail");
                console.log(e);
                layer.close(layerIndex_tools);
            },
        });

    };

    /**
     * 点击卡片
     * @param id
     */
    function clickCard(id) {
        currentToolId = id;
        var formData = getToolParams(id);
        params = JSON.parse(formData.paramJson);
        currentUrl = formData.url;
        currentTool = formData.name;
        currentToolType = formData.toolType;
        var executeHtml = createExecuteHtml(params);
        showLayer("execute", executeHtml);
        if ($("[dict-name]").length > 0) {
            $("[dict-name]").each(function () {
                helper.bindDict(this, $(this).attr("dict-name"));
            });
            form.render("select");
        }
        if ($('#datasource-filter').length > 0) {
            bindRegisterTable();
        }
        if ($('.btn-shp').length > 0) {
            upload.render({
                elem: '.btn-shp',
                url: "/dm/tool/execute",
                accept: 'file',
                exts: 'zip',
                auto: false,
                choose: function (obj) {
                    obj.preview(function (index, file, result) {
                        choosefile[currentfilename.toString()] = file;
                        delete file[index];
                    })
                },
            })
        }
    };

    /**
     * 动态图闪烁
     */
    setInterval(function () {
        $(".top").fadeToggle("slow")
    }, 1500);


    function saveToolResult(msg) {
        $.ajax({
            type: 'POST',
            url: '/rest/result/save',
            data: {
                "toolId": currentToolId,
                "toolName": currentTool,
                "state":msg,
            }
        })
    }
})