layui.config({base:'./js/'}).use(['table'],function () {
    var table=layui.table;

    var height=$(".right-content").outerHeight();
    var tableIns=table.render({
        elem:'#data-table',
        url:'/rest/result/list',
        request:{
            pageName:'page',
            limitName:'size'
        },
        height:height,
        skin: 'line',
        even: true,
        page:{
            limit:10,
            layout:['prev', 'page', 'next', 'limit', 'skip'],
            theme: '#1890FF',
        },
        cols:[[
            {field:'user',title:'用户',align: 'center',templet:function (obj) {
                    return obj.createBy;
                }},
            {field:'tool',title:"执行工具名称",align:'center',templet:function (obj) {
                    return obj.toolName;
                }},
            {field:'date',title:'执行时间',align:'center',templet:function (obj) {
                    return obj.createTime;
                }},
            {field:'date',title:'执行状态',align:'center',templet:function (obj) {
                    return helper.showState(obj.state);
                }}
        ]],
        done:function (res, curr, count) {
            table.resize('data-table');
        }
    });
})