initElem();
bindEvents();

function initElem() {
    initChart1();
    // initChart2();
    initChart3();
    // initChart4();

    $.getJSON(rootPath + '/yzylog/access-stats', function (res) {
        $('#total-access').html(res.total);
    });

    var time = new Date().getTime();
    $.getJSON(rootPath + '/yzylog/hot?start=' + (time - 604800000) + '&end=' + time, function (res) {
        $.each(res.data, function (index, value) {
            $('#hot-resource').append(
                '<p><span class="list-text" data-id="' + value.key + '">' + value.value + '</span></p>'
            );
        });
    });

    // 最新资源
    $.getJSON(rootPath + '/yzy/query/latest?limit=10', function (res) {
        $('#total-resource').html(res.count);
        res.data.forEach(function (data) {
            $('#new-resource').append(
                '<p><span class="list-text" data-id="' + data.id + '">' + data.title + '</span><span class="date">' + data.createAt.split(' ')[0] + '</span></p>'
            );
        })
    });

    // 资源注册量
    function initChart1() {
        var myChart = echarts.init($('#zy-echart1')[0]);
        $.getJSON(rootPath + '/v2/catalog/sourcesCount', function (res) {
            var legend = [], data = [];
            for (var val in res) {
                legend.push(val);
                data.push({
                    name: val,
                    value: res[val]
                })
            }
            var option = {
                color: [
                    '#2980b9',
                    '#f39c12',
                    '#f1c40f',
                    '#2ecc71',
                    '#1abc9c',
                    '#3498db'
                ],
                tooltip: {
                    trigger: 'item',
                    formatter: "{a} <br/>{b}: {c} ({d}%)",
                    textStyle: {
                        align: 'left'
                    }
                },
                legend: {
                    orient: 'vertical',
                    x: 'left',
                    data: legend
                },
                series: [
                    {
                        name: '资源注册量',
                        type: 'pie',
                        radius: ['50%', '70%'],
                        avoidLabelOverlap: false,
                        label: {
                            normal: {
                                show: false,
                                position: 'center'
                            },
                            emphasis: {
                                show: true,
                                textStyle: {
                                    fontSize: '30',
                                    fontWeight: 'bold'
                                }
                            }
                        },
                        labelLine: {
                            normal: {
                                show: false
                            }
                        },
                        data: data
                    }
                ]
            };
            if (option && typeof option === "object") {
                myChart.setOption(option, true);
            }
        });
    }

    function initChart2() {
        var myChart = echarts.init($('#zy-echart2')[0]);
        var option = {
            title: {},
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'cross',
                    label: {
                        backgroundColor: '#6a7985'
                    }
                },
                textStyle: {
                    align: 'left'
                }
            },
            legend: {
                data: ['多时期矢量', '多时相影像', '三维模型', '地理实体', '地名地址']
            },
            // toolbox: {
            //     feature: {
            //         saveAsImage: {}
            //     }
            // },
            grid: {
                left: '3%',
                right: '4%',
                bottom: '3%',
                containLabel: true
            },
            xAxis: [
                {
                    type: 'category',
                    boundaryGap: false,
                    data: ['周一', '周二', '周三', '周四', '周五', '周六', '周日']
                }
            ],
            yAxis: [
                {
                    type: 'value'
                }
            ],
            series: [
                {
                    name: '多时期矢量',
                    type: 'line',
                    stack: '总量',
                    areaStyle: {},
                    data: [120, 132, 101, 134, 90, 230, 210]
                },
                {
                    name: '多时相影像',
                    type: 'line',
                    stack: '总量',
                    areaStyle: {},
                    data: [220, 182, 191, 234, 290, 330, 310]
                },
                {
                    name: '三维模型',
                    type: 'line',
                    stack: '总量',
                    areaStyle: {},
                    data: [150, 232, 201, 154, 190, 330, 410]
                },
                {
                    name: '地理实体',
                    type: 'line',
                    stack: '总量',
                    areaStyle: {normal: {}},
                    data: [320, 332, 301, 334, 390, 330, 320]
                },
                {
                    name: '地名地址',
                    type: 'line',
                    stack: '总量',
                    label: {
                        normal: {
                            show: true,
                            position: 'top'
                        }
                    },
                    areaStyle: {normal: {}},
                    data: [820, 932, 901, 934, 1290, 1330, 1320]
                }
            ]
        };
        if (option && typeof option === "object") {
            myChart.setOption(option, true);
        }
    }

    function initChart3() {
        var myChart = echarts.init($('#zy-echart3')[0]);
        var now = new Date();
        var end = now.getTime();
        now.setDate(now.getDate() - 7);
        var start = now.getTime();
        $.getJSON(rootPath + '/yzylog/getHotResourcePercent?start=' + start + '&end=' + end, function (res) {
            var legend = [], data = [];
            for (var val in res) {
                legend.push(val);
                data.push({
                    name: val,
                    value: res[val]
                })
            }
            var option = {
                color: [
                    '#2980b9',
                    '#f39c12',
                    '#f1c40f',
                    '#2ecc71',
                    '#1abc9c',
                    '#3498db'
                ],
                title: {
                    text: '',
                    subtext: '',
                    x: 'center'
                },
                tooltip: {
                    trigger: 'item',
                    formatter: "{a} <br/>{b} : {c} ({d}%)",
                    textStyle: {
                        align: 'left'
                    }
                },
                legend: {
                    orient: 'vertical',
                    left: 'left',
                    data: legend
                },
                series: [
                    {
                        name: '资源访问量',
                        type: 'pie',
                        radius: '55%',
                        center: ['50%', '60%'],
                        data: data,
                        itemStyle: {
                            emphasis: {
                                shadowBlur: 10,
                                shadowOffsetX: 0,
                                shadowColor: 'rgba(0, 0, 0, 0.5)'
                            }
                        }
                    }
                ]
            };
            if (option && typeof option === "object") {
                myChart.setOption(option, true);
            }
        });
    }

    function initChart4() {
        var myChart = echarts.init($('#zy-echart4')[0]);
        var option = {
            tooltip: {
                trigger: 'axis',
                axisPointer: {            // 坐标轴指示器，坐标轴触发有效
                    type: 'shadow'        // 默认为直线，可选为：'line' | 'shadow'
                },
                textStyle: {
                    align: 'left'
                }
            },
            legend: {
                data: ['多时期矢量', '多时相影像', '三维模型', '地理实体', '地名地址']
            },
            grid: {
                left: '3%',
                right: '4%',
                bottom: '3%',
                containLabel: true
            },
            xAxis: {
                type: 'value'
            },
            yAxis: {
                type: 'category',
                data: ['周一', '周二', '周三', '周四', '周五', '周六', '周日']
            },
            series: [
                {
                    name: '多时期矢量',
                    type: 'bar',
                    stack: '总量',
                    label: {
                        normal: {
                            show: true,
                            position: 'insideRight'
                        }
                    },
                    data: [320, 302, 301, 334, 390, 330, 320]
                },
                {
                    name: '多时相影像',
                    type: 'bar',
                    stack: '总量',
                    label: {
                        normal: {
                            show: true,
                            position: 'insideRight'
                        }
                    },
                    data: [120, 132, 101, 134, 90, 230, 210]
                },
                {
                    name: '三维模型',
                    type: 'bar',
                    stack: '总量',
                    label: {
                        normal: {
                            show: true,
                            position: 'insideRight'
                        }
                    },
                    data: [220, 182, 191, 234, 290, 330, 310]
                },
                {
                    name: '地理实体',
                    type: 'bar',
                    stack: '总量',
                    label: {
                        normal: {
                            show: true,
                            position: 'insideRight'
                        }
                    },
                    data: [150, 212, 201, 154, 190, 330, 410]
                },
                {
                    name: '地名地址',
                    type: 'bar',
                    stack: '总量',
                    label: {
                        normal: {
                            show: true,
                            position: 'insideRight'
                        }
                    },
                    data: [820, 832, 901, 934, 1290, 1330, 1320]
                }
            ]
        };
        if (option && typeof option === "object") {
            myChart.setOption(option, true);
        }
    }
}

function bindEvents() {
    $(document).on('click', '.list-text', function () {
        window.open(rootPath + '/yzy/yzyxq?id=' + $(this).attr('data-id'), '_blank');
    });
}