layui.config({
    base: 'js/',
}).use(['element', 'layer', 'jquery', 'form', 'laydate', 'upload'], function () {
    var element = layui.element,
        $ = layui.$,
        form = layui.form,
        layer = layui.layer,
        laydate = layui.laydate,
        upload = layui.upload,
        formSelects = layui.formSelects;

    var icon = "", iconSrc = "";
    var result = {"form1": {}, "form2": {}, "form3": {}, "form4": {}};

    var tools = (function () {
        function resizeFormContent() {
            var width = $(window).width() - $('.form-nav').width() - 200;
            $('.from-content').css("width", width + "px");
            $('#icon-upload').css("height", $('#icon-upload').width());
        }

        return {
            resizeFormContent: resizeFormContent
        }
    })();

    initElem();
    bindEvents();

    function initElem() {
        //日期
        laydate.render({
            elem: '#datestart'
        });
        laydate.render({
            elem: '#dateend'
        });
        laydate.render({
            elem: '#datefb'
        });

        //界面赋初始值
        if (seriveId != '') {
            initValue(seriveId);
        }

        function initValue(id) {
        }

        //普通图片上传
        upload.render({
            elem: '#icon-upload',
            url: rootPath + '/common/upload',
            before: function (obj) {
                //预读本地文件示例，不支持ie8
                obj.preview(function (index, file, result) {
                    $('#icon-preview').attr('src', result); //图片链接（base64）
                });
            },
            done: function (res) {
                //如果上传失败
                if (res.code > 0) {
                    if (iconSrc !== "") {
                        $('#icon-preview').attr('src', iconSrc);
                    } else {
                        $('#icon-preview').attr('src', "");
                    }
                    return layer.msg('上传失败');
                }
                //上传成功
                icon = res.data.id;
                iconSrc = res.data.downUrl;
                $('#icon-preview').attr('src', res.data.downUrl);
                $('input[name=iconDefault]').attr('checked', false);
                form.render();
                layer.msg("上传成功");
            },
            error: function () {
                //演示失败状态，并实现重传
                if (iconSrc !== "") {
                    $('#icon-preview').attr('src', iconSrc);
                } else {
                    $('#icon-preview').attr('src', "");
                }
                layer.msg("上传失败");
            },
            progress: function (n) {
                if (n > 0 && n < 100) {
                    $('.layui-progress').show();
                } else {
                    $('.layui-progress').hide();
                }
                var percent = n + '%';
                element.progress('icon-upload-progress', percent);
            }
        });

        // // 展示目录
        // $.ajax({
        //     url: '/zydict/findDefaultDicts',
        //     data: {type: "catalogService"},
        //     type: 'GET',
        //     dataType: 'json',
        //     success: function (data) {
        //         $.each(data, function (index, item) {
        //             if (item.title != "资源中心")
        //                 $('#zsmk').append(new Option(item.title, item.id));//往下拉菜单里添加元素
        //         });
        //
        //         form.render();//菜单渲染 把内容加载进去
        //     }
        // });

        // 空间参考
        $.ajax({
            url: '/yzy/query/getSpatialCoverageRefList',
            data: {},
            type: 'GET',
            dataType: 'json',
            success: function (data) {
                $.each(data, function (index, item) {
                    $('#kjck').append(new Option(item.description, item.wkid));//往下拉菜单里添加元素
                });

                form.render();//菜单渲染 把内容加载进去
            }
        });

        // 资源目录
        formSelects.data('selectzyml', 'server', {
            url: '/v2/catalog/getAllCatalogRESC',
            linkage: true
        });

        // 行政机构
        formSelects.data('selectxzjg', 'server', {
            url: '/v2/catalog/getAllCatalogXZJG',
            linkage: true
        });

        // 关键词
        formSelects.data('keywords', 'server', {
            url: "/yzy/query/findAllKeyword"
        });
    }

    function bindEvents() {
        // 改变展示类型
        form.on('select(zsmk)', function (data) {
            $.ajax({
                url: '/v2/catalog/findDefaultCatalog',
                data: {dicId: $('#zsmk option:selected').val()},
                type: 'GET',
                dataType: 'json',
                success: function (data) {
                    $("#zslx").empty();
                    $('#zslx').append(new Option("请选择展示类型", ""));//往下拉菜单里添加元素
                    $.each(data, function (index, item) {
                        $('#zslx').append(new Option(item.title, item.type));//往下拉菜单里添加元素
                    })
                    form.render();//菜单渲染 把内容加载进去
                }
            });
        });

        // 改变展示目录
        form.on('select(zslx)', function (data) {
            $.ajax({
                url: '/v2/catalog/getAllCatalog',
                data: {type: $('#zslx option:selected').val()},
                type: 'GET',
                dataType: 'json',
                // Ajax 成功执行时的回调函数；
                // 回调函数的参数即为服务端返回的数据
                success: function (json) {

                    formSelects.data('selectzsml', 'local', {
                        arr: json,
                        linkage: true
                    });
                },

                // 如果 Ajax 执行失败；
                // 将返回原始错误信息以及状态码
                // 传入这个回调函数中
                error: function (xhr, status) {
                    console.log('Sorry, can not get ZSML');
                },
            });
        });

        // 下一步功能
        form.on('submit(submit_one)', function (data) {
            result.form1 = data.field;
            var zymls = formSelects.value('selectzyml', 'valStr').split('/');
            var orgnization = formSelects.value('selectxzjg', 'valStr').split('/');
            result.form1.catalogIds = [zymls[zymls.length - 1], orgnization[orgnization.length - 1]];
            var orgnizationNames = formSelects.value('selectxzjg', 'name')[0].split('/');
            form.val('step_four', {"orgnizationName": orgnizationNames[orgnizationNames.length - 1]});
            $('#step_one').css('display', 'none');
            $('#step_two').css('display', 'block');
            $('#step_three').css('display', 'none');
            $('#step_four').css('display', 'none');
            $('#btnback').css('display', 'block');
            tools.resizeFormContent();
            return false;
        });

        form.on('submit(submit_two)', function (data) {
            result.form2 = data.field;
            $('#step_one').css('display', 'none');
            $('#step_two').css('display', 'none');
            $('#step_three').css('display', 'block');
            $('#step_four').css('display', 'none');
            tools.resizeFormContent();
            return false;
        });

        form.on('submit(submit_three)', function (data) {
            result.form3 = data.field;
            $('#step_one').css('display', 'none');
            $('#step_two').css('display', 'none');
            $('#step_three').css('display', 'none');
            $('#step_four').css('display', 'block');
            $('#btnnext').css('display', 'none');
            $('#btnfinish').css('display', 'block');
            tools.resizeFormContent();
            return false;
        });

        // 最终提交
        form.on('submit(submit_four)', function (data) {
            result.form4 = data.field;
            // 组合所有表单值
            var req = {
                capables: [{
                    info: "",
                    title: "",
                    type: "",
                    url: ""
                }]
                , catalogIds: result.form1.catalogIds
                , description: result.form1.description
                , icon: icon ? icon !== "" && result.form4.iconDefault !== "on" : "2c98981d6519113f0166e1acd1970038"
                , keywordIds: []
                , permission: result.form1.permission
                , regionCode: ""
                , resourceIds: []
                , responsible: {
                    address: result.form4.address
                    , orgnizationName: result.form4.orgnizationName
                    , principal: result.form4.principal
                    , tel: result.form4.tel
                }
                , source: {
                    associate_indexed: false
                    , coverageArea: result.form3.coverageArea
                    , description: result.form1.description
                    , endAt: result.form3.endAt !== "" ? result.form3.endAt + ' 00:00:00' : undefined
                    , indexName: ""
                    , index_checked: false
                    , keywords: formSelects.value('keywords', 'name')
                    , kj_checked: false
                    , layerDescription: result.form3.layerDescription
                    , layerFbsj: result.form3.layerFbsj !== "" ? result.form3.layerFbsj + ' 00:00:00' : undefined
                    , layerGxzq: result.form3.layerGxzq !== "" ? result.form3.layerGxzq + ' 00:00:00' : undefined
                    , permission: result.form1.permission
                    , registerType: "server"
                    , resList: []
                    , resourceCount: "single"
                    , resourceGxzq: result.form1.resourceGxzq
                    , startAt: result.form3.startAt !== "" ? result.form3.startAt + ' 00:00:00' : undefined
                    , title: result.form1.title
                    , type: "1"
                    , urlList: []
                }
                , spatialCoverage: {
                    wkid: result.form3.wkid
                    , coverageArea: result.form3.coverageArea
                    , bottom: result.form3.bottom
                    , left: result.form3.left
                    , right: result.form3.right
                    , top: result.form3.top
                }
                , startAt: result.form3.startAt !== "" ? result.form3.startAt + ' 00:00:00' : null
                , endAt: result.form3.endAt !== "" ? result.form3.endAt + ' 00:00:00' : null
                , status: "register"
                , title: result.form1.title
                , type: ""
                , url: ""
            };
            switch (result.form2.selectUrlType) {
                case "1":
                    req.capables = [{
                        title: result.form2.urlType1,
                        type: result.form2.urlType1.toLowerCase(),
                        url: result.form2.url1
                    }];
                    req.type = "空间数据服务";
                    $.ajax({
                        url: "/yzy/checkUrl"
                        , data: {
                            url: result.form2.url1,
                            type: result.form2.urlType1
                        }
                    }).done(function (data) {
                        if (data.flag) {
                            req.capables[0].info = data.resInfo;
                        }
                    });
                    break;
                case "2":
                    req.capables = [{
                        title: result.form2.urlType2,
                        type: result.form2.urlType2.toLowerCase(),
                        url: result.form2.url2
                    }];
                    req.type = "空间功能服务";
                    $.ajax({
                        url: "/yzy/checkUrl"
                        , data: {
                            url: result.form2.url2,
                            type: result.form2.urlType2
                        }
                    }).done(function (data) {
                        if (data.flag) {
                            req.capables[0].info = data.resInfo;
                        }
                    });
                    break;
                case "3":
                    layer.msg("对不起，属性服务资源注册咱不可用.", {icon: 5});
                    return false;
                    break;
                case "4":
                    req.capables = [{
                        info: result.form2.url4,
                        title: "报表服务",
                        type: "noProxy",
                        url: result.form2.url4
                    }];
                    req.type = "报表服务";
                    break;
                case "5":
                    req.capables = [{
                        info: result.form2.url5,
                        title: "其他类服务",
                        type: "proxy",
                        url: result.form2.url5
                    }];
                    req.type = "其他类型服务";
                    break;
                default:
                    break;
            }

            // 提交参数
            $.ajax({
                type: 'POST',
                url: rootPath + '/yzy/save',
                contentType: 'application/json;charset=UTF-8',
                data: JSON.stringify(req),
                success: function (res) {
                    location.href = rootPath + '/yzy/yzyxq?id=' + res;
                },
                error: function (err) {
                    console.error(err);
                }
            });
            return false;
        });

        form.on('radio(selectUrlType)', function (data) {
            element.tabChange('urlType', data.value);
        });

        form.on('radio(selectDbType)', function (data) {
            element.tabChange('DbType', data.value);
        });

        form.verify({
            serviceType: function (value, item) {
                // if ($(item).parents('.layui-tab-item').hasClass('layui-show') && value === "") {
                //     return "必填项不能为空";
                // }
            }
        });

        // 上一步
        $(document).on('click', '#btnback', function () {
            if ($('#step_two').css('display') === 'block') {
                $('#step_one').css('display', 'block');
                $('#step_two').css('display', 'none');
                $('#step_three').css('display', 'none');
                $('#step_four').css('display', 'none');
                $('#btnback').css('display', 'none');
                tools.resizeFormContent();
                return;
            }
            if ($('#step_three').css('display') === 'block') {
                $('#step_one').css('display', 'none');
                $('#step_two').css('display', 'block');
                $('#step_three').css('display', 'none');
                $('#step_four').css('display', 'none');
                tools.resizeFormContent();
                return;
            }
            if ($('#step_four').css('display') === 'block') {
                $('#step_one').css('display', 'none');
                $('#step_two').css('display', 'none');
                $('#step_three').css('display', 'block');
                $('#step_four').css('display', 'none');
                $('#btnnext').css('display', 'block');
                $('#btnfinish').css('display', 'none');
                tools.resizeFormContent();
                return;
            }
        });

        // 取消
        $(document).on('click', '#btncancle', function () {
            self.location = document.referrer;
        });

        // checkUrl
        $(document).on('click', '.urlCheck', function () {
            if ($(this).parents('.layui-input-block').find('.serviceUrl').val() !== "") {
                var data = {};
                data.url = $(this).parents('.layui-input-block').find('.serviceUrl').val();
                if ($(this).parents('.layui-input-block').find('.layui-select').val()) {
                    data.type = $(this).parents('.layui-input-block').find('.layui-select').val();
                } else {
                    data.type = "other";
                }
                $.ajax({
                    url: "/yzy/checkUrl",
                    data: data
                }).done(function (data) {
                    if (data.flag) {
                        layer.msg("验证成功！", {icon: 6});
                        form.val("step_three", data);
                    } else {
                        layer.msg("验证失败！", {icon: 5});
                    }
                }).error(function () {
                    layer.msg("网络异常！", {icon: 5});
                });
            } else {
                layer.msg("请输入地址!", {icon: 5});
            }
        });

        // 窗口自适应
        $(window).resize(function () {
            tools.resizeFormContent();
        });

        tools.resizeFormContent();
    }
});