layui.use(['element', 'layer', 'table', 'sidebar'], function () {
    var element = layui.element,
        $ = layui.jquery,
        layer = layui.layer,
        table = layui.table,
        sidebar = layui.sidebar;

    var tableIns;

    var where = {};

    var tools = (function () {
        function getNavTitleByKey(key) {
            var nav = {
                'WDLX': '',
                'REST': '按服务类型分类',
                'RESC': '按主体分类',
                'XZJG': '按机构分类',
                'ZBXT': '按坐标系分类'
            };
            return nav[key];
        }

        return {
            getNavTitleByKey: getNavTitleByKey
        }
    })();

    renderElem();
    bindEvent();

    function renderElem() {
        $.ajax({
            type: 'get',
            url: rootPath + '/v2/catalog/root/groups',
            async: false,
            dataType: 'json',
            success: function (data) {
                var keys = ['RESC', 'XZJG', 'REST', 'ZBXT', 'WDLX'];
                var nav = [];
                keys.forEach(function (key) {
                    if (data[key].length != 0) {
                        var item = {
                            "children": [],
                            "href": "",
                            "icon": "fa fa-server",
                            "spread": false,
                            "title": tools.getNavTitleByKey(key)
                        };
                        data[key].forEach(function (child) {
                            item.children.push({
                                "href": child.id,
                                "icon": "fa fa-cube",
                                "spread": false,
                                "title": child.title,
                                "id": child.id
                            });
                        });
                        nav.push(item);
                    }
                });
                sidebar.render({
                    el: '#yzy-list-nav',
                    data: nav
                });
                $('#yzy-list-nav ul').attr('lay-shrink', 'all');
            }
        });

        tableIns = table.render({
            id: 'yzy-list-table',
            elem: '#yzy-list-table'
            , url: '/yzy/query/condition4/pageable'
            , request: {
                pageName: 'page',
                limitName: 'size'
            }
            , height: 'full-200'
            , cellMinWidth: 100 //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            , skin: 'line' //line （行边框风格） row （列边框风格） nob （无边框风格）
            , even: false //开启隔行背景
            , size: 'lg' //小尺寸的表格
            , page:
                {
                    count: 100
                    , layout: ['prev', 'page', 'next', 'limit', 'skip']
                    , theme: '#1890FF'
                } //开启分页
            ,
            limit: 10
            , cols: [
                [{
                    title: '资源缩略图',
                    field: 'sign',
                    // style: 'height:80px',
                    templet: function (obj) {
                        var img = '<img src="' + obj.icon + '" style="width:50px;height:50px;" />';
                        var target = '<a href="' + rootPath + '/yzy/yzyxq?id=' + obj.id + '">' + img + '</a>';
                        return target;
                    }
                }, { //配置数据列
                    title: '标题描述', //显示名称
                    field: 'name', //字段名
                    style: '',
                    templet: function (obj) {
                        if (obj.description) {
                            return "<div style='display:block;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;'><strong>"
                                + obj.title + "</strong><br>" + obj.description + "</div>";
                            // return obj.title + "\n" + obj.description;
                        } else {
                            return "<div style='display:block;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;'><strong>"
                                + obj.title + "</strong></div>";
                        }
                    }
                }, { //配置数据列
                    title: '关键字', //显示名称
                    field: 'name', //字段名
                    templet: function (obj) {
                        return obj.keywordIds;
                    }
                }, { //配置数据列
                    title: '资源类型', //显示名称
                    field: 'name', //字段名
                    templet: function (obj) {
                        return obj.type;
                    }
                }, { //配置数据列
                    title: '发布机构', //显示名称
                    field: 'name', //字段名
                    templet: function (obj) {
                        return obj.publisher;
                    }
                }, {
                    title: '最新更新时间',
                    field: 'createtime',
                    templet: function (obj) {
                        return obj.updateAt;
                    }
                }, {
                    title: '操作',
                    field: 'tool',
                    align: 'center',
                    // style: 'cursor:pointer',
                    toolbar: '#toolbar'
                }]
            ]
            , parseData: function (res) {
                return {
                    "code": 0,
                    "msg": "",
                    "count": res.totalElements,
                    "data": res.content
                }
            }
            , done: function () {
                tableIns.resize();
                $(".layui-table-cell img").each(function () {
                    $(this).on('error', function () {
                        $(this).attr("src", "/assets/images/defaultPhoto.png");
                    });
                })
            }
        });
    }

    function bindEvent() {
        sidebar.on('click(changeNav)', function (elem) {
            switch (elem.elem.parents('li').find('a')[0].innerText) {
                case tools.getNavTitleByKey('WDLX'):
                    break;
                case tools.getNavTitleByKey('REST'):
                    where.type = [];
                    where.type.push(elem.field.title);
                    $('#REST').html(elem.field.title);
                    $('#REST').removeClass('layui-hide');
                    $.getJSON(rootPath + '/v2/catalog/findRootCatalogByParentId/' + elem.field.href, function (res) {
                        if (res.length > 0) {
                            res.forEach(function (data) {
                                where.type.push(data.title);
                                $.ajax({
                                    url: rootPath + '/v2/catalog/findRootCatalogByParentId/' + data.id,
                                    async: false,
                                    success: function (resChild) {
                                        if (resChild.length > 0) {
                                            resChild.forEach(function (dataChild) {
                                                where.type.push(dataChild.title);
                                            });
                                        }
                                    }
                                });
                            });
                        }
                    }).done(function () {
                        tableIns.reload({
                            where: where
                        });
                    });
                    break;
                case tools.getNavTitleByKey('RESC'):
                    where = {};
                    where.catalog = [];
                    where.catalog.push(elem.field.href);
                    $('.filters').addClass('layui-hide');
                    $('#RESC').html(elem.field.title);
                    $('#RESC').removeClass('layui-hide');
                    $.getJSON(rootPath + '/v2/catalog/findRootCatalogByParentId/' + elem.field.href, function (res) {
                        if (res.length > 0) {
                            res.forEach(function (data) {
                                where.catalog.push(data.id);
                                $.ajax({
                                    url: rootPath + '/v2/catalog/findRootCatalogByParentId/' + data.id,
                                    async: false,
                                    success: function (resChild) {
                                        if (resChild.length > 0) {
                                            resChild.forEach(function (dataChild) {
                                                where.catalog.push(dataChild.id);
                                            });
                                        }
                                    }
                                });
                            });
                        }
                    }).done(function () {
                        tableIns.reload({
                            where: where
                        });
                    });
                    break;
                case tools.getNavTitleByKey('XZJG'):
                    where.department = [];
                    where.department.push(elem.field.href);
                    $('#XZJG').html(elem.field.title);
                    $('#XZJG').removeClass('layui-hide');
                    $.getJSON(rootPath + '/v2/catalog/findRootCatalogByParentId/' + elem.field.href, function (res) {
                        if (res.length > 0) {
                            res.forEach(function (data) {
                                where.department.push(data.id);
                                $.ajax({
                                    url: rootPath + '/v2/catalog/findRootCatalogByParentId/' + data.id,
                                    async: false,
                                    success: function (resChild) {
                                        if (resChild.length > 0) {
                                            resChild.forEach(function (dataChild) {
                                                where.department.push(dataChild.id);
                                            });
                                        }
                                    }
                                });
                            });
                        }
                    }).done(function () {
                        tableIns.reload({
                            where: where
                        });
                    });
                    break;
                case tools.getNavTitleByKey('ZBXT'):
                    where.wkid = elem.field.href;
                    $('#ZBXT').html(elem.field.title);
                    $('#ZBXT').removeClass('layui-hide');
                    tableIns.reload({
                        where: where
                    });
                    break;
                default:
                    break;
            }
        });

        //监听表格里控件的点击事件
        table.on('tool(yzy-list-table)', function (obj) {
            if (obj.event === 'detail') {
                location.href = rootPath + "/yzy/yzyxq?id=" + obj.data.id;
            }
            if (obj.event === 'del') {
                $.ajax({
                    url: '/yzy/deleteResource?id=' + obj.data.id
                }).done(function (data) {
                    layer.msg("删除成功");
                    tableIns.reload();
                }).fail(function () {
                    layer.msg("删除失败");
                });
            }
        });

        //导航三级级菜单面板悬浮事件
        $('.left-nav').find('a').hover(function () {
            var id = $(this).attr('data-id');
            var title = $(this).find('cite').html();
            if (id !== undefined && id !== "") {
                $.getJSON(rootPath + '/v2/catalog/findRootCatalogByParentId/' + id, function (res) {
                    if (res.length > 0) {
                        $('.third-menu').empty();
                        $('.third-menu').attr('data-type', res[0].type);
                        $('.third-menu').append(
                            '<div class="menu-title">' +
                            '<span class="blue-line"></span>' +
                            '<span class="menu-title-txt">' + title + '</span>' +
                            '</div>' +
                            '<div class="title-line"></div>' +
                            '<div class="third-menu-content"></div>'
                        );
                        res.forEach(function (data, index) {
                            $('.third-menu .third-menu-content').append(
                                '<div class="content-box">' +
                                '<div class="box-city" data-id="' + data.id + '">' + data.title + '</div>' +
                                '<div class="city-area"></div>' +
                                '</div>'
                            );
                            if (data.id != undefined || data.id != "") {
                                $.ajax({
                                    url: rootPath + '/v2/catalog/findRootCatalogByParentId/' + data.id,
                                    async: false,
                                    success: function (resChild) {
                                        if (resChild.length > 0) {
                                            resChild.forEach(function (dataChild) {
                                                $('.third-menu .third-menu-content .content-box:eq(' + index + ') .city-area').append(
                                                    '<div class="city-area-zi" data-id="' + dataChild.id + '">' + dataChild.title + '</div>'
                                                );
                                            });
                                        }
                                    }
                                });
                            }
                        });
                        $('.third-menu').show();
                    }
                });
            }
        }, function () {
            $('.third-menu').hide();
        });

        $(document).on('click', '.filters', function () {
            var type = $(this).attr('id');
            switch (type) {
                case 'WDLX':
                    break;
                case 'REST':
                    where.type = [];
                    break;
                case 'RESC':
                    where = {};
                    $('.filters').addClass('layui-hide');
                    break;
                case 'XZJG':
                    where.department = [];
                    break;
                case 'ZBXT':
                    where.wkid = '';
                    break;
                default:
                    break;
            }
            $(this).addClass('layui-hide');
            tableIns.reload({
                where: where
            })
        });

        $(document).on('click', '.box-city', function () {
            var type = $(this).parents('.third-menu').attr('data-type');
            switch (type) {
                case 'WDLX':
                    break;
                case 'REST':
                    where.type = [];
                    where.type.push($(this).attr('data-id'));
                    $('#REST').html($(this).html());
                    $('#REST').removeClass('layui-hide');
                    for (var i = 0; i < $(this).parents('.content-box').find('.city-area-zi').length; i++) {
                        where.type.push($(this).parents('.content-box').find('.city-area-zi:eq(' + i + ')').attr('data-id'));
                    }
                    break;
                case 'RESC':
                    where = {};
                    where.catalog = [];
                    where.catalog.push($(this).attr('data-id'));
                    $('.filters').addClass('layui-hide');
                    $('#RESC').html($(this).html());
                    $('#RESC').removeClass('layui-hide');
                    for (var i = 0; i < $(this).parents('.content-box').find('.city-area-zi').length; i++) {
                        where.catalog.push($(this).parents('.content-box').find('.city-area-zi:eq(' + i + ')').attr('data-id'));
                    }
                    break;
                case 'XZJG':
                    where.department = [];
                    where.department.push($(this).attr('data-id'));
                    $('#XZJG').html($(this).html());
                    $('#XZJG').removeClass('layui-hide');
                    for (var i = 0; i < $(this).parents('.content-box').find('.city-area-zi').length; i++) {
                        where.department.push($(this).parents('.content-box').find('.city-area-zi:eq(' + i + ')').attr('data-id'));
                    }
                    break;
                case 'ZBXT':
                    where.wkid = $(this).attr('data-id');
                    $('#ZBXT').html($(this).html());
                    $('#ZBXT').removeClass('layui-hide');
                    break;
                default:
                    break;
            }
            tableIns.reload({
                where: where
            })
        });

        $(document).on('click', '.city-area-zi', function () {
            var type = $(this).parents('.third-menu').attr('data-type');
            switch (type) {
                case 'WDLX':
                    break;
                case 'REST':
                    where.type = [];
                    where.type.push($(this).attr('data-id'));
                    $('#REST').html($(this).html());
                    $('#REST').removeClass('layui-hide');
                    break;
                case 'RESC':
                    where = {};
                    where.catalog = [];
                    where.catalog.push($(this).attr('data-id'));
                    $('.filters').addClass('layui-hide');
                    $('#RESC').html($(this).html());
                    $('#RESC').removeClass('layui-hide');
                    break;
                case 'XZJG':
                    where.department = [];
                    where.department.push($(this).attr('data-id'));
                    $('#XZJG').html($(this).html());
                    $('#XZJG').removeClass('layui-hide');
                    break;
                case 'ZBXT':
                    where.wkid = $(this).attr('data-id');
                    $('#ZBXT').html($(this).html());
                    $('#ZBXT').removeClass('layui-hide');
                    break;
                default:
                    break;
            }
            tableIns.reload({
                where: where
            })
        });

        $(document).on('click', '#searchbtn', function () {
            where.keyword = $('#search-content').val();
            tableIns.reload({
                where: where
            })
        });

        $(document).on('keyup', '#search-content', function (e) {
            if (e.which === 13) {
                where.keyword = $('#search-content').val();
                tableIns.reload({
                    where: where
                });
            }
        });

        $(document).on('click', '#zyzc', function () {
            location.href = rootPath + "/yzy/yzyzc?alone=true";
        })
    }
});