layui.use(['form', 'layedit', 'laydate', 'element'], function () {
    var form = layui.form,
        element = layui.element,
        layer = layui.layer,
        chartweek;

    var tools = (function () {
        function getDayList() {
            var defaultDayList = ['星期一', '星期二', '星期三', '星期四', '星期五', '星期六', '星期日'];
            var dayIndex = new Date().getDay();
            var temp1 = defaultDayList.slice(dayIndex, 7);
            var temp2 = defaultDayList.slice(0, dayIndex);
            return temp1.concat(temp2);
        }

        return {
            getDayList: getDayList
        }
    })();

    initElem();
    bindEvent();

    function initElem() {
        // 资源详情
        $.ajax({
            // 要请求的 URL
            url: '/yzy/query/queryResourceId',

            // 要发给服务端的数据
            // （将会转化为查询字符串，如：?id=123）
            data: {id: id},

            // 定义此 Ajax 请求是 POST 还是 GET
            type: 'GET',

            // 服务端返回的数据类型
            dataType: 'json',
        }).done(function (json) {
            $('.right-title').html(json.title);
            $("#sjlx").text(json.capables[0].title);
            $('.left-img')
                .attr("src", storageServerPath + "rest/files/" + json.icon + "/thumbnail?w=250&h=250")
                .on('error', function () {
                    $(this).attr("src", "/assets/images/defaultPhoto.png");
                });

            //表单初始赋值
            form.val('example', {
                "fwlx": json.capables[0].title,
                "fwjj": json.description,
                "zbx": json.spatialCoverage.wkid,
                "gxlx": json.permission === "1" ? "无条件共享" : json.permission === "2" ? "有条件共享" : json.permission === "3" ? "不予共享" : "",
                "fwmc": json.title,
                "gjz": json.source.keywords,
                "fgqy": json.spatialCoverage.coverageArea,
                "tylx": json.projection,
                "gxzq": json.source.resourceGxzq,
                "zbx1": json.spatialCoverage.wkid,
                "fbsj1": json.source.layerFbsj,
                "tcjj1": json.source.layerDescription,
                "tylx1": json.projection,
                "gxzq1": json.source.resourceGxzq,
                "fbjg": json.responsible.orgnizationName,
                "lxr": json.responsible.principal,
                "dz": json.responsible.address,
                "lxdh": json.responsible.tel
            });

            if (json.rescIds) {
                if (json.rescIds.length > 0) {
                    var zymls = Array(json.rescIds.length);
                    var count = 0;
                    $.each(json.rescIds, function (i, val) {
                        $.ajax({
                            url: "/v2/catalog/findCatalogById", type: "GET", dataType: "json", data: {id: val}
                        }).done(function (data) {
                            zymls[i] = data.title;
                            count++;
                            if (count === json.rescIds.length) {
                                form.val('example', {
                                    "zyml": zymls.join(' / ')
                                });
                            }
                        }).error(function (err) {
                            count++;
                            if (count === json.rescIds.length) {
                                form.val('example', {
                                    "zyml": zymls.join(' / ')
                                });
                            }
                        });
                    });
                }
            }

            // 资源访问权限
            $.ajax({
                url: '/yzy/query/getRightsByResource/' + id
            }).done(function (data) {
                if (data) {
                    $("#fwqx").text("无需申请");
                    $('#btn-address-copy').css('display', 'inline-block');
                    $('#btn-address-copy').click(function () {
                        layer.open({
                            title: '复制访问地址',
                            shadeClose: true,
                            type: 1,
                            area: ['500px', '125px'],
                            content: $('#fwdzPanel').html()
                        });
                        $('#fwdz').val(resourceProxyPath + '/resp/' + id + '/' + $("#sjlx").text().toLowerCase());
                        document.getElementById("fwdz").select();
                        try {
                            if (document.execCommand("Copy", false, null)) {
                                layer.msg('访问地址已复制到剪贴板！', {icon: 6, offset: 't'});
                            } else {
                                layer.msg('复制访问地址失败！', {icon: 5, offset: 't'});
                            }
                        } catch (err) {
                            layer.msg('复制访问地址错误！', {icon: 5, offset: 't'});
                        }
                    });
                } else {
                    $("#fwqx").text("需要申请");
                    $('#btn-access').css('display', 'inline-block');
                    $('#btn-access').click(function () {
                        layer.open({
                            title: '提交申请',
                            shadeClose: true,
                            type: 1,
                            area: ['500px', '360px'],
                            content: $('#script-download').html(),
                        });
                    });
                    $(document).on('click', '#btn-download', function () {
                        $.post('/yzy/apply/start', {
                            params: JSON.stringify(json),
                            reason: $('#text-reason')[0].value
                        }).then(
                            function (obj) {
                                if (obj.data != null) {
                                    if (obj.data) {
                                        return layer.msg("申请成功，等待审核！");
                                    } else {
                                        return layer.msg("请勿重复申请！");
                                    }
                                }
                                return layer.msg("申请失败！");
                            },
                            function (obj) {
                                return layer.msg("申请失败！");
                            }
                        );
                    });
                }
            });
        }).fail(function (xhr, status) {
            console.log('Sorry, there was a problem!');
        });

        $.ajax({
            // 要请求的 URL
            url: '/yzy/query/findCapablesByResource',

            // 要发给服务端的数据
            // （将会转化为查询字符串，如：?id=123）
            data: {id: id},

            // 定义此 Ajax 请求是 POST 还是 GET
            type: 'GET',

            // 服务端返回的数据类型
            dataType: 'json',

            // Ajax 成功执行时的回调函数；
            // 回调函数的参数即为服务端返回的数据
            success: function (json) {
                // $("#zyfwl").text(json.capables[0].title);
                // console.table(json);
            },

            // 如果 Ajax 执行失败；
            // 将返回原始错误信息以及状态码
            // 传入这个回调函数中
            error: function (xhr, status) {
                console.log('Sorry, there was a problem!');
            }

        });

        // 资源访问量
        $.ajax({
            // 要请求的 URL
            url: '/yzy/number',

            // 要发给服务端的数据
            // （将会转化为查询字符串，如：?id=123）
            data: {id: id},

            // 定义此 Ajax 请求是 POST 还是 GET
            type: 'GET',

            // 服务端返回的数据类型
            dataType: 'json',

            // Ajax 成功执行时的回调函数；
            // 回调函数的参数即为服务端返回的数据
            success: function (num) {
                //表单初始赋值
                $('#zyfwl').html(num);
            },

            // 如果 Ajax 执行失败；
            // 将返回原始错误信息以及状态码
            // 传入这个回调函数中
            error: function (xhr, status) {
                console.log('Sorry, there was a problem!');
            }

        });

        // 访问统计表
        $.ajax({
            url: '/yzylog/week/detail',
            data: {id: id}
        }).done(function (data) {
            chartweek = echarts.init($('#chartweek')[0], 'macarons');
            chartweek.showLoading();
            var option = {
                title: {text: '一周数据访问情况', show: true, top: 15, left: 20},
                legend: {top: 20, data: ['数据访问量']},
                tooltip: {
                    trigger: 'axis',
                    axisPointer: {
                        type: 'cross',
                        label: {
                            backgroundColor: '#283b56'
                        }
                    }
                },
                xAxis: {
                    type: 'category',
                    boundaryGap: false,
                    data: tools.getDayList()
                },
                yAxis: {
                    type: 'value'
                },
                series: [{
                    data: data.data,
                    type: 'line',
                    smooth: true,
                    areaStyle: {}
                }]
            };
            chartweek.hideLoading();
            if (chartweek && typeof chartweek === "object") {
                chartweek.setOption(option);
            }
        });
    }

    function bindEvent() {
        element.on('tab(docDemoTabBrief)', function () {
            if (chartweek && typeof chartweek === "object") {
                chartweek.resize();
            }
        });

        $(window).resize(function () {
            if (chartweek && typeof chartweek === "object") {
                chartweek.resize();
            }
        });
    }
})
;