layui.use(["table", "layer", "form", "laytpl", 'upload'], function () {
    var $ = layui.jquery,
        table = layui.table,
        layer = layui.layer,
        form = layui.form,
        upload = layui.upload

    var dynamicCols = [],
        colsList = [];

    init();

    function init() {
        loadVersionTable();
        bindEvent();
        // loadDataTable();
    }

    //加载版本变化表
    function loadVersionTable() {
        table.render({
            elem: '#tb-version',
            url: '/rest/es/search/boolall',
            cellMinWidth: 100,
            // skin: 'line',
            even: false,
            id: 'tb-version',
            where: {
                tableid: tableid
            },
            page: false,
            initSort: {
                field: 'operatetime' //排序字段，对应 cols 设定的各字段名
                ,type: 'desc' //排序方式  asc: 升序、desc: 降序、null: 默认排序
            },
            cols: [[
                {type: 'checkbox',style: 'height:60px', fixed: 'left'},
                {
                    title: '日期',
                    field: 'date',
                    align: 'center',
                    edit: false,
                    templet: function (obj) {
                        return obj.date;
                    },
                },
                {
                    title: '用户',
                    field: 'user',
                    align: 'center',
                    edit: false,
                    templet: function (obj) {
                        return obj.user;
                    },
                },
                {
                    title: '操作',
                    field: 'operate',
                    align: 'center',
                    edit: false,
                    templet: function (obj) {
                        return obj.operate;
                    },
                },
                {
                    title: '操作时间',
                    field: 'operatetime',
                    align: 'center',
                    edit: false,
                    sort: true,
                    templet: function (obj) {
                        return obj.operatetime;
                    },
                },
                {
                    title: '行号',
                    field: 'rowid',
                    align: 'center',
                    edit: false,
                    templet: function (obj) {
                        return obj.rowid;
                    },
                },
                {
                    title: '列名',
                    field: 'column',
                    align: 'center',
                    edit: false,
                    templet: function (obj) {
                        return obj.column;
                    },
                },
                {
                    title: '原值',
                    field: 'oldvalue',
                    align: 'center',
                    edit: false,
                    templet: function (obj) {
                        return obj.oldvalue;
                    },
                },
                {
                    title: '修改值',
                    field: 'newvalue',
                    align: 'center',
                    edit: false,
                    templet: function (obj) {
                        return obj.newvalue;
                    },
                },
                {title: '操作', field: 'tool', align: 'center', toolbar: '#parambar'},
            ]],
            done: function (res, curr, count) {
                if(res.data.length == 0){
                    // layer.msg('未找到版本信息',{time:1000,icon:0}, function(){
                    //     // var root = window.location.origin;
                    //     // location.href = root + "/dw/metadata?id=" + tableid + "&ownState=private&cur=1";
                    // });
                }

                //执行表格“尺寸结构”的重置，这个必须要执行，否则获取的body的高度不准确
                table.resize('data-table');
            }
        });

        // table.on('rowDouble(test)', function(obj){
        //     var data = obj.data;
        //
        //
        //
        //
        //
        //     // layer.alert(JSON.stringify(data), {
        //     //     title: '当前行数据：'
        //     // });
        //     //
        //     // //标注选中样式
        //     // obj.tr.addClass('layui-table-click').siblings().removeClass('layui-table-click');
        // });
    }

    //加载数据表
    function loadDataTable () {
        $.ajax({
            type: 'GET',
            url: '/metainfo/field',
            data: {
                id: 'c3cf437e-564c-4f70-b927-f1755b4e0a59',
                page: 1,
                limit: 100
            },
            async: false,
            success: function (obj) {
                for(var i = 0;i<obj.data.length;i++){
                    var info = {field: obj.data[i].columnName, title: obj.data[i].columnName};
                    colsList.push(info);
                }
                dynamicCols.push(colsList);
            },
            error: function (e, state, error) {
                console.log(e);
            },
        })

        table.render({
            elem: '#param-table',
            url: '/metainfo/data?id=c3cf437e-564c-4f70-b927-f1755b4e0a59',
            cellMinWidth: 100,
            // skin: 'line',
            even: false,
            id: 'data-table',
            page: false,
            // page: {
            //     // count: 10,
            //     layout: ['prev', 'page', 'next', 'limit', 'skip', 'count'],
            //     theme: '#1890FF',
            // },
            // limit: 10,
            cols: dynamicCols,
            done: function (res, curr, count) {
                // datatablepage = curr;
                //执行表格“尺寸结构”的重置，这个必须要执行，否则获取的body的高度不准确
                table.resize('data-table');
            }
        })
    };



    function bindEvent() {
        $(document).on('click', '#btn-recover', function () {
            var checkStatus = table.checkStatus('tb-version');
            var tbdata = checkStatus.data;
            if (tbdata.length == 0) {
                layer.msg("请先选择版本记录进行操作！");
                return;
            }
            layerConfirm("是否确定恢复所选版本操作？", function () {
                var selList = [];
                for (var i = 0; i < tbdata.length; i++) {
                    selList.push(tbdata[i]);
                }
                var listJson = JSON.stringify(selList);

                $.ajax({
                    type: 'PUT',
                    url: '/rest/datastore/table/recover',
                    data: {
                        "tableId": tableid,
                        "listMapField" : listJson
                    },
                    success: function (data) {
                        if (data.data == "false") {
                            layer.msg("版本恢复失败！");
                        } else {
                            // reload();
                            layer.msg("版本恢复成功！");
                        }
                    },
                    error: function (e, state, errorThrown) {
                        console.log(e);
                        layer.msg("版本恢复失败！");
                    }
                });
            })
        });
    }

    //监听参数表行工具栏事件
    table.on("tool(param-table)", function (obj) {
        if (obj.event === 'paramrecover') {
            var rowdata = obj.data;
            var tbrowid = rowdata.rowid;
            var tbcolumn = rowdata.column;
            var oldvalue = rowdata.oldvalue;
            var operate = rowdata.operate;



        }
    });


    $(document).on('click', '#div-back', function () {
        var root = window.location.origin;
        location.href = root + "/dw/tables_info";
    })

    $(document).on('click', '#div-metadata', function () {
        var root = window.location.origin;
        location.href = root + "/dw/metadata?id=" + tableid + "&ownState=private&cur=1";
    })

});