layui.config({
    base: './js/'
}).use(['layer', 'table', 'form', 'tree'], function () {
        var $ = layui.jquery,
            table = layui.table,
            form = layui.form,
            tree = layui.tree,
            formSelects = layui.formSelects;
        var searchName = "",
            searchAlisa = "",
            userTableIns,
            layerIndex_showLayer,
            showLayer_operation,
            org_operation,
            org_detail;

        $('#sideNav a').click(function () {
            elem.render();
        });

        $(".left-nav1").css("height", window.innerHeight - $(".new-header-box").outerHeight() + 5);
        $(".main-container").css("height", $(".left-nav1").outerHeight());
        $(".show-container").css("height", ($(".main-container").outerHeight() - $(".header-container").outerHeight()) - 15);
        showContent("用户管理");

        $(".div-usermanage .layui-nav-item").click(function (obj) {
            var navName = $(this)[0].innerText;
            showContent(navName);
        });

        function showContent(name) {
            $(".header-title")[0].innerText = name;
            $(".cur-nav")[0].innerText = name;
            var id;
            switch (name) {
                case "用户管理":
                    id = "user-script";
                    break;
                case "组织机构":
                    id = "org-script";
                    break;
            }
            $(".show-container").empty();
            $($("#" + id)[0].innerText).appendTo($(".show-container"));
            init(name);
        };

        function init(name) {
            if (name == "用户管理") {
                bindTable(0);
                bindButton(0);
            }
            else if (name == "组织机构") {
                $(".org-tree").css("height", $(".show-container").height() - $(".org-top").height() - 10);
                $(".org-detail").css("height", $(".show-container").height() - $(".org-top").height() - 10);
                $(".org-detail").css("width", $(".show-container").width() - $(".org-tree").width() - 80);
                bindTree(1);
                bindButton(1);
            }
        };

        function bindTable(index) {
            var tableHeight = $(".show-container").height() - $(".item-top").height() - 10;
            if (index == 0) {
                userTableIns = table.render({
                    elem: '#user-table',
                    url: '/authority/userbyPage',
                    skin: 'line',
                    height: tableHeight,
                    even: true,
                    request: {
                        pageName: 'page'
                        , limitName: 'size'
                    },
                    where: {
                        searchName: searchName,
                        searchAlisa: searchAlisa
                    },
                    page: {
                        layout: ['prev', 'page', 'next', 'limit', 'skip'],
                        theme: '#1890FF',
                    },
                    // limit: 10,
                    cols: [[
                        {
                            title: 'id', field: 'id', hide: true, templet: function (obj) {
                                return obj.id;
                            }
                        },
                        {
                            title: '用户名', field: 'username', templet: function (obj) {
                                return obj.username;
                            }
                        },
                        {
                            title: '姓名', field: 'alias', templet: function (obj) {
                                return obj.alias;
                            }
                        },
                        {
                            title: '组织机构', field: 'orgName', templet: function (obj) {
                                if (obj.orgRecordList[0]) {
                                    return obj.orgRecordList[0].name;
                                }
                                else {
                                    return "";
                                }
                            }
                        },
                        {
                            title: '组织机构id', field: 'orgNameId', hide: true, templet: function (obj) {
                                if (obj.orgRecordList[0]) {
                                    return obj.orgRecordList[0].id;
                                }
                                else {
                                    return "";
                                }
                            }
                        },
                        {
                            title: '密码', field: 'password', hide: true, templet: function (obj) {
                                return obj.password;
                            }
                        },
                        {
                            title: '是否可用', field: 'enabled', templet: "#enable-script"
                        },
                        {
                            title: '操作', field: 'tool', align: 'center', style: 'cursor:pointer', templet: "#toolbar-script"
                        },
                    ]],
                    done: function (res, curr, count) {
                        table.resize('user-table');
                    },
                })
            }
        };

        function bindButton(index) {
            if (index == 0) {
                $("#btn-add").click(function (obj) {
                    showLayer("add");
                    bindTree(0);
                });
                $("#btn-search").click(function (obj) {
                    searchName = $("#input-user")[0].value;
                    searchAlisa = $("#input-alisa")[0].value;
                    userTableIns.reload({
                        where: {
                            searchName: searchName,
                            searchAlisa: searchAlisa
                        }
                    });
                });
                form.on("submit(submit)", function (obj) {
                    param = obj.field;
                    var id = param.selectID;
                    var ids = new Array();
                    ids[0] = id;
                    $.ajax({
                        type: "post",
                        url: "/authority/getOrg",
                        data: {ids: JSON.stringify(ids)},
                        success: function (obj) {
                            var ids = obj.data;
                            for (var i = 0; i < ids.length; i++) {
                                param["orgRecordList[" + i + "].id"] = ids[i].id;
                                param["orgRecordList[" + i + "].code"] = ids[i].code;
                                param["orgRecordList[" + i + "].name"] = ids[i].name;
                                param["orgRecordList[" + i + "].parentId"] = ids[i].parentId;
                                param["orgRecordList[" + i + "].isParent"] = ids[i].isParent;
                                param["orgRecordList[" + i + "].parentName"] = ids[i].parentName;
                                param["orgRecordList[" + i + "].parentCode"] = ids[i].parentCode;
                            }

                            if (showLayer_operation == "add") {
                                // param.enabled = 1;
                                $.ajax({
                                    type: "POST",
                                    url: "/authority/adduser",
                                    data: param,
                                    success: function (obj) {
                                        if (obj.data) {
                                            layer.msg("添加用户成功！");
                                            userTableIns.reload();
                                        }
                                        else {
                                            layer.msg("添加用户失败！");
                                        }
                                        layer.close(layerIndex_showLayer);
                                    },
                                    error: function (e) {
                                        layer.msg("添加用户失败！");
                                        layer.close(layerIndex_showLayer);
                                    }
                                });
                            }
                            else if (showLayer_operation == "edit") {
                                $.ajax({
                                    type: "POST",
                                    url: "/authority/edituser",
                                    data: param,
                                    success: function (obj) {
                                        if (obj.data) {
                                            layer.msg("修改用户信息成功！");
                                            userTableIns.reload();
                                        }
                                        else {
                                            layer.msg("修改用户信息失败！");
                                        }
                                        layer.close(layerIndex_showLayer);
                                    },
                                })
                            }
                        }
                    })
                    return false;
                });
                form.on("switch(enable-filter)", function (obj) {
                    var enabled = 0;
                    if (obj.elem.checked) {
                        enabled = 1;
                    }
                    $.ajax({
                        type: "POST",
                        url: "/authority/enableUser",
                        data: {"id": this.value, "enable": enabled},
                        success: function (data) {
                            if (data.data) {
                                if (obj.elem.checked) {
                                    layer.msg("启用成功！");
                                }
                                else {
                                    layer.msg("禁用成功！");
                                }
                            }
                        },
                        error: function (e) {
                            layer.msg("操作失败！");
                        }
                    })
                });
                table.on("tool(user-table)", function (obj) {
                    var data = obj.data;
                    if (obj.event == "view") {
                        showLayer("edit");
                        bindTree(0);
                        $("input[name=username]").attr("readonly", true).addClass("layui-bg-gray");
                        form.val("edit-form", data);
                        if (data.orgRecordList[0]) {
                            $("input[name=selectID]")[0].value = data.orgRecordList[0].id;
                            $("#treeclass")[0].innerText = data.orgRecordList[0].name;
                        }
                    }
                    else if (obj.event == "authority") {
                        showLayer("authority");
                        bindformSelect();
                        bindTree(2, data.username);
                        $("[name=username]").val(data.username);
                    }
                    else if (obj.event == "del") {
                        layer.confirm('确认删除' + data.username + '用户？', function (index) {
                            var id = data.id;
                            $.ajax({
                                type: 'POST',
                                url: '/authority/delete',
                                data: {
                                    "id": id,
                                },
                                success: function (data) {
                                    var isdelete = data.data;
                                    if (isdelete) {
                                        obj.del();
                                        layer.msg("删除成功!");
                                    }
                                },
                                error: function (e, state, errorThrown) {
                                    layer.msg("删除失败!");
                                    console.log(e);
                                }
                            });
                            layer.close(index);
                        });
                    }
                });
                form.on("submit(submit-authority)", function (obj) {
                    var params = obj.field;
                    var operations = formSelects.value('select-operation');
                    $.post("/authority/saveModuleAuthority", {
                        "username": params.username,
                        "moduleId": params.id,
                        "Operations": JSON.stringify(operations)
                    }).success(function (obj) {
                        if (obj.data) {
                            layer.msg("授权成功！");
                            layer.close(layerIndex_showLayer);
                        }
                    }).error(function (obj) {
                        layer.msg("授权失败！");
                        layer.close(layerIndex_showLayer);
                    })
                });
                $(document).on("click","#btn-reset",function () {
                    $('[name=username]')[0].defaultValue=$('[name=username]')[0].value;
                })
            }
            else if (index == 1) {
                form.on("submit(submit-org)", function (obj) {
                    if (org_operation == "edit") {
                        org_detail.code = obj.field.code;
                        org_detail.name = obj.field.name;
                        var param = org_detail;
                        delete param.children;
                        $.ajax({
                            type: "post",
                            url: "/authority/editorg",
                            data: param,
                            success: function (obj) {
                                if (obj.data) {
                                    layer.msg("修改成功！");
                                    $("#orgtree").empty();
                                    bindTree(1);
                                }
                                else {
                                    layer.msg("修改失败！");
                                }
                            },
                            error: function (obj) {
                                layer.msg("修改失败！");
                            }
                        })
                    }
                    else if (org_operation == "addnew") {
                        org_detail.code = obj.field.code;
                        org_detail.name = obj.field.name;
                        $.ajax({
                            type: "post",
                            url: "/authority/addorg",
                            data: org_detail,
                            success: function (obj) {
                                if (obj.data) {
                                    layer.msg("新增成功！");
                                    $("#orgtree").empty();
                                    bindTree(1);
                                }
                                else {
                                    layer.msg("新增失败！");
                                }
                            },
                            error: function (obj) {
                                layer.msg("新增失败！");
                            }
                        })
                    }
                    return false;
                });
                $("#btn-add").click(function (obj) {
                    $("#org-form")[0].reset();
                    org_operation = "addnew";
                    $("#orgtree").find("a").css("font-weight", "500");
                    org_detail = {};
                });
                $("#btn-addchild").click(function (obj) {
                    var parentId = org_detail.id;
                    var parentCode = org_detail.code;
                    var parentName = org_detail.name;
                    $("#org-form")[0].reset();
                    $("[name=parentName]").val(parentName);
                    org_operation = "addnew";
                    org_detail = {};
                    org_detail.parentId = parentId;
                    org_detail.parentCode = parentCode;
                    org_detail.parentName = parentName;
                });
                $("#btn-delete").click(function (obj) {
                    if ((!org_detail.id) && (!org_detail.parentId)) {
                        layer.msg("请选择需要删除的部门!");
                        return;
                    }
                    var name, id;
                    if (org_detail.name) {
                        name = org_detail.name;
                        id = org_detail.id;
                    }
                    else {
                        name = org_detail.parentName;
                        id = org_detail.parentId;
                    }
                    layer.confirm('确认删除' + name + '部门？', function (index) {
                        $.ajax({
                            type: 'POST',
                            url: '/authority/deleteorg',
                            data: {
                                "id": id,
                            },
                            success: function (obj) {
                                if (obj) {
                                    layer.msg("删除成功！");
                                    $("#orgtree").empty();
                                    bindTree(1);
                                }
                                else {
                                    layer.msg("删除失败！");
                                }
                            },
                            error: function (obj) {
                                layer.msg("删除失败！");
                            }
                        });
                        layer.close(index);
                    });
                })
            }
        };

        function bindTree(index, username) {
            if (index == 0 || index == 1) {
                $.get("/authority/orgs").done(function (obj) {
                    var data = obj.data;
                    if (index == 0) {
                        tree({
                            elem: "#classtree",
                            nodes: data,
                            click: function (node) {
                                var $select = $($(this)[0].elem).parents(".layui-form-select");
                                $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.name).end().find("input:hidden[name='selectID']").val(node.id);
                            }
                        });
                        $(".downpanel").on("click", ".layui-select-title", function (e) {
                            $(".layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
                            $(this).parents(".downpanel").toggleClass("layui-form-selected");
                            layui.stope(e);
                        }).on("click", "dl i", function (e) {
                            layui.stope(e);
                        });
                        $(document).on("click", function (e) {
                            $(".layui-form-select").removeClass("layui-form-selected");
                        });
                    }
                    else if (index == 1) {
                        tree({
                            elem: "#orgtree",
                            nodes: data,
                            click: function (node) {
                                org_operation = "edit";
                                org_detail = node;
                                form.val("org-form", node);
                            },
                        });
                        $("#orgtree a").on("click", function (e) {
                            $(this).parents("#orgtree").find("a").css("font-weight", "500");
                            $(this).css("font-weight", "600");
                        });
                        $("#orgtree").find("a")[0].click();
                    }
                });
            }
            else if (index == 2) {
                $.get("/authority/modules", {"clientId": clientId}).success(function (obj) {
                    var data = obj.data;
                    tree({
                        elem: "#authoritytree",
                        nodes: data,
                        click: function (node) {
                            $("#authority-form")[0].reset();
                            formSelects.value("select-operation", []);
                            form.val("authority-form", node);
                            $("[name=username]").val(username);
                            $.post("/authority/userModuleAuthority", {
                                "userName": username,
                                "moduleCode": node.code
                            }).success(function (obj) {
                                var data = obj.data;
                                if (data) {
                                    for (var i = 0; i < data.length; i++) {
                                        formSelects.value("select-operation", [data[i].value], true);
                                    }
                                }
                            })
                        }
                    });
                    $("#authoritytree a").on("click", function (e) {
                        $(this).parents("#authoritytree").find("a").css("font-weight", "500");
                        $(this).css("font-weight", "600");
                    });
                    $("#authoritytree").find("a")[0].click();
                })
            }
        };

        function showLayer(param) {
            var config = {
                shadeClose: true,
                type: 1,
                area: ['700px', '400px'],
            }
            if (param == "add") {
                config.title = "添加用户";
                config.content = $('#add-script')[0].innerHTML;
                config.skin = 'to-fix-select';
                showLayer_operation = "add";
            }
            else if (param == "edit") {
                config.title = "编辑用户";
                config.content = $('#add-script')[0].innerHTML;
                config.skin = 'to-fix-select';
                showLayer_operation = "edit";
            }
            else if (param == "authority") {
                config.title = "模块授权";
                config.content = $('#authority-script')[0].innerHTML;
                config.skin = 'to-fix-select';
                showLayer_operation = "authority";
            }
            layerIndex_showLayer = layer.open(config);
        };

        function bindformSelect() {
            formSelects.render('select-operation');
            $.ajax({
                type: 'GET',
                url: '/authority/operations',
                success: function (obj) {
                    layui.formSelects.data('select-operation', 'local', {
                        arr: obj
                    });
                },
                error: function (e, state, errorThrown) {
                    // console.log(e);
                },
            });
        }

        form.verify({
            nameIndex: function (value) {
                var re = /[~^$%=?_@&!*()<>:;'"{}【】 	]/gi;
                if (re.test(value)) {
                    return '用户名格式为字母或数字或中文';
                }
                if (showLayer_operation == "add") {
                    if (value.length > 16) {
                        return '用户名不能超过16位';
                    }
                    var res = false;
                    $.ajax({
                        url: '/authority/exist?username=' + encodeURIComponent(value),
                        type: 'GET',
                        async: false,
                        cache: false,
                        error: function () {
                            console.log("操作失败");
                        },
                        success: function (data) {
                            if (data) {
                                res = true;
                            }
                        }
                    });
                    if (res) {
                        return '用户名已存在';
                    }
                }
            },
            rePass: function (value) {
                var pwd = $("input[name='password']").val();
                if (pwd != null && pwd != undefined && pwd != "") {
                    if (value == null || value == undefined || value == "") {
                        return '密码验证不通过';
                    }
                    if (pwd.length < 6) {
                        return '密码至少6位';
                    }
                    var re = /[~^$%?&!*()<>:;'"{}【】 	]/gi;
                    if (re.test(pwd)) {
                        return '密码格式不正确';
                    }
                    if (value != pwd) {
                        return '密码验证不通过';
                    }
                }
                if (pwd == null || pwd == undefined || pwd == "") {
                    if (value != null && value != undefined && value != "") {
                        return '密码验证不通过';
                    }
                }
            }
        });
    }
);