layui.config({
    base: './js/'
}).use(['layer', 'table', 'form', 'laytpl'], function () {
    var $ = layui.jquery,
        table = layui.table,
        form = layui.form,
        formSelects = layui.formSelects;

    var ownState = "private",      //标识页面展示的数据是“共享”还是“私有”
        keywords,      //用于做模糊查询时的关键字
        currentPage = 1,       //标识当前页码
        layerIndex_authority,       //layui中弹窗的索引，此值记录的是授权弹窗的索引
        layerIndex_waiting,         //layui中弹窗的索引,此值记录等待框的索引
        moduleCode = "ccglzy",        //模块标识码,在用户权限中心配置
        moduleName = "仓储管理资源",        //模块名称,在用户权限中心配置
        tableIns,       //数据表绑定的实例
        tableparam,     //参数表绑定的实例
        paramdata;      //新增表时的参数数据

    init();

    /**
     * 初始化函数，用于表格、下拉框等控件的初始化
     */
    function init() {
        bindTables();
        bindDBSelect();
        bindAuthoritySelect();
        bindEvent();
    }

    /**
     * 数据绑定选择数据库实例的下拉框
     */
    function bindDBSelect() {
        $.ajax({
            type: 'GET',
            url: '/tablesinfo/instance',
            success: function (obj) {
                var data = obj.data;
                var option = "<option></option>";
                if (data.length != 0) {
                    for (var i = 0; i < data.length; i++) {
                        option += "<option value=\"" + data[i].id + "\">" + data[i].instanceName + "</option>";
                    }
                    $('#add-instance').html(option);
                    form.render('select');
                }
            },
            error: function (e, state, error) {
                layer.msg("获取数据库实例数据失败!");
            },
        })
    };

    /**
     * 绑定授权弹出层中用户数据和操作权限数据
     */
    function bindAuthoritySelect() {
        formSelects.render('select-user');
        $.ajax({
            type: 'GET',
            url: '/authority/users',
            success: function (obj) {
                layui.formSelects.data('select-user', 'local', {
                    arr: obj
                });
            },
            error: function (e, state, errorThrown) {
                console.log(e);
            },
        });
    };

    /**
     * 绑定页面上的数据表
     */
    function bindTables() {
        var height = $(".right-content").outerHeight() - $(".item-top").outerHeight();
        //数据表初始化加载数据
        tableIns = table.render({
            elem: '#data-table',
            url: '/tablesinfo/search',
            skin: 'line',
            even: true,
            id: 'data-table',
            height: height,
            where: {
                keyword: keywords,
                moduleCode: moduleCode,
                ownState: ownState,
            },
            page: {
                layout: ['prev', 'page', 'next', 'limit', 'skip'],
                theme: '#1890FF',
            },
            cols: [
                [{
                    type: 'checkbox'
                },
                    {
                        title: 'ID',
                        field: 'id',
                        hide: true,
                        templet: function (obj) {
                            return obj.id;
                        },
                    },
                    {
                        title: '名称',
                        field: 'name',
                        align: 'center',
                        templet: function (obj) {
                            return obj.tableName;
                        },
                    },
                    {
                        title: '数据类型',
                        field: 'dataType',
                        align: 'center',
                        templet: function (obj) {
                            return obj.dataType;
                        },
                    },
                    {
                        title: '数据来源',
                        field: 'resource',
                        align: 'center',
                        templet: function (obj) {
                            return obj.dataSource;
                        },
                    },
                    {
                        title: '关键字',
                        field: 'dataTags',
                        align: 'center',
                        templet: function (obj) {
                            if (!obj.dataTags) {
                                return "";
                            }
                            return obj.dataTags;
                        },
                    },
                    {
                        title: '更新时间',
                        field: 'dbTypeName',
                        align: 'center',
                        templet: function (obj) {
                            return renderDate(obj.lastUpdateTime);
                        },
                    },
                    {
                        title: '数据库连接',
                        field: 'dbName',
                        hide: true,
                        templet: function (obj) {
                            return obj.dbName;
                        },
                    },
                    {
                        title: '操作',
                        field: 'tool',
                        align: 'center',
                        style: 'cursor:pointer',
                        toolbar: '#toolbar',
                    },
                ]
            ],
            done: function (res, curr, count) {
                // 权限控制:公共数据时只可进行查看操作,无法授权和删除
                if (ownState == "public") {
                    $('.btn-tool-authority').hide();
                    $('.btn-tool-delete').hide();
                } else {
                    $('.btn-tool-authority').show();
                    $('.btn-tool-delete').show();
                }
                currentPage = curr;
                table.resize('data-table');
            },
        });
        //参数表格
        tableparam = table.render({
            elem: "#param-table",
            title: "字段表",
            // skin: 'line',
            even: true,
            toolbar: '#paramtoolbar',
            id: 'param-table',
            defaultToolbar: [],
            data: [],
            cols: [[
                {title: '字段名', field: 'name', width: '180', edit: true},
                {title: '显示名称', field: 'alias', width: '180', edit: true},
                {title: '数据类型', field: 'datatype', width: '130', templet: '#selectTool'},
                {title: '数据字典', field: 'dict', hide: true},
                {title: '操作', field: 'tool', width: '118', align: 'center', toolbar: '#parambar'}
            ]],
            done: function (res, curr, count) {
                $("[name=type]").parent().css("padding", "0 0");
                paramdata = res.data;
                table.resize('param-table');
            }
        });
    };

    /**
     * 绑定监听事件
     */
    function bindEvent() {
        /**
         * 注册弹出层
         */
        $(document).on('click', '#registerbtn', function () {
            $('#add-form')[0].reset();
            showLayer("registerdiv");
        });

        /**
         * 新增弹出层
         */
        $(document).on('click', '#addbtn', function () {
            $('#addform')[0].reset();
            showLayer("adddiv");
        });

        /**
         * 删除选中元素
         */
        $(document).on('click', '#deletebtn', function () {
            var checkStatus = table.checkStatus('data-table');
            var data = checkStatus.data;
            if (data.length > 0) {
                layer.confirm('确认删除选中项？', function (index) {
                    for (var i = 0; i < data.length; i++) {
                        var id = data[i].id;
                        $.ajax({
                            type: 'POST',
                            url: '/tablesinfo/delete',
                            data: {
                                "id": id,
                                "moduleCode": moduleCode,
                                "moduleName": moduleName,
                            },
                            success: function (data) {
                                layer.msg("删除成功!");
                                active['reload'].call(this);
                            },
                            error: function (e, state, errorThrown) {
                                console.log(e);
                                layer.msg("删除失败!");
                            },
                        });
                    }
                    layer.close(index);
                });
            } else {
                layer.msg('请选择删除数据！');
            }
        });

        /**
         * 共享数据给其他人
         */
        $(document).on('click', '#sharebtn', function () {
            var checkStatus = table.checkStatus('data-table');
            var data = checkStatus.data;
            if (data.length > 0) {
                var ids = "", tableNames = "";
                for (var i = 0; i < data.length; i++) {
                    ids += data[i].id + ",";
                    tableNames += data[i].tableName + ",";
                }
                showLayer("authority");
                form.val('authority-form', {
                    "id": ids,
                    "tableName": tableNames,
                });
                formSelects.value('select-user', []);
            } else {
                layer.msg('请选择共享的数据！');
            }
        });

        /**
         * 模糊查询
         */
        $(document).on('click', '#search-btn', function () {
            keywords = $('#search-text').val();
            active['reload'].call(this);
        });
        $('#search-text').keyup(function (event) {
            if (event.keyCode == 13) {
                keywords = $('#search-text').val();
                active['reload'].call(this);
            }
        });

        /**
         * 新增数据
         */
        form.on('submit(submit)', function (data) {
            var field = data.field;
            var instanceId = field.instance;
            var layerName = field.layerName;
            $.ajax({
                type: 'POST',
                url: '/tablesinfo/register',
                data: {
                    id: instanceId,
                    layerName: layerName,
                    moduleCode: moduleCode,
                    moduleName: moduleName,
                },
                beforeSend: function () {
                    layerIndex_waiting = helper.showLoad("正在保存数据...");
                },
                success: function (data) {
                    helper.closeLoad(layerIndex_waiting);
                    var root = window.location.origin;
                    location.href = root + "/dw/metadata?id=" + data.data + "&ownState=" + ownState + "&cur=" + currentPage;
                },
                error: function (e, state, errorThrown) {
                    console.log(e);
                    helper.closeLoad(layerIndex_waiting);
                    layer.msg("添加数据失败！");
                }
            });
            return false;
        });

        /**
         * 根据选择的实例，列出该实例下的所有表
         */
        form.on('select(add-instance)', function (data) {
            var instancId = data.value;
            if (!instancId) {
                $('#add-tableName').attr("disabled", true);
                $('#add-tableName').html("");
                form.render('select');
                return;
            }
            $.ajax({
                type: 'GET',
                url: '/tablesinfo/listlayer?id=' + instancId,
                beforeSend: function () {
                    layerIndex_waiting = helper.showLoad("正在获取该实例下数据表...");
                },
                success: function (obj) {
                    helper.closeLoad(layerIndex_waiting);
                    var data = obj.data;
                    if (data.length != 0) {
                        var option = "<option></option>";
                        for (var i = 0; i < data.length; i++) {
                            option += "<option value=\"" + data[i] + "\">" + data[i] + "</option>";
                        }
                        $('#add-tableName').attr("disabled", false);
                        $('#add-tableName').html(option);
                        form.render('select');
                    }
                },
                error: function (e, state, error) {
                    helper.closeLoad(layerIndex_waiting);
                    layer.msg("获取数据失败！");
                    console.log(e);
                },
            })
        });

        /**
         * 监听表格里控件的点击事件
         */
        table.on('tool(data-table)', function (obj) {
            var data = obj.data;
            if (obj.event == "del") {
                layer.confirm('确认删除' + data.tableName + '？', function (index) {
                    var id = data.id;
                    $.ajax({
                        type: 'POST',
                        url: '/tablesinfo/delete',
                        data: {
                            "id": id,
                            "moduleCode": moduleCode,
                            "moduleName": moduleName,
                        },
                        success: function (data) {
                            var isdelete = data.data;
                            if (isdelete) {
                                obj.del();
                                layer.msg("删除成功!");
                            }
                        },
                        error: function (e, state, errorThrown) {
                            layer.msg("删除失败!");
                            console.log(e);
                        }
                    });
                    layer.close(index);
                });
            }
            else if (obj.event == "detail") {
                var root = window.location.origin;
                location.href = root + "/dw/metadata?id=" + data.id + "&ownState=" + ownState + "&cur=" + currentPage;
            }
            else if (obj.event == "author") {
                showLayer("authority");
                form.val('authority-form', {
                    "id": data.id,
                    "tableName": data.tableName,
                });
                formSelects.value('select-user', []);
            }
        });

        /**
         * 提交授权
         */
        form.on('submit(authority-submit)', function (data) {
            var param = data.field;
            var userNames = formSelects.value('select-user', 'nameStr');
            $.ajax({
                type: 'POST',
                url: '/authority/save',
                data: {
                    "users": userNames,
                    "moduleCode": moduleCode,
                    "moduleName": moduleName,
                    "code": param.id,
                },
                success: function (data) {
                    layer.msg("共享成功！");
                },
                error: function (e, state, errorThrown) {
                    layer.msg("共享失败！");
                    console.log(e);
                }
            })
            layer.close(layerIndex_authority);
            return false;
        });

        /**
         * 监听参数表头工具栏事件
         */
        table.on("toolbar(param-table)", function (obj) {
            if (obj.event === 'paramadd') {
                // 增加参数
                paramdata.push({
                    "name": "",
                    "alias": "",
                    "type": "String",
                    "dict": ""
                });
                tableparam.reload({
                    data: paramdata
                });
                tableparam.resize();
            }
        });

        /**
         * 监听参数表行工具栏事件
         */
        table.on("tool(param-table)", function (obj) {
            if (obj.event === 'paramdel') {
                // 删除参数
                var dataindex = obj.tr.selector.match(/data-index="(\S*)"]/)[1];
                paramdata.splice(dataindex, 1);
                tableparam.reload({
                    data: paramdata
                });
            }
        });

        /**
         * 监听参数类别更改
         */
        form.on('select(type)', function (data) {
            var elem = data.othis.parents('tr');
            var dataindex = elem.attr('data-index');
            paramdata[dataindex].type = data.value;
        });

        /**
         * 新建或修改模型提交
         */
        form.on("submit(newTable-submit)", function (data) {
            // 参数设置表验证
            if (tools.checkParams(paramdata)) {
                var new_task = data.field;
                new_task.paramJson = JSON.stringify(paramdata);

                $.ajax({
                    type: "POST",
                    url: rootPath + "/tablesinfo/newtable",
                    contentType: "application/json",
                    data: JSON.stringify(new_task),
                    dataType: "json",
                    success: function (data) {
                        layer.msg("创建成功！");
                        layer.close(all);
                    }, error: function (err) {
                        layer.msg("创建失败！");
                        console.log(err);
                        layer.close(all);
                    }
                });
            } else {
                layer.msg("请确保参数设置正确！");
            }
            return false;
        });

        /**
         * 切换公有/私有数据
         */
        $(document).on('click', '#li-public', function () {
            if (ownState == "public") {
                return;
            }
            $('#btn-tool-authority').hide();
            $('#btn-tool-delete').hide();
            $('#li-public').css('background-color', '#377BFE');
            $('#li-public').css('color', '#fff');
            $('#li-private').css('background-color', '#d2d2d2');
            $('#li-private').css('color', '#333');
            $('#addbtn').hide();
            $('#deletebtn').hide();
            $('#sharebtn').hide();
            $('#registerbtn').hide();
            $('.item-left').css('margin-left', '0px');
            ownState = "public";
            active['reload'].call(this);
        })
        $(document).on('click', '#li-private', function () {
            if (ownState == "private") {
                return;
            }
            $('#btn-tool-authority').show();
            $('#btn-tool-delete').show();
            $('#li-private').css('background-color', '#377BFE');
            $('#li-private').css('color', '#fff');
            $('#li-public').css('background-color', '#d2d2d2');
            $('#li-public').css('color', '#333');
            $('#addbtn').show();
            $('#deletebtn').show();
            $('#sharebtn').show();
            $('#registerbtn').show();
            ownState = "private";
            active['reload'].call(this);
        })
    };

    /**
     * 弹出层实现
     * @param index
     */
    var showLayer = function (index) {
        if (index == 'registerdiv') {
            $('#add-tableName').attr("disabled", true);
            layer.open({
                title: '注册数据库已有表信息',
                skin: 'to-fix-select',
                shadeClose: true,
                type: 1,
                area: ['700px'],
                content: $('#add-div'),
            })
        }
        else if (index == 'authority') {
            layerIndex_authority = layer.open({
                title: '共享数据',
                shadeClose: true,
                skin: 'to-fix-select',
                type: 1,
                area: ['700px'],
                maxHeight: 400,
                maxWidth: 1000,
                content: $('#authority-div'),
            })
        }
        else if (index == 'adddiv') {
            layer.open({
                title: '新增表数据',
                shadeClose: true,
                // skin: 'to-fix-select',
                type: 1,
                area: ['800px'],
                maxHeight: 400,
                maxWidth: 1000,
                content: $('#addform'),
            })
        }
    };

    var active = {
        reload: function () {
            table.reload('data-table', {
                page: {
                    curr: currentPage,
                },
                where: {
                    keyword: keywords,
                    moduleCode: moduleCode,
                    ownState: ownState,
                }
            }, 'data');
        },
    };

    /**
     * 辅助工具
     * @type {{checkParams}}
     */
    var tools = (function () {
        "use strict";

        // 参数设置表验证
        function checkParams(paramdata) {
            var f = 0;
            // 验证是否存在空值
            for (var i = 0; i < paramdata.length; i++) {
                if (paramdata[i].name === "" || paramdata[i].alias === "") {
                    f = 1;
                    break;
                }
            }
            // 验证是否有重复的字段名
            if (f === 0) {
                var namehash = {},
                    aliashash = {};
                for (var i in paramdata) {
                    if (namehash[paramdata[i].name]) {
                        f = 1;
                        break;
                    }
                    if (aliashash[paramdata[i].alias]) {
                        f = 1;
                        break;
                    }
                    namehash[paramdata[i].name] = true;
                    aliashash[paramdata[i].alias] = true;
                }
            }
            if (f === 0) {
                return true; // 符合要求
            } else {
                return false; // 存在问题
            }
        }

        return {
            checkParams: checkParams
        }
    })();
})
