layui.config({
    base: './js/'
}).use(['layer', 'table', 'form'], function () {
    var $ = layui.jquery,
        table = layui.table,
        form = layui.form,
        formSelects = layui.formSelects;



    var ownState = "private",     //标识页面展示的数据是“共享”还是“私有”
        keywords,      //用于做模糊查询时的关键字
        currentPage = 1,        //标识当前页码
        layerIndex_authority,       //layui中弹窗的索引，此值记录的是授权弹窗的索引
        layerIndex_waiting,         //layui中弹窗的索引,此值记录等待框的索引
        layerIndex_edit,        //layui中弹窗的索引,此值记录编辑弹窗的索引
        layerIndex_add,         //layui中弹窗的索引,此值记录新增弹窗的索引
        moduleCode = "fwglzy",        //模块标识码,在用户权限中心配置
        moduleName = "服务管理资源",       //模块名称,在用户权限中心配置
        tableIns,
        map,
        lookLayer,
        // centerX,
        // centerY,
        gsurl,
        publishMap,
        map_edit,
        lookLayer_edit,
        // centerX_edit,
        // centerY_edit,
        gsurl_edit,
        publishMap_edit,
        preview_state;

    init();

    /**
     * 初始化函数，用于表格、下拉框等控件的初始化
     */
    function init() {
        bindTables();
        bindTableSelect();
        // bindLayerStyle();
        bindAuthoritySelect();
        bindTagSelect();
        bindEvent();
    }

    /**
     * 绑定授权弹出层中用户数据和操作权限数据
     */
    function bindAuthoritySelect() {
        formSelects.render('select-user');
        $.ajax({
            type: 'GET',
            url: '/authority/users',
            success: function (obj) {
                layui.formSelects.data('select-user', 'local', {
                    arr: obj
                });
            },
            error: function (e, state, errorThrown) {
                // console.log(e);
            },
        });
    };

    /**
     * 绑定数据表
     */
    function bindTables() {
        var height = $(".right-content").outerHeight() - $(".item-top").outerHeight();
        tableIns = table.render({
            elem: '#data-table',
            url: '/gs/mapservice/list',
            skin: 'line',
            even: true,
            id: 'data-table',
            height: height,
            where: {
                keywords: keywords,
                moduleCode: moduleCode,
                ownState: ownState,
                withthumbnail: false,
            },
            page: {
                limit: 10,
                layout: ['prev', 'page', 'next', 'limit', 'skip'],
                theme: '#1890FF',
            },
            cols: [
                [{
                    type: 'checkbox',
                },
                    {
                        title: 'ID',
                        field: 'id',
                        align: 'center',
                        hide: true,
                        templet: function (obj) {
                            return obj.id;
                        },
                    },
                    {
                        title: '资源缩略图',
                        field: 'sign',
                        align: 'center',
                        style: 'height:80px',
                        templet: function (obj) {
                            //     return '<img src="' + obj.thumbnail + '" style="width:75px;height:75px;" />';
                            return '<img src="' + rootPath + '/images/default.png" style="width:75px;height:75px;" />';
                        },
                    },
                    {
                        title: '名称',
                        field: 'serviceName',
                        align: 'center',
                        style: 'font-weight:700;',
                        templet: function (obj) {
                            return obj.serviceName;
                        },
                    },
                    {
                        title: '关键字',
                        field: 'keywords',
                        align: 'center',
                        style: 'font-weight:700;',
                        templet: function (obj) {
                            var tags = obj.tags;
                            var value = '';
                            if (tags) {
                                for (var i = 0; i < tags.length; i++) {
                                    value += tags[i];
                                    if (i != tags.length - 1) {
                                        value += ',';
                                    }
                                }
                            }
                            return value;
                        },
                    },
                    {
                        title: '资源类型',
                        field: 'serviceType',
                        align: 'center',
                        width: 180,
                        style: 'cursor:pointer',
                        toolbar: '#toolbar1'
                    },
                    // {
                    //     title: '资源类型',
                    //     align: 'center',
                    //     width: 150,
                    //     field: 'serviceType',
                    //     templet: function (obj) {
                    //         if (obj.serviceType) {
                    //             return obj.serviceType;
                    //         }
                    //         return "";
                    //     },
                    // },
                    {
                        title: '服务状态',
                        align: 'center',
                        field: 'enable',
                        templet: function (obj) {
                            var state = obj.enable;
                            if (ownState == "private") {
                                if (state) {
                                    return '<input type="checkbox" id="' + obj.id + '" checked="" lay-skin="switch" lay-filter="serviceswitch" title="开关" lay-text="ON|OFF">';
                                } else {
                                    return '<input type="checkbox" id="' + obj.id + '" lay-skin="switch" lay-filter="serviceswitch" title="开关" lay-text="ON|OFF">';
                                }
                            } else {
                                if (state) {
                                    return helper.showState("opened");
                                } else {
                                    return helper.showState("closed");
                                }
                            }

                        },
                    },
                    {
                        title: '服务地址',
                        field: 'baseUrl',
                        align: 'center',
                        hide: true,
                        templet: function (obj) {
                            return obj.baseUrl;
                        },
                    },
                    {//发布图层
                        title: '发布图层',
                        field: 'layer',
                        align: 'center',
                        hide: true,
                        templet: function (obj) {
                            var tables = obj.tables;
                            if (tables) {
                                return tables[0];
                            }
                        },
                    },
                    {
                        title: '操作',
                        field: 'id',
                        align: 'center',
                        width: 180,
                        style: 'cursor:pointer',
                        toolbar: '#toolbar'
                    },
                ]
            ],
            done: function (res, curr, count) {
                if (ownState == "public") {
                    $('.btn-tool-edit').hide();
                    $('.btn-tool-delete').hide();
                    $('.btn-tool-authority').hide();
                } else {
                    $('.btn-tool-edit').show();
                    $('.btn-tool-delete').show();
                    $('.btn-tool-authority').show();
                }
                bindLayerStyle();

                var dataTemp = table.cache[this.id];
                var tableElem = this.elem.next();

                $.ajax({
                    url: "/gs/mapservice/list",
                    type: "GET",
                    data: {
                        keywords: keywords,
                        moduleCode: moduleCode,
                        ownState: ownState,
                        withthumbnail: true,
                    },
                    dataType: 'json',
                    success: function (result) {

                        layui.each(dataTemp, function (index, data) {
                            var typeElem = tableElem.find('tr[data-index="' + index + '"]').find('td[data-field="sign"]').find('div.layui-table-cell')[0];
                            if (typeElem) {
                                typeElem.children[0].src = result.data[index].thumbnail;
                            }
                        });
                        table.resize('table-params');
                    }
                });

                currentPage = curr;
                // table.resize('data-table');
            },
        });
    };

    /**
     * 绑定新增/编辑服务弹窗中的数据表的下拉框（绑定的是此用户创建的数据仓储数据）
     */
    function bindTableSelect() {
        //绑定下拉框，详见helper.js
        helper.bindSelect('#add-dataresource,#edit-dataresource', rootPath + "/tablesinfo/search?page=1&limit=100&keyword=&moduleCode=ccglzy", function (data) {
            if (!data["data"]) {
                layer.msg("未获取到可发布图层！");
                return;
            }
            var content = data["data"];
            var result = [];
            if (content) {
                for (var i = 0; i < content.length; i++) {
                    var item = {};
                    item.id = content[i].id;
                    item.name = content[i].tableName;
                    result.push(item);
                }
            }
            return result;
        });
        form.render('select');
    };

    function bindLayerStyle() {
        helper.bindSelect('#add-layerstyle,#edit-layerstyle', rootPath + "/serviceinfo/style", function (data) {
            if (!data["data"]) {
                layer.msg("未获取到图层样式！");
                return;
            }
            var content = data["data"];
            var result = [];
            if (content) {
                for (var i = 0; i < content.length; i++) {
                    var item = {};
                    item.id = content[i].name;
                    item.name = content[i].name;
                    result.push(item);
                }
            }
            return result;
        });
        form.render('select');
    }

    /**
     * 绑定标签下拉框
     */
    function bindTagSelect() {
        formSelects.render('add-select-keywords');
        $.ajax({
            type: 'GET',
            url: '/metainfo/tags',
            success: function (obj) {
                layui.formSelects.data('add-select-keywords', 'local', {
                    arr: obj
                });
                layui.formSelects.data('edit-select-keywords', 'local', {
                    arr: obj
                });
            },
            error: function (e, state, errorThrown) {
                console.log(e);
            },
        });
    };

    /**
     * 绑定监听事件
     */
    function bindEvent() {
        /**
         * 新增弹出层
         */
        $(document).on('click', '#addbtn', function () {
            $('#add-form')[0].reset();
            document.getElementById('img-mapstyle').style.display = 'block';
            document.getElementById('mapDiv').style.display = 'none';

            showLayer("adddiv");
            layui.formSelects.value('add-select-keywords', []);
        });
        /**
         * 提交表单，将新增服务信息存入数据库
         */
        form.on('submit(add-submit)', function (data) {
            var param = data.field;
            var keywords = layui.formSelects.value('add-select-keywords', 'name');
            param.keywords = keywords;
            param.moduleCode = moduleCode;
            param.moduleName = moduleName;
            publish(param);
            bindTagSelect();
            return false;
        });
        /**
         * 提交表单，将编辑的服务信息存入数据库
         */
        form.on('submit(edit-submit)', function (data) {
            var param = data.field;
            var keywords = layui.formSelects.value('edit-select-keywords', 'name');
            param.keywords = keywords;
            updateData(param, keywords);
            bindTagSelect();
            return false;
        });
        /**
         * 批量删除选中元素
         */
        $(document).on('click', '#deletebtn', function () {
            var checkStatus = table.checkStatus('data-table');
            var data = checkStatus.data;
            if (data.length > 0) {
                for (var i = 0; i < data.length; i++) {
                    var serviceId = data[i].id;
                    $.ajax({
                        type: 'POST',
                        url: '/gs/layer/delete',
                        data: {
                            "serviceId": serviceId,
                            "moduleCode": moduleCode,
                            "moduleName": moduleName,
                        },
                        success: function (data) {
                            layer.msg("删除成功！");
                            active['reload'].call(this);
                        },
                        error: function (e, state, errorThrown) {
                            layer.msg("删除失败！");
                            console.log(e);
                        },
                    });
                }
            } else {
                layer.msg('请选择删除数据！');
            }
        });
        /**
         * 批量开启服务
         */
        $(document).on('click', '#startbtn', function () {
            var count = 0;            //记录是否存在需要开启的服务(假设所有服务都已开启，那么点击该按钮应该提示)
            var checkStatus = table.checkStatus('data-table');
            var data = checkStatus.data;
            var errorMsg = "";            //记录开启服务失败的信息
            if (data.length > 0) {
                for (var i = 0; i < data.length; i++) {
                    var serviceid = data[i].id;
                    var swicth = $('#' + serviceid);
                    if (!swicth.is(':checked')) {//这里需要判断该服务是否是关闭状态
                        count++;
                        var state = setServiceEnabled(serviceid, true);
                        if (!state) {
                            errorMsg += "[" + data[i].serviceName + "]";
                        }
                        else {
                            swicth.prop('checked', true);
                        }
                    }
                }
                if (count == 0) {
                    layer.msg("无需要开启的服务！");
                    return;
                }
                if (errorMsg != "") {
                    layer.msg(errorMsg + "服务开启失败！");
                }
                else {
                    layer.msg("所有服务开启成功！");
                }
            }
            else {
                layer.msg("请勾选需要开启的服务！");
            }
            form.render('checkbox');
        });
        /**
         * 批量关闭服务
         */
        $(document).on('click', '#stopbtn', function () {
            var count = 0;
            var checkStatus = table.checkStatus('data-table');
            var data = checkStatus.data;
            var errorMsg = "";
            if (data.length > 0) {
                for (var i = 0; i < data.length; i++) {
                    var serviceid = data[i].id
                    var swicth = $('#' + serviceid);
                    if (swicth.is(':checked')) {//这里需要判断该服务是否是开启状态
                        count++;
                        var state = setServiceEnabled(serviceid, false);
                        if (!state) {
                            errorMsg += "[" + data[i].serviceName + "]";
                        }
                        else {
                            swicth.prop('checked', false);
                        }
                    }
                }
                if (count == 0) {
                    layer.msg("无需要关闭的服务！");
                    return;
                }
                if (errorMsg != "") {
                    layer.msg(errorMsg + "服务关闭失败！");
                }
                else {
                    layer.msg("所有服务关闭成功！");
                }
            }
            else {
                layer.msg("请勾选需要关闭的服务！");
            }
            form.render('checkbox');
        });
        /**
         * 通过开关开启/关闭服务
         */
        form.on('switch(serviceswitch)', function (data) {
            var start;
            if (``) {
                start = true;
            } else {
                start = false;
            }
            var elem = data.elem;
            if (elem) {
                var id = elem.id;
                var state = setServiceEnabled(id, start);
                if (!state) {
                    if (start) {
                        $(this).prop('checked', false);
                        layer.msg("服务开启失败！");
                    }
                    else {
                        $(this).prop('checked', true);
                        layer.msg("服务关闭失败！");
                    }
                }
                else {
                    if (start) {
                        layer.msg("服务开启成功！");
                    }
                    else {
                        layer.msg("服务关闭成功！");
                    }
                }
                form.render('checkbox');
            }
        });
        /**
         * 监听表格里控件的点击事件
         */
        table.on('tool(data-table)', function (obj) {
            var data = obj.data;
            if (obj.event == 'del') {
                layer.confirm('确认删除' + data.serviceName + '？', function (index) {
                    var serviceId = data.id;
                    $.ajax({
                        type: 'POST',
                        url: '/gs/layer/delete',
                        data: {
                            "serviceId": serviceId,
                            "moduleCode": moduleCode,
                            "moduleName": moduleName,
                        },
                        success: function (data) {
                            var isdelete = data.data;
                            if (isdelete) {
                                obj.del();
                                layer.close(index);
                            }
                        },
                        error: function (e, state, errorThrown) {
                            console.log(e);
                        }
                    });
                });
            }
            else if (obj.event == 'edit') {
                showLayer("editdiv");
                $("#edit-form")[0].reset();
                form.val('edit-form', data);

                //初始化样式预览
                preview_state = "初始化";
                $.ajax({
                    url: "/gs/layerinfo",
                    type: "GET",
                    data: {
                        layerName: data.layerName
                    },
                    dataType: 'json',
                    async: false,
                    success: function (result) {
                        document.getElementById('img-mapstyle-edit').style.display = 'none';
                        document.getElementById('mapDiv-edit').style.display = 'block';

                        lookLayer_edit = result.data.name;
                        var centerX = ((Number(result.data.maxX) + Number(result.data.minX)) * 0.5).toFixed(2);
                        var centerY = ((Number(result.data.maxY) + Number(result.data.minY)) * 0.5).toFixed(2);
                        gsurl_edit = result.data.gsUrl;

                        if (map_edit == null) {
                            //预览样式
                            map_edit = new L.Map("mapDiv-edit", {
                                zoom: 5,
                                center: [centerY, centerX],
                                boxZoom: true,
                                attributionControl: false,
                                zoomControl: false
                            });
                        }else {
                            map_edit.flyTo([centerY, centerX],5);
                        }

                        map_edit.eachLayer(function (layer) {
                            layer.remove();
                        });

                        var wmsLayer = L.tileLayer.wms(gsurl_edit + "dw/wms?", {
                            layers: lookLayer_edit,//需要加载的图层'JHB_1562743355102'
                            format: 'image/png',//返回的数据格式
                            transparent: true,
                            styles: data.styleName
                        });
                        map_edit.addLayer(wmsLayer);
                    },
                    error: function (e, state, error) {
                        document.getElementById('img-mapstyle-edit').style.display = 'block';
                        document.getElementById('mapDiv-edit').style.display = 'none';
                        layer.msg("获取图层信息失败！");
                    }
                });

                var tags = data.tags;
                if (tags) {
                    layui.formSelects.value('edit-select-keywords', tags);
                }
                if (data.tables) {
                    $('#edit-dataresource').find("option[value='" + data.tables[0] + "']").prop("selected", true);
                    form.render('select');
                }
                $('#' + data.id).prop('checked', data.enable);
            }
            else if (obj.event == 'pre') {
                // showLayer(2);
                form.val('url-form', {
                    "url": data.baseUrl,
                })
                $('#copyurl').select();
                try {
                    if (document.execCommand("Copy", "false", null)) {
                        layer.msg("复制地址成功！");
                    } else {
                        layer.msg("复制地址失败！");
                    }
                } catch (err) {
                    layer.msg("复制错误！")
                }
            }
            else if (obj.event == 'author') {
                showLayer("authority");
                form.val('authority-form', {
                    "id": data.id,
                    "serviceName": data.serviceName,
                    "serviceUrl": data.baseUrl,
                })
                formSelects.value('select-user', []);
            }
            else if (obj.event == 'wms') {
                form.val('url-form', {
                    "url": data.wmsUrl
                });
                $('#copyurl').select();
                try {
                    if (document.execCommand("Copy", "false", null)) {
                        layer.msg("复制地址成功！");
                    } else {
                        layer.msg("复制地址失败！");
                    }
                } catch (err) {
                    layer.msg("复制错误！")
                }
            }
            else if (obj.event == 'wfs') {
                form.val('url-form', {
                    "url": data.wfsUrl
                });
                $('#copyurl').select();
                try {
                    if (document.execCommand("Copy", "false", null)) {
                        layer.msg("复制地址成功！");
                    } else {
                        layer.msg("复制地址失败！");
                    }
                } catch (err) {
                    layer.msg("复制错误！")
                }
            }
            else if (obj.event == 'wmts') {
                form.val('url-form', {
                    "url": data.wmtsUrl
                });
                $('#copyurl').select();
                try {
                    if (document.execCommand("Copy", "false", null)) {
                        layer.msg("复制地址成功！");
                    } else {
                        layer.msg("复制地址失败！");
                    }
                } catch (err) {
                    layer.msg("复制错误！")
                }
            }
        });

        /**
         * 模糊查询
         */
        $(document).on('click', '#search-btn', function () {
            keywords = $('#search-text').val();
            active['reload'].call(this);
        });
        $('#search-text').keyup(function (event) {
            if (event.keyCode == 13) {
                keywords = $('#search-text').val();
                active['reload'].call(this);
            }
        });
        /**
         * 复制服务地址
         */
        $(document).on('click', '#copybtn', function () {
            $('#copyurl').select();
            try {
                if (document.execCommand("Copy", "false", null)) {
                    layer.msg("复制成功！");
                } else {
                    layer.msg("复制失败！");
                }
            } catch (err) {
                layer.msg("复制错误！")
            }
            layer.close(urlIndex);
        });
        /**
         * 跳转到资源注册页面
         */
        $(document).on('click', '#registerbtn', function () {
            var checkStatus = table.checkStatus('data-table');
            var data = checkStatus.data;
            var errorMsg = "";
            if (data.length != 1) {
                layer.msg("请选择一个服务！");
                return;
            }
            var service = data[0];
            window.location.href = rootPath + '/yzy/yzyzc?id=' + service.id;
        });
        /**
         * 提交授权
         */
        form.on('submit(authority-submit)', function (data) {
            var param = data.field;
            var userNames = formSelects.value('select-user', 'nameStr');
            helper.saveAuthority(moduleName, moduleCode, param.id, userNames, "共享成功！");
            layer.close(layerIndex_authority);
            return false;
        });
        /**
         * 共享数据给其他人
         */
        $(document).on('click', '#sharebtn', function () {
            var checkStatus = table.checkStatus('data-table');
            var data = checkStatus.data;
            if (data.length > 0) {
                var ids = "", serviceNames = "", serviceUrls = "";
                for (var i = 0; i < data.length; i++) {
                    ids += data[i].id + ",";
                    serviceNames += data[i].serviceName + ",";
                    serviceUrls += data[i].baseUrl + ",";
                }
                serviceNames = serviceNames.substring(0, serviceNames.length - 1);
                serviceUrls = serviceUrls.substring(0, serviceUrls.length - 1);
                showLayer("authority");
                form.val('authority-form', {
                    "id": ids,
                    "serviceName": serviceNames,
                    "serviceUrl": serviceUrls,
                });
                formSelects.value('select-user', []);
            } else {
                layer.msg('请选择共享的数据！');
            }
        });
        /**
         * 切换公有/私有服务
         */
        $(document).on('click', '#li-public', function () {
            if (ownState == "public") {
                return;
            }
            $('#addbtn').hide();
            $('#deletebtn').hide();
            $('#startbtn').hide();
            $('#stopbtn').hide();
            $('#sharebtn').hide();
            $('#registerbtn').hide();
            $('#li-public').css('background-color', '#377BFE');
            $('#li-public').css('color', '#fff');
            $('#li-private').css('background-color', '#d2d2d2');
            $('#li-private').css('color', '#333');
            ownState = "public";
            active['reload'].call(this);
        })
        $(document).on('click', '#li-private', function () {
            if (ownState == "private") {
                return;
            }
            $('#addbtn').show();
            $('#deletebtn').show();
            $('#startbtn').show();
            $('#stopbtn').show();
            $('#sharebtn').show();
            $('#registerbtn').show();
            $('#li-private').css('background-color', '#377BFE');
            $('#li-private').css('color', '#fff');
            $('#li-public').css('background-color', '#d2d2d2');
            $('#li-public').css('color', '#333');
            ownState = "private";
            active['reload'].call(this);
        })


        //样式切换(新增)
        form.on('select(layerstyle)', function(data){
            if(document.getElementById('mapDiv').style.display == 'block' && lookLayer != null){
                map.eachLayer(function (layer) {
                    layer.remove();
                });

                var wmsLayer = L.tileLayer.wms(gsurl + "dw_temp/wms?", {
                    layers: lookLayer,//需要加载的图层'JHB_1562743355102'
                    format: 'image/png',//返回的数据格式
                    transparent: true,
                    styles: data.value
                });
                map.addLayer(wmsLayer);
            }
            // $.ajax({
            //     url: "/gs/publishedlayers",
            //     type: "GET",
            //     contentType: false,
            //     processData: false,
            //     async: false,
            //     success: function (result) {
            //         if (result.length == 0) {
            //             layer.msg("无可预览图层！");
            //             return;
            //         }
            //         var lookLayer = result.data[0].name;
            //
            //         $.ajax({
            //             url:'/gs/thumbnail',
            //             data: {
            //                 layerName : lookLayer,
            //                 styleName : data.value
            //                 // styleName : $('#add-layerstyle option:selected') .val()
            //             },
            //             type: 'POST',
            //             dataType: 'json',
            //             success:function(data){
            //                 $("#img-mapstyle").attr("src",data.data);
            //                 $("#img-editmapstyle").attr("src",data.data);
            //             }
            //         });
            //     },
            //     error: function (e, state, error) {
            //         layer.msg("获取图层预览失败！");
            //     }
            // });
        });

        //图层切换(新增)
        form.on('select(tableId)',function (data) {
            $("#img-mapstyle").attr("src",rootPath + "/images/mapdefault.png");
            document.getElementById('img-mapstyle').style.display = 'block';
            document.getElementById('mapDiv').style.display = 'none';

            map.eachLayer(function (layer) {
                layer.remove();
            });

            // map = null;
            // lookLayer = null;
            // centerX = null;
            // centerY = null;
            // gsurl = null;
        });

        //预览(新增)
        form.on('submit(bt-preview)', function (data) {
            var param = data.field;
            param.moduleCode = moduleCode;
            param.moduleName = moduleName;
            temppublish(param);

            if(publishMap==null){
                return false;
            }

            lookLayer = publishMap.name;
            var centerX = ((Number(publishMap.maxX) + Number(publishMap.minX)) * 0.5).toFixed(2);
            var centerY = ((Number(publishMap.maxY) + Number(publishMap.minY)) * 0.5).toFixed(2);
            gsurl = publishMap.gsUrl;

            var styleName = $('#add-layerstyle option:selected').val();

            // document.getElementById('div-img-add').style.marginLeft = '38px';
            document.getElementById('img-mapstyle').style.display = 'none';
            document.getElementById('mapDiv').style.display = 'block';

            if (map == null) {
                //预览样式
                map = new L.Map("mapDiv", {
                    zoom: 6,
                    center: [centerY, centerX],
                    boxZoom: true,
                    attributionControl: false,
                    zoomControl: false
                });
            }else {
                map.flyTo([centerY, centerX],5);
            }

            map.eachLayer(function (layer) {
                layer.remove();
            });

            var wmsLayer = L.tileLayer.wms(gsurl + "dw_temp/wms?", {
                layers: lookLayer,//需要加载的图层'JHB_1562743355102'
                format: 'image/png',//返回的数据格式
                transparent: true,
                styles: styleName
            });
            map.addLayer(wmsLayer);

            return false;
        });




        //样式切换(编辑)
        form.on('select(layerstyle-edit)', function(data){
            if(document.getElementById('mapDiv-edit').style.display == 'block' && lookLayer_edit != null){
                map_edit.eachLayer(function (layer) {
                    layer.remove();
                });

                var workspace_name = "dw_temp";
                if(preview_state == "初始化"){
                    workspace_name = "dw";
                }
                var wmsLayer = L.tileLayer.wms(gsurl_edit + workspace_name + "/wms?", {
                    layers: lookLayer_edit,//需要加载的图层'JHB_1562743355102'
                    format: 'image/png',//返回的数据格式
                    transparent: true,
                    styles: data.value
                });
                map_edit.addLayer(wmsLayer);
            }
        });

        //图层切换(编辑)
        form.on('select(tableId-edit)',function (data) {
            preview_state = "预发布";
            $("#img-mapstyle-edit").attr("src",rootPath + "/images/mapdefault1.png");
            document.getElementById('img-mapstyle-edit').style.display = 'block';
            document.getElementById('mapDiv-edit').style.display = 'none';

            map_edit.eachLayer(function (layer) {
                layer.remove();
            });
        });

        //预览(编辑)
        form.on('submit(bt-preview-edit)', function (data) {
            var param = data.field;
            param.moduleCode = moduleCode;
            param.moduleName = moduleName;
            temppublish(param);

            if(publishMap_edit==null){
                return false;
            }

            lookLayer_edit = publishMap_edit.name;
            var centerX = ((Number(publishMap_edit.maxX) + Number(publishMap_edit.minX)) * 0.5).toFixed(2);
            var centerY = ((Number(publishMap_edit.maxY) + Number(publishMap_edit.minY)) * 0.5).toFixed(2);
            gsurl_edit = publishMap_edit.gsUrl;

            var styleName = $('#edit-layerstyle option:selected').val();

            document.getElementById('img-mapstyle-edit').style.display = 'none';
            document.getElementById('mapDiv-edit').style.display = 'block';

            if (map_edit == null) {
                //预览样式
                map_edit = new L.Map("mapDiv-edit", {
                    zoom: 6,
                    center: [centerY, centerX],
                    boxZoom: true,
                    attributionControl: false,
                    zoomControl: false
                });
            }else {
                map_edit.flyTo([centerY, centerX],5);
            }

            map_edit.eachLayer(function (layer) {
                layer.remove();
            });

            var wmsLayer = L.tileLayer.wms(gsurl_edit + "dw_temp/wms?", {
                layers: lookLayer_edit,//需要加载的图层'JHB_1562743355102'
                format: 'image/png',//返回的数据格式
                transparent: true,
                styles: styleName
            });
            map_edit.addLayer(wmsLayer);

            return false;
        });





    }

    /**
     * 保存服务信息
     * @param param
     */
    var publish = function (param) {
        $.ajax({
            type: 'POST',
            url: '/gs/layer/publish',
            data: param,
            beforeSend: function () {
                layerIndex_waiting = helper.showLoad("正在新增服务...");
            },
            success: function (data) {
                helper.closeLoad(layerIndex_waiting);
                layer.msg("新增服务成功！");
                active['reload'].call(this);
                layer.close(layerIndex_add);
            },
            error: function (e, state, errorThrown) {
                console.log(e);
                helper.closeLoad(layerIndex_waiting);
                layer.msg("新增服务失败！");
            }
        });
    };

    var temppublish = function (param) {
        $.ajax({
            type: 'POST',
            url: '/gs/layer/temppublish',
            data: param,
            async: false,
            beforeSend: function () {
                layerIndex_waiting = helper.showLoad("正在预发布服务...");
            },
            success: function (data) {
                helper.closeLoad(layerIndex_waiting);
                publishMap = data.data;
                publishMap_edit = data.data;
            },
            error: function (e, state, errorThrown) {
                console.log(e);
                helper.closeLoad(layerIndex_waiting);
                publishMap = null;
                layer.msg("预发布服务失败！");
            }
        });
    };

    /**
     *  更新数据
     * @param param 修改的属性
     * @param tags 修改的标签
     */
    var updateData = function (param, tags) {
        var id = param.id;
        delete param.id;
        var attrs = JSON.stringify(param);
        $.ajax({
            type: 'POST',
            url: '/gs/layer/update',
            data: {
                "id": id,
                "attributes": attrs,
                "keywords": tags,
            },
            beforeSend: function () {
                layerIndex_waiting = helper.showLoad("正在修改服务信息...");
            },
            success: function (data) {
                helper.closeLoad(layerIndex_waiting);
                layer.msg("编辑服务成功！");
                active['reload'].call(this);
                layer.close(layerIndex_edit);
            },
            error: function (e, state, errorThrown) {
                console.log(e);
                helper.closeLoad(layerIndex_waiting);
                layer.msg("编辑服务失败！");
            }
        });

    }

    /**
     * 根据服务id设置服务的开启/关闭状态
     * @param id 服务id
     * @param state boolean，开启或关闭
     * @returns {*}
     */
    function setServiceEnabled(id, state) {
        var result;
        $.ajax({
            type: 'POST',
            url: '/gs/layer/enable',
            data: {
                serviceId: id,
                enable: state,
            },
            async: false,
            success: function (data) {
                if (data) {
                    if (data.code != 0) {
                        result = false;
                    }
                }
                result = true;
            },
            error: function (e, state, errorThrown) {
                console.log(e);
                result = false;
            }
        });
        return result;
    };
    /**
     * 弹出div函数实现
     * @param index
     */
    var showLayer = function (index) {
        if (index == 'adddiv') {
            layerIndex_add = layer.open({
                title: '新增服务信息',
                skin: 'to-fix-select',
                shadeClose: true,
                type: 1,
                area: ['800px'],
                maxHeight: 700,
                maxWidth: 1000,
                content: $('#add-div'),
            })
        }
        else if (index == 'editdiv') {
            layerIndex_edit = layer.open({
                title: '修改服务信息',
                shadeClose: true,
                skin: 'to-fix-select',
                type: 1,
                area: ['800px'],
                maxHeight: 700,
                maxWidth: 1000,
                content: $('#edit-div'),
            })
        }
        else if (index == "authority") {
            layerIndex_authority = layer.open({
                title: '共享服务',
                shadeClose: true,
                skin: 'to-fix-select',
                type: 1,
                area: ['700px'],
                maxHeight: 400,
                maxWidth: 1000,
                content: $('#authority-div'),
            })
        }
    }

    var active = {
        reload: function () {
            table.reload('data-table', {
                page: {
                    curr: currentPage,
                },
                where: {
                    keywords: keywords,
                    moduleCode: moduleCode,
                    ownState: ownState,
                }
            }, 'data');
        },
    };


})
