layui.config({base: "./js/"}).use(["element", "layer", "table", "form", "common_util", "upload", "tree"], function () {
    var $ = layui.jquery, table = layui.table, form = layui.form, elem = layui.element,
        layer = layui.layer, upload = layui.upload, common_util = layui.common_util,
        tree = layui.tree;
    var layerIndex_showLayer, searchCategory, searchInstanceName, taskTableIns, wordTableIns,
        currentNode = "",
        uploadIns, searchFileName, searchLayerName, searchResourceName;

    var parentNodes = [];

    $('#sideNav a').click(function () {
        elem.render();
    });

    $(".left-nav1").css("height", window.innerHeight - $(".new-header-box").outerHeight() + 5);
    $(".main-container").css("height", $(".left-nav1").outerHeight());
    $(".show-container").css("max-height", ($(".main-container").outerHeight() - $(".header-container").outerHeight()) - 15);
    init("我的信息");

    $(".div-personal .nav-personal .layui-nav-item").click(function () {
        if ($(this).find(".layui-nav-child").length > 0) {
            return false;
        }
        var name = $(this)[0].innerText;
        // name = name.substr(1, name.length - 1);
        init(name);
    });
    $(".div-personal .nav-personal .layui-nav-child dd").click(function () {
        var name = $(this)[0].innerText;
        name = name.substr(1, name.length - 1);
        init(name);
    });

    function init(tagName) {
        $(".cur-nav")[0].innerText = tagName;
        if (tagName == "修改信息") {
            tagName = editUser;
        }
        $(".header-title")[0].innerText = tagName;
        // $(".cur-nav")[0].innerText = tagName;
        var idName;
        if (tagName == "新建任务") {
            createTaskList();
        }
        else if (tagName == "待办任务") {
            createUpcomingTask();
        }
        else if (tagName == "已办任务") {
            createFinishTask();
        }
        else if (tagName == "我的文档") {
            currentNode = "";
            parentNodes = [];
            searchFileName = "";
            createWord();
            $("#input-fileName").val("");
        }
        else if (tagName == "我的信息") {
            createUserHtml();
        }
        else if (tagName == "数据申请") {
            createApplyTask();
        }
        else if (tagName == "数据审批") {
            createReviewTask();
        }
        else if (tagName == "资源申请") {
            createResourceApply();
        }
        else if (tagName == "资源审批") {
            createResourceReview();
        }
    };

    function createTaskList() {
        $.get("/personal/getProcessDefine").success(function (obj) {
            var data = obj.data;
            createTaskHtml(data);
            $(".task-tag").click(function () {
                showLayer("createTask");
                var id = this.id;
                var keyIndex = id.indexOf(":");
                var key = id.substr(0, keyIndex);
                var categoryName = this.attributes["proType"].value;
                var processDefName = this.attributes["proName"].value;
                var categoryKey = this.attributes["proNameKey"].value;
                $.get("/authority/currentUser").done(function (obj) {
                    var data = obj.data;
                    form.val("createTask-form", {
                        "id": id,
                        "key": key,
                        "categoryName": categoryName,
                        "processCatalogKey": categoryKey,
                        "processDefName": processDefName,
                        "startUserName": data.username,
                    })
                });
            });
        });
        form.on("submit(createTask-submit)", function (obj) {
            var data = obj.field;
            var data_json = {
                'processDefKey': data.key,
                'processDefId': data.id,
                'category': data.processCatalogKey,
                'processInstanceName': data.processInstanceName,
                'priority': data.priority,
                'workDayId': 'a8deac2e-7ce1-4896-b0bf-9d765ba0c3ce',
                'department': '',
                'procDueLimt': data.procDueLimt,
                'isPriority': 0,
                'desc': ''
            };
            $.ajax({
                type: "post",
                url: "/personal/startUpTask",
                data: data_json,
                success: function (obj) {
                    var data = obj.data;
                    if (data) {
                        layer.msg("任务创建成功！");
                    }
                    else {
                        layer.msg("任务创建失败！");
                    }
                }
            });
            return false;
        });
    };

    function createTaskHtml(data) {
        var mustachHtml = {};
        mustachHtml.params = data;
        mustachHtml.name = function () {
            return this.name;
        };
        var html = Mustache.render($("#newTask-script").html(), mustachHtml);
        $(".show-container").empty();
        $(".show-container").html(html);
    };

    function createUpcomingTask() {
        var html = $("#upcomingTask-script").html();
        $(".show-container").empty();
        $(".show-container").html(html);
        var maxHeight = $(".show-container").css("max-height");
        var tableHeight = maxHeight.substr(0, maxHeight.length - 2) - $(".item-top").height() - 10;
        taskTableIns = table.render({
            elem: '#task-table',
            url: '/personal/tasksundone',
            skin: 'line',
            height: tableHeight,
            even: true,
            // request: {
            //     pageName: 'page'
            //     , limitName: 'size'
            // },
            where: {
                category: searchCategory,
                instanceName: searchInstanceName
            },
            page: {
                layout: ['prev', 'page', 'next', 'limit', 'skip'],
                theme: '#1890FF',
            },
            limit: 10,
            cols: [[
                {
                    title: 'taskId', field: 'taskId', hide: true, templet: function (obj) {
                        return obj.taskId;
                    }
                },
                {
                    title: '项目名称', field: 'processInstanceName', templet: function (obj) {
                        return obj.processInstanceName;
                    }
                },
                {
                    title: '任务名称', field: 'taskName', templet: function (obj) {
                        return obj.taskName;
                    }
                },
                {
                    title: '流程名称', field: 'processDefName', templet: function (obj) {
                        return obj.processDefName;
                    }
                },
                {
                    title: '业务类型', field: 'category', hide: true, templet: function (obj) {
                        return obj.category;
                    }
                },
                {
                    title: '优先级', field: 'priorityName', templet: function (obj) {
                        return obj.priorityName;
                    }
                },
                {
                    title: '开始时间', field: 'startTime', templet: function (obj) {
                        return obj.startTime;
                    }
                },
                {
                    title: '超期状态', field: 'taskTimeoutStatusName', templet: function (obj) {
                        return obj.taskTimeoutStatusName;
                    }
                },
                {
                    title: '操作',
                    field: 'tool',
                    align: 'center',
                    width: '200',
                    style: 'cursor:pointer',
                    templet: "#undo-toolbar-script"
                },
            ]],
            done: function (res, curr, count) {
                table.resize('task-table');
            },
        });
        table.on("tool(task-table)", function (obj) {
            var data = obj.data;
            data = obj.data;
            event = obj.event;
            var taskId_ = data.taskId;
            var processInstanceId_ = data.processInstanceId;
            var processInstanceName_ = data.processInstanceName;
            var processDefName_ = data.processDefName;
            var delegation_ = data.delegation;
            var formKey_ = data.formKey;
            var state_ = data.state;
            var claimStatus_ = data.claimStatus;
            if (delegation_ == null) {
                delegation_ = "null";
            }
            var $layer = layer;
            if (event === 'track') {//流程跟踪
                showProcessDetail(taskId_, processInstanceId_, "todoTask", $layer);
            } else if (event === 'edit') {//办理任务
                taskHandler(taskId_, processInstanceId_, formKey_, state_, claimStatus_, processInstanceName_, false);
            } else if (event === "view") {
                taskHandler(taskId_, processInstanceId_, formKey_, state_, claimStatus_, processInstanceName_, true);
            } else if (event == "del") {
                layer.confirm('确认删除' + data.processInstanceName + '项目？', function (index) {
                    var id = data.taskId;
                    $.ajax({
                        type: 'POST',
                        url: '/personal/delete',
                        data: {
                            "taskId": id,
                        },
                        success: function (data) {
                            var isdelete = data.data;
                            if (isdelete) {
                                obj.del();
                                layer.msg("删除成功!");
                            }
                        },
                        error: function (e, state, errorThrown) {
                            layer.msg("删除失败!");
                            console.log(e);
                        }
                    });
                    layer.close(index);
                });
            }
        });
        $("#btn-search-undo").click(function (obj) {
            searchInstanceName = $("#processInsstanceName")[0].value;
            taskTableIns.reload({
                where: {
                    category: searchCategory,
                    layerName: searchInstanceName
                }
            });
        });
    };

    function createFinishTask() {
        var html = $("#finishTask-script").html();
        $(".show-container").empty();
        $(".show-container").html(html);
        var maxHeight = $(".show-container").css("max-height");
        var tableHeight = maxHeight.substr(0, maxHeight.length - 2) - $(".item-top").height() - 10;
        taskTableIns = table.render({
            elem: '#finishTask-table',
            url: '/personal/tasksFinish',
            skin: 'line',
            height: tableHeight,
            even: true,
            // request: {
            //     pageName: 'page'
            //     , limitName: 'size'
            // },
            where: {
                category: searchCategory,
                instanceName: searchInstanceName
            },
            page: {
                layout: ['prev', 'page', 'next', 'limit', 'skip'],
                theme: '#1890FF',
            },
            limit: 10,
            cols: [[
                {
                    title: 'taskId', field: 'taskId', hide: true, templet: function (obj) {
                        return obj.taskId;
                    }
                },
                {
                    title: '项目名称', field: 'processInstanceName', templet: function (obj) {
                        return obj.processInstanceName;
                    }
                },
                {
                    title: '任务名称', field: 'taskName', templet: function (obj) {
                        return obj.taskName;
                    }
                },
                {
                    title: '流程名称', field: 'processDefName', templet: function (obj) {
                        return obj.processDefName;
                    }
                },
                {
                    title: '业务类型', field: 'category', hide: true, templet: function (obj) {
                        return obj.category;
                    }
                },
                {
                    title: '优先级', field: 'priorityName', templet: function (obj) {
                        return obj.priorityName;
                    }
                },
                {
                    title: '开始时间', field: 'startTime', templet: function (obj) {
                        return obj.startTime;
                    }
                },
                {
                    title: '超期状态', field: 'taskTimeoutStatusName', templet: function (obj) {
                        return obj.taskTimeoutStatusName;
                    }
                },
                {
                    title: '操作',
                    field: 'tool',
                    align: 'center',
                    width: '150',
                    style: 'cursor:pointer',
                    templet: "#finish-toolbar-script"
                },
            ]],
            done: function (res, curr, count) {
                table.resize('finishTask-table');
            },
        });
        table.on('tool(finishTask-table)', function (obj) {
            data = obj.data;
            event = obj.event;
            var taskId_ = data.taskId;
            var processInstanceId_ = data.processInstanceId;
            var processDefName_ = data.processDefName;
            var processInstanceName = data.processInstanceName;
            var delegation_ = data.delegation;
            var formKey_ = data.formKey;
            var state_ = data.state;
            var claimStatus_ = data.claimStatus;
            var $layer = layer;
            if (event === 'retrieve') {
                fetchBack(table, taskId_);
            } else if (event === 'view') {
                taskHandler(taskId_, processInstanceId_, formKey_, state_, claimStatus_, processInstanceName, true);
            } else if (event === 'track') {
                showProcessDetail(taskId_, processInstanceId_, "completeTask", $layer);
            }
        });
    };

    function createWord() {
        var html = $("#storage-script").html();
        $(".show-container").empty();
        $(".show-container").html(html);
        var maxHeight = $(".show-container").css("max-height");
        var tableHeight = maxHeight.substr(0, maxHeight.length - 2) - $(".item-top").height() - 10;
        wordTableIns = table.render({
            elem: '#file-table',
            url: '/personal/listfiles?&clientId=' + clientId,
            skin: 'line',
            height: tableHeight,
            even: true,
            where: {
                fileName: searchFileName,
                nodeId: currentNode,
            },
            page: {
                layout: ['prev', 'page', 'next', 'limit', 'skip'],
                theme: '#1890FF',
            },
            limit: 10,
            cols: [[
                {type: 'checkbox'},
                {
                    title: 'id', field: 'id', hide: true, templet: function (obj) {
                        return obj.id;
                    }
                },
                {
                    title: '文件', width: '40%', templet: function (obj) {
                        var imgSrc = (obj.type == 0) ? rootPath + "/images/file/folder.png" : getFileImgUrl(obj.name);
                        var imgElement = '<img src="' + imgSrc + '">';
                        var nameElement = '<span>' + obj.name + '</span>';
                        var _class = (obj.type == 0) ? "folder" : "";
                        return '<span title="' + obj.name + '" id="' + obj.id + '" class="table-name ' + _class + '">' + imgElement + nameElement + '</span>';
                    }
                },
                {
                    title: '大小', templet: function (obj) {
                        if (obj.type != null && obj.type != 0 && obj.fileSize != null && obj.fileSize != undefined) {
                            return getFileSize(obj.fileSize);
                        } else {
                            return "-";
                        }
                    }
                }
                , {field: 'updateAt', title: '修改日期'}
            ]],
            done: function (res, curr, count) {
                $(".folder").click(function () {
                    searchFileName = "";
                    $("#input-fileName").val("");
                    parentNodes[parentNodes.length] = currentNode;
                    currentNode = $(this).attr("id");
                    wordTableIns.reload({
                        where: {
                            fileName: searchFileName,
                            nodeId: currentNode,
                        },
                    });
                    $("#btn-return").show();
                });
                // $(".viewer").click(function(){
                //     view($(this).attr("viewAccess"), $(this).attr("id"), null, $(this).attr("title"));
                // });
            }
        });
        uploadIns = upload.render({
            elem: '#btn-upload'
            , method: 'post'
            , url: '/personal/upload'
            , data: {
                nodeId: function () {
                    return currentNode;
                },
                clientId: clientId,
            }
            , accept: 'file'
            , multiple: true
            , auto: true
            // ,bindAction: '#testListAction'
            , before: function (obj) {
                i = helper.showLoad("正在上传...");
            }
            , allDone: function (obj) {
                helper.closeLoad(i);
                setTimeout(function () {
                    if (obj.aborted == 0) {
                        layer.msg('上传成功');
                    }
                    //layer.msg("共上传" + obj.total + "个文件，成功上传" + obj.successful + "个，失败" + obj.aborted + "个");
                }, 300);
            }, done: function (res, index, upload) {
                wordTableIns.reload();
            }, error: function (index, upload) {
                layer.msg('上传失败', {icon: 2});
            }
        });
        $("#btn-newDir").click(function () {
            showLayer("createNewFolder");
            $("#btn-folder-cancel").click(function () {
                layer.close(layerIndex_showLayer);
            });
        })
        form.on("submit(createFolder-submit)", function (obj) {
            var field = obj.field;
            var name = field.name;
            if (common_util.isBlank(name)) {
                layer.msg("文件夹名称不能为空");
                return false;
            }
            var exist = validExist(currentNode, name, 0);
            if (!exist) {
                addFolder(currentNode, name, layerIndex_showLayer);
            }
            return false;
        });
        $("#btn-download").click(function () {
            var checkStatus = table.checkStatus('file-table')
                , data = checkStatus.data;
            if (common_util.isArrayEmpty(data)) {
                layer.msg("请勾选文件");
                return;
            }
            var idParam = "";
            for (var i = 0; i < data.length; i++) {
                idParam += "&id=" + data[i].id;
            }
            window.open(storageServerPath + "/rest/files/zip/download?sId=" + idParam);
        });
        $("#btn-delete").click(function () {
            var checkStatus = table.checkStatus('file-table')
                , data = checkStatus.data;
            if (data == null || data == undefined || data.length == 0) {
                layer.msg("请勾选文件");
                return;
            }
            var ids = new Array();
            for (var i = 0; i < data.length; i++) {
                ids.push(data[i].id);
            }
            $.ajax({
                type: "post",
                data: {"ids": JSON.stringify(ids)},
                url: '/personal/deletefiles',
                success: function (data) {
                    if (data != null && data != undefined && data != "") {
                        wordTableIns.reload();
                        layer.msg("删除成功!");
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg("删除失败！");
                }
            });
        });
        $("#btn-return").click(function () {
            searchFileName = "";
            $("#input-fileName").val("");
            currentNode = parentNodes[parentNodes.length - 1];
            wordTableIns.reload({
                where: {
                    fileName: searchFileName,
                    nodeId: currentNode,
                },
            });
            parentNodes.splice(parentNodes.length - 1, 1);
            if (parentNodes.length == 0) {
                $("#btn-return").hide();
            }
        });
        $("#btn-search").click(function () {
            searchFileName = $("#input-fileName").val();
            wordTableIns.reload({
                where: {
                    fileName: searchFileName,
                    nodeId: currentNode,
                },
            });
        })
    };

    function createApplyTask() {
        var html = $("#apply-script").html();
        var state = "0";
        $(".show-container").empty();
        $(".show-container").html(html);
        var maxHeight = $(".show-container").css("max-height");
        var tableHeight = maxHeight.substr(0, maxHeight.length - 2) - $(".item-top").height() - 10;
        taskTableIns = table.render({
            elem: '#apply-table',
            url: '/personal/queryApply',
            skin: 'line',
            height: tableHeight,
            even: true,
            where: {
                layerName: searchLayerName,
                state: state
            },
            page: {
                layout: ['prev', 'page', 'next', 'limit', 'skip'],
                theme: '#1890FF',
            },
            limit: 10,
            cols: [[
                {
                    title: 'id', field: 'id', hide: true, templet: function (obj) {
                        return obj.id;
                    }
                },
                {
                    title: 'processInsId',
                    field: 'processInsId',
                    hide: true,
                    templet: function (obj) {
                        return obj.processInsId;
                    }
                },
                {
                    title: '数据名称', field: 'layerName', templet: function (obj) {
                        return obj.layerName;
                    }
                },
                {
                    title: '申请时间', field: 'time', templet: function (obj) {
                        return obj.time;
                    }
                },
                {
                    title: '申请人', field: 'userName', templet: function (obj) {
                        return obj.userName;
                    }
                },
                {
                    title: '申请理由', field: 'reason', templet: function (obj) {
                        return obj.reason;
                    }
                },
                {
                    title: '状态', field: 'state', templet: function (obj) {
                        if (state === "0") {
                            return "审核中";
                        } else if (state === "true") {
                            return "已通过";
                        } else if (state === "false") {
                            return "未通过";
                        }
                    }
                },
                {
                    title: '操作',
                    field: 'tool',
                    align: 'center',
                    width: '200',
                    style: 'cursor:pointer',
                    templet: function (obj) {
                        if (state === "true") {
                            return $('#apply-tool-script2').html();
                        } else {
                            return $('#apply-tool-script1').html();
                        }
                    }
                },
            ]],
            done: function (res, curr, count) {
                table.resize('apply-table');
            },
        });
        $('#search-btn').click(function () {
            searchLayerName = $("#search-apply").val();
            taskTableIns.reload({
                where: {
                    layerName: searchLayerName,
                    state: state,
                },
            });
        });
        $('#search-apply').keyup(function (event) {
            if (event.keyCode == 13) {
                searchLayerName = $('#search-apply').val();
                taskTableIns.reload({
                    where: {
                        layerName: searchLayerName,
                        state: state,
                    },
                });
            }
        });
        $('#li-review').click(function () {
            var $this = $(this);
            var $lipass = $('#li-pass');
            var $linopass = $('#li-nopass');
            $this.css('background-color', '#377BFE');
            $lipass.css('background-color', '#fff');
            $linopass.css('background-color', '#fff');
            $this.css('color', '#fff');
            $lipass.css('color', '#333');
            $linopass.css('color', '#333');
            state = '0';
            taskTableIns.reload({
                where: {
                    layerName: searchLayerName,
                    state: state,
                },
            });
        });
        $('#li-pass').click(function () {
            var $this = $(this);
            var $lireview = $('#li-review');
            var $linopass = $('#li-nopass');
            $this.css('background-color', '#377BFE');
            $lireview.css('background-color', '#fff');
            $linopass.css('background-color', '#fff');
            $this.css('color', '#fff');
            $lireview.css('color', '#333');
            $linopass.css('color', '#333');
            state = 'true';
            taskTableIns.reload({
                where: {
                    layerName: searchLayerName,
                    state: state,
                },
            });
        });
        $('#li-nopass').click(function () {
            var $this = $(this);
            var $lireview = $('#li-review');
            var $lipass = $('#li-pass');
            $this.css('background-color', '#377BFE');
            $lireview.css('background-color', '#fff');
            $lipass.css('background-color', '#fff');
            $this.css('color', '#fff');
            $lireview.css('color', '#333');
            $lipass.css('color', '#333');
            state = 'false';
            taskTableIns.reload({
                where: {
                    layerName: searchLayerName,
                    state: state,
                },
            });
        });
        table.on('tool(apply-table)', function (obj) {
            var data = obj.data;
            if (obj.event == 'view') {
                var processInsId = data.processInsId;
                layer.open({
                    type: 2,
                    title: '申请信息',
                    area: ['1000px', '440px'],
                    content: rootPath + '/dw/form-download?ywbsId=' + processInsId + '&state=1',
                })
            } else if (obj.event == 'download') {
                var tableId = data.tableId;
                var a = document.createElement('a');
                a.href = datastorePath + '/export/shp?tableId=' + tableId;
                a.click();
            }
        })
    };

    function createReviewTask() {
        var html = $("#review-script").html();
        var state = "0";
        $(".show-container").empty();
        $(".show-container").html(html);
        var maxHeight = $(".show-container").css("max-height");
        var tableHeight = maxHeight.substr(0, maxHeight.length - 2) - $(".item-top").height() - 10;
        taskTableIns = table.render({
            elem: '#review-table',
            url: '/personal/queryReview',
            skin: 'line',
            height: tableHeight,
            even: true,
            where: {
                layerName: searchLayerName,
                state: state
            },
            page: {
                layout: ['prev', 'page', 'next', 'limit', 'skip'],
                theme: '#1890FF',
            },
            limit: 10,
            cols: [[
                {
                    title: 'id', field: 'id', hide: true, templet: function (obj) {
                        return obj.id;
                    }
                },
                {
                    title: 'processInsId',
                    field: 'processInsId',
                    hide: true,
                    templet: function (obj) {
                        return obj.processInsId;
                    }
                },
                {
                    title: '数据名称', field: 'layerName', templet: function (obj) {
                        return obj.layerName;
                    }
                },
                {
                    title: '申请时间', field: 'time', templet: function (obj) {
                        return obj.time;
                    }
                },
                {
                    title: '申请人', field: 'userName', templet: function (obj) {
                        return obj.userName;
                    }
                },
                {
                    title: '申请理由', field: 'reason', templet: function (obj) {
                        return obj.reason;
                    }
                },
                {
                    title: '状态', field: 'state', templet: function (obj) {
                        if (state === "0") {
                            return "审核中";
                        } else if (state === "true") {
                            return "已通过";
                        } else if (state === "false") {
                            return "未通过";
                        }
                    }
                },
                {
                    title: '操作',
                    field: 'tool',
                    align: 'center',
                    width: '200',
                    style: 'cursor:pointer',
                    templet: function (obj) {
                        if (state === "0") {
                            return $('#review-tool-script1').html();
                        } else {
                            return $('#review-tool-script2').html();
                        }
                    }
                },
            ]],
            done: function (res, curr, count) {
                table.resize('review-table');
            },
        });
        $('#search-btn').click(function () {
            searchLayerName = $("#search-review").val();
            taskTableIns.reload({
                where: {
                    layerName: searchLayerName,
                    state: state,
                },
            });
        });
        $('#search-review').keyup(function (event) {
            if (event.keyCode == 13) {
                searchLayerName = $('#search-review').val();
                taskTableIns.reload({
                    where: {
                        layerName: searchLayerName,
                        state: state,
                    },
                });
            }
        });
        $('#li-undo').click(function () {
            var $this = $(this);
            var $lidone = $('#li-done');
            $this.css('background-color', '#377BFE');
            $lidone.css('background-color', '#fff');
            $this.css('color', '#fff');
            $lidone.css('color', '#333');
            state = '0';
            taskTableIns.reload({
                where: {
                    layerName: searchLayerName,
                    state: state,
                },
            });
        });
        $('#li-done').click(function () {
            var $this = $(this);
            var $liundo = $('#li-undo');
            $this.css('background-color', '#377BFE');
            $liundo.css('background-color', '#fff');
            $this.css('color', '#fff');
            $liundo.css('color', '#333');
            state = 'true';
            taskTableIns.reload({
                where: {
                    layerName: searchLayerName,
                    state: state,
                },
            });
        });
        table.on('tool(review-table)', function (obj) {
            var data = obj.data;
            var processInsId = data.processInsId;
            if (obj.event == 'operation') {
                layer.open({
                    type: 2,
                    title: '申请信息',
                    area: ['1000px', '550px'],
                    content: rootPath + '/dw/form-download?ywbsId=' + processInsId,
                })
            } else if (obj.event == 'view') {
                layer.open({
                    type: 2,
                    title: '申请信息',
                    area: ['1000px', '440px'],
                    content: rootPath + '/dw/form-download?ywbsId=' + processInsId + '&state=1',
                })
            }
        })
    };

    function createResourceApply() {
        var html = $("#resourceApply-script").html();
        var state = "uncheck";
        $(".show-container").empty();
        $(".show-container").html(html);
        var maxHeight = $(".show-container").css("max-height");
        var tableHeight = maxHeight.substr(0, maxHeight.length - 2) - $(".item-top").height() - 10;
        searchResourceName = '';
        taskTableIns = table.render({
            elem: '#resourceApply-table',
            url: '/yzy/apply/query',
            skin: 'line',
            height: tableHeight,
            even: true,
            where: {
                resourceName: searchResourceName,
                state: state
            },
            page: {
                layout: ['prev', 'page', 'next', 'limit', 'skip'],
                theme: '#1890FF',
            },
            limit: 10,
            cols: [[
                {
                    title: 'id', field: 'id', hide: true, templet: function (obj) {
                        return obj.id;
                    }
                },
                {
                    title: 'processId',
                    field: 'processId',
                    hide: true,
                    templet: function (obj) {
                        return obj.processId;
                    }
                },
                {
                    title: '资源名称', field: 'title', templet: function (obj) {
                        return obj.title;
                    }
                },
                {
                    title: '资源描述', field: 'description', templet: function (obj) {
                        return obj.description;
                    }
                },
                {
                    title: '申请时间', field: 'time', templet: function (obj) {
                        var time = obj.createAt.toString();
                        var index = time.indexOf(' ');
                        return index == -1 ? time : time.substring(0, index);
                    }
                },
                {
                    title: '申请人', field: 'userName', templet: function (obj) {
                        return obj.applicantName;
                    }
                },
                {
                    title: '申请理由', field: 'reason', templet: function (obj) {
                        return obj.applyReason;
                    }
                },
                {
                    title: '状态', field: 'state', templet: function (obj) {
                        if (state === "uncheck") {
                            return "审核中";
                        } else if (state === "pass") {
                            return "已通过";
                        } else if (state === "nopass") {
                            return "未通过";
                        }
                    }
                },
                {
                    title: '操作',
                    field: 'tool',
                    align: 'center',
                    width: '200',
                    style: 'cursor:pointer',
                    templet: function (obj) {
                        return $('#apply-tool-script1').html();
                    }
                },
            ]],
            done: function (res, curr, count) {
                table.resize('resourceApply-table');
            },
        });
        $('#search-btn').click(function () {
            searchResourceName = $("#search-apply").val();
            taskTableIns.reload({
                where: {
                    resourceName: searchResourceName,
                    state: state,
                },
            });
        });
        $('#search-apply').keyup(function (event) {
            if (event.keyCode == 13) {
                searchResourceName = $('#search-apply').val();
                taskTableIns.reload({
                    where: {
                        resourceName: searchResourceName,
                        state: state,
                    },
                });
            }
        });
        $('#li-review').click(function () {
            var $this = $(this);
            var $lipass = $('#li-pass');
            var $linopass = $('#li-nopass');
            $this.css('background-color', '#377BFE');
            $lipass.css('background-color', '#fff');
            $linopass.css('background-color', '#fff');
            $this.css('color', '#fff');
            $lipass.css('color', '#333');
            $linopass.css('color', '#333');
            state = 'uncheck';
            taskTableIns.reload({
                where: {
                    resourceName: searchResourceName,
                    state: state,
                },
            });
        });
        $('#li-pass').click(function () {
            var $this = $(this);
            var $lireview = $('#li-review');
            var $linopass = $('#li-nopass');
            $this.css('background-color', '#377BFE');
            $lireview.css('background-color', '#fff');
            $linopass.css('background-color', '#fff');
            $this.css('color', '#fff');
            $lireview.css('color', '#333');
            $linopass.css('color', '#333');
            state = 'pass';
            taskTableIns.reload({
                where: {
                    resourceName: searchResourceName,
                    state: state,
                },
            });
        });
        $('#li-nopass').click(function () {
            var $this = $(this);
            var $lireview = $('#li-review');
            var $lipass = $('#li-pass');
            $this.css('background-color', '#377BFE');
            $lireview.css('background-color', '#fff');
            $lipass.css('background-color', '#fff');
            $this.css('color', '#fff');
            $lireview.css('color', '#333');
            $lipass.css('color', '#333');
            state = 'nopass';
            taskTableIns.reload({
                where: {
                    resourceName: searchResourceName,
                    state: state,
                },
            });
        });
        table.on('tool(resourceApply-table)', function (obj) {
            var data = obj.data;
            if (obj.event == 'view') {
                layer.open({
                    type: 1,
                    title: '申请信息',
                    area: ['1000px', '440px'],
                    content: $('#resource-form-script').html(),
                });
                var time = data.createAt.toString();
                var index = time.indexOf(' ');
                time = index == -1 ? time : time.substring(0, index);
                $('[name=userName]').val(data.applicantName);
                $('[name=resourceName]').val(data.title);
                $('[name=time]').val(time);
                $('[name=reason]').val(data.applyReason);
                $('#div-download-title').hide();
                $('#div-download-check').hide();
                $('#div-download-execute').hide();
                form.render();
            }
        })
    };

    function createResourceReview() {
        searchResourceName = "";
        var selectApply;
        var html = $("#resourceReview-script").html();
        var state = "undo";
        $(".show-container").empty();
        $(".show-container").html(html);
        var maxHeight = $(".show-container").css("max-height");
        var tableHeight = maxHeight.substr(0, maxHeight.length - 2) - $(".item-top").height() - 10;
        taskTableIns = table.render({
            elem: '#review-table',
            url: '/yzy/apply/review',
            skin: 'line',
            height: tableHeight,
            even: true,
            where: {
                resourceName: searchResourceName,
                state: state
            },
            page: {
                layout: ['prev', 'page', 'next', 'limit', 'skip'],
                theme: '#1890FF',
            },
            limit: 10,
            cols: [[
                {
                    title: 'id', field: 'id', hide: true, templet: function (obj) {
                        return obj.id;
                    }
                },
                {
                    title: 'processId',
                    field: 'processId',
                    hide: true,
                    templet: function (obj) {
                        return obj.processId;
                    }
                },
                {
                    title: '资源名称', field: 'title', templet: function (obj) {
                        return obj.title;
                    }
                },
                {
                    title: '资源描述', field: 'description', templet: function (obj) {
                        return obj.description;
                    }
                },
                {
                    title: '申请时间', field: 'time', templet: function (obj) {
                        var time = obj.createAt.toString();
                        var index = time.indexOf(' ');
                        return index == -1 ? time : time.substring(0, index);
                    }
                },
                {
                    title: '申请人', field: 'userName', templet: function (obj) {
                        return obj.applicantName;
                    }
                },
                {
                    title: '申请理由', field: 'reason', templet: function (obj) {
                        return obj.applyReason;
                    }
                },
                {
                    title: '状态', field: 'state', templet: function (obj) {
                        if (state === "undo") {
                            return "未审核";
                        } else if (state === "done") {
                            return "已审核";
                        }
                    }
                },
                {
                    title: '操作',
                    field: 'tool',
                    align: 'center',
                    width: '200',
                    style: 'cursor:pointer',
                    templet: function (obj) {
                        if (state === "undo") {
                            return $('#review-tool-script1').html();
                        } else {
                            return $('#review-tool-script2').html();
                        }
                    }
                },
            ]],
            done: function (res, curr, count) {
                table.resize('review-table');
            },
        });
        $('#search-btn').click(function () {
            searchResourceName = $("#search-review").val();
            taskTableIns.reload({
                where: {
                    resourceName: searchResourceName,
                    state: state,
                },
            });
        });
        $('#search-review').keyup(function (event) {
            if (event.keyCode == 13) {
                searchResourceName = $('#search-review').val();
                taskTableIns.reload({
                    where: {
                        resourceName: searchResourceName,
                        state: state,
                    },
                });
            }
        });
        $('#li-undo').click(function () {
            var $this = $(this);
            var $lidone = $('#li-done');
            $this.css('background-color', '#377BFE');
            $lidone.css('background-color', '#fff');
            $this.css('color', '#fff');
            $lidone.css('color', '#333');
            state = 'undo';
            taskTableIns.reload({
                where: {
                    resourceName: searchResourceName,
                    state: state,
                },
            });
        });
        $('#li-done').click(function () {
            var $this = $(this);
            var $liundo = $('#li-undo');
            $this.css('background-color', '#377BFE');
            $liundo.css('background-color', '#fff');
            $this.css('color', '#fff');
            $liundo.css('color', '#333');
            state = 'done';
            taskTableIns.reload({
                where: {
                    resourceName: searchResourceName,
                    state: state,
                },
            });
        });
        table.on('tool(review-table)', function (obj) {
            var data = obj.data;
            var processInsId = data.processInsId;
            if (obj.event == 'operation') {
                selectApply = data;
                var layerReview = layer.open({
                    type: 1,
                    title: '审批信息',
                    area: ['1000px', '440px'],
                    content: $('#resource-form-script').html(),
                });
                form.render();
                var time = data.createAt.toString();
                var index = time.indexOf(' ');
                time = index == -1 ? time : time.substring(0, index);
                $('[name=id]').val(data.id);
                $('[name=userName]').val(data.applicantName);
                $('[name=resourceName]').val(data.title);
                $('[name=time]').val(time);
                $('[name=reason]').val(data.applyReason);

                $(document).on('click', '#btn-OK', function () {
                    var check = $('input[name=radio-result]:checked').val();
                    var state = '';
                    if (check === 'true') {
                        state = "agree";
                    }
                    $.post('/yzy/apply/check', {
                        'params': JSON.stringify(selectApply),
                        'state': state
                    }).then(
                        function (obj) {
                            if (obj.data) {
                                layer.close(layerReview);
                                layer.msg("审批成功！");
                                taskTableIns.reload({
                                    where: {
                                        resourceName: searchResourceName,
                                        state: state,
                                    },
                                });
                            } else {
                                layer.msg("审批失败！");
                            }
                        },
                        function (obj) {
                            return layer.msg("审批失败！");
                        }
                    );
                });
            } else if (obj.event == 'view') {
                layer.open({
                    type: 1,
                    title: '审批信息',
                    area: ['1000px', '440px'],
                    content: $('#resource-form-script').html(),
                });
                var time = data.createAt.toString();
                var index = time.indexOf(' ');
                time = index == -1 ? time : time.substring(0, index);
                $('[name=userName]').val(data.applicantName);
                $('[name=resourceName]').val(data.title);
                $('[name=time]').val(time);
                $('[name=reason]').val(data.applyReason);
                $('[name=reason]').attr('readonly', true);
                $('#div-download-title').hide();
                $('#div-download-check').hide();
                $('#div-download-execute').hide();
                form.render('radio');
            }
            form.render();
        });
    }

    function showProcessDetail(taskId, processInstanceId, imgType, $layer) {
        var index = $layer.open({
            type: 2,
            title: '流程详情页面',
            shadeClose: true,
            shade: false,
            maxmin: false, //开启最大化最小化按钮
            area: ['1400px', '750px'],
            content: bpmPath + "process/processDetail/" + processInstanceId
        });
        $layer.full(index);
    };

    function taskHandler(taskId, processInstanceId, formKey, state, claimStatus, processInstanceName, disable) {
        var url = bpmPath + "task/" + taskId + "/openFormPage?processInstanceId=" + processInstanceId
            + "&formKey=" + formKey + "&state=" + state + "&claimStatus=" + claimStatus + "&processInstanceName="
            + processInstanceName + "&disable=" + disable;
        openWindow(url, processInstanceName);
    };

    function openWindow(url, processInstanceName) {
        var elem = $(".layui-this");
        var fulls = "left=0,screenX=0,top=0,screenY=0,scrollbars=1";    //定义弹出窗口的参数
        if (window.screen) {
            var ah = screen.availHeight - 30;
            var aw = screen.availWidth - 10;
            fulls += ",height=" + ah;
            fulls += ",innerHeight=" + ah;
            fulls += ",width=" + aw;
            fulls += ",innerWidth=" + aw;
            fulls += ",resizable"
        } else {
            fulls += ",resizable"; // 对于不支持screen属性的浏览器，可以手工进行最大化。 manually
        }

        // var winObj = window.open(url,processDefName + processInstanceName + '-审批页面',fulls);
        var winObj = window.open(url, processInstanceName + '-审批页面', fulls);

        var loop = setInterval(function () {
            if (winObj != null && winObj.closed) {
                clearInterval(loop);
                // parent.location.reload();
                elem.click();
            }
        }, 1);
    };

    function fetchBack(table, taskId) {
        $.ajax({
            url: "/personal/fetchback",
            async: false,
            type: "post",
            dataType: 'json',
            data: {"taskId": taskId},
            success: function (data) {
                if (data.code == 0) {
                    layer.msg("取回成功！")
                    taskTableIns.reload();
                } else {
                    layer.msg(data.msg)
                }

            },
            beforeSend: function (XMLHttpRequest) {
                console.log(this);
                layer.msg("正在取回...");
            },
            // complete: function (XMLHttpRequest, textStatus) {
            //     if (textStatus == 'timeout') {
            //         var xmlhttp = window.XMLHttpRequest ? new window.XMLHttpRequest() : new ActiveXObject("Microsoft.XMLHttp");
            //         xmlhttp.abort();
            //         layer.msg("网络超时!");
            //     }
            // },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                // console.log(XMLHttpRequest);  //XMLHttpRequest.responseText    XMLHttpRequest.status   XMLHttpRequest.readyState  
                // console.log(textStatus);
                // if (textStatus == "timeout") {
                //     layer.msg("请求超时!");
                // } else if (textStatus == "notmodified") {
                //     layer.msg("客户端已经执行了POST，但文件未变化!");
                // } else if (textStatus == "parsererror") {
                //     layer.msg("解析器错误!");
                // } else if (XMLHttpRequest.responseJSON != null || XMLHttpRequest.responseJSON != undefined &&
                //     XMLHttpRequest.responseJSON.message != null || XMLHttpRequest.responseJSON.message != undefined && XMLHttpRequest.responseJSON.message != "") {
                //     alert(XMLHttpRequest.responseJSON.message);
                // } else {
                layer.msg("取回失败");
                // }
            }
        });
        /*$.ajax({
            url: bpmUiPath + '/ui/v1/process-tasks/' + taskId + "/fallback",
            async: false,
            type: "GET",
            dataType: 'json',
            data: {},
            success: function (data) {

                if(data.result == "true"){
                    // window.parent.location.reload();
                    reloadTable(table,path);
                    layer.msg(data.message);
                }else{
                    layer.msg(data.message);
                }
            }
        });*/
    };

    function getFileImgUrl(fileName) {
        var name = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        if (name == 'png' || name == "jpeg" || name == "gif" || name == "bmp" || name == "jpg") {
            return rootPath + '/images/file/picture.png';
        }
        if (name == 'doc' || name == "docx") {
            return rootPath + '/images/file/doc.png';
        }
        if (name == "pdf") {
            return rootPath + '/images/file/pdf.png';
        }
        if (name == "txt") {
            return rootPath + '/images/file/txt.png';
        }
        if (name == "ppt" || name == "pptx") {
            return rootPath + '/images/file/ppt.png';
        }
        if (name == "xls" || name == "xlsx") {
            return rootPath + '/images/file/xls.png';
        }
        if (name == "mp3" || name == "ac3" || name == "wav" || name == "m4a" || name == "wma" || name == "aac" || name == "ape" || name == "swk") {
            return rootPath + '/images/file/music.png';
        }

        if (name == "mp4" || name == "mov" || name == "mkv" || name == "avi" || name == "wmv" || name == "m4v" || name == "mpeg" || name == "ogv" || name == "3gp" || name == "flv" || name == "f4v" || name == "swf") {
            return rootPath + '/images/file/video.png';
        }

        if (name == "zip" || name == "rar" || name == "7z" || name == "rar" || name == "gz" || name == "tar" || name == "gtar" || name == "bz2") {
            return rootPath + '/images/file/zip.png';
        }
        return rootPath + '/images/file/other.png';
    };

    function getFileSize(fileSize) {
        var size = fileSize / 1024;
        if (size < 1024) {
            return size.toFixed(2) + "KB";
        }
        size = size / 1024;
        if (size < 1024) {
            return size.toFixed(2) + "M";
        }
        size = size / 1024;
        return size.toFixed(2) + "G";
    };

    function view(viewAccess, id, secret, name) {
        if (viewAccess == "DOC") {
            if (secret != null && secret != undefined && secret != "") {
                window.open(documentPath + "viewer" + "/" + id + "?secret=" + secret);
            } else {
                window.open(documentPath + "viewer" + "/" + id);
            }
        } else if (viewAccess == "HTML") {
            window.open(storageServerPath + "/rest/files/download/" + id);
        } else if (viewAccess == "IMAGE") {
            window.open(storageServerPath + "/rest/files/download/" + id);
        }
    };

    function validExist(nodeId, name, type) {
        var checkpath = '/personal/existfile?name=' + encodeURIComponent(name) + "&type=" + (type == 0 ? 0 : 1) + "&clientId=" + clientId;
        checkpath += common_util.isBlank(nodeId) ? "" : ("&nodeId=" + nodeId);
        var exist = false;
        $.ajax({
            type: "GET",
            url: checkpath,
            async: false,
            cache: false,
            error: function (XMLHttpRequest, textStatus, errorThrown) {

            },
            success: function (obj) {
                if (obj.data) {
                    exist = true;
                    layer.msg(type == 0 ? "文件夹已存在" : "文件已存在");
                }
            }
        });
        return exist;
    };

    function addFolder(nodeId, name, index) {
        var path = '/personal/createfolder?name=' + encodeURIComponent(name) + '&clientId=' + clientId;
        path += common_util.isBlank(nodeId) ? "" : ("&nodeId=" + nodeId);
        $.ajax({
            type: "post",
            url: path,
            async: false,
            cache: false,
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                layer.msg("创建失败！");
            },
            success: function (data) {
                layer.msg('创建成功！');
                layer.close(index);
                wordTableIns.reload();
            }
        });
    };

    function showLayer(param) {
        var config = {
            shadeClose: true,
            type: 1,
            area: ['700px', '500px'],
        }
        if (param == "createTask") {
            config.title = "新建任务";
            config.content = $('#createTask-script')[0].innerHTML;
            config.skin = 'to-fix-select';
        }
        if (param == "createNewFolder") {
            config.area = ['385px', '215px'];
            config.title = "新建文件夹";
            config.content = $('#createNewFolder-script')[0].innerHTML;
            config.skin = 'to-fix-select';
        }
        layerIndex_showLayer = layer.open(config);
    };

    function createUserHtml() {
        var html = $("#user-script").html();
        $(".show-container").empty();
        $(".show-container").html(html);
        var maxHeight = $(".show-container").css("max-height");
        $(".form-box").attr("height", maxHeight.substr(0, maxHeight.length - 2) - $(".item-top").height() - 10);
        $.ajax({
            type: "get",
            url: "/authority/currentUser",
            success: function (obj) {
                var data = obj.data;
                bindTree();
                if (data) {
                    form.val("person-form", {
                        "id": data.id,
                        "username": data.username,
                        "alias": data.alias,
                        "mobile": data.mobile,
                        "email": data.email,
                        "birthday": data.birthday,
                        "title": data.title,
                        "password": data.password,
                    })
                    $("input[name=username]").attr("readonly", true).addClass("layui-bg-gray");
                    if (data.orgRecordList[0]) {
                        $("input[name=selectID]")[0].value = data.orgRecordList[0].id;
                        $("#treeclass")[0].innerText = data.orgRecordList[0].name;
                    }
                }

            }
        });
        form.on("submit(person-submit)", function (obj) {
            param = obj.field;
            var id = param.selectID;
            var ids = new Array();
            ids[0] = id;
            $.ajax({
                type: "post",
                url: "/authority/getOrg",
                data: {ids: JSON.stringify(ids)},
                success: function (obj) {
                    var ids = obj.data;
                    for (var i = 0; i < ids.length; i++) {
                        param["orgRecordList[" + i + "].id"] = ids[i].id;
                        param["orgRecordList[" + i + "].code"] = ids[i].code;
                        param["orgRecordList[" + i + "].name"] = ids[i].name;
                        param["orgRecordList[" + i + "].parentId"] = ids[i].parentId;
                        param["orgRecordList[" + i + "].isParent"] = ids[i].isParent;
                        param["orgRecordList[" + i + "].parentName"] = ids[i].parentName;
                        param["orgRecordList[" + i + "].parentCode"] = ids[i].parentCode;
                    }
                    $.ajax({
                        type: "POST",
                        url: "/authority/edituser",
                        data: param,
                        success: function (obj) {
                            if (obj.data) {
                                layer.msg("修改信息成功！");
                            }
                            else {
                                layer.msg("修改信息失败！");
                            }
                            layer.close(layerIndex_showLayer);
                        },
                    })
                }
            })
            return false;
        });
    };

    function bindTree() {
        $.get("/authority/orgs").done(function (obj) {
            var data = obj.data;
            tree({
                elem: "#classtree",
                nodes: data,
                click: function (node) {
                    var $select = $($(this)[0].elem).parents(".layui-form-select");
                    $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.name).end().find("input:hidden[name='selectID']").val(node.id);
                }
            });
            $(".downpanel").on("click", ".layui-select-title", function (e) {
                $(".layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
                $(this).parents(".downpanel").toggleClass("layui-form-selected");
                layui.stope(e);
            }).on("click", "dl i", function (e) {
                layui.stope(e);
            });
            $(document).on("click", function (e) {
                $(".layui-form-select").removeClass("layui-form-selected");
            });
        });
    };

    form.verify({
        nameIndex: function (value) {
            var re = /[~^$%=?_@&!*()<>:;'"{}【】 	]/gi;
            if (re.test(value)) {
                return '用户名格式为字母或数字或中文';
            }
        },
        rePass: function (value) {
            var pwd = $("input[name='password']").val();
            if (pwd != null && pwd != undefined && pwd != "") {
                if (value == null || value == undefined || value == "") {
                    return '密码验证不通过';
                }
                if (pwd.length < 6) {
                    return '密码至少6位';
                }
                var re = /[~^$%?&!*()<>:;'"{}【】 	]/gi;
                if (re.test(pwd)) {
                    return '密码格式不正确';
                }
                if (value != pwd) {
                    return '密码验证不通过';
                }
            }
            if (pwd == null || pwd == undefined || pwd == "") {
                if (value != null && value != undefined && value != "") {
                    return '密码验证不通过';
                }
            }
        }
    });
});